package com.ejianc.business.material.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.PurchaseSettlementVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;

public interface IPurchaseSettlementService extends IBaseService<PurchaseSettlementEntity> {
    IPage<PurchaseSettlementVO> queryForList(QueryParam queryParam, boolean isEs);

    /**
    　* @Description: 计算指定合同满足条件的所有结算记录的结算总金额(含税)
    　* @param [queryParam]
    　* @return java.math.BigDecimal
    　* @throws
    　* @author CJ
    　* @date 2020/6/19 9:09
    　*/
    BigDecimal calculateTotalSettlement(QueryParam queryParam);

    BigDecimal calculateTotalSettlementNoTax(QueryParam queryParam);

    void processCost(PurchaseSettlementEntity entity);

    ParamsCheckVO checkParams(Integer isJc, Long contractId, BigDecimal settledAmount, BigDecimal currentSettlementAmount, BigDecimal contractAmount,String purchaseMethod, MaterialPriceVO vo);
}
