/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostSettingApi;
import com.ejianc.business.cost.vo.SubjectMaterialVO;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.mapper.OutStoreSubMapper;
import com.ejianc.business.material.mapper.StatisticsMapper;
import com.ejianc.business.material.service.IStatisticsService;
import com.ejianc.business.material.vo.MaterialCostVO;
import com.ejianc.business.material.vo.MaterialSubjectVO;
import com.ejianc.business.material.vo.MaterialSubjectsVO;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticsService
implements IStatisticsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private StatisticsMapper statisticsMapper;
    @Autowired
    private OutStoreSubMapper outStoreSubMapper;
    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;
    @Autowired
    private ICostSettingApi costSettingApi;
    @Autowired
    private IMaterialMasterPlanService materialMasterPlanService;
    @Autowired
    private IMaterialApi materialApi;

    @Override
    public IPage<JSONObject> queryInStoreDetailsPageList(QueryParam param) {
        String sql;
        if (null != param.getParams().get("m.contractType")) {
            param.getParams().put("m.contractType", new Parameter("eq", ((Parameter)param.getParams().get("m.contractType")).getValue()));
        }
        String status = null;
        if (null != param.getParams().get("status")) {
            status = (String)((Parameter)param.getParams().get("status")).getValue();
            param.getParams().remove("status");
        }
        if (StringUtils.isNotEmpty((CharSequence)(sql = this.getSql(param))) && sql.contains("material_name")) {
            sql = sql.replace("material_name", "s.material_name");
        }
        if (StringUtils.isNotEmpty((CharSequence)sql) && sql.contains("org_id")) {
            sql = sql.replace("org_id", "m.org_id");
        }
        if (StringUtils.isNotEmpty((CharSequence)sql) && sql.contains("org_name")) {
            sql = sql.contains("m.org_name") ? this.replaceOccurrence(sql, "org_name", "m.org_name", 2) : sql.replace("org_name", "m.org_name");
        }
        List<JSONObject> map = this.statisticsMapper.queryInStoreDetailsPageList(sql, (param.getPageIndex() - 1) * param.getPageSize(), param.getPageSize(), status);
        Page page = new Page();
        page.setCurrent((long)param.getPageIndex());
        page.setSize((long)param.getPageSize());
        page.setRecords(map);
        page.setTotal(this.statisticsMapper.queryInStoreDetailsPageListCount(sql, status).longValue());
        return page;
    }

    private String replaceOccurrence(String text, String replaceFrom, String replaceTo, int occurrenceIndex) {
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(replaceFrom);
        Matcher m = p.matcher(text);
        int count = 0;
        while (m.find()) {
            if (count++ != occurrenceIndex - 1) continue;
            m.appendReplacement(sb, replaceTo);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public IPage<JSONObject> queryOutStoreDetailsPageList(QueryParam param) {
        String status = null;
        if (null != param.getParams().get("status")) {
            status = (String)((Parameter)param.getParams().get("status")).getValue();
            param.getParams().remove("status");
        }
        String sql = this.getCustomSql(param);
        List<JSONObject> map = this.statisticsMapper.queryOutStoreDetailsPageList(sql, (param.getPageIndex() - 1) * param.getPageSize(), param.getPageSize(), status);
        Page page = new Page();
        page.setCurrent((long)param.getPageIndex());
        page.setSize((long)param.getPageSize());
        page.setRecords(map);
        page.setTotal(this.statisticsMapper.queryOutStoreDetailsPageListCount(sql, status).longValue());
        return page;
    }

    private String getCustomSql(QueryParam param) {
        StringBuffer sql = new StringBuffer(" AND ");
        boolean hasData = false;
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText()) && !ListUtil.isEmpty((List)param.getFuzzyFields())) {
            hasData = true;
            String searchText = param.getSearchText();
            List fuzzyFields = param.getFuzzyFields();
            if (param.getFuzzyFields().size() == 1) {
                sql.append((String)fuzzyFields.get(0)).append(" like '%").append(StringEscapeUtils.escapeSql((String)searchText)).append("%' ");
            } else {
                sql.append(" ( ");
                int fuzzyFieldsSize = fuzzyFields.size();
                for (int i = 0; i < fuzzyFieldsSize; ++i) {
                    String key = (String)fuzzyFields.get(i);
                    sql.append(key).append(" like '%").append(StringEscapeUtils.escapeSql((String)searchText)).append("%' ");
                    if (i == fuzzyFieldsSize - 1) continue;
                    sql.append(" or ");
                }
                sql.append(" ) ");
            }
        }
        if (param.getParams().size() > 0) {
            if (hasData) {
                sql.append(" AND  ( ");
            }
            int i = 1;
            for (String key : param.getParams().keySet()) {
                String type;
                Parameter parameter = (Parameter)param.getParams().get(key);
                switch (type = parameter.getType()) {
                    case "eq": {
                        if (null == parameter.getValue()) {
                            sql.append(key).append(" IS NULL ");
                            break;
                        }
                        sql.append(key).append(" = '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "ne": {
                        if (null == parameter.getValue()) {
                            sql.append(key).append(" IS NOT NULL ");
                            break;
                        }
                        sql.append(key).append(" != '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "in": {
                        if (parameter.getValue() instanceof List) {
                            sql.append(key).append(" IN (").append(String.join((CharSequence)",", ((List)parameter.getValue()).stream().map(Object::toString).collect(Collectors.toList()))).append(") ");
                            break;
                        }
                        if (!(parameter.getValue() instanceof String)) break;
                        String[] paramArr = parameter.getValue().toString().split(",");
                        sql.append(key).append(" IN (").append(String.join((CharSequence)",", Arrays.asList(paramArr))).append(") ");
                        break;
                    }
                    case "not_in": {
                        if (parameter.getValue() instanceof List) {
                            sql.append(key).append(" NOT IN (").append(String.join((CharSequence)",", ((List)parameter.getValue()).stream().map(Object::toString).collect(Collectors.toList()))).append(") ");
                            break;
                        }
                        if (!(parameter.getValue() instanceof String)) break;
                        String[] paramArr = parameter.getValue().toString().split(",");
                        sql.append(key).append(" NOT IN (").append(String.join((CharSequence)",", Arrays.asList(paramArr))).append(") ");
                        break;
                    }
                    case "like": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(key).append(" LIKE '%").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("%' ");
                        break;
                    }
                    case "not_like": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(key).append(" NOT LIKE '%").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("%' ");
                        break;
                    }
                    case "like_left": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(key).append(" LIKE '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("%' ");
                        break;
                    }
                    case "like_right": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(key).append(" LIKE '%").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "between": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        String[] paramArr = parameter.getValue().toString().split(",");
                        sql.append(key).append(" BETWEEN '").append(paramArr[0]).append("' AND '").append(paramArr[1]).append("' ");
                        break;
                    }
                    case "lt": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(key).append(" < ").append(parameter.getValue()).append(" ");
                        break;
                    }
                    case "le": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(key).append(" <= ").append(parameter.getValue()).append(" ");
                        break;
                    }
                    case "gt": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(key).append(" > ").append(parameter.getValue()).append(" ");
                        break;
                    }
                    case "ge": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(key).append(" >= ").append(parameter.getValue()).append(" ");
                    }
                }
                if (i != param.getParams().size()) {
                    sql.append(" AND ");
                }
                ++i;
            }
            if (hasData) {
                sql.append(" ) ");
            }
            hasData = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSearchObject())) {
            JSONObject searchObject = JSONObject.parseObject((String)param.getSearchObject());
            if (hasData) {
                sql.append(" AND ");
            }
            int i = 1;
            for (String key : searchObject.keySet()) {
                sql.append(key).append(" = '").append(searchObject.get((Object)key)).append("' ");
                if (i != searchObject.size()) {
                    sql.append(" AND ");
                }
                ++i;
            }
        }
        if (sql.length() == 5) {
            return null;
        }
        this.logger.info("sql\u7247\u6bb5\uff1a{}", (Object)sql);
        return sql.toString();
    }

    @Override
    public IPage<JSONObject> queryInOutStorePageList(QueryParam param) {
        Object map;
        Map params = param.getParams();
        String ciDate = null;
        String moDate = null;
        List orgIds = (List)((Parameter)param.getParams().get("orgId")).getValue();
        String orgId = "(" + String.join((CharSequence)",", orgIds.stream().map(Object::toString).collect(Collectors.toList())) + ")";
        if (params.get("dateIn") != null) {
            Parameter p = (Parameter)params.get("dateIn");
            ciDate = " AND ( c.instore_date BETWEEN '" + p.getValue().toString().split(",")[0] + " 00:00:00' AND '" + p.getValue().toString().split(",")[1] + " 00:00:00' ) ";
            moDate = " AND ( m.out_date BETWEEN '" + p.getValue().toString().split(",")[0] + " 00:00:00' AND '" + p.getValue().toString().split(",")[1] + " 00:00:00' ) ";
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        for (String key : params.keySet()) {
            if (((Parameter)params.get(key)).getValue() == null || !StringUtils.isNotEmpty((CharSequence)((Parameter)params.get(key)).getValue().toString())) continue;
            maps.put(key, ((Parameter)params.get(key)).getValue().toString());
        }
        ArrayList<Long> projectIds = null;
        if (null != param.getParams().get("pIds")) {
            projectIds = new ArrayList<Long>();
            String[] con = String.valueOf(((Parameter)param.getParams().get("pIds")).getValue()).split(",");
            for (int i = 0; i < con.length; ++i) {
                projectIds.add(Long.valueOf(con[i]));
            }
        }
        ArrayList<Long> materialCategoryIds = null;
        if (null != param.getParams().get("mcIds")) {
            materialCategoryIds = new ArrayList<Long>();
            String[] con = String.valueOf(((Parameter)param.getParams().get("mcIds")).getValue()).split(",");
            for (int i = 0; i < con.length; ++i) {
                materialCategoryIds.add(Long.valueOf(con[i]));
            }
            map = new HashMap<String, ArrayList<Long>>();
            map.put("innerCodes", materialCategoryIds);
            CommonResponse listCommonResponse = this.materialApi.queryListByInnerCode(map);
            System.out.print(listCommonResponse);
            if (listCommonResponse.getCode() == 0 && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
                materialCategoryIds.clear();
                List data = (List)listCommonResponse.getData();
                System.out.print(data);
                for (MaterialCategoryVO mc : data) {
                    materialCategoryIds.add(mc.getId());
                }
            }
        }
        ArrayList<Long> materialNames = null;
        if (null != param.getParams().get("mIds")) {
            materialNames = new ArrayList<Long>();
            String[] con = String.valueOf(((Parameter)param.getParams().get("mIds")).getValue()).split(",");
            for (int i = 0; i < con.length; ++i) {
                materialNames.add(Long.valueOf(con[i]));
            }
        }
        map = this.statisticsMapper.queryInOutStorePageList(maps, param.getSearchText(), orgId, ciDate, moDate, (param.getPageIndex() - 1) * param.getPageSize(), param.getPageSize(), projectIds, materialCategoryIds, materialNames);
        this.setInOutStorePageTotalOutAndSurplus((List<JSONObject>)map, orgId, ciDate, moDate);
        Page page = new Page();
        page.setCurrent((long)param.getPageIndex());
        page.setSize((long)param.getPageSize());
        page.setRecords((List)map);
        page.setTotal(this.statisticsMapper.queryInOutStorePageListCount(maps, param.getSearchText(), orgId, ciDate, moDate, projectIds, materialCategoryIds, materialNames).longValue());
        return page;
    }

    @Override
    public IPage<JSONObject> queryPlanInOutStorePageList(QueryParam param) {
        Map params = param.getParams();
        Page page = new Page();
        if (params.get("projectId") == null) {
            return page;
        }
        String projectId = (String)((Parameter)params.get("projectId")).getValue();
        String startDay = params.get("startDay") != null ? (String)((Parameter)params.get("startDay")).getValue() : null;
        String endDay = params.get("endDay") != null ? (String)((Parameter)params.get("endDay")).getValue() : null;
        int startLine = (param.getPageIndex() - 1) * param.getPageSize();
        int pageSize = param.getPageSize();
        HashMap<String, String> maps = new HashMap<String, String>();
        for (String key : params.keySet()) {
            if (((Parameter)params.get(key)).getValue() == null || !StringUtils.isNotEmpty((CharSequence)((Parameter)params.get(key)).getValue().toString())) continue;
            maps.put(key, ((Parameter)params.get(key)).getValue().toString());
        }
        List<JSONObject> map = this.statisticsMapper.queryPlanInOutStorePageList(maps, projectId, startDay, endDay, startLine, pageSize);
        this.setPlanInOutStorePageTotalOutAndSurplus(map, projectId, startDay, endDay);
        page.setCurrent((long)param.getPageIndex());
        page.setSize((long)param.getPageSize());
        page.setRecords(map);
        page.setTotal(this.statisticsMapper.queryPlanInOutStorePageListCount(maps, projectId, startDay, endDay).longValue());
        return page;
    }

    private void setPlanInOutStorePageTotalOutAndSurplus(List<JSONObject> objectList, String projectId, String startDay, String endDay) {
        HashMap<String, ArrayList<JSONObject>> materials = new HashMap<String, ArrayList<JSONObject>>();
        if (ListUtil.isNotEmpty(objectList)) {
            for (int i = 0; i < objectList.size(); ++i) {
                Map vo = (Map)objectList.get(i);
                String newKey = vo.get("material_id").toString();
                ArrayList<JSONObject> material = (ArrayList<JSONObject>)materials.get(newKey);
                if (ListUtil.isEmpty((List)material)) {
                    material = new ArrayList<JSONObject>();
                    materials.put(newKey, material);
                }
                material.add(objectList.get(i));
            }
            for (String key : materials.keySet()) {
                List material = (List)materials.get(key);
                for (int i = 0; i < material.size(); ++i) {
                    Map vo = (Map)material.get(i);
                    Map<String, BigDecimal> returnStoreInfo = this.statisticsMapper.queryReturnStoreNumByProjectIdAndMaterialId(projectId, startDay, endDay, key);
                    if (returnStoreInfo == null) {
                        returnStoreInfo = new HashMap<String, BigDecimal>();
                        returnStoreInfo.put("rNum", new BigDecimal("0.00"));
                        returnStoreInfo.put("rAmount", new BigDecimal("0.00"));
                    }
                    BigDecimal oNum = (BigDecimal)vo.get("oNum");
                    BigDecimal oAmount = (BigDecimal)vo.get("oAmount");
                    if (oNum == null) {
                        oNum = new BigDecimal("0.00");
                    }
                    oNum = oNum.subtract(returnStoreInfo.get("rNum")).setScale(2, 4);
                    if (oAmount == null) {
                        oAmount = new BigDecimal("0.00");
                    }
                    oAmount = oAmount.subtract(returnStoreInfo.get("rAmount")).setScale(2, 4);
                    if (i == 0) {
                        vo.put("materialRowSpan", material.size());
                        vo.put("oNum", oNum);
                        vo.put("oAmount", oAmount);
                        if (vo.get("pNum") != null) {
                            vo.put("pNum", new BigDecimal(vo.get("pNum").toString()).setScale(2, 4));
                        }
                        if (vo.get("pPrice") != null) {
                            vo.put("pPrice", new BigDecimal(vo.get("pPrice").toString()).setScale(2, 4));
                        }
                        if (vo.get("pAmount") != null) {
                            vo.put("pAmount", new BigDecimal(vo.get("pAmount").toString()).setScale(2, 4));
                        }
                        if (vo.get("aNum") != null) {
                            vo.put("aNum", new BigDecimal(vo.get("aNum").toString()).setScale(2, 4));
                        }
                        if (vo.get("aAmount") != null) {
                            vo.put("aAmount", new BigDecimal(vo.get("aAmount").toString()).setScale(2, 4));
                        }
                    } else {
                        vo.put("materialRowSpan", 0);
                    }
                    if (vo.get("iUnitPrice") == null) {
                        vo.put("iUnitPriceRowSpan", 1);
                        continue;
                    }
                    vo.put("iUnitPriceRowSpan", 1);
                    vo.put("iNum", ((BigDecimal)vo.get("iNum")).setScale(2, 4));
                    vo.put("iUnitPrice", ((BigDecimal)vo.get("iUnitPrice")).setScale(2, 4));
                    vo.put("iAmount", ((BigDecimal)vo.get("iAmount")).setScale(2, 4));
                }
            }
        }
    }

    private void setInOutStorePageTotalOutAndSurplus(List<JSONObject> objectList, String orgIds, String ciDate, String moDate) {
        HashMap<String, ArrayList<JSONObject>> materials = new HashMap<String, ArrayList<JSONObject>>();
        if (ListUtil.isNotEmpty(objectList)) {
            for (int i = 0; i < objectList.size(); ++i) {
                Map vo = (Map)objectList.get(i);
                String newKey = vo.get("newKey").toString();
                ArrayList<JSONObject> material = (ArrayList<JSONObject>)materials.get(newKey);
                if (ListUtil.isEmpty((List)material)) {
                    material = new ArrayList<JSONObject>();
                    materials.put(newKey, material);
                }
                material.add(objectList.get(i));
            }
            for (String key : materials.keySet()) {
                Map vo;
                int i;
                String storeId = key.split("\\|")[0];
                String materialId = key.split("\\|")[1];
                BigDecimal outNum = this.statisticsMapper.queryOutStoreNumByStoreIdAndMaterialId(orgIds, ciDate, moDate, storeId, materialId);
                BigDecimal returnNum = this.statisticsMapper.queryReturnStoreNumByStoreIdAndMaterialId(orgIds, ciDate, moDate, storeId, materialId);
                if (outNum == null) {
                    outNum = new BigDecimal("0.00");
                }
                if (returnNum == null) {
                    returnNum = new BigDecimal("0.00");
                }
                outNum = outNum.subtract(returnNum).setScale(8, 4);
                BigDecimal inNum = new BigDecimal("0.00");
                List material = (List)materials.get(key);
                HashMap supply = new HashMap();
                for (i = 0; i < material.size(); ++i) {
                    vo = (Map)material.get(i);
                    if (vo.get("instoreNumber") == null) continue;
                    inNum = inNum.add((BigDecimal)vo.get("instoreNumber"));
                    if (i == 0) {
                        vo.put("newKeyRowSpan", material.size());
                    } else {
                        vo.put("newKeyRowSpan", 0);
                    }
                    vo.put("instoreNumber", ((BigDecimal)vo.get("instoreNumber")).setScale(2, 4));
                    if (vo.get("supplierName") == null) continue;
                    ArrayList supList = (ArrayList)supply.get(vo.get("supplierName").toString());
                    if (ListUtil.isEmpty((List)supList)) {
                        supList = new ArrayList();
                        supply.put(vo.get("supplierName").toString(), supList);
                    }
                    supList.add(material.get(i));
                }
                for (String supKey : supply.keySet()) {
                    List supp = (List)supply.get(supKey);
                    HashMap supplyPrice = new HashMap();
                    for (int i2 = 0; i2 < supp.size(); ++i2) {
                        Map suppVo = (Map)supp.get(i2);
                        if (i2 == 0) {
                            suppVo.put("supplyRowSpan", supp.size());
                        } else {
                            suppVo.put("supplyRowSpan", 0);
                        }
                        ArrayList suPrice = (ArrayList)supplyPrice.get(supKey + suppVo.get("unitPrice"));
                        if (ListUtil.isEmpty((List)suPrice)) {
                            suPrice = new ArrayList();
                            supplyPrice.put(supKey + suppVo.get("unitPrice"), suPrice);
                        }
                        suPrice.add(supp.get(i2));
                    }
                    for (String priceKey : supplyPrice.keySet()) {
                        List price = (List)supplyPrice.get(priceKey);
                        for (int i3 = 0; i3 < price.size(); ++i3) {
                            Map priceVo = (Map)price.get(i3);
                            if (i3 == 0) {
                                priceVo.put("priceRowSpan", price.size());
                                BigDecimal inStoreNum = new BigDecimal("0.00");
                                for (int j = 0; j < price.size(); ++j) {
                                    inStoreNum = inStoreNum.add((BigDecimal)priceVo.get("instoreNumber"));
                                }
                                priceVo.put("instoreNumber", inStoreNum);
                                continue;
                            }
                            priceVo.put("priceRowSpan", 0);
                        }
                    }
                }
                for (i = 0; i < material.size(); ++i) {
                    vo = (Map)material.get(i);
                    vo.put("outStoreNumber", outNum.setScale(2, 4));
                    vo.put("surplusNumber", inNum.subtract(outNum).setScale(2, 4));
                }
            }
        }
    }

    private String getSql(QueryParam param) {
        StringBuffer sql = new StringBuffer(" AND ");
        boolean hasData = false;
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText()) && !ListUtil.isEmpty((List)param.getFuzzyFields())) {
            hasData = true;
            String searchText = param.getSearchText();
            List fuzzyFields = param.getFuzzyFields();
            if (param.getFuzzyFields().size() == 1) {
                sql.append(CamelAndUnderLineConverter.humpToLine((String)((String)fuzzyFields.get(0)))).append(" like '%").append(StringEscapeUtils.escapeSql((String)searchText)).append("%' ");
            } else {
                sql.append(" ( ");
                int fuzzyFieldsSize = fuzzyFields.size();
                for (int i = 0; i < fuzzyFieldsSize; ++i) {
                    String key = (String)fuzzyFields.get(i);
                    sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" like '%").append(StringEscapeUtils.escapeSql((String)searchText)).append("%' ");
                    if (i == fuzzyFieldsSize - 1) continue;
                    sql.append(" or ");
                }
                sql.append(" ) ");
            }
        }
        if (param.getParams().size() > 0) {
            if (hasData) {
                sql.append(" AND  ( ");
            }
            int i = 1;
            for (String key : param.getParams().keySet()) {
                String type;
                Parameter parameter = (Parameter)param.getParams().get(key);
                switch (type = parameter.getType()) {
                    case "eq": {
                        if (null == parameter.getValue()) {
                            sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" IS NULL ");
                            break;
                        }
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" = '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "ne": {
                        if (null == parameter.getValue()) {
                            sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" IS NOT NULL ");
                            break;
                        }
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" != '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "in": {
                        if (parameter.getValue() instanceof List) {
                            sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" IN (").append(String.join((CharSequence)",", ((List)parameter.getValue()).stream().map(Object::toString).collect(Collectors.toList()))).append(") ");
                            break;
                        }
                        if (!(parameter.getValue() instanceof String)) break;
                        String[] paramArr = parameter.getValue().toString().split(",");
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" IN (").append(String.join((CharSequence)",", Arrays.asList(paramArr))).append(") ");
                        break;
                    }
                    case "not_in": {
                        if (parameter.getValue() instanceof List) {
                            sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" NOT IN (").append(String.join((CharSequence)",", ((List)parameter.getValue()).stream().map(Object::toString).collect(Collectors.toList()))).append(") ");
                            break;
                        }
                        if (!(parameter.getValue() instanceof String)) break;
                        String[] paramArr = parameter.getValue().toString().split(",");
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" NOT IN (").append(String.join((CharSequence)",", Arrays.asList(paramArr))).append(") ");
                        break;
                    }
                    case "like": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" LIKE '%").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("%' ");
                        break;
                    }
                    case "not_like": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" NOT LIKE '%").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("%' ");
                        break;
                    }
                    case "like_left": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" LIKE '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("%' ");
                        break;
                    }
                    case "like_right": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" LIKE '%").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "between": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        String[] paramArr = parameter.getValue().toString().split(",");
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" BETWEEN '").append(paramArr[0]).append("' AND '").append(paramArr[1]).append("' ");
                        break;
                    }
                    case "lt": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" < ").append(parameter.getValue()).append(" ");
                        break;
                    }
                    case "le": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" <= ").append(parameter.getValue()).append(" ");
                        break;
                    }
                    case "gt": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" > ").append(parameter.getValue()).append(" ");
                        break;
                    }
                    case "ge": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" >= ").append(parameter.getValue()).append(" ");
                    }
                }
                if (i != param.getParams().size()) {
                    sql.append(" AND ");
                }
                ++i;
            }
            if (hasData) {
                sql.append(" ) ");
            }
            hasData = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSearchObject())) {
            JSONObject searchObject = JSONObject.parseObject((String)param.getSearchObject());
            if (hasData) {
                sql.append(" AND ");
            }
            int i = 1;
            for (String key : searchObject.keySet()) {
                sql.append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" = '").append(searchObject.get((Object)key)).append("' ");
                if (i != searchObject.size()) {
                    sql.append(" AND ");
                }
                ++i;
            }
        }
        if (sql.length() == 5) {
            return null;
        }
        this.logger.info("sql\u7247\u6bb5\uff1a{}", (Object)sql);
        return sql.toString();
    }

    @Override
    public CommonResponse<JSONObject> queryMaterialViewBoardByProjectId(Long projectId) {
        JSONObject resp = new JSONObject();
        Map<String, BigDecimal> leftMoney = this.instoreMaterialMapper.queryStoreLeftMoneyAndMaterialTypeNumByProjectId(projectId);
        if (leftMoney == null) {
            leftMoney = new HashMap<String, BigDecimal>();
            leftMoney.put("inventoryAmount", BigDecimal.ZERO);
            leftMoney.put("materialTypeNumber", BigDecimal.ZERO);
        }
        resp.put("target", leftMoney);
        List<OutStoreSubVO> top5 = this.outStoreSubMapper.queryMaterialCostTopNByProjectId(5, projectId);
        if (ListUtil.isNotEmpty(top5)) {
            JSONObject respTop5 = new JSONObject();
            ArrayList<String> label = new ArrayList<String>();
            ArrayList<BigDecimal> value = new ArrayList<BigDecimal>();
            for (OutStoreSubVO vo : top5) {
                label.add(vo.getMaterialName());
                value.add(vo.getAmount());
            }
            respTop5.put("label", label);
            respTop5.put("value", value);
            resp.put("materialConsumptionTop5", (Object)respTop5);
        } else {
            resp.put("materialConsumptionTop5", null);
        }
        List<JSONObject> top10 = this.statisticsMapper.queryPlanOutStoreListTopN(projectId.toString(), 10);
        resp.put("materialConsumptionTop10", top10);
        return CommonResponse.success((Object)resp);
    }

    @Override
    public CommonResponse<MaterialCostVO> queryMaterialCostByProjectId(Long projectId) {
        MaterialCostVO resVo = new MaterialCostVO();
        List res = new ArrayList();
        CommonResponse subjectRes = this.costSettingApi.querySubjectsByProj(projectId);
        if (subjectRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)subjectRes.getData()))) {
            List subjectMaterialVOS = (List)subjectRes.getData();
            List materialSubjectVOS = BeanMapper.mapList((Iterable)subjectMaterialVOS, MaterialSubjectsVO.class);
            List<MaterialSubjectsVO> list = this.statisticsMapper.queryMaterialCost(projectId, InvocationInfoProxy.getTenantid());
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambda.eq(MaterialMasterPlanEntity::getProjectId, (Object)projectId);
            lambda.in(MaterialMasterPlanEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            List materialMasterPlanEntities = this.materialMasterPlanService.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)materialMasterPlanEntities)) {
                BigDecimal totalPlanAmt = materialMasterPlanEntities.stream().map(e -> e.getTotalPlanAmt() == null ? BigDecimal.ZERO : e.getTotalPlanAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
                resVo.setPlanMoney(totalPlanAmt == null ? BigDecimal.ZERO : totalPlanAmt);
            } else {
                resVo.setPlanMoney(BigDecimal.ZERO);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                list.forEach(e -> {
                    e.setLeafFlag(Boolean.valueOf(true));
                    if ("0".equals(((SubjectMaterialVO)subjectMaterialVOS.get(0)).getTaxFlag())) {
                        e.setAmount(e.getHappenTaxMny() == null ? BigDecimal.ZERO : e.getHappenTaxMny());
                    } else {
                        e.setAmount(e.getHappenMny() == null ? BigDecimal.ZERO : e.getHappenMny());
                    }
                });
                if ("0".equals(((SubjectMaterialVO)subjectMaterialVOS.get(0)).getMaterialCost())) {
                    BigDecimal costMoney = list.stream().map(e -> e.getAmount() == null ? BigDecimal.ZERO : e.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    resVo.setCostMoney(costMoney);
                    materialSubjectVOS.addAll(list);
                }
                for (int i = 0; i < materialSubjectVOS.size(); ++i) {
                    ((MaterialSubjectsVO)materialSubjectVOS.get(i)).setNumber(Integer.valueOf(i + 1));
                }
                MaterialSubjectsVO tempVo = new MaterialSubjectsVO();
                tempVo.setId(Long.valueOf(999L));
                tempVo.setNumber(Integer.valueOf(0));
                tempVo.setParentId(Long.valueOf(0L));
                materialSubjectVOS.add(tempVo);
                List<Object> listres = new ArrayList<MaterialSubjectsVO>();
                MaterialSubjectsVO vo = this.calculateValue(materialSubjectVOS);
                this.printGoal(vo, listres);
                listres = listres.stream().sorted(Comparator.comparing(MaterialSubjectsVO::getNumber)).collect(Collectors.toList());
                listres.remove(0);
                res = BeanMapper.mapList(listres, MaterialSubjectVO.class);
            } else {
                res = BeanMapper.mapList((Iterable)subjectMaterialVOS, MaterialSubjectVO.class);
                resVo.setCostMoney(BigDecimal.ZERO);
            }
            res = TreeNodeBUtil.buildTree(res);
        }
        resVo.setSubjectDetails(res);
        return CommonResponse.success((Object)resVo);
    }

    public List<MaterialSubjectsVO> getBottomNode(List<MaterialSubjectsVO> listGoal) {
        HashMap<Long, MaterialSubjectsVO> map = new HashMap<Long, MaterialSubjectsVO>();
        for (MaterialSubjectsVO g : listGoal) {
            map.put(g.getId(), g);
        }
        for (MaterialSubjectsVO g : listGoal) {
            Long pid = g.getParentId();
            if (!map.containsKey(pid)) continue;
            map.remove(pid);
        }
        return new ArrayList<MaterialSubjectsVO>(map.values());
    }

    public List<MaterialSubjectsVO> setParentValue(List<MaterialSubjectsVO> listAllGoal, List<MaterialSubjectsVO> listBottomGoal) {
        HashMap<Long, ArrayList<MaterialSubjectsVO>> map = new HashMap<Long, ArrayList<MaterialSubjectsVO>>();
        for (MaterialSubjectsVO g : listBottomGoal) {
            Long pid = g.getParentId();
            ArrayList<MaterialSubjectsVO> listGoal = (ArrayList<MaterialSubjectsVO>)map.get(pid);
            if (listGoal == null) {
                listGoal = new ArrayList<MaterialSubjectsVO>();
            }
            listGoal.add(g);
            map.put(pid, listGoal);
        }
        for (Long i : map.keySet()) {
            List tempListGoal = (List)map.get(i);
            BigDecimal result = BigDecimal.ZERO;
            BigDecimal result2 = BigDecimal.ZERO;
            for (MaterialSubjectsVO g : tempListGoal) {
                result = result.add(g.getAmount() == null ? BigDecimal.ZERO : g.getAmount());
                result2 = result2.add(g.getStoreNumber() == null ? BigDecimal.ZERO : g.getStoreNumber());
            }
            for (MaterialSubjectsVO g : listAllGoal) {
                Long id = g.getId();
                if (id.longValue() != i.longValue()) continue;
                List tempList = g.getChildren();
                if (tempList != null) {
                    tempListGoal.addAll(tempList);
                }
                g.setChildren(tempListGoal);
                BigDecimal score = g.getAmount() == null ? BigDecimal.ZERO : g.getAmount();
                BigDecimal score2 = g.getStoreNumber() == null ? BigDecimal.ZERO : g.getStoreNumber();
                score = score.add(result);
                score2 = score2.add(result2);
                g.setAmount(score);
                g.setStoreNumber(score2);
            }
        }
        for (MaterialSubjectsVO g : listBottomGoal) {
            listAllGoal.remove(g);
        }
        return listAllGoal;
    }

    public MaterialSubjectsVO calculateValue(List<MaterialSubjectsVO> listGoal) {
        if (listGoal.size() == 1) {
            return listGoal.get(0);
        }
        List<MaterialSubjectsVO> listBottomGoal = this.getBottomNode(listGoal);
        List<MaterialSubjectsVO> list = this.setParentValue(listGoal, listBottomGoal);
        return this.calculateValue(list);
    }

    public void printGoal(MaterialSubjectsVO goal, List<MaterialSubjectsVO> list) {
        list.add(goal);
        List listGoal = goal.getChildren();
        if (listGoal == null || listGoal.size() == 0) {
            return;
        }
        for (MaterialSubjectsVO g : listGoal) {
            this.printGoal(g, list);
        }
    }
}

