/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.StoreExportVO;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/store/"})
public class StoreController {
    @Autowired
    IStoreService storeService;
    @Autowired
    IInstoreMaterialService iInstoreMaterialService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StoreVO> saveOrUpdate(@RequestBody StoreVO vo) {
        StoreEntity entity = (StoreEntity)((Object)BeanMapper.map((Object)vo, StoreEntity.class));
        this.storeService.saveOrUpdate((Object)entity, false);
        StoreVO backVo = (StoreVO)BeanMapper.map((Object)((Object)entity), StoreVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVo);
    }

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StoreVO> queryDetail(Long id) {
        StoreEntity entity = (StoreEntity)((Object)this.storeService.selectById(id));
        StoreVO vo = (StoreVO)BeanMapper.map((Object)((Object)entity), StoreVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"storematerialList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InstoreMaterialVO>> storematerialList(@RequestBody Map<String, Object> params) {
        if (params.get("storeId") == null) {
            return CommonResponse.error((String)"\u4ed3\u5e93id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long storeId = Long.parseLong(params.get("storeId").toString());
        Integer pageNumber = Integer.valueOf(params.get("pageIndex").toString());
        Integer pageSize = Integer.valueOf(params.get("pageSize").toString());
        String searchText = null;
        if (params.get("searchText") != null) {
            searchText = params.get("searchText").toString();
        }
        IPage<InstoreMaterialVO> page = this.iInstoreMaterialService.storematerialList(storeId, searchText, pageNumber, pageSize);
        return CommonResponse.success(page);
    }

    @RequestMapping(value={"excelStoreMaterialList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelStoreMaterialList(@RequestBody Map<String, Object> params, HttpServletResponse response) {
        if (params.get("storeId") == null) {
            throw new BusinessException("\u4ed3\u5e93id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long storeId = Long.parseLong(params.get("storeId").toString());
        String searchText = null;
        if (params.get("searchText") != null) {
            searchText = params.get("searchText").toString();
        }
        IPage<InstoreMaterialVO> page = this.iInstoreMaterialService.storematerialList(storeId, searchText, null, null);
        List list = page.getRecords();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        String fileName = "storeMaterialExport.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    private String getText(String str, String pat, int num) {
        Pattern pattern = Pattern.compile(pat);
        Matcher findMatcher = pattern.matcher(str);
        int number = 0;
        while (findMatcher.find() && ++number != num) {
        }
        int i = findMatcher.start();
        return str.substring(0, i);
    }

    @RequestMapping(value={"queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage<StoreVO> page = this.storeService.queryForList(param, false);
        List list = page.getRecords();
        for (StoreVO vo : list) {
            InstoreMaterialVO pageInstoreMaterial = this.iInstoreMaterialService.censusStorematerial(vo.getId());
            if (pageInstoreMaterial == null) continue;
            String name = pageInstoreMaterial.getMaterialName();
            int count = name.length() - name.replace("\u3001", "").length();
            if (count > 2) {
                vo.setStoreMaterialName(this.getText(name, "\u3001", 3) + "\u7b49" + (count + 1) + "\u79cd");
            } else {
                vo.setStoreMaterialName(name);
            }
            vo.setStoreAmount(pageInstoreMaterial.getStoreAmount());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", page);
    }

    @RequestMapping(value={"queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("store", this.storeService.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StoreVO> vos) {
        return this.storeService.delete(vos);
    }

    @RequestMapping(value={"excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage<StoreVO> voPage = this.storeService.queryForList(queryParam, false);
        List list = voPage.getRecords();
        ArrayList exportVOS = new ArrayList();
        list.forEach(vo -> {
            IPage<InstoreMaterialVO> pageInstoreMaterial = this.iInstoreMaterialService.storematerialList(vo.getId(), null, 1, 3);
            BigDecimal amount = new BigDecimal(0.0);
            String name = "";
            if (pageInstoreMaterial.getTotal() > 0L) {
                for (InstoreMaterialVO material : pageInstoreMaterial.getRecords()) {
                    name = name.length() > 0 ? name + "\u3001" + material.getMaterialName() : name + material.getMaterialName();
                    amount = amount.add(material.getStoreAmount().setScale(2, 4));
                }
                if (pageInstoreMaterial.getTotal() > 3L) {
                    name = name + "\u7b49" + pageInstoreMaterial.getTotal() + "\u79cd";
                }
            }
            vo.setStoreMaterialName(name);
            vo.setStoreAmount(amount);
            StoreExportVO exportVO = (StoreExportVO)BeanMapper.map((Object)vo, StoreExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getCreateTime()));
            if (exportVO.getState() != null) {
                if ("1".equals(vo.getState())) {
                    exportVO.setState("\u542f\u7528");
                } else if ("0".equals(vo.getState())) {
                    exportVO.setState("\u505c\u7528");
                }
            }
            if ("1".equals(exportVO.getProjectType())) {
                exportVO.setProjectType("\u7ec4\u7ec7\u4ed3\u5e93");
            }
            if ("2".equals(exportVO.getProjectType())) {
                exportVO.setProjectType("\u516c\u53f8\u4ed3\u5e93");
            }
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("storeListExport.xlsx", beans, response);
    }

    @RequestMapping(value={"queryRefList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> queryRefList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        Long orgId = null;
        QueryParam param = new QueryParam();
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject json = JSONObject.parseObject((String)condition);
            if (json.get((Object)"orgId") != null) {
                orgId = Long.parseLong(json.get((Object)"orgId").toString());
                if (null != json.get((Object)"selfAndUnderData")) {
                    param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                } else if (null != json.get((Object)"isFindParentsData")) {
                    param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findParentsByOrgId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                } else {
                    param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
                }
            } else {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11orgId\uff01");
            }
            if (null != json.get((Object)"sort")) {
                Map sort = (Map)JSONObject.parseObject((String)json.getString("sort"), Map.class);
                for (String key : sort.keySet()) {
                    param.getOrderMap().put(key, sort.get(key).toString());
                }
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11condition\u6761\u4ef6");
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                param.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
            List fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("name");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }
        param.getParams().put("state", new Parameter("eq", (Object)1));
        return CommonResponse.success((String)"\u67e5\u8be2\u4ed3\u5e93\u6570\u636e\u6210\u529f\uff01", this.storeService.queryForList(param, false));
    }

    @RequestMapping(value={"calculateCanUseNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> calculateCanUseNum(@RequestParam Long inStoreSubId, @RequestParam Long materialId, @RequestParam Long outSubId) {
        return CommonResponse.success((String)"\u8ba1\u7b97\u53ef\u7528\u5e93\u5b58\u6210\u529f\uff01", (Object)this.storeService.calculateCanUseNum(inStoreSubId, materialId, outSubId).toString());
    }

    @RequestMapping(value={"queryNewestStoreByOrgId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StoreVO> queryNewestStoreByOrgId(@RequestParam Long orgId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u6700\u65b0\u4ed3\u5e93\u6210\u529f\uff01", (Object)this.storeService.queryNewestStoreByOrgId(orgId));
    }

    @RequestMapping(value={"refCanUseNumData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstoreMaterialVO>> refCanUseNumData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchText, String searchObject) {
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6condition\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject con = JSONObject.parseObject((String)condition);
        if (StringUtils.isBlank((CharSequence)con.getString("storeId"))) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u3010\u4ed3\u5e93\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)con.getString("outDate"))) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u3010\u51fa\u5e93\u65e5\u671f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("storeId", new Parameter("eq", (Object)con.getString("storeId")));
        queryParam.getParams().put("instoreDate", new Parameter("le", (Object)con.getString("outDate")));
        queryParam.getParams().put("storeState", new Parameter("eq", (Object)MaterialStoreState.STORED.getCode()));
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");
        Page pageVo = new Page();
        IPage<InstoreMaterialVO> entityPage = this.iInstoreMaterialService.queryStoreCanUseNumPageData(searchText, searchObject, con.getString("outDate"), con.getLong("storeId"), pageNumber, pageSize);
        if (entityPage != null) {
            ArrayList voList = new ArrayList();
            entityPage.getRecords().forEach(e -> {
                InstoreMaterialVO vo = (InstoreMaterialVO)BeanMapper.map((Object)e, InstoreMaterialVO.class);
                vo.setCanUseNumber(this.storeService.calculateCanUseNum(vo.getId(), vo.getMaterialId(), null));
                voList.add(vo);
            });
            pageVo.setRecords(voList);
            pageVo.setSize((long)queryParam.getPageSize());
            pageVo.setCurrent(entityPage.getCurrent());
            pageVo.setPages(entityPage.getPages());
            pageVo.setTotal(entityPage.getTotal());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u51fa\u5e93\u53ef\u7528\u7269\u8d44\u53c2\u7167\u6210\u529f\uff01", entityPage);
    }

    @RequestMapping(value={"refUsableSubMaterialList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstoreMaterialVO>> refUsableSubMaterialList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchText, @RequestParam(required=false) String searchObject) {
        JSONObject con;
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6condition\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> map = null;
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            map = new HashMap<String, String>();
            if (search.get((Object)"materialCategoryName") != null) {
                map.put("material_category_name", search.get((Object)"materialCategoryName").toString());
            }
            if (search.get((Object)"materialName") != null) {
                map.put("material_name", search.get((Object)"materialName").toString());
            }
            if (search.get((Object)"materialSpec") != null) {
                map.put("material_spec", search.get((Object)"materialSpec").toString());
            }
        }
        if (StringUtils.isBlank((CharSequence)(con = JSONObject.parseObject((String)condition)).getString("storeId"))) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u3010\u4ed3\u5e93\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)con.getString("outDate"))) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u3010\u51fa\u5e93\u65e5\u671f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List materialIds = null;
        if (null != con.get((Object)"materialIds")) {
            materialIds = JSONArray.parseArray((String)con.getString("materialIds"), Long.class);
        }
        Page pageVo = new Page();
        IPage<InstoreMaterialVO> entityPage = this.iInstoreMaterialService.queryUsableSubMaterialList(searchText, con.getString("outDate"), con.getLong("storeId"), pageNumber, pageSize, materialIds, map);
        if (entityPage != null) {
            ArrayList voList = new ArrayList();
            entityPage.getRecords().forEach(e -> {
                InstoreMaterialVO vo = (InstoreMaterialVO)BeanMapper.map((Object)e, InstoreMaterialVO.class);
                vo.setCanUseNumber(this.storeService.calculateCanUseNum(vo.getId(), vo.getMaterialId(), null));
                voList.add(vo);
            });
            pageVo.setRecords(voList);
            pageVo.setSize((long)pageSize.intValue());
            pageVo.setCurrent(entityPage.getCurrent());
            pageVo.setPages(entityPage.getPages());
            pageVo.setTotal(entityPage.getTotal());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u51fa\u5e93\u53ef\u7528\u7269\u8d44\u53c2\u7167\u6210\u529f\uff01", (Object)pageVo);
    }
}

