package com.ejianc.business.material.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/23 10:30
 */
@RestController
@RequestMapping("/api/materialContract/")
public class MaterialContractApi {

    @Autowired
    private IMaterialContractService materialContractService;

    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;

    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private ICustomerApi customerApi;

    /**
     * 分页查询生效的物资合同列表信息
     *
     * @param queryParam
     * @return
     */
    @PostMapping("queryContractList")
    CommonResponse<JSONObject> queryContractList(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("org_name");
        queryParam.getFuzzyFields().add("supplier_name");
        //按照合同创建时间倒序排列
        queryParam.getOrderMap().put("create_time", QueryParam.DESC);
        //租户Id
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //已生效状态的合同
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));

        IPage<MaterialContractEntity> pageData = materialContractService.queryPage(queryParam, false);
        resp.put("pages", pageData.getPages());
        resp.put("current", pageData.getCurrent());
        resp.put("size", pageData.getSize());
        resp.put("total", pageData.getTotal());
        resp.put("records", BeanMapper.mapList(pageData.getRecords(), MaterialContractVO.class));

        return CommonResponse.success("查询合同列表成功！", resp);
    }

    /**
     * 根据主键查询合同详情，并查询合同中供方、客户信息
     *
     * @param id
     * @return
     */
    @GetMapping("queryContractById")
    CommonResponse<JSONObject> queryContractInfoById(@RequestParam(value = "id") Long id) {
        JSONObject resp = new JSONObject();
        MaterialContractEntity contract = materialContractService.selectById(id);
        resp.put("contract", contract);
        if(null != contract) {
            if(null != contract.getSupplierId()) {
                CommonResponse<SupplierVO> supplierResp = supplierApi.queryById(contract.getSupplierId());
                if(supplierResp.isSuccess()) {
                    resp.put("supplier", supplierResp.getData());
                }
            }
            if(null != contract.getContractorEnterpriseId()) {
                CommonResponse<CustomerVO> customerResp = customerApi.detailById(contract.getContractorEnterpriseId());
                if(customerResp.isSuccess()) {
                    resp.put("customer", customerResp.getData());
                }
            }
        }

        return CommonResponse.success("查询合同信息成功！", resp);
    }

    @GetMapping("queryContractNumAndMoneyAndSettleMoneyByProjectId")
    CommonResponse<JSONObject> queryContractNumAndMoneyAndSettleMoneyByProjectId(@RequestParam(value = "projectId") Long projectId){
        JSONObject resp = new JSONObject();
        QueryParam param = new QueryParam();
        param.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        param.getParams().put("billState",new Parameter(QueryParam.IN,"1,3"));
        List<MaterialContractEntity> contractEntities = materialContractService.queryList(param,false);
        if(ListUtil.isEmpty(contractEntities)){
            resp.put("number",0);
            resp.put("contractAmount",0.00);
            resp.put("settlementAmount",0.00);
            return CommonResponse.success(resp);
        }
        resp.put("number",contractEntities.size());
        BigDecimal contractAmount = BigDecimal.ZERO;
        BigDecimal settlementAmount = BigDecimal.ZERO;
        for (int i = 0; i < contractEntities.size(); i++) {
            MaterialContractEntity contractEntity = contractEntities.get(i);
            contractAmount = contractAmount.add(contractEntity.getAmountWithTax());
        }
        resp.put("contractAmount",contractAmount.setScale(2,BigDecimal.ROUND_HALF_UP));
        List<PurchaseSettlementEntity> purchaseSettlementEntities = purchaseSettlementService.queryList(param,false);
        if(ListUtil.isNotEmpty(purchaseSettlementEntities)){
            for (int i = 0; i < purchaseSettlementEntities.size(); i++) {
                PurchaseSettlementEntity purchaseSettlementEntity = purchaseSettlementEntities.get(i);
                settlementAmount = settlementAmount.add(purchaseSettlementEntity.getCurrentSettlementAmountTax());
            }
        }
        resp.put("settlementAmount",settlementAmount);
        return CommonResponse.success(resp);
    }
    /**
     * 查物资合同结算
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/getMonthMaterialMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialReportVo>> getMonthMaterialMny(@RequestParam(value = "projectId") Long projectId,
                                                                @RequestParam(value = "lastDay") Integer lastDay) {
        return CommonResponse.success("查询列表数据成功！", materialContractService.getMonthMaterialMny(projectId, lastDay));
    }
    /**
     * 查物资合同数量，金额，结算金额
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/getMaterialContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialReportVo> getMaterialContract(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询列表数据成功！", materialContractService.getMaterialContract(projectId));
    }
}
