package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.utils.ListSplitUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资合同数据处理服务
 *
 * @author CJ
 */
@Service("materialService")
public class MaterialContractServiceImpl extends BaseServiceImpl<MaterialContractMapper, MaterialContractEntity> implements IMaterialContractService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String DEFAULT_RULE_CODE = "materialContract";

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private MaterialContractMapper materialContractMapper;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;


    @Autowired
    private IParamConfigApi paramConfigApi;

    //总计划量
    private static String PARAM_PLAN_COUNT = "P-8N9Au207";

    //总计划价
    private static String PARAM_PLAN_PRICE = "P-2Ux27w08";


    //总计划价
    private static String PARAM_PRICE_AREA = "P-126hYD10";

    @Override
    public List<MaterialContractVO> queryContractTaxWarnContract(List<SqlParam> sqlParamList) {
        List<MaterialContractVO> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(materialContractMapper.queryContractTaxWarnContract(list));
        }
        return result;
    }

    @Override
    public MaterialContractVO save(MaterialContractVO materialContractVO) {
        MaterialContractEntity saveEntity = null;
        UserContext userContext = sessionManager.getUserContext();

        //设置合同初始化金额、变更前金额
        materialContractVO.setBaseMoney(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBaseTaxMoney(materialContractVO.getAmountWithTax());
        materialContractVO.setBeforeChangeMny(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBeforeChangeTaxMny(materialContractVO.getAmountWithTax());
        BigDecimal totalAmountWith = new BigDecimal(0).setScale(8, BigDecimal.ROUND_HALF_UP);

        if (null != materialContractVO.getId()) {
            MaterialContractEntity dbEntity = super.selectById(materialContractVO.getId());
            saveEntity = BeanMapper.map(materialContractVO, MaterialContractEntity.class);
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setCreateUserName(dbEntity.getCreateUserName());
            saveEntity.setModifyUserName(userContext.getUserName());

        } else {
            //创建人信息
            materialContractVO.setCreateUserName(userContext.getUserName());
            //设置初始变更版本号：1
            materialContractVO.setChangeVersion(1);
            //设置审批状态为自由态
            materialContractVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //设置合同变更状态：未变更
            materialContractVO.setChangeState(MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED);

            saveEntity = BeanMapper.map(materialContractVO, MaterialContractEntity.class);
        }
        //重新计算合同金额，税金
        if (CollectionUtils.isNotEmpty(saveEntity.getMaterialDetailList())) {
            totalAmountWith = totalAmountWith.add(saveEntity.getMaterialDetailList()
                    .stream().filter(detail -> !"del".equals(detail.getRowState()) && (null != detail.getTotalAmount()))
                    .map(MaterialContractDetailSubEntity::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty(saveEntity.getOtherCostList())) {
            totalAmountWith = totalAmountWith.add(saveEntity.getOtherCostList().stream()
                    .filter(cost -> !"del".equals(cost.getRowState()) && (null != cost.getCostAmount()))
                    .map(MaterialContractOtherCostSubEntity::getCostAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            saveEntity.getOtherCostList().stream().filter(cost -> null == cost.getCostAmount())
                    .forEach(cost -> cost.setCostAmount(new BigDecimal(0)));
        }
        //都为空,则是没子表,手动录入的,不需要在合计
       /* if(CollectionUtils.isNotEmpty(saveEntity.getMaterialDetailList()) || CollectionUtils.isNotEmpty(saveEntity.getOtherCostList())){
            saveEntity.setAmountWithTax(totalAmountWith);
            saveEntity.setAmountWithoutTax(totalAmountWith.divide(new BigDecimal(1 + saveEntity.getTaxRate() / 100), 8, BigDecimal.ROUND_HALF_UP));
            saveEntity.setTaxFee(saveEntity.getAmountWithTax().subtract(saveEntity.getAmountWithoutTax()).setScale(8, BigDecimal.ROUND_HALF_UP));

        }*/
        super.saveOrUpdate(saveEntity, false);
        return BeanMapper.map(saveEntity, MaterialContractVO.class);
    }



    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper<MaterialContractEntity> wrapper = super.changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_tax_money) as originalAmount, sum(amount_with_tax) as curAmount");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("originalAmount", 0);
            resp.put("curAmount", 0);
        }

        return resp;
    }

    @Override
    public boolean codeCheck(Long id, String code) {
        QueryParam check = new QueryParam();
        if(id != null){
            check.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        check.getParams().put("code", new Parameter(QueryParam.EQ, code));
        check.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<MaterialContractEntity> contractEntityList = super.queryList(check, false);
        if (CollectionUtils.isNotEmpty(contractEntityList)) {
            return false;
        }
        check.getParams().remove("id");
        check.getParams().put("material_contract_id", new Parameter(QueryParam.NE, id));
        check.getParams().put("bill_state", new Parameter(QueryParam.NE, BillStateEnum.PASSED_STATE.getBillStateCode()));

        List<ContractChangeEntity> changeList = contractChangeService.queryList(check, false);
        if (CollectionUtils.isNotEmpty(changeList)) {
            return false;
        }
        return true;
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/7/22  校验合同合法性
     * @Description checkContract
     * @Param [id]
     * @Return void
     */
    @Override
    public void checkContract(Long id) {
        MaterialContractEntity contractEntity = super.selectById(id);
        if (contractEntity == null) {
            throw new BusinessException("所选合同不存在！");
        }
        if (!(contractEntity.getBillState() == 1 || contractEntity.getBillState() == 3)) {
            throw new BusinessException("所选合同未生效！");
        }
    }

    @Override
    public List<Map<String, Object>> queryAllWarnContracts(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(materialContractMapper.queryAllWarnContracts(list));
        }
        return result;
    }

    @Override
    public List<MaterialWarnVo> materialProjectOutMny(List<Long> tenantIds) {
        return baseMapper.materialProjectOutMny(tenantIds);
    }

    @Override
    public List<MaterialReportVo> getMonthMaterialMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthMaterialMny(projectId, lastDay);
    }

    @Override
    public MaterialReportVo getMaterialContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<MaterialContractEntity> lambda = Wrappers.<MaterialContractEntity>lambdaQuery();
        lambda.eq(MaterialContractEntity::getProjectId, projectId);
        lambda.eq(MaterialContractEntity::getDr, 0);
        lambda.in(MaterialContractEntity::getBillState, billStatus);
        List<MaterialContractEntity> quoteEntities = super.list(lambda);
        for (MaterialContractEntity ce : quoteEntities) {
            mny = mny.add(ce.getAmountWithTax()==null?BigDecimal.ZERO:ce.getAmountWithTax());
        }
        LambdaQueryWrapper<PurchaseSettlementEntity> lambda2 = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambda2.eq(PurchaseSettlementEntity::getProjectId, projectId);
        lambda2.eq(PurchaseSettlementEntity::getDr, 0);
        lambda2.in(PurchaseSettlementEntity::getBillState, billStatus);
        List<PurchaseSettlementEntity> purchaseSettlementEntities = purchaseSettlementService.list(lambda2);
        for (PurchaseSettlementEntity ce : purchaseSettlementEntities) {
            settleMny = settleMny.add(ce.getCurrentSettlementAmountTax()==null?BigDecimal.ZERO:ce.getCurrentSettlementAmountTax());
        }
        MaterialReportVo vo = new MaterialReportVo();
        vo.setMny(mny);
        vo.setNum(quoteEntities.size());
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<MaterialContractVO> queryWarnContracts(List<Long> tenantAllIds) {
        return materialContractMapper.queryWarnContracts(tenantAllIds);
    }

    @Override
    public List<MaterialContractVO> queryWarnPrePayContracts(List<Long> tenantAllIds) {
        return materialContractMapper.queryWarnPrePayContracts(tenantAllIds);
    }


    @Override
    public MaterialPriceVO queryPrice(Integer isJc, Long contractId, MaterialPriceVO vo) {
        Long projectId = vo.getProjectId();
        List<MaterialPriceVO> detail = vo.getDetail();
        if (CollectionUtils.isNotEmpty(detail)) {
            List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
            if (projectId != null && 1 != isJc) {
                List<MaterialPriceVO> materialPriceVOS = materialContractMapper.queryPlanPriceByProjectId(projectId, materialIds);
                if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                    Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account,(v1, v2) -> v2));
                    for (MaterialPriceVO v : detail) {
                        Long materialId = v.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (null != p) {
                            v.setPlanNum(p.getPlanNum());
                            v.setPlanPrice(p.getPlanPrice());
                        }
                    }
                }
            }
            //结算历史低价和高价只和租户有关
            List<MaterialPriceVO> materialPrices = materialContractMapper.querySettlePriceByTenantId(InvocationInfoProxy.getTenantid(), materialIds);
            if (CollectionUtils.isNotEmpty(materialPrices)) {
                Map<Long, MaterialPriceVO> priceVO = materialPrices.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account,(v1, v2) -> v2));
                for (MaterialPriceVO v : detail) {
                    Long materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVO.get(materialId);
                    if (null != p) {
                        v.setMinPrice(p.getMinPrice());
                        v.setMaxPrice(p.getMaxPrice());
                        v.setPriceArea(p.getMinPrice().setScale(2,BigDecimal.ROUND_HALF_UP) + "~" + p.getMaxPrice().setScale(2,BigDecimal.ROUND_HALF_UP));

                    }
                }
            }
        }
        return vo;
    }


    // 【物资总计划量】控制【物资合同量】P-8N9Au207 集采不受控制
    // 总计划价格【物资总计划价】控制【物资合同价】P-2Ux27w08  集采不受控制
    // 结算历史价格区间【历史价】控制【物资合同价】P-126hYD10
    //控制方式 0：不控制，1、提醒，2、无法保存
    @Override
    public ParamsCheckVO checkParams(Integer isJc, Long contractId, MaterialPriceVO vo) {
        List<MaterialPriceVO> detailList = vo.getDetail();
        Map<Long, MaterialPriceVO> numMap = new HashMap<>();
        detailList.forEach(detail->{
            MaterialPriceVO numVO = numMap.get(detail.getMaterialId());
            if(numVO != null){
                numVO.setNum(ComputeUtil.safeAdd(numVO.getNum(),detail.getNum()));
                numVO.setPrice(ComputeUtil.isLessThan(detail.getPrice() , numVO.getPrice()) ? detail.getPrice() : numVO.getPrice());
            }else{
                numMap.put(detail.getMaterialId(),detail);
            }
        });
        vo.setDetail(new ArrayList<>(numMap.values()));
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        List<MaterialPriceVO> detail = vo.getDetail();
        Integer controlType = 0;
        if (CollectionUtils.isNotEmpty(detail)) {
            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
            if (isJc == 0) {
                // 【物资总计划量】控制【物资合同量】P-8N9Au207 集采不受控制
                CommonResponse<BillParamVO> countParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
                if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
                    BillParamVO billParamVO = countParamByCode.getData();
                    if (0 != billParamVO.getControlType()) {
                        List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                        //获取已生效的量
                        List<MaterialPriceVO> vos = new ArrayList<>();
                        if(contractId != null){
                            vos = materialContractMapper.queryMaterialContractCount(contractId, vo.getProjectId(), materialIds);

                        }
                        Map<Long, BigDecimal> priceVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        for (MaterialPriceVO d : detail) {
                            BigDecimal num = d.getNum();
                            BigDecimal planNum = d.getPlanNum().multiply(divide);
                            BigDecimal hasNum = priceVOMap.get(d.getMaterialId()) != null ? priceVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal allNum = hasNum.add(num);
                            if (allNum.compareTo(planNum) > 0) {
                                controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;

                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "count");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : "" ));
                                paramsCheckDsVO.setWarnName("合同数量大于总计划数量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次合同数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，已签订数量：").append(hasNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，总计划数量*").append(roleValue).append("%: ").append(planNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(allNum.subtract(planNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        }
                    }
                } else {
                    logger.info(countParamByCode.getMsg());
                    throw new BusinessException("获取控制参数失败");
                }

                // 总计划价格【物资总计划价】控制【物资合同价】P-2Ux27w08  集采不受控制
                CommonResponse<BillParamVO> priceParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_PRICE);
                if (priceParamByCode.isSuccess() && null != priceParamByCode.getData()) {
                    BillParamVO billParamVO = priceParamByCode.getData();
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        for (MaterialPriceVO d : detail){
                            BigDecimal price = d.getPrice();
                            BigDecimal planPrice = d.getPlanPrice();
                            BigDecimal _planPrice = planPrice.multiply(divide);
                            if (price.compareTo(_planPrice) > 0) {
                                controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;

                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "unitPrice");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : "" ));
                                paramsCheckDsVO.setWarnName("合同单价大于总计划单价");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次合同单价：").append(price.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，总计划单价*").append(roleValue).append("%: ").append(_planPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出单价：").append(price.subtract(_planPrice).setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        }
                    }
                } else {
                    logger.info(priceParamByCode.getMsg());
                    throw new BusinessException("获取控制参数失败");
                }

            }


            // 结算历史价格区间【历史价】控制【物资合同价】P-126hYD10
            CommonResponse<BillParamVO> areaParamByCode = paramConfigApi.getBillParamByCode(PARAM_PRICE_AREA);
            if (areaParamByCode.isSuccess() && null != areaParamByCode.getData()) {
                BillParamVO billParamVO = areaParamByCode.getData();
                if (0 != billParamVO.getControlType()) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                    for (MaterialPriceVO d : detail){
                        BigDecimal price = d.getPrice();
                        BigDecimal maxPrice = d.getMaxPrice() == null ? BigDecimal.ZERO : d.getMaxPrice();
                        BigDecimal minPrice = d.getMinPrice();
                        if (maxPrice.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal _maxPrice = maxPrice.multiply(divide);
                            BigDecimal _minPrice = minPrice.multiply(divide);
                            if(price.compareTo(_maxPrice) > 0){
                                controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;

                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "unitPrice");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : "" ));
                                paramsCheckDsVO.setWarnName("合同单价大于历史价");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次合同单价：").append(price.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，物资历史价*").append(roleValue).append("%: ").append(_minPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("~").append(_maxPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出最高价：").append(price.subtract(_maxPrice).setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }

                        }
                    }
                }
            } else {
                logger.info(areaParamByCode.getMsg());
                throw new BusinessException("获取控制参数失败");
            }
            paramsCheckVO.setWarnType(paramsArray[controlType]);

            paramsCheckVO.setDataSource(checkDsVOS);

        }


        return paramsCheckVO;
    }

}
