package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.bean.PurchaseSettlementMaterialDetailEntity;
import com.ejianc.business.material.bean.PurchaseSettlementOtherFeeEntity;
import com.ejianc.business.material.mapper.PurchaseSettlementMapper;
import com.ejianc.business.material.mapper.PurchaseSettlementMaterialDetailMapper;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.PurchaseSettlementVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class PurchaseSettlementService extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity> implements IPurchaseSettlementService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private PurchaseSettlementMaterialDetailMapper purchaseSettlementMaterialDetailMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IVoucherApi voucherApi;

    //总计划量
    private static String PARAM_PLAN_COUNT = "P-41513I11";

    //总计划价
    private static String PARAM_PLAN_PRICE = "P-u2AcaJ12";


    //历史价
    private static String PARAM_PRICE_AREA = "P-166rjs14";

    //合同金额
    private static String PARAM_PRICE_CONTRACT = "P-hSH85015";

    @Override
    public IPage<PurchaseSettlementVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<PurchaseSettlementVO> voPage = null;
        IPage<PurchaseSettlementEntity> entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(), PurchaseSettlementVO.class));
        }
        return voPage;
    }

    @Override
    public BigDecimal calculateTotalSettlement(QueryParam queryParam) {
        QueryWrapper<PurchaseSettlementEntity> query = changeToQueryWrapper(queryParam);
        query.select("sum(current_settlement_amount_tax) as totalSettleAmount");
        Map<String, Object> amount = super.getMap(query);

        return null != amount ? new BigDecimal(amount.get("totalSettleAmount").toString()) : BigDecimal.ZERO.setScale(8);
    }
    @Override
    public BigDecimal calculateTotalSettlementNoTax(QueryParam queryParam) {
        QueryWrapper<PurchaseSettlementEntity> query = changeToQueryWrapper(queryParam);
        query.select("sum(current_settlement_amount) as totalSettleAmountNoTax");
        Map<String, Object> amount = super.getMap(query);

        return null != amount ? new BigDecimal(amount.get("totalSettleAmountNoTax").toString()) : BigDecimal.ZERO.setScale(8);
    }

    @Override
    public void processCost(PurchaseSettlementEntity entity) {
        String factor = "1";
        boolean canPush = true;
        List<CostDetailVO> list = new ArrayList<>();
        if (ListUtil.isNotEmpty(entity.getMaterialDetails())) {
            for (int i = 0; i < entity.getMaterialDetails().size(); i++) {
                PurchaseSettlementMaterialDetailEntity sub = entity.getMaterialDetails().get(i);
                if (sub.getSubjectId() != null && sub.getSubjectId() > 0L) {
                    CostDetailVO c = new CostDetailVO();
                    c.setSubjectId(sub.getSubjectId());
                    c.setSourceId(entity.getId());
                    c.setSourceDetailId(sub.getId());
                    c.setProjectId(entity.getProjectId());
                    c.setHappenTaxMny(sub.getMoney() == null ? new BigDecimal("0.00") : sub.getMoney());
                    if (sub.getMoney() == null) {
                        c.setHappenMny(new BigDecimal("0.00"));
                    } else {
                        BigDecimal rate = entity.getTaxRate() == null ? (new BigDecimal("1.00")) : new BigDecimal("1.00").add(entity.getTaxRate().divide(new BigDecimal("100.00"), 8, BigDecimal.ROUND_HALF_UP));
                        BigDecimal happenMny = sub.getMoney().divide(rate, 8, BigDecimal.ROUND_HALF_UP);
                        logger.info("物资结算 happenMny=" + happenMny + " TaxRate=" + rate.toPlainString() + " sub.getMoney()=" + sub.getMoney());
                        c.setHappenMny(happenMny);
                    }
                    c.setHappenDate(entity.getSettlementDate());
                    c.setMemo(entity.getMemo());
                    c.setCreateUserName(sessionManager.getUserContext().getUserName());
                    c.setSourceType("物资采购结算");
                    c.setSourceTabType("物资采购结算-物资明细子表");
                    list.add(c);
                } else {
                    canPush = false;
                    break;
                }
            }

        }
        if (ListUtil.isNotEmpty(entity.getFeeEntities())) {
            for (int i = 0; i < entity.getFeeEntities().size(); i++) {
                PurchaseSettlementOtherFeeEntity sub = entity.getFeeEntities().get(i);
                if (sub.getFeeSubjectId() != null && sub.getFeeSubjectId() > 0L) {
                    CostDetailVO c = new CostDetailVO();
                    c.setSubjectId(sub.getFeeSubjectId());
                    c.setSourceDetailId(sub.getId());
                    c.setSourceId(entity.getId());
                    c.setProjectId(entity.getProjectId());
                    c.setHappenTaxMny(sub.getMoney() == null ? new BigDecimal("0.00") : sub.getMoney().multiply(new BigDecimal(factor)));
                    if (sub.getMoney() == null) {
                        c.setHappenMny(new BigDecimal("0.00"));
                    } else {
                        BigDecimal rate = entity.getTaxRate() == null ? (new BigDecimal("1.00")) : new BigDecimal("1.00").add(entity.getTaxRate().divide(new BigDecimal("100.00"), 8, BigDecimal.ROUND_HALF_UP));
                        BigDecimal happenMny = sub.getMoney().divide(rate, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(factor));
                        c.setHappenMny(happenMny);
                    }
                    c.setHappenDate(entity.getSettlementDate());
                    c.setMemo(entity.getMemo());
                    c.setCreateUserName(sessionManager.getUserContext().getUserName());
                    c.setSourceType("物资采购结算");
                    c.setSourceTabType("物资采购结算-其他费用明细子表");
                    list.add(c);
                } else {
                    canPush = false;
                    break;
                }
            }

        }
        if (ListUtil.isEmpty(entity.getFeeEntities()) && ListUtil.isEmpty(entity.getMaterialDetails())) {
            canPush = false;
        }
        if (canPush) {
            CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            logger.info("推送成本 物资结算 结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag("1");
        } else {
            CommonResponse<String> response = iCostDetailApi.deleteSubject(entity.getId());
            logger.info("删除成本 物资结算 结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag("0");
        }
    }

    @Override
    public ParamsCheckVO checkParams(Integer isJc, Long contractId, BigDecimal settledAmount, BigDecimal currentSettlementAmount, BigDecimal contractAmount, String purchaseMethod, MaterialPriceVO vo) {
        List<MaterialPriceVO> detailList = vo.getDetail();
        Map<Long, MaterialPriceVO> numMap = new HashMap<>();
        detailList.forEach(detail->{
            MaterialPriceVO materialPriceVO = numMap.get(detail.getMaterialId());
            if(materialPriceVO != null){
                materialPriceVO.setNum(ComputeUtil.safeAdd(materialPriceVO.getNum(),detail.getNum()));
                materialPriceVO.setPrice(ComputeUtil.isLessThan(detail.getPrice() , materialPriceVO.getPrice()) ? detail.getPrice() : materialPriceVO.getPrice());
            }else{
                numMap.put(detail.getMaterialId(),detail);
            }
        });
        vo.setDetail(new ArrayList<>(numMap.values()));

        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        List<MaterialPriceVO> detail = vo.getDetail();
        Integer controlType = 0;
        if (CollectionUtils.isNotEmpty(detail)) {
            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
            if (isJc == 0) {
                // 【物资总计划量】控制【物资合同量】 组织结算不受控制
                CommonResponse<BillParamVO> countParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
                if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
                    BillParamVO billParamVO = countParamByCode.getData();
                    if (0 != billParamVO.getControlType()) {
                        List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                        //获取已生效的量
                        List<MaterialPriceVO> vos = purchaseSettlementMaterialDetailMapper.purchaseSettlementMaterialDetailMapper(vo.getProjectId(), materialIds);

                        Map<Long, BigDecimal> priceVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        for (MaterialPriceVO d : detail) {
                            BigDecimal num = d.getNum();
                            BigDecimal planNum = d.getPlanNum();
                            BigDecimal _planNum = planNum.multiply(divide);
                            BigDecimal hasNum = priceVOMap.get(d.getMaterialId()) != null ? priceVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal allNum = hasNum.add(num);
                            if (allNum.compareTo(_planNum) > 0) {
                                controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                                //已签订数量
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : "" ));
                                paramsCheckDsVO.setWarnName("物资结算量大于总计划量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次结算数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，已结算数量：").append(hasNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，总计划数量*").append(roleValue).append("%:").append(_planNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(allNum.subtract(_planNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        }
                    }
                } else {
                    logger.info(countParamByCode.getMsg());
                    throw new BusinessException("获取控制参数失败");
                }

                // 总计划价格【总计划价】控制【物资结算价】 组织结算不受控制
                CommonResponse<BillParamVO> priceParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_PRICE);
                if (priceParamByCode.isSuccess() && null != priceParamByCode.getData()) {
                    BillParamVO billParamVO = priceParamByCode.getData();
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        for (MaterialPriceVO d : detail) {
                            BigDecimal price = d.getPrice();
                            BigDecimal planPrice = d.getPlanPrice();
                            if (price.compareTo(planPrice) > 0) {
                                controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                                BigDecimal _planPrice = planPrice.multiply(divide);
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : "" ));
                                paramsCheckDsVO.setWarnName("结算单价大于总计划单价");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次结算单价：").append(price.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，总计划单价*").append(roleValue).append("%: ").append(_planPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出金额：").append(price.subtract(_planPrice).setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        }
                    }
                } else {
                    logger.info(priceParamByCode.getMsg());
                    throw new BusinessException("获取控制参数失败");
                }
            }


            // 结算历史价格区间【历史价】控制【物资结算价】
            CommonResponse<BillParamVO> areaParamByCode = paramConfigApi.getBillParamByCode(PARAM_PRICE_AREA);
            if (areaParamByCode.isSuccess() && null != areaParamByCode.getData()) {
                BillParamVO billParamVO = areaParamByCode.getData();

                if (0 != billParamVO.getControlType()) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                    for (MaterialPriceVO d : detail) {
                        BigDecimal price = d.getPrice();
                        BigDecimal maxPrice = d.getMaxPrice() == null ? BigDecimal.ZERO : d.getMaxPrice();
                        BigDecimal minPrice = d.getMinPrice();
                        if (price.compareTo(maxPrice) > 0 && maxPrice.compareTo(BigDecimal.ZERO) > 0) {
                            controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                            BigDecimal _maxPrice = maxPrice.multiply(divide);
                            BigDecimal _minPrice = minPrice.multiply(divide);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : "" ));
                            paramsCheckDsVO.setWarnName("结算单价大于物资历史价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("本次结算单价：").append(price.setScale(2, BigDecimal.ROUND_HALF_UP))
                                    .append("，物资历史价*").append(roleValue).append("%: ").append(_minPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                    .append("~").append(_maxPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出最高价：").append(price.subtract(_maxPrice).setScale(2, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                    }
                }
            } else {
                logger.info(areaParamByCode.getMsg());
                throw new BusinessException("获取控制参数失败");
            }
            if ("项目自采".equals(purchaseMethod)) {
                //【合同金额】控制【结算金额】 集采合同不受该参数影响
                CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(PARAM_PRICE_CONTRACT);
                if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
                    BillParamVO billParamVO = billParamByCode.getData();
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = contractAmount.multiply(roleValue.divide(BigDecimal.valueOf(100)));
                    BigDecimal sumPayWithThisMny = settledAmount.add(currentSettlementAmount);
                    if (sumPayWithThisMny.compareTo(comMny) > 0) {
                        controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("合同超结");
                        paramsCheckDsVO.setWarnName("结算金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次结算金额：").append(currentSettlementAmount.toString())
                                .append("元，合同金额*").append(roleValue).append("%: ")
                                .append(comMny).append("元。超出金额：").append(sumPayWithThisMny.subtract(comMny)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                } else {
                    logger.info(billParamByCode.getMsg());
                    throw new BusinessException("获取控制参数失败");
                }
            }
            paramsCheckVO.setWarnType(paramsArray[controlType]);
            paramsCheckVO.setDataSource(checkDsVOS);

        }


        return paramsCheckVO;
    }

    @Override
    public void handleVoucher(PurchaseSettlementEntity entity, boolean isGenerate) {
        if (isGenerate) {
            VoucherParams voucherParams = VoucherParams.newInstance("BT200610000000004", entity.getOrgId(), entity.getBillCode(), entity, SystemCodeEnum.MATERIAL);
            CommonResponse<VoucherInfo> response = voucherApi.save(voucherParams);
            logger.info("推送凭证结果：" + DataConvertUtil.toPrettyFormat(response));
            LambdaUpdateWrapper<PurchaseSettlementEntity> lambda = new LambdaUpdateWrapper<>();
            lambda.eq(PurchaseSettlementEntity::getId, entity.getId());
            if (response.isSuccess()) {
                VoucherInfo voucherInfo = response.getData();
                lambda.set(PurchaseSettlementEntity::getVoucherInfo, DataConvertUtil.objToString(voucherInfo));
                lambda.set(PurchaseSettlementEntity::getVoucherFlag, voucherInfo.getVoucherFlag());
            } else {
                lambda.set(PurchaseSettlementEntity::getVoucherInfo, response.getMsg());
                lambda.set(PurchaseSettlementEntity::getVoucherFlag, VoucherFlag.FAILED);
            }
            this.update(lambda);
        } else {
            if (VoucherFlag.SUCCESS.equals(entity.getVoucherFlag())) {
                CommonResponse<String> response = voucherApi.del(JSONObject.parseObject(entity.getVoucherInfo(), VoucherInfo.class));
                logger.info("删除凭证结果：" + DataConvertUtil.toPrettyFormat(response));
                if (response.isSuccess()) {
                    LambdaUpdateWrapper<PurchaseSettlementEntity> lambda = new LambdaUpdateWrapper<>();
                    lambda.eq(PurchaseSettlementEntity::getId, entity.getId());
                    lambda.set(PurchaseSettlementEntity::getVoucherInfo, null);
                    lambda.set(PurchaseSettlementEntity::getVoucherFlag, 0);
                    this.update(lambda);
                }
            }

        }
    }
}
