package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.vo.PayMnyWarnVO;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceMnyWarnVO;
import com.ejianc.business.tax.vo.InvoicePubWarnQueryVO;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/1/26 17:46
 */
@RestController
@RequestMapping(value = "/materialContractWarn/")
public class MaterialContractWarnController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PC_URL = "/ejc-material-frontend/#/materialContract/cards?id=";

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private ITenantApi tenantApi;

    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IPayContractApi payContractApi;

    @Autowired
    private IInvoiceApi invoiceApi;

    @PostMapping(value = "execute")
    public CommonResponse<String> execute(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);


        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("执行物资合同预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行物资合同预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行物资合同预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
//            return CommonResponse.success("执行物资合同预警完成，获取有效的租户Id列表为空！");
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);
        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行物资合同预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
//            return CommonResponse.success("执行物资合同预警完成，获取有效的租户Id列表为空！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<SqlParam> sqlParamList = new ArrayList<>();
        JSONObject warnInfo = null;
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            if(!ignoreTenantIds.contains(Long.valueOf(param.getString("tenantId")))) {
                warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
                for(SqlParam p : warnParamList) {
                    p.setWarnLevel(param.getString("warnLevel"));
                    p.setTenantId(Long.valueOf(param.getString("tenantId")));
                    p.setValue(p.getValue() / 100d);
                    sqlParamList.add(p);
                }
                customTenantIds.add(Long.valueOf(param.getString("tenantId")));
            }
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);
        List<SqlParam> defaultParam = null;

        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
        }

        List<Map<String, Object>> result = materialContractService.queryAllWarnContracts(sqlParamList);
        if(CollectionUtils.isEmpty(result)) {
            logger.error("执行物资合同预警完成，未发现有匹配预警规则的合同信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        return sendWarnToTask(transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }
    @PostMapping(value = "executeInvoicePayWarn")
    public CommonResponse<String> executeInvoicePayWarn(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("执行物资合同付款预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行物资合同预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行物资合同付款预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);
        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行物资合同付款预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<SqlParam> sqlParamList = new ArrayList<>();
        JSONObject warnInfo = null;
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            if(!ignoreTenantIds.contains(Long.valueOf(param.getString("tenantId")))) {
                warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
                for(SqlParam p : warnParamList) {
                    p.setWarnLevel(param.getString("warnLevel"));
                    p.setTenantId(Long.valueOf(param.getString("tenantId")));
                    p.setValue(p.getValue() / 100d);
                    sqlParamList.add(p);
                }
                customTenantIds.add(Long.valueOf(param.getString("tenantId")));
            }
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);
        List<SqlParam> defaultParam = null;

        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
        }

        //集采和自采从付款和收票上取
        List<EarlyWarnTransVO> warnTransVOS = new ArrayList<>();
        Map<Long, SqlParam> paramMap = new HashMap<>();
        List<Long> tenantidList = new ArrayList<>();
        for (SqlParam param : sqlParamList) {
            paramMap.put(param.getTenantId(), param);
            tenantidList.add(param.getTenantId());
        }

        PubWarnQueryVO pubWarnQueryVO = new PubWarnQueryVO();
        pubWarnQueryVO.setContractType(4);
        pubWarnQueryVO.setTenantIds(tenantidList);
        CommonResponse<Map<String, PayMnyWarnVO>> payResponse = payContractApi.warnPayMny(pubWarnQueryVO);
        if(payResponse.isSuccess() && !payResponse.getData().isEmpty()){
            Map<String, PayMnyWarnVO> payMap = payResponse.getData();
            InvoicePubWarnQueryVO invoicePubWarnQueryVO = new InvoicePubWarnQueryVO();
            invoicePubWarnQueryVO.setContractType(4);
            invoicePubWarnQueryVO.setTenantIds(tenantidList);
            CommonResponse<Map<String, InvoiceMnyWarnVO>> invoiceResponse = invoiceApi.getWarnInvoiceMny(invoicePubWarnQueryVO);
            Map<String, InvoiceMnyWarnVO> invoiceMap = invoiceResponse.getData();
            for(String key : payMap.keySet()){
                PayMnyWarnVO payWarnVO = payMap.get(key);
                SqlParam param = paramMap.get(payWarnVO.getTenantId());
                BigDecimal invoiceMny = BigDecimal.ZERO;
                if(null != invoiceMap && invoiceMap.containsKey(key)){
                    invoiceMny = invoiceMap.get(key).getSumInvoiceMny();
                }
                BigDecimal overMny = payWarnVO.getSumPayMny().multiply(new BigDecimal(param.getValue())).subtract(invoiceMny);
                if(overMny.compareTo(BigDecimal.ZERO) > 0){
                    warnTransVOS.add(margeInvoicePayToWarnVO(payWarnVO, invoiceMny, payWarnVO.getSumPayMny().multiply(new BigDecimal(param.getValue())), param, defaultWarnInfo));
                }
            }
        }
        return sendWarnToTask(warnTransVOS, defaultWarnInfo.getLong("warnSetId"));
    }
    @PostMapping(value = "executePayWarn")
    public CommonResponse<String> executePayWarn(@RequestBody JSONObject jsonParam) {

        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("执行物资合同付款预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行物资合同预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行物资合同付款预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);

        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行物资合同付款预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<SqlParam> sqlParamList = new ArrayList<>();
        JSONObject warnInfo = null;
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            if(!ignoreTenantIds.contains(Long.valueOf(param.getString("tenantId")))) {
                warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
                for(SqlParam p : warnParamList) {
                    p.setWarnLevel(param.getString("warnLevel"));
                    p.setTenantId(Long.valueOf(param.getString("tenantId")));
                    p.setValue(p.getValue() / 100d);
                    sqlParamList.add(p);
                }
                customTenantIds.add(Long.valueOf(param.getString("tenantId")));
            }
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);
        List<SqlParam> defaultParam = null;

        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
        }
        List<Long> tenantAllIds = new ArrayList<>();
        for (SqlParam sqlParam : sqlParamList){
            tenantAllIds.add(sqlParam.getTenantId());
        }

        //获取合同金额等信息
        List<MaterialContractVO> result = materialContractService.queryWarnContracts(tenantAllIds);
        if(CollectionUtils.isEmpty(result)) {
            logger.error("执行物资合同付款大于合同金额预警完成，未发现有匹配预警规则的合同信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        //集采和自采从付款取值
        List<EarlyWarnTransVO> warnTransVOS = new ArrayList<>();
        Map<Long, SqlParam> paramMap = new HashMap<>();
        List<Long> tenantidList = new ArrayList<>();
        for (SqlParam param : sqlParamList) {
            paramMap.put(param.getTenantId(), param);
            tenantidList.add(param.getTenantId());
        }

        PubWarnQueryVO pubWarnQueryVO = new PubWarnQueryVO();
        pubWarnQueryVO.setContractType(4);
        pubWarnQueryVO.setTenantIds(tenantidList);
        CommonResponse<Map<String, PayMnyWarnVO>> payResponse = payContractApi.warnMaterialPayMny(pubWarnQueryVO);
        if(payResponse.isSuccess() && !payResponse.getData().isEmpty()){
            Map<String, PayMnyWarnVO> payMap = payResponse.getData();
            for (MaterialContractVO materialContractVO : result){
                for (String key : payMap.keySet()){
                    if ((materialContractVO.getTenantId() + "@" + materialContractVO.getId()).equals(key)){
                        BigDecimal amountWithTax = materialContractVO.getAmountWithTax();
                        PayMnyWarnVO payMnyWarnVO = payMap.get(key);
                        SqlParam param = paramMap.get(materialContractVO.getTenantId());
                        BigDecimal sumPayMny = payMnyWarnVO.getSumPayMny();
                        BigDecimal overMny = sumPayMny.subtract(amountWithTax.multiply(new BigDecimal(param.getValue())));
                        if(overMny.compareTo(BigDecimal.ZERO) >= 0){
                            warnTransVOS.add(margePrePayToWarnVO(payMnyWarnVO, sumPayMny, amountWithTax.multiply(new BigDecimal(param.getValue())), param, defaultWarnInfo,materialContractVO.getAmountWithTax(),materialContractVO.getOrgId(),materialContractVO.getOrgName()));
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnTransVOS, defaultWarnInfo.getLong("warnSetId"));
    }

    // xuannl
    @PostMapping(value = "executeInvoiceContractWarn")
    public CommonResponse<String> executeInvoiceContractWarn(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);


        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("执行物资采购合同【收票金额】大于等于【合同金额】预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行物资采购合同预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行物资采购合同【【收票金额】大于等于【合同金额】预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);
        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行物资采购合同【收票金额】大于等于【合同金额】预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<SqlParam> sqlParamList = new ArrayList<>();
        JSONObject warnInfo = null;
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);
        List<SqlParam> defaultParam = null;

        Map<Long,SqlParam> tMap = new HashMap<>();
        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
                tMap.put(tenantId,p);
            }
        }

        List<MaterialContractVO> materialContractVOS = materialContractService.queryContractTaxWarnContract(sqlParamList);
        List<Long> contractIds = new ArrayList<>();
        materialContractVOS.forEach(item->{
            contractIds.add(item.getId());
        });
        CommonResponse<Map<Long, InvoiceReceiveRecordVO>> invoiceReceiveRecords = invoiceApi.getInvoiceReceiveRecords(contractIds);
        if(!invoiceReceiveRecords.isSuccess()){
            logger.error("执行物资采购合同【收票金额】大于等于【合同金额】预警完成，未成功查询收票信息！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        Map<Long, InvoiceReceiveRecordVO> map = invoiceReceiveRecords.getData();
        List<Map<String, Object>> result = new ArrayList<>();
        materialContractVOS.forEach(item->{
            SqlParam sqlParam = tMap.get(item.getTenantId());
            InvoiceReceiveRecordVO invoiceReceiveRecordVO = map.get(item.getId());
            if(null != invoiceReceiveRecordVO && null != sqlParam){

                if(invoiceReceiveRecordVO.getContractId() == 564884278688383044L || invoiceReceiveRecordVO.getContractId() == 567437833934639126L){
                    logger.info("-------------");
                    logger.info(invoiceReceiveRecordVO.getContractId().toString());
                    logger.info(invoiceReceiveRecordVO.getInvoiceTaxMny().toString());
                    logger.info(item.getAmountWithTax().toString());
                }


                if(null == invoiceReceiveRecordVO.getInvoiceTaxMny()){
                    invoiceReceiveRecordVO.setInvoiceTaxMny(BigDecimal.ZERO);
                }
                BigDecimal amountWithTax = item.getAmountWithTax();
                Double value = sqlParam.getValue();
                if(null == amountWithTax){
                    item.setAmountWithTax(BigDecimal.ZERO);
                    amountWithTax = item.getAmountWithTax();
                }

                BigDecimal multiply = amountWithTax.multiply(new BigDecimal(value));
                if(invoiceReceiveRecordVO.getContractId() == 564884278688383044L || invoiceReceiveRecordVO.getContractId() == 567437833934639126L){
                    logger.info("++++++++++");
                    logger.info(invoiceReceiveRecordVO.getContractId().toString());
                    logger.info(item.getAmountWithTax().toString());
                    logger.info(multiply.toString());
                    logger.info(multiply.toString());
                    logger.info(invoiceReceiveRecordVO.getInvoiceTaxMny().toString());
                }

                if(multiply.compareTo(invoiceReceiveRecordVO.getInvoiceTaxMny()) <= 0){
                    Map<String, Object> tempMap = new HashMap<>();
                    tempMap.put("contractCode",item.getCode());
                    tempMap.put("contractId",item.getId());
                    tempMap.put("orgId",item.getOrgId());
                    tempMap.put("orgName",item.getOrgName());
                    tempMap.put("tenantId",item.getTenantId());
                    tempMap.put("warnLevel",sqlParam.getWarnLevel());
                    tempMap.put("contractName",item.getName());
                    tempMap.put("sumInvoiceTaxMny",invoiceReceiveRecordVO.getInvoiceTaxMny());
                    tempMap.put("contractTaxMny",item.getAmountWithTax());
                    tempMap.put("percent",sqlParam.getValue()*100);
                    tempMap.put("overAmt",multiply);
                    result.add(tempMap);
                }
            }
        });
        return sendWarnToTask(transContractToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }


    @PostMapping(value = "executePrePayWarn")
    public CommonResponse<String> executePrePayWarn(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("执行物资合同付款预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行物资合同预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行物资合同付款预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);

        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行物资合同付款预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<SqlParam> sqlParamList = new ArrayList<>();
        JSONObject warnInfo = null;
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            if(!ignoreTenantIds.contains(Long.valueOf(param.getString("tenantId")))) {
                warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
                for(SqlParam p : warnParamList) {
                    p.setWarnLevel(param.getString("warnLevel"));
                    p.setTenantId(Long.valueOf(param.getString("tenantId")));
                    p.setValue(p.getValue() / 100d);
                    sqlParamList.add(p);
                }
                customTenantIds.add(Long.valueOf(param.getString("tenantId")));
            }
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);
        List<SqlParam> defaultParam = null;

        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
        }
        List<Long> tenantAllIds = new ArrayList<>();
        for (SqlParam sqlParam : sqlParamList){
            tenantAllIds.add(sqlParam.getTenantId());
        }

        //获取合同金额等信息
        List<MaterialContractVO> result = materialContractService.queryWarnPrePayContracts(tenantAllIds);
        if(CollectionUtils.isEmpty(result)) {
            logger.error("执行物资合同付款大于合同金额预警完成，未发现有匹配预警规则的合同信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        //集采和自采从付款取值
        List<EarlyWarnTransVO> warnTransVOS = new ArrayList<>();
        Map<Long, SqlParam> paramMap = new HashMap<>();
        List<Long> tenantidList = new ArrayList<>();
        for (SqlParam param : sqlParamList) {
            paramMap.put(param.getTenantId(), param);
            tenantidList.add(param.getTenantId());
        }

        PubWarnQueryVO pubWarnQueryVO = new PubWarnQueryVO();
        pubWarnQueryVO.setContractType(4);
        pubWarnQueryVO.setTenantIds(tenantidList);
        CommonResponse<Map<String, PayMnyWarnVO>> payResponse = payContractApi.warnMaterialPrePayMny(pubWarnQueryVO);
        if(payResponse.isSuccess() && !payResponse.getData().isEmpty()){
            Map<String, PayMnyWarnVO> payMap = payResponse.getData();
            for (MaterialContractVO materialContractVO : result){
                for (String key : payMap.keySet()){
                    if ((materialContractVO.getTenantId() + "@" + materialContractVO.getId()).equals(key)){
                        BigDecimal amountWithTax = materialContractVO.getAmountWithTax();
                        PayMnyWarnVO payMnyWarnVO = payMap.get(key);
                        BigDecimal offSetMny = materialContractVO.getOffSetMny();
                        SqlParam param = paramMap.get(materialContractVO.getTenantId());
                        BigDecimal sumPayMny = payMnyWarnVO.getSumPayMny();
                        //计算剩余冲抵金额
                        BigDecimal subtractMny = sumPayMny.subtract(offSetMny);
                        BigDecimal overMny = subtractMny.subtract(amountWithTax.multiply(new BigDecimal(param.getValue())));
                        if(overMny.compareTo(BigDecimal.ZERO) >= 0){
                            warnTransVOS.add(margePrePayToWarnVO(payMnyWarnVO, subtractMny, amountWithTax.multiply(new BigDecimal(param.getValue())), param, defaultWarnInfo,materialContractVO.getAmountWithTax(),materialContractVO.getOrgId(),materialContractVO.getOrgName()));
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnTransVOS, defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    private List<EarlyWarnTransVO> transContractToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for(Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            Object categoryName = defaultWarnInfo.get("categoryName");
            if(null != defaultWarnInfo.get("categoryName")){
                logger.info("1");
            }
            logger.info(categoryName.toString());
            vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + m.get("contractCode").toString());
            vo.setPcTitle("物资采购合同");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#orgName#", m.get("orgName").toString())
                            .replaceAll("#contractName#", m.get("contractName").toString())
                            .replaceAll("#sumInvoiceTaxMny#", df.format(new BigDecimal(m.get("sumInvoiceTaxMny").toString())))
                            .replaceAll("#contractTaxMny#", df.format(new BigDecimal(m.get("contractTaxMny").toString())))
                            .replaceAll("#percent#", m.get("percent").toString())
                            .replaceAll("#overAmt#", df.format(new BigDecimal(m.get("overAmt").toString())))
            );

            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for(Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + m.get("contractCode").toString());
            vo.setPcTitle("物资合同");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#contractName#", m.get("contractName").toString())
                            .replaceAll("#contractSettlementAmt#", df.format(new BigDecimal(m.get("contractSettlementAmt").toString())))
                            .replaceAll("#contractAmt#", df.format(new BigDecimal(m.get("contractAmt").toString())))
                            .replaceAll("#percent#", m.get("percent").toString())
                            .replaceAll("#overAmt#", df.format(new BigDecimal(m.get("overAmt").toString())))
            );

            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }
    private EarlyWarnTransVO margeInvoicePayToWarnVO(PayMnyWarnVO payWarnVO, BigDecimal invoiceMny, BigDecimal overMny, SqlParam param, JSONObject defaultWarnInfo) {
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + payWarnVO.getContractCode());
        vo.setPcTitle("物资采购合同");
        vo.setPcUrl(PC_URL + payWarnVO.getContractId().toString());
        vo.setOrgId(payWarnVO.getOrgId());
        vo.setOrgName(payWarnVO.getOrgName());
        vo.setSourceId(payWarnVO.getContractId().toString());
        vo.setTenantId(payWarnVO.getTenantId());
        vo.setWarnLevel(param.getWarnLevel());
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(
                tmpContent.replaceAll("#orgName#", payWarnVO.getOrgName())
                        .replaceAll("#contractName#", payWarnVO.getContractName())
                        .replaceAll("#sumInvoiceTaxMny#", df.format(invoiceMny))
                        .replaceAll("#sumPayMny#", df.format(payWarnVO.getSumPayMny()))
                        .replaceAll("#percent#", String.valueOf((param.getValue() * 100d)))
                        .replaceAll("#overMny#", df.format(overMny))
        );
        return vo;
    }
    private EarlyWarnTransVO margePrePayToWarnVO(PayMnyWarnVO payWarnVO, BigDecimal invoiceMny, BigDecimal overMny, SqlParam param, JSONObject defaultWarnInfo,BigDecimal contractMny,Long orgId,String orgName) {
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + payWarnVO.getContractCode());
        vo.setPcTitle("物资采购合同");
        vo.setPcUrl(PC_URL + payWarnVO.getContractId().toString());
        vo.setOrgId(orgId);
        vo.setOrgName(orgName);
        vo.setSourceId(payWarnVO.getContractId().toString());
        vo.setTenantId(payWarnVO.getTenantId());
        vo.setWarnLevel(param.getWarnLevel());
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(
                tmpContent.replaceAll("#contractName#", payWarnVO.getContractName())
                        .replaceAll("#contractPayAmt#", df.format(payWarnVO.getSumPayMny()))
                        .replaceAll("#contractAmt#", df.format(contractMny))
                        .replaceAll("#percent#", String.valueOf((param.getValue() * 100d)))
                        .replaceAll("#overAmt#", df.format(overMny))
        );
        return vo;
    }
    private BigDecimal getBigDecimal(Object obj){
        return null == obj ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }

}
