package com.ejianc.business.material.service.impl;

import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service("purchaseSettlement")
public class PurchaseSettlementBpmService implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IPurchaseSettlementService iPurchaseSettlementService;
    @Autowired
    IInstoreService iInstoreService;
    @Autowired
    IOutStoreService iOutStoreService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private ICostDetailApi iCostDetailApi;

    @Autowired
    private HttpServletRequest request;

    // 是否推送凭证
    private static final String VOUCHER_PARAM = "P-h5UC6769";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IVoucherApi voucherApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 提交前回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 提交完回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 终审审核前回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    @Transactional
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 终审审核完回调 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = iPurchaseSettlementService.selectById(billId);
        if (purchaseSettlementEntity == null) {
            return CommonResponse.error("没有找到相关结算单！");
        }
        if (ListUtil.isNotEmpty(purchaseSettlementEntity.getMaterialDetails())) {
            List<String> outStoreIds = new ArrayList<>();
            List<String> inStoreIds = new ArrayList<>();
            purchaseSettlementEntity.getMaterialDetails().forEach(p -> {
                //入库单
                if (Objects.equals("2", p.getSourceType())) {
                    if (!inStoreIds.contains(p.getSourceMainId())) {
                        inStoreIds.add(p.getSourceMainId());
                    }
                }
                //出库单
                if (Objects.equals("4", p.getSourceType())) {
                    if (!outStoreIds.contains(p.getSourceMainId())) {
                        outStoreIds.add(p.getSourceMainId());
                    }
                }
            });
            StringBuffer msg = new StringBuffer("");
            inStoreIds.forEach(s -> {
                InstoreEntity entity = iInstoreService.selectById(Long.parseLong(s));
                if (entity != null) {
                    entity.setSettlementFlag(1);
                    iInstoreService.saveOrUpdate(entity, false);
                } else {
                    msg.append("1");
                }
            });
            if (msg.length() > 0) {
                return CommonResponse.error("没有找到结算单中入库单信息！");
            }
            StringBuffer msg1 = new StringBuffer("");
            outStoreIds.forEach(s -> {
                OutStoreEntity entity = iOutStoreService.selectById(Long.parseLong(s));
                if (entity != null) {
                    entity.setSettlementFlag(1);
                    iOutStoreService.saveOrUpdate(entity, false);
                } else {
                    msg1.append("1");
                }
            });
            if (msg1.length() > 0) {
                return CommonResponse.error("没有找到结算单中退货单信息！");
            }
        }
        iPurchaseSettlementService.processCost(purchaseSettlementEntity);
        iPurchaseSettlementService.saveOrUpdate(purchaseSettlementEntity);

        // 推送凭证
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            Long projectId = purchaseSettlementEntity.getProjectId();
            if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
                ExecutorService threadPool = Executors.newFixedThreadPool(1);
                String authority = request.getHeader("authority");
                if (authority == null) {
                    logger.info("request-authority为空");
                    authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
                }
                try {
                    VoucherParams voucherParams = VoucherParams.newInstanceByOrgId(PurchaseSettlementEntity.BILL_TYPE_CODE, purchaseSettlementEntity, SystemCodeEnum.MATERIAL);
                    Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, iPurchaseSettlementService, voucherParams, VoucherOptFlag.SAVE, RequestContextHolder.getRequestAttributes(), authority);
                    threadPool.submit(voucherCallable);
                } catch (Exception e) {
                    logger.error(this.getClass() + "推送凭证异常, ", e);
                } finally {
                    threadPool.shutdown();
                }
            }
        }
        return CommonResponse.success();
    }


    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 弃审前事件回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = iPurchaseSettlementService.selectById(billId);
        if(purchaseSettlementEntity==null){
            return CommonResponse.error("没有找到相关结算单！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId",new Parameter(QueryParam.EQ,purchaseSettlementEntity.getContractId()));
        param.getParams().put("orgId",new Parameter(QueryParam.EQ,purchaseSettlementEntity.getOrgId()));
        param.getParams().put("createTime",new Parameter(QueryParam.GT,purchaseSettlementEntity.getCreateTime()));
        List<PurchaseSettlementEntity> entities = iPurchaseSettlementService.queryList(param,false);
        if(ListUtil.isNotEmpty(entities)){
            return CommonResponse.error("该结算单结算之后存在单据编号为【"+entities.get(0).getBillCode()+"】的相同合同和组织的结算单，无法撤回！");
        }
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()) {
            logger.info("物资合同结算单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}",billId,billTypeCode, resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 弃审后事件回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = iPurchaseSettlementService.selectById(billId);
        if(purchaseSettlementEntity==null){
            return CommonResponse.error("没有找到相关结算单！");
        }
        if(ListUtil.isNotEmpty(purchaseSettlementEntity.getMaterialDetails())){
            List<String> inStoreIds = new ArrayList<>();
            List<String> outStoreIds = new ArrayList<>();
            purchaseSettlementEntity.getMaterialDetails().forEach(p->{
                //入库单
                if(Objects.equals("2",p.getSourceType())){
                    if(!inStoreIds.contains(p.getSourceMainId())){
                        inStoreIds.add(p.getSourceMainId());
                    }
                }
                //出库单
                if(Objects.equals("4",p.getSourceType())){
                    if(!outStoreIds.contains(p.getSourceMainId())){
                        outStoreIds.add(p.getSourceMainId());
                    }
                }
            });
            StringBuffer msg = new StringBuffer("");
            inStoreIds.forEach(s -> {
                InstoreEntity entity = iInstoreService.selectById(Long.parseLong(s));
                if(entity!=null){
                    entity.setSettlementFlag(0);
                    iInstoreService.saveOrUpdate(entity,false);
                }else {
                    msg.append("1");
                }
            });
            if(msg.length()>0){
                return CommonResponse.error("没有找到结算单中入库单信息！");
            }
            StringBuffer msg1 = new StringBuffer("");
            outStoreIds.forEach(s -> {
                OutStoreEntity entity = iOutStoreService.selectById(Long.parseLong(s));
                if(entity!=null){
                    entity.setSettlementFlag(0);
                    iOutStoreService.saveOrUpdate(entity,false);
                }else {
                    msg1.append("1");
                }
            });
            if(msg1.length()>0){
                return CommonResponse.error("没有找到结算单中退货单信息！");
            }
        }
        iCostDetailApi.deleteSubject(purchaseSettlementEntity.getId());
        purchaseSettlementEntity.setRelationFlag("0");
        iPurchaseSettlementService.saveOrUpdate(purchaseSettlementEntity);

        //更新凭证恢复到初始态
        if (!VoucherFlag.NO_NEED.equals(purchaseSettlementEntity.getVoucherFlag())) {
            //有凭证则删除
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = request.getHeader("authority");
            if (authority == null) {
                logger.info("request-authority为空");
                authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
            }
            try {
                VoucherParams voucherParams = VoucherParams.newInstanceByOrgId(purchaseSettlementEntity.BILL_TYPE_CODE, purchaseSettlementEntity, SystemCodeEnum.MATERIAL);
                Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, iPurchaseSettlementService, voucherParams, VoucherOptFlag.DEL, RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            } catch (Exception e) {
                logger.error(this.getClass() + "撤回凭证异常, ", e);
            } finally {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success();
    }
}
