package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanChangeHisEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.PlanChangeHisMapper;
import com.ejianc.business.plan.mapper.PlanChangeMapper;
import com.ejianc.business.plan.mapper.PlanChangeSubMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/5 9:57
 */
@Service(value = "planChangeService")
public class PlanChangeServiceImpl extends BaseServiceImpl<PlanChangeMapper, PlanChangeEntity> implements IPlanChangeService {

    @Autowired
    private PlanChangeSubMapper planChangeSubMapper;

    @Autowired
    private PlanChangeMapper planChangeMapper;

    @Autowired
    private PlanChangeHisMapper planChangeHisMapper;

    @Autowired
    private IMaterialMasterPlanService materialMasterPlanService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PlanChangeEntity saveOrUpdatePlanChange(PlanChangeEntity saveEntity) {
        if(CollectionUtils.isNotEmpty(saveEntity.getMaterialSubList())) {
            //更新子表信息
            if(null != saveEntity.getId()) {
                planChangeSubMapper.delByPlanId(saveEntity.getId());
            }
        }
        super.saveOrUpdate(saveEntity, false);

        MaterialMasterPlanEntity planEntity = materialMasterPlanService.selectById(saveEntity.getSourcePlanId());
        if(1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingPlanId(saveEntity.getId());
            materialMasterPlanService.saveOrUpdate(planEntity, false);
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteChangePlan(List<Long> changeIds) {
        List<PlanChangeEntity> changeList = planChangeMapper.selectBatchIds(changeIds);
        List<Long> planIds = changeList.stream().map(PlanChangeEntity::getSourcePlanId).collect(Collectors.toList());

        QueryWrapper<MaterialMasterPlanEntity> planQuery = new QueryWrapper<>();
        planQuery.in("id", planIds);
        List<MaterialMasterPlanEntity> planList = materialMasterPlanService.list(planQuery);

        //查询已有的变更历史记录
        QueryWrapper<PlanChangeHisEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, source_plan_id as planId");
        query.in("source_plan_id", planIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("source_plan_id");

        List<Map<String, Object>> queryResult = planChangeHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });

        for(MaterialMasterPlanEntity plan : planList) {
            plan.setChangeState((null !=hisCountNumMap.get(plan.getId()) && hisCountNumMap.get(plan.getId()) > 0) ? 2 : 0); //未变更
            plan.setCurChangingPlanId(null);
        }

        materialMasterPlanService.saveOrUpdateBatch(planList, planList.size());

        super.removeByIds(changeList.stream().map(PlanChangeEntity::getId).collect(Collectors.toList()), false);
    }

    @Override
    public PlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper<PlanChangeEntity> query = new QueryWrapper<>();
        query.eq("source_plan_id", sourcePlanId);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return planChangeMapper.selectOne(query);
    }
}
