package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author liyongjia
 * @Date 2020/6/11  收料入库-物资（子表）实体
 * @Description InstoreMaterialEntity
 */
@TableName("ejc_material_instore_bill_material")
public class InstoreBillMaterialEntity extends BaseEntity {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 入库日期（冗余主表入库日期，便于出库查询计算）
	 */
	@TableField(value = "instore_date")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date instoreDate;

	/**
	 * 仓库id（冗余主表仓库仓库id，便于出库查询计算）
	 */
	@TableField(value = "store_id")
	private Long storeId;

	/**
	 * 入库库物资库存状态，根据主表billState状态判断
	 * 已提交和已通过的，状态为：STORED(3,"已入库");
	 * 新增和审批中的均为：STORING(2,"入库中"),
	 * 参见com.ejianc.business.material.pub.MaterialStoreState.java
	 */
	@TableField(value = "store_state")
	private Integer storeState;

    /**
     * 物资分类名称
     */
    @TableField(value = "material_category_name")
    private String materialCategoryName;

    /**
     * 物资分类id
     */
    @TableField(value = "material_category_id")
    private Long materialCategoryId;

    /**
     * 物资id
     */
    @TableField(value = "material_id")
    private Long materialId;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 规格型号
     */
    @TableField(value = "material_spec")
    private String materialSpec;

    /**
     * 计量单位
     */
    @TableField(value = "material_unit")
    private String materialUnit;

    /**
     * 入库数量
     */
    @TableField(value = "instore_number")
    private BigDecimal instoreNumber;

    /**
     * 单价
     */
    @TableField(value = "unit_price")
    private BigDecimal unitPrice;

    /**
     * 金额
     */
    @TableField(value = "amount")
    private BigDecimal amount;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 领料数量---领料退库
     */
    @TableField(value = "pick_number")
    private BigDecimal pickNumber;

    /**
     * 来源
     */
    @TableField(value = "source_type")
    private String sourceType;

    /**
     * 来源id
     */
    @TableField(value = "source_id")
    private Long sourceId;

	/**
	 * 数据来源主表id
	 */
	@TableField(value = "source_main_id")
	private String sourceMainId;

    /**
     * 主表id
     */
    @TableField(value = "instore_id")
    private Long instoreId;

    /**
     * 入库类型（1:收料入库,2:直接入库,3:调拨入库,4:物资退库）
     */
    @TableField(value = "instore_type")
    private Integer instoreType;

	/**
	 * 成本科目主键
	 */
	@TableField(value = "subject_id")
	private Long subjectId;

	/**
	 * 成本科目名称
	 */
	@TableField(value = "subject_name")
	private String subjectName;

	/**
	 * 税率
	 */
	@TableField(value = "tax_rate")
	private BigDecimal taxRate;

	@TableField(value="material_info")
	private String materialInfo; // 采购物资名称
	@TableField(value="material_supplier_id")
	private Long materialSupplierId; // 供应商品牌id
	@TableField(value="material_supplier_name")
	private String materialSupplierName; // 供应商品牌
	@TableField(value="model_id")
	private Long modelId; // 规格型号id
	@TableField(value="thickness")
	private String thickness; // 厚度
	@TableField(value="colour")
	private String colour; // 色号/容重

	public Date getInstoreDate() {
		return instoreDate;
	}

	public void setInstoreDate(Date instoreDate) {
		this.instoreDate = instoreDate;
	}

	public Long getStoreId() {
		return storeId;
	}

	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public Integer getStoreState() {
		return storeState;
	}

	public void setStoreState(Integer storeState) {
		this.storeState = storeState;
	}

	public String getMaterialCategoryName() {
		return materialCategoryName;
	}

	public void setMaterialCategoryName(String materialCategoryName) {
		this.materialCategoryName = materialCategoryName;
	}

	public Long getMaterialCategoryId() {
		return materialCategoryId;
	}

	public void setMaterialCategoryId(Long materialCategoryId) {
		this.materialCategoryId = materialCategoryId;
	}

	public Long getMaterialId() {
		return materialId;
	}

	public void setMaterialId(Long materialId) {
		this.materialId = materialId;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public String getMaterialSpec() {
		return materialSpec;
	}

	public void setMaterialSpec(String materialSpec) {
		this.materialSpec = materialSpec;
	}

	public String getMaterialUnit() {
		return materialUnit;
	}

	public void setMaterialUnit(String materialUnit) {
		this.materialUnit = materialUnit;
	}

	public BigDecimal getInstoreNumber() {
		return instoreNumber;
	}

	public void setInstoreNumber(BigDecimal instoreNumber) {
		this.instoreNumber = instoreNumber;
	}

	public BigDecimal getUnitPrice() {
		return unitPrice;
	}

	public void setUnitPrice(BigDecimal unitPrice) {
		this.unitPrice = unitPrice;
	}

	public BigDecimal getAmount() {
		return amount;
	}

	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getSourceType() {
		return sourceType;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}

	public Long getInstoreId() {
		return instoreId;
	}

	public void setInstoreId(Long instoreId) {
		this.instoreId = instoreId;
	}

	public Integer getInstoreType() {
		return instoreType;
	}

	public void setInstoreType(Integer instoreType) {
		this.instoreType = instoreType;
	}

	public BigDecimal getPickNumber() {
		return pickNumber;
	}

	public void setPickNumber(BigDecimal pickNumber) {
		this.pickNumber = pickNumber;
	}

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	public String getSourceMainId() {
		return sourceMainId;
	}

	public void setSourceMainId(String sourceMainId) {
		this.sourceMainId = sourceMainId;
	}

	public Long getSubjectId() {
		return subjectId;
	}

	public void setSubjectId(Long subjectId) {
		this.subjectId = subjectId;
	}

	public String getSubjectName() {
		return subjectName;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}

	public BigDecimal getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(BigDecimal taxRate) {
		this.taxRate = taxRate;
	}

	public String getMaterialInfo() {
		return materialInfo;
	}

	public void setMaterialInfo(String materialInfo) {
		this.materialInfo = materialInfo;
	}

	public Long getMaterialSupplierId() {
		return materialSupplierId;
	}

	public void setMaterialSupplierId(Long materialSupplierId) {
		this.materialSupplierId = materialSupplierId;
	}

	public String getMaterialSupplierName() {
		return materialSupplierName;
	}

	public void setMaterialSupplierName(String materialSupplierName) {
		this.materialSupplierName = materialSupplierName;
	}

	public Long getModelId() {
		return modelId;
	}

	public void setModelId(Long modelId) {
		this.modelId = modelId;
	}

	public String getThickness() {
		return thickness;
	}

	public void setThickness(String thickness) {
		this.thickness = thickness;
	}

	public String getColour() {
		return colour;
	}

	public void setColour(String colour) {
		this.colour = colour;
	}

}
