package com.ejianc.business.material.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.InstoreBillMaterialEntity;
import com.ejianc.business.material.vo.InstoreBillMaterialVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public interface IInstoreBillMaterialService extends IBaseService<InstoreBillMaterialEntity> {

    List<InstoreBillMaterialVO> querylist(QueryWrapper<InstoreBillMaterialEntity> queryWrapper);

    IPage<InstoreBillMaterialVO> queryStoreCanUseNumPageData(String searchText, String outDate,
                                                         Long storeId, Integer pageNum, Integer pageSize);

    IPage<InstoreBillMaterialVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize);

    BigDecimal countAmount(QueryParam param);

    InstoreBillMaterialVO censusStorematerial(Long storeIid);

    /**
     * 查询指定仓库可用物资列表，相同物资数量、金额合并
     *
     * @param searchText
     * @param outDate
     * @param storeId
     * @param pageNumber
     * @param pageSize
     * @param materialIds
     * @param map
     * @return
     */
    IPage<InstoreBillMaterialVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds, HashMap<String, String> map);

    /**
     * 查询指定物资在指定仓库中的各个入库单中的库存情况，盘点使用
     *
     * @param storeId
     * @param checkDate
     * @param materialId
     * @param inventory
     * @return
     */
    List<InstoreBillMaterialVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory);


    /**
     * @param vo
     * @description: 参数校验
     * @return: com.ejianc.business.finance.vo.ParamsCheckVO
     * @author songlx
     * @date: 2021-05-27
     */
    ParamsCheckVO checkParams(MaterialPriceVO vo);
}
