package com.ejianc.business.material.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  用料申请子实体
 * @Description UseApplySubEntity
 */

public class UseApplySubVO extends BaseVO {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 主表id
     */
    private Long pid;

    /**
     * 物资分类名称
     */
    private String materialTypeName;


    /**
     * 物资分类id
     */
    private Long materialTypeId;

    /**
     * 物资名称
     */
    private String materialName;

    /**
     * 物资id
     */
    private Long materialId;

    /**
     * 规格型号
     */
    private String model;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 申请数量
     */
    private BigDecimal applyNum;

    /**
     * 暂估单价
     */
    private BigDecimal estimatePrice;

    /**
     * 暂估金额
     */
    private BigDecimal estimateMoney;

    /**
     * 计划进场日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subPlanEnterDate;

    /**
     * 备注
     */
    private String memo;

    /**
     * 物资来源类型：1-总计划，2-物资档案，3-批次计划，4-导入
     */
    private String sourceType;

    /**
     * 物资来源单据Id
     */
    private Long sourceId;

    /**
     * 临时字段 计划进场日期字符串，导出使用
     */
    private String subPlanEnterDateStr;

    private java.lang.String materialInfo; // 采购物资名称
    private java.lang.Long supplierId; // 供应商品牌id
    private java.lang.String supplierName; // 供应商品牌
    private java.lang.Long modelId; // 规格型号id
    private java.lang.String thickness; // 厚度
    private java.lang.String colour; // 色号/容重

    private java.math.BigDecimal orderNum; // 订货量
    private java.math.BigDecimal planNum; // 进度量
    private java.math.BigDecimal totalNum; // 总量
    private Integer isFinish; // 是否完成1是0否

    private java.math.BigDecimal sumApplyNum; // 累计申请量

    private java.lang.String orderPlanNum; // 订货量/进度量

    private java.lang.String orderTotalNum; // 订货量/总量

    private java.math.BigDecimal masterPlanNum; // 总计划量
    private java.lang.String orderMasterPlanNum; // 订货量/总计划量

    /**
     * 导入失败原因
     */
    private String errorMessage;

    public BigDecimal getMasterPlanNum() {
        return masterPlanNum;
    }

    public void setMasterPlanNum(BigDecimal masterPlanNum) {
        this.masterPlanNum = masterPlanNum;
    }

    public String getOrderMasterPlanNum() {
        return ComputeUtil.nullToZero(this.orderNum) + "/" + ComputeUtil.nullToZero(this.masterPlanNum);
    }

    public void setOrderMasterPlanNum(String orderMasterPlanNum) {
        this.orderMasterPlanNum = orderMasterPlanNum;
    }

    public String getOrderPlanNum() {
        return ComputeUtil.nullToZero(this.orderNum) + "/" + ComputeUtil.nullToZero(this.planNum);
    }

    public void setOrderPlanNum(String orderPlanNum) {
        this.orderPlanNum = orderPlanNum;
    }

    public String getOrderTotalNum() {
        return ComputeUtil.nullToZero(this.orderNum) + "/" + ComputeUtil.nullToZero(this.totalNum);
    }

    public void setOrderTotalNum(String orderTotalNum) {
        this.orderTotalNum = orderTotalNum;
    }

    public BigDecimal getSumApplyNum() {
        return sumApplyNum;
    }

    public void setSumApplyNum(BigDecimal sumApplyNum) {
        this.sumApplyNum = sumApplyNum;
    }


    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }


    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    @ReferDeserialTransfer@ReferSerialTransfer(referCode = "support-defdoc")
    public Long getModelId() {
        return modelId;
    }
    @ReferDeserialTransfer
    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public String getThickness() {
        return thickness;
    }

    public void setThickness(String thickness) {
        this.thickness = thickness;
    }

    public String getColour() {
        return colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }

    public BigDecimal getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(BigDecimal orderNum) {
        this.orderNum = orderNum;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(BigDecimal totalNum) {
        this.totalNum = totalNum;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getApplyNum() {
        return applyNum;
    }

    public void setApplyNum(BigDecimal applyNum) {
        this.applyNum = applyNum;
    }

    public BigDecimal getEstimatePrice() {
        return estimatePrice;
    }

    public void setEstimatePrice(BigDecimal estimatePrice) {
        this.estimatePrice = estimatePrice;
    }

    public BigDecimal getEstimateMoney() {
        return estimateMoney;
    }

    public void setEstimateMoney(BigDecimal estimateMoney) {
        this.estimateMoney = estimateMoney;
    }

    public Date getSubPlanEnterDate() {
        return subPlanEnterDate;
    }

    public void setSubPlanEnterDate(Date subPlanEnterDate) {
        this.subPlanEnterDate = subPlanEnterDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSubPlanEnterDateStr() {
        return subPlanEnterDateStr;
    }

    public void setSubPlanEnterDateStr(String subPlanEnterDateStr) {
        this.subPlanEnterDateStr = subPlanEnterDateStr;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
