/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.vo.MaterialContractDetailSubVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.plan.bean.BatchPlanEntity;
import com.ejianc.business.plan.bean.BatchPlanSubEntity;
import com.ejianc.business.plan.mapper.BatchPlanMapper;
import com.ejianc.business.plan.mapper.BatchPlanSubMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.service.IBatchPlanService;
import com.ejianc.business.plan.vo.BatchPlanSubVO;
import com.ejianc.business.plan.vo.BatchPlanVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="batchPlanService")
public class BatchPlanServiceImpl
extends BaseServiceImpl<BatchPlanMapper, BatchPlanEntity>
implements IBatchPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BatchPlanMapper batchPlanMapper;
    @Autowired
    private BatchPlanSubMapper batchPlanSubMapper;
    @Autowired
    private UseApplyMapper useApplyMapper;
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    private static String PARAM_PLAN_ALL_COUNT = "P-sa751728";

    @Override
    public BatchPlanVO queryByCode(String billCode) {
        BatchPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)billCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        BatchPlanEntity entity = (BatchPlanEntity)((Object)this.batchPlanMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (BatchPlanVO)BeanMapper.map((Object)((Object)entity), BatchPlanVO.class);
        }
        return resp;
    }

    @Override
    public List<BatchPlanEntity> queryByProjectId(Long projectId, Long id) {
        Object resp = null;
        QueryWrapper query = new QueryWrapper();
        if (id != null) {
            query.notIn((Object)"id", new Object[]{id});
        }
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List entitys = this.batchPlanMapper.selectList((Wrapper)query);
        return entitys;
    }

    @Override
    public BigDecimal getSurplusNum(BatchPlanSubVO vo) {
        ArrayList<Integer> approvedBillState = new ArrayList<Integer>();
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("materialId", vo.getMaterialId());
        queryParam.put("materialTypeId", vo.getMaterialCategoryId());
        queryParam.put("sourceId", vo.getId());
        List<UseApplySubVO> applylist = this.useApplyMapper.queryListByMaterial(queryParam);
        List<MaterialContractDetailSubVO> contractList = this.materialContractMapper.queryListByMaterial(queryParam);
        BigDecimal applyNum = applylist.stream().map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractNum = contractList.stream().map(MaterialContractDetailSubVO::getCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal num_temp = ComputeUtil.safeSub((BigDecimal)vo.getNum(), (BigDecimal)applyNum);
        BigDecimal surplusNum = ComputeUtil.safeSub((BigDecimal)num_temp, (BigDecimal)contractNum);
        return surplusNum;
    }

    @Override
    public ParamsCheckVO checkAllParams(BatchPlanVO vo) {
        List batchPlanSubList = vo.getBatchPlanSubList();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isEmpty((Collection)batchPlanSubList)) {
            return paramsCheckVO;
        }
        CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_ALL_COUNT);
        if (!countParamByCode.isSuccess() || null == countParamByCode.getData()) {
            this.logger.info(countParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        BigDecimal manageRate = ((BillParamVO)countParamByCode.getData()).getRoleValue();
        BillParamVO billParamVO = (BillParamVO)countParamByCode.getData();
        paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
        if (billParamVO.getControlType() == 0) {
            return paramsCheckVO;
        }
        ArrayList checkDsVOS = new ArrayList();
        Long projectId = vo.getProjectId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.in((Object)"bill_state", new Object[]{1, 3});
        List materialMasterPlanEntities = this.materialMasterPlanMapper.selectList((Wrapper)wrapper);
        QueryWrapper planSubWrapper = new QueryWrapper();
        ArrayList<Long> ids = new ArrayList<Long>();
        materialMasterPlanEntities.forEach(item -> ids.add(item.getId()));
        ids.add(1L);
        planSubWrapper.in((Object)"material_master_plan_id", ids);
        planSubWrapper.eq((Object)"dr", (Object)0);
        List materialMasterPlanSubEntities = this.materialMasterPlanSubMapper.selectList((Wrapper)planSubWrapper);
        HashMap planMap = new HashMap();
        materialMasterPlanSubEntities.forEach(item -> {
            Double num = item.getNum();
            planMap.put(item.getMaterialId(), BigDecimal.valueOf(num));
        });
        QueryWrapper appWrapper = new QueryWrapper();
        appWrapper.eq((Object)"project_id", (Object)projectId);
        appWrapper.eq((Object)"dr", (Object)0);
        List batchPlanEntities = this.batchPlanMapper.selectList((Wrapper)appWrapper);
        ids.clear();
        batchPlanEntities.forEach(item -> ids.add(item.getId()));
        ArrayList noIds = new ArrayList();
        batchPlanSubList.forEach(item -> {
            if (item.getId() != null) {
                noIds.add(item.getId());
            }
        });
        ids.add(1L);
        QueryWrapper appSubWrapper = new QueryWrapper();
        appSubWrapper.in((Object)"plan_id", ids);
        appSubWrapper.notIn((Object)"id", noIds);
        appSubWrapper.eq((Object)"dr", (Object)0);
        List batchPlanSubEntities1 = this.batchPlanSubMapper.selectList((Wrapper)appSubWrapper);
        List batchPlanSubEntities2 = BeanMapper.mapList((Iterable)batchPlanSubList, BatchPlanSubEntity.class);
        HashMap<Long, BatchPlanSubEntity> thisMap = new HashMap<Long, BatchPlanSubEntity>();
        batchPlanSubEntities2.forEach(item -> {
            if (thisMap.containsKey(item.getMaterialId())) {
                BatchPlanSubEntity batchPlanSubEntity = (BatchPlanSubEntity)((Object)((Object)thisMap.get(item.getMaterialId())));
                batchPlanSubEntity.setNum(batchPlanSubEntity.getNum().add(item.getNum()));
            } else {
                thisMap.put(item.getMaterialId(), (BatchPlanSubEntity)((Object)item));
            }
        });
        HashMap oldAppMap = new HashMap();
        batchPlanSubEntities1.forEach(item -> {
            BigDecimal applyNum = item.getNum();
            if (oldAppMap.containsKey(item.getMaterialId())) {
                BigDecimal bigDecimal = (BigDecimal)oldAppMap.get(item.getMaterialId());
                oldAppMap.put(item.getMaterialId(), applyNum.add(bigDecimal));
            } else {
                oldAppMap.put(item.getMaterialId(), applyNum);
            }
        });
        thisMap.forEach((k, item) -> {
            BigDecimal batNumber;
            Long materialId = item.getMaterialId();
            BigDecimal batNum = item.getNum();
            BigDecimal oldBatNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)oldAppMap.get(materialId);
            BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)planMap.get(materialId);
            BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100L));
            if (planNumber.compareTo(batNumber = ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)oldBatNum, (BigDecimal)batNum))) == -1) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)item.getSpec()) ? " [" + item.getSpec() + "]" : ""));
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u6279\u6b21\u8ba1\u5212\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u91cf");
                paramsCheckDsVO.setContent("\u672c\u6b21\u8ba1\u5212\u6570\u91cf:" + batNum.setScale(2, 4) + ",\u542b\u672c\u6b21\u7d2f\u8ba1\u8ba1\u5212\u6570\u91cf:" + batNumber.setScale(2, 4) + ",\u603b\u8ba1\u5212\u6570\u91cf:" + planNum.setScale(2, 4) + ",\u8d85\u51fa\u6570\u91cf:" + ComputeUtil.safeSub((BigDecimal)batNumber, (BigDecimal)planNum).setScale(2, 4));
                checkDsVOS.add(paramsCheckDsVO);
            }
            paramsCheckVO.setDataSource(checkDsVOS);
        });
        return paramsCheckVO;
    }
}

