/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.mapper.InstoreBillMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.mapper.OutStoreMapper;
import com.ejianc.business.material.mapper.OutStoreSubMapper;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.business.material.vo.OutStoreVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.PickRegisterDetailVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutStoreService
extends BaseServiceImpl<OutStoreMapper, OutStoreEntity>
implements IOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OutStoreSubMapper outStoreSubMapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-72Q53Y26";
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private InstoreBillMaterialMapper instoreBillMaterialMapper;

    @Override
    public IPage<OutStoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), OutStoreVO.class));
        }
        return voPage;
    }

    @Override
    public void processCost(OutStoreEntity entity) {
        String factor = "1";
        if (ListUtil.isNotEmpty(entity.getOutStoreSubEntities())) {
            ArrayList<CostDetailVO> list = new ArrayList<CostDetailVO>();
            boolean canPush = true;
            for (int i = 0; i < entity.getOutStoreSubEntities().size(); ++i) {
                CostDetailVO c;
                OutStoreSubEntity sub = entity.getOutStoreSubEntities().get(i);
                if (sub.getSubjectId() != null && sub.getSubjectId() > 0L) {
                    c = new CostDetailVO();
                    c.setSubjectId(sub.getSubjectId());
                    c.setSourceId(entity.getId());
                    c.setSourceDetailId(sub.getId());
                    c.setProjectId(entity.getProjectId());
                    c.setHappenTaxMny(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().multiply(new BigDecimal(factor)));
                    if (sub.getAmount() == null) {
                        c.setHappenMny(new BigDecimal("0.00"));
                    } else {
                        BigDecimal rate = sub.getTaxRate() == null ? new BigDecimal("1.00") : new BigDecimal("1.00").add(sub.getTaxRate().divide(new BigDecimal("100.00"), 8, 4));
                        BigDecimal happenMny = sub.getAmount().divide(rate, 8, 4).multiply(new BigDecimal(factor));
                        c.setHappenMny(happenMny);
                    }
                } else {
                    canPush = false;
                    break;
                }
                c.setHappenDate(entity.getOutDate());
                c.setMemo(entity.getMemo());
                c.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                c.setSourceType(MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getStoreType()));
                c.setSourceTabType(MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getStoreType()) + "\u5b50\u8868");
                list.add(c);
            }
            if (canPush) {
                CommonResponse response = this.iCostDetailApi.saveSubject(list);
                this.logger.info("\u63a8\u9001\u6210\u672c" + MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getStoreType()) + "\u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
                entity.setRelationFlag("1");
            } else {
                CommonResponse response = this.iCostDetailApi.deleteSubject(entity.getId());
                this.logger.info("\u5220\u9664\u6210\u672c" + MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getStoreType()) + "\u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
                entity.setRelationFlag("0");
            }
        } else {
            this.iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }

    @Override
    public CommonResponse<List<JSONObject>> queryMaterialCostTopN(Integer topN, Integer type) {
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        String startDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.beginOfYear((Date)new Date()));
        startDate = "'" + startDate + "'";
        List<OutStoreSubVO> outStoreSubEntities = this.outStoreSubMapper.queryMaterialCategoryCostTopN(topN, type, startDate, orgIds);
        ArrayList result = new ArrayList();
        this.logger.info("\u67e5\u8be2\u7269\u8d44\u5f00\u7d2f\u5e74\u7d2f\u6d88\u8017top n outStoreSubEntities \u6570\u91cf\uff1a" + (ListUtil.isNotEmpty(outStoreSubEntities) ? Integer.valueOf(outStoreSubEntities.size()) : "\u7a7a") + " \u5f53\u524dorgId\uff1a" + InvocationInfoProxy.getOrgId());
        if (ListUtil.isNotEmpty(outStoreSubEntities)) {
            outStoreSubEntities.forEach(en -> {
                JSONObject object = new JSONObject();
                object.put("materialCategoryName", (Object)en.getMaterialCategoryName());
                object.put("outStoreNumber", (Object)en.getOutStoreNumber());
                object.put("amount", (Object)en.getAmount());
                object.put("weight", (Object)(ComputeUtil.safeMultiply((BigDecimal)en.getUnitPrice(), (BigDecimal)new BigDecimal("100")).setScale(0, 4) + "%"));
                result.add(object);
            });
        }
        return CommonResponse.success(result);
    }

    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        ArrayList checkDsVOS;
        List detailList = vo.getDetail();
        HashMap numMap = new HashMap();
        detailList.forEach(detail -> {
            MaterialPriceVO materialPriceVO = (MaterialPriceVO)numMap.get(detail.getMaterialId());
            if (materialPriceVO != null) {
                materialPriceVO.setNum(ComputeUtil.safeAdd((BigDecimal)materialPriceVO.getNum(), (BigDecimal)detail.getNum()));
            } else {
                numMap.put(detail.getMaterialId(), detail);
            }
        });
        vo.setDetail(new ArrayList(numMap.values()));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List detail2 = vo.getDetail();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isEmpty((Collection)detail2)) {
            return paramsCheckVO;
        }
        CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)countParamByCode.getData();
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            checkDsVOS = new ArrayList();
            if (0 != billParamVO.getControlType()) {
                List<Long> materialIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                List<MaterialPriceVO> vos = this.outStoreSubMapper.queryMaterialOutstoreCount(vo.getProjectId(), materialIds);
                List<MaterialPriceVO> list = this.instoreBillMaterialMapper.queryReturnInStoreCount(vo.getProjectId(), materialIds);
                List<MaterialPriceVO> materialPriceVOS = this.materialContractMapper.queryPlanPriceByProjectId(vo.getProjectId(), materialIds);
                if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                    Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                    for (MaterialPriceVO v : detail2) {
                        Long materialId = v.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (null == p) continue;
                        v.setPlanNum(p.getPlanNum());
                        v.setPlanPrice(p.getPlanPrice());
                    }
                }
                Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                Map<Long, BigDecimal> returNumMap = list.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                detail2.forEach(d -> {
                    BigDecimal _planNum;
                    BigDecimal num = d.getNum();
                    BigDecimal planNum = d.getPlanNum();
                    BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? (BigDecimal)numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                    BigDecimal allNum = hasNum.add(num);
                    BigDecimal returNum = returNumMap.get(d.getMaterialId()) != null ? (BigDecimal)returNumMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                    if ((allNum = allNum.subtract(returNum)).compareTo(_planNum = planNum.multiply(divide)) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                        paramsCheckDsVO.setWarnName("\u7269\u8d44\u51fa\u5e93\u6570\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u6570\u91cf");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u51fa\u5e93\u6570\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u5df2\u51fa\u5e93\u6570\u91cf\uff1a").append(hasNum.subtract(returNum).setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue).append("%: ").append(_planNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(allNum.subtract(_planNum).setScale(2, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                });
            }
        } else {
            this.logger.info(countParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }

    @Override
    public List<PickRegisterDetailVO> queryPickDeductList(Page<PickRegisterDetailVO> page, QueryWrapper wrapper, Long projectId, Long supplierId) {
        return ((OutStoreMapper)this.baseMapper).queryPickDeductList(page, wrapper, projectId, supplierId);
    }
}

