/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.material.bean.PickRegisterDetailEntity;
import com.ejianc.business.material.bean.PickRegisterEntity;
import com.ejianc.business.material.service.IPickRegisterDetailService;
import com.ejianc.business.material.service.IPickRegisterService;
import com.ejianc.business.material.vo.PickRegisterDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pickRegister/"})
public class MaterialPickRegisterApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IPickRegisterService pickRegisterService;
    @Autowired
    IPickRegisterDetailService pickRegisterDetailService;

    @RequestMapping(value={"updateDeductMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateDeductMny(@RequestBody List<PickRegisterDetailVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            Map<Long, BigDecimal> map = vos.stream().collect(Collectors.toMap(BaseVO::getId, PickRegisterDetailVO::getDeductMny, (key1, key2) -> key2));
            LambdaQueryWrapper detailEntity = new LambdaQueryWrapper();
            detailEntity.in(BaseEntity::getId, map.keySet());
            List list = this.pickRegisterDetailService.list((Wrapper)detailEntity);
            BigDecimal totalDeductMny = BigDecimal.ZERO;
            for (PickRegisterDetailEntity entity : list) {
                BigDecimal deductMny = ComputeUtil.safeAdd((BigDecimal)entity.getDeductMny(), (BigDecimal)map.get(entity.getId()));
                totalDeductMny = ComputeUtil.safeAdd((BigDecimal)totalDeductMny, (BigDecimal)deductMny);
                LambdaUpdateWrapper detailWrapper = new LambdaUpdateWrapper();
                detailWrapper.set(PickRegisterDetailEntity::getDeductMny, (Object)deductMny);
                detailWrapper.eq(BaseEntity::getId, (Object)entity.getId());
                this.pickRegisterDetailService.update((Wrapper)detailWrapper);
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(PickRegisterEntity::getTotalDeductMny, (Object)totalDeductMny);
            wrapper.eq(BaseEntity::getId, (Object)vos.get(0).getRegisterId());
            this.pickRegisterService.update((Wrapper)wrapper);
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u6570\u636e\u6210\u529f\uff01");
    }
}

