/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/purchaseSettlement/"})
public class MaterialSettlementApi {
    @Autowired
    IPurchaseSettlementService iPurchaseSettlementService;

    @GetMapping(value={"updateSettlementBillAlreadyApplyAmount"})
    public CommonResponse<String> updateSettlementBillAlreadyApplyAmount(@RequestParam(value="settlementBillId") Long settlementBillId, @RequestParam(value="currentApplyAmount") BigDecimal currentApplyAmount) {
        if (settlementBillId == null || currentApplyAmount == null) {
            return CommonResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)this.iPurchaseSettlementService.selectById(settlementBillId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355\uff01");
        }
        BigDecimal currentSettlementAmountTax = entity.getCurrentSettlementAmountTax();
        BigDecimal alreadyApplyAmount = entity.getCurrentApplyAmount();
        if (alreadyApplyAmount == null) {
            alreadyApplyAmount = new BigDecimal("0.00");
        }
        alreadyApplyAmount = alreadyApplyAmount.add(currentApplyAmount).setScale(2, 4);
        entity.setCurrentApplyAmount(alreadyApplyAmount);
        if (currentSettlementAmountTax == null) {
            currentSettlementAmountTax = new BigDecimal("0.00");
        }
        BigDecimal remainCanApplyAmount = currentSettlementAmountTax.subtract(alreadyApplyAmount).subtract(entity.getOffsetAmountInCurrentPeriod()).setScale(2, 4);
        entity.setRemainCanApplyAmount(remainCanApplyAmount);
        this.iPurchaseSettlementService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u66f4\u65b0\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355\u7d2f\u8ba1\u5df2\u7533\u8bf7\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"updateSettlementBillAlreadyPaidAmount"})
    public CommonResponse<String> updateSettlementBillAlreadyPaidAmount(@RequestParam(value="settlementBillId") Long settlementBillId, @RequestParam(value="currentPaidAmount") BigDecimal currentPaidAmount) {
        if (settlementBillId == null || currentPaidAmount == null) {
            return CommonResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)this.iPurchaseSettlementService.selectById(settlementBillId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355\uff01");
        }
        BigDecimal alreadyPaidAmount = entity.getCurrentPaidAmount();
        if (alreadyPaidAmount == null) {
            alreadyPaidAmount = new BigDecimal("0.00");
        }
        alreadyPaidAmount = alreadyPaidAmount.add(currentPaidAmount).setScale(2, 4);
        entity.setCurrentPaidAmount(alreadyPaidAmount);
        this.iPurchaseSettlementService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u66f4\u65b0\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355\u7d2f\u8ba1\u5df2\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"getTotalOffsetAmountByContractIdAndOrgId"})
    public CommonResponse<BigDecimal> getTotalOffsetAmountByContractIdAndOrgId(@RequestParam(value="contractId") Long contractId, @RequestParam(value="orgId") Long orgId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.iPurchaseSettlementService.queryList(queryParam, false);
        BigDecimal res = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty((List)list)) {
            for (PurchaseSettlementEntity entity : list) {
                res = res.add(entity.getOffsetAmountInCurrentPeriod()).setScale(2, 4);
            }
        }
        return CommonResponse.success((Object)res);
    }

    @GetMapping(value={"getSumSettleTaxMny"})
    public CommonResponse<BigDecimal> getSumSettleTaxMny(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="projectId", required=true) Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq(PurchaseSettlementEntity::getContractId, (Object)contractId);
        wrapper.eq(PurchaseSettlementEntity::getProjectId, (Object)projectId);
        wrapper.in(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.iPurchaseSettlementService.list((Wrapper)wrapper);
        BigDecimal res = BigDecimal.ZERO;
        for (PurchaseSettlementEntity entity : list) {
            res = MathUtil.safeAdd((BigDecimal)res, (BigDecimal)entity.getCurrentSettlementAmountTax());
        }
        return CommonResponse.success((Object)res);
    }
}

