package com.ejianc.business.material.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.plan.api.IBudgetPlanApi;
import com.ejianc.business.plan.vo.RecalculateVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("instore")
public class InstoreBpmService implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IInstoreService iInstoreService;

    @Autowired
    IBudgetPlanApi budgetPlanApi;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    IUseApplyService useApplyService;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        logger.info("-----------审批节点审批中时节点审批后回调-----------");
        logger.info("开始时间-----------" + other.get("taskStartTime"));
        logger.info("审批意见-----------" + other.get("comment"));
        logger.info("other-----------" + other);
        return CommonResponse.success();
    }

    ;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
//		return CommonResponse.error("提交后手动失败测试");
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
//		return CommonResponse.error("撤回后手动失败测试");
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("审批通过后的回调开始-------------------");
        logger.info("审批通过后的回调，修改的状态------" + MaterialStoreState.STORED.getCode());
//		return CommonResponse.error("审批通过后手动失败测试");
        InstoreEntity entity = iInstoreService.selectById(billId);
        if (null != entity && entity.getProjectId() != null) {

            RecalculateVO cal = RecalculateVO.intsance(entity.getProjectId(), null);
            CommonResponse<RecalculateVO> info = budgetPlanApi.getInfo(cal);
            //如果有计划信息
            if (info.isSuccess()) {
                RecalculateVO data = info.getData();
                Map<String, Object> queryParam = data.getQueryParam();
                if (queryParam != null && queryParam.size() > 0) {
                    List<InstoreMaterialVO> instoreMaterialVOS = iInstoreService.instoreNumCount(queryParam);
                    List<UseApplyFinishVO> useApplySubVOS = useApplyService.materialFinishCount(queryParam);
                    if(CollectionUtils.isNotEmpty(instoreMaterialVOS)){
                        cal.setInstoreMaterialVOS(instoreMaterialVOS);
                        cal.setUseApplyFinishVOS(useApplySubVOS);
                        CommonResponse<RecalculateVO> recal = budgetPlanApi.recal(cal);
                        logger.info("收料入库审批通过回写施工计划返回信息:" + recal.getMsg());
                    }
                }
            } else {
                CommonResponse<RecalculateVO> recalculateVOCommonResponse = budgetPlanApi.recal3(entity.getProjectId());
                logger.info("无施工计划入库更新:"+recalculateVOCommonResponse.getMsg());
                logger.info("收料入库审批通过查询施工计划返回信息:" + info.getMsg());
            }
        }
        return changeStoreState(billId, MaterialStoreState.STORED.getCode());
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("弃审后的回调开始-------------------");
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            logger.info("收料入库单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}", billId, billTypeCode, resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }
        logger.info("弃审后的回调，修改的状态------" + MaterialStoreState.STORED.getCode());

        CommonResponse<String> stringCommonResponse = changeStoreState(billId, MaterialStoreState.STORING.getCode());

        if(stringCommonResponse.isSuccess()){
            InstoreEntity entity = iInstoreService.selectById(billId);
            if (null != entity && entity.getProjectId() != null) {
                RecalculateVO cal = RecalculateVO.intsance(entity.getProjectId(), null);
                CommonResponse<RecalculateVO> info = budgetPlanApi.getInfo(cal);
                //如果有计划信息
                if (info.isSuccess()) {
                    RecalculateVO data = info.getData();
                    Map<String, Object> queryParam = data.getQueryParam();
                    if (queryParam != null && queryParam.size() > 0) {
                        List<InstoreMaterialVO> instoreMaterialVOS = iInstoreService.instoreNumCount(queryParam);
                        List<UseApplyFinishVO> useApplySubVOS = useApplyService.materialFinishCount(queryParam);
                        if(CollectionUtils.isNotEmpty(instoreMaterialVOS)){
                            cal.setInstoreMaterialVOS(instoreMaterialVOS);
                            cal.setUseApplyFinishVOS(useApplySubVOS);
                            CommonResponse<RecalculateVO> recal = budgetPlanApi.recal(cal);
                            logger.info("收料入库弃审回写施工计划返回信息:" + recal.getMsg());
                        }
                    }
                } else {
                    CommonResponse<RecalculateVO> recalculateVOCommonResponse = budgetPlanApi.recal3(entity.getProjectId());
                    logger.info("无施工计划入库弃审更新:"+recalculateVOCommonResponse.getMsg());
                    logger.info("收料入库弃审查询施工计划返回信息:" + info.getMsg());
                }
            }
        }

        return stringCommonResponse;
    }

    public CommonResponse<String> changeStoreState(Long billId, Integer state) {
        InstoreEntity entity = iInstoreService.selectById(billId);
        if (entity == null) {
            CommonResponse.error("没有找到相关入库单！");
        }
        if (!ListUtil.isEmpty(entity.getInstoreMaterialList())) {
            entity.getInstoreMaterialList().forEach(sub -> {
                sub.setStoreState(state);
            });
        }
        iInstoreService.saveOrUpdate(entity, false);
        return CommonResponse.success();
    }
}
