/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.bean.PurchaseSettlementMaterialDetailEntity;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="purchaseSettlement")
public class PurchaseSettlementBpmService
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IPurchaseSettlementService iPurchaseSettlementService;
    @Autowired
    IInstoreService iInstoreService;
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    IInstoreMaterialService instoreMaterialService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private HttpServletRequest request;
    private static final String VOUCHER_PARAM = "P-h5UC6769";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IVoucherApi voucherApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ed3\u7b97 \u63d0\u4ea4\u524d\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ed3\u7b97 \u63d0\u4ea4\u5b8c\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ed3\u7b97 \u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Long projectId;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        CommonResponse byCode;
        this.logger.info("\u7ed3\u7b97 \u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = (PurchaseSettlementEntity)((Object)this.iPurchaseSettlementService.selectById(billId));
        if (purchaseSettlementEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7ed3\u7b97\u5355\uff01");
        }
        if (ListUtil.isNotEmpty(purchaseSettlementEntity.getMaterialDetails())) {
            ArrayList outStoreIds = new ArrayList();
            ArrayList inStoreIds = new ArrayList();
            purchaseSettlementEntity.getMaterialDetails().forEach(p -> {
                if (Objects.equals("2", p.getSourceType()) && !inStoreIds.contains(p.getSourceMainId())) {
                    inStoreIds.add(p.getSourceMainId());
                }
                if (Objects.equals("4", p.getSourceType()) && !outStoreIds.contains(p.getSourceMainId())) {
                    outStoreIds.add(p.getSourceMainId());
                }
            });
            StringBuffer msg = new StringBuffer("");
            inStoreIds.forEach(s -> {
                InstoreEntity entity = (InstoreEntity)((Object)((Object)this.iInstoreService.selectById(Long.valueOf(Long.parseLong(s)))));
                if (entity != null) {
                    entity.setSettlementFlag(1);
                    this.iInstoreService.saveOrUpdate((Object)entity, false);
                } else {
                    msg.append("1");
                }
            });
            if (msg.length() > 0) {
                return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u7ed3\u7b97\u5355\u4e2d\u5165\u5e93\u5355\u4fe1\u606f\uff01");
            }
            StringBuffer msg1 = new StringBuffer("");
            outStoreIds.forEach(s -> {
                OutStoreEntity entity = (OutStoreEntity)((Object)((Object)this.iOutStoreService.selectById(Long.valueOf(Long.parseLong(s)))));
                if (entity != null) {
                    entity.setSettlementFlag(1);
                    this.iOutStoreService.saveOrUpdate((Object)entity, false);
                } else {
                    msg1.append("1");
                }
            });
            if (msg1.length() > 0) {
                return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u7ed3\u7b97\u5355\u4e2d\u9000\u8d27\u5355\u4fe1\u606f\uff01");
            }
        }
        this.iPurchaseSettlementService.processCost(purchaseSettlementEntity);
        this.iPurchaseSettlementService.saveOrUpdate((Object)purchaseSettlementEntity);
        if (CollectionUtils.isNotEmpty(purchaseSettlementEntity.getMaterialDetails())) {
            List<PurchaseSettlementMaterialDetailEntity> materialDetailEntityList = purchaseSettlementEntity.getMaterialDetails();
            List subids = materialDetailEntityList.stream().filter(e -> e.getSourceType().equals("2")).map(e -> e.getSourceSubId()).collect(Collectors.toList());
            List mainIds = materialDetailEntityList.stream().filter(e -> e.getSourceType().equals("2")).map(e -> e.getSourceMainId()).distinct().collect(Collectors.toList());
            Map<String, BigDecimal> subTotalMny = materialDetailEntityList.stream().filter(e -> e.getSourceType().equals("2")).collect(Collectors.groupingBy(PurchaseSettlementMaterialDetailEntity::getSourceMainId, Collectors.reducing(BigDecimal.ZERO, PurchaseSettlementMaterialDetailEntity::getMoney, BigDecimal::add)));
            if (CollectionUtils.isNotEmpty(subids) && CollectionUtils.isNotEmpty(mainIds)) {
                for (PurchaseSettlementMaterialDetailEntity purchaseSettlementMaterialDetailEntity : materialDetailEntityList) {
                    LambdaUpdateWrapper updateWrapperSub = new LambdaUpdateWrapper();
                    updateWrapperSub.eq(BaseEntity::getId, (Object)purchaseSettlementMaterialDetailEntity.getSourceSubId());
                    updateWrapperSub.set(InstoreMaterialEntity::getAmount, (Object)purchaseSettlementMaterialDetailEntity.getMoney());
                    updateWrapperSub.set(InstoreMaterialEntity::getUnitPrice, (Object)purchaseSettlementMaterialDetailEntity.getPrice());
                    this.instoreMaterialService.update((Wrapper)updateWrapperSub);
                }
                QueryWrapper queryWrapperMain = new QueryWrapper();
                queryWrapperMain.in((Object)"id", mainIds);
                List mainList = this.iInstoreService.list((Wrapper)queryWrapperMain);
                if (CollectionUtils.isNotEmpty((Collection)mainList)) {
                    for (InstoreEntity instoreEntity : mainList) {
                        LambdaUpdateWrapper updateWrapperMain = new LambdaUpdateWrapper();
                        updateWrapperMain.eq(BaseEntity::getId, (Object)instoreEntity.getId());
                        updateWrapperMain.set(InstoreEntity::getTotalAmount, (Object)subTotalMny.get(instoreEntity.getId().toString()));
                        updateWrapperMain.set(InstoreEntity::getTotalAmountNoTax, (Object)ComputeUtil.safeDiv((BigDecimal)subTotalMny.get(instoreEntity.getId().toString()), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)new BigDecimal("1"), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)instoreEntity.getTaxRate(), (BigDecimal)new BigDecimal("100")))).setScale(2, 4));
                        this.iInstoreService.update((Wrapper)updateWrapperMain);
                    }
                }
            }
        }
        if ((byCode = this.paramConfigApi.getByCode(VOUCHER_PARAM)).isSuccess() && null != byCode.getData() && ((valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData()).equals(String.valueOf(projectId = purchaseSettlementEntity.getProjectId())) || "\u662f".equals(valueData))) {
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                this.logger.info("request-authority\u4e3a\u7a7a");
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            try {
                VoucherParams voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200610000000004", (Object)((Object)purchaseSettlementEntity), (SystemCodeEnum)SystemCodeEnum.MATERIAL);
                AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.iPurchaseSettlementService, voucherParams, "save", RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            }
            catch (Exception e2) {
                this.logger.error(this.getClass() + "\u63a8\u9001\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e2);
            }
            finally {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ed3\u7b97 \u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = (PurchaseSettlementEntity)((Object)this.iPurchaseSettlementService.selectById(billId));
        if (purchaseSettlementEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7ed3\u7b97\u5355\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)purchaseSettlementEntity.getContractId()));
        param.getParams().put("orgId", new Parameter("eq", (Object)purchaseSettlementEntity.getOrgId()));
        param.getParams().put("createTime", new Parameter("gt", (Object)purchaseSettlementEntity.getCreateTime()));
        List entities = this.iPurchaseSettlementService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)entities)) {
            return CommonResponse.error((String)("\u8be5\u7ed3\u7b97\u5355\u7ed3\u7b97\u4e4b\u540e\u5b58\u5728\u5355\u636e\u7f16\u53f7\u4e3a\u3010" + ((PurchaseSettlementEntity)((Object)entities.get(0))).getBillCode() + "\u3011\u7684\u76f8\u540c\u5408\u540c\u548c\u7ec4\u7ec7\u7684\u7ed3\u7b97\u5355\uff0c\u65e0\u6cd5\u64a4\u56de\uff01"));
        }
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            this.logger.info("\u7269\u8d44\u5408\u540c\u7ed3\u7b97\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", new Object[]{billId, billTypeCode, resp.getMsg()});
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ed3\u7b97 \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = (PurchaseSettlementEntity)((Object)this.iPurchaseSettlementService.selectById(billId));
        if (purchaseSettlementEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7ed3\u7b97\u5355\uff01");
        }
        if (ListUtil.isNotEmpty(purchaseSettlementEntity.getMaterialDetails())) {
            ArrayList inStoreIds = new ArrayList();
            ArrayList outStoreIds = new ArrayList();
            purchaseSettlementEntity.getMaterialDetails().forEach(p -> {
                if (Objects.equals("2", p.getSourceType()) && !inStoreIds.contains(p.getSourceMainId())) {
                    inStoreIds.add(p.getSourceMainId());
                }
                if (Objects.equals("4", p.getSourceType()) && !outStoreIds.contains(p.getSourceMainId())) {
                    outStoreIds.add(p.getSourceMainId());
                }
            });
            StringBuffer msg = new StringBuffer("");
            inStoreIds.forEach(s -> {
                InstoreEntity entity = (InstoreEntity)((Object)((Object)this.iInstoreService.selectById(Long.valueOf(Long.parseLong(s)))));
                if (entity != null) {
                    entity.setSettlementFlag(0);
                    this.iInstoreService.saveOrUpdate((Object)entity, false);
                } else {
                    msg.append("1");
                }
            });
            if (msg.length() > 0) {
                return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u7ed3\u7b97\u5355\u4e2d\u5165\u5e93\u5355\u4fe1\u606f\uff01");
            }
            StringBuffer msg1 = new StringBuffer("");
            outStoreIds.forEach(s -> {
                OutStoreEntity entity = (OutStoreEntity)((Object)((Object)this.iOutStoreService.selectById(Long.valueOf(Long.parseLong(s)))));
                if (entity != null) {
                    entity.setSettlementFlag(0);
                    this.iOutStoreService.saveOrUpdate((Object)entity, false);
                } else {
                    msg1.append("1");
                }
            });
            if (msg1.length() > 0) {
                return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u7ed3\u7b97\u5355\u4e2d\u9000\u8d27\u5355\u4fe1\u606f\uff01");
            }
        }
        this.iCostDetailApi.deleteSubject(purchaseSettlementEntity.getId());
        purchaseSettlementEntity.setRelationFlag("0");
        this.iPurchaseSettlementService.saveOrUpdate((Object)purchaseSettlementEntity);
        if (!VoucherFlag.NO_NEED.equals(purchaseSettlementEntity.getVoucherFlag())) {
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                this.logger.info("request-authority\u4e3a\u7a7a");
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            try {
                VoucherParams voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200610000000004", (Object)((Object)purchaseSettlementEntity), (SystemCodeEnum)SystemCodeEnum.MATERIAL);
                AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.iPurchaseSettlementService, voucherParams, "del", RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            }
            catch (Exception e) {
                this.logger.error(this.getClass() + "\u64a4\u56de\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e);
            }
            finally {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success();
    }
}

