/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.service.IPlanChangeHisService;
import com.ejianc.business.plan.vo.MaterialMasterPlanSubVO;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.PlanChangeHisVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/masterPlan/"})
public class MasterPlanController {
    @Autowired
    private IMaterialMasterPlanService materialMasterPlanService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private final String BILL_CODE = "MATERIAL_MASTER_PLAN";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPlanChangeHisService planChangeHisService;
    @Autowired
    private IMaterialMasterPlanSubService materialMasterPlanSubService;

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<MaterialMasterPlanVO> saveOrUpdate(@RequestBody MaterialMasterPlanVO masterPlanVo) {
        if (StringUtils.isNotBlank((CharSequence)masterPlanVo.getPlanCode())) {
            MaterialMasterPlanVO voByCode = this.materialMasterPlanService.queryByCode(masterPlanVo.getPlanCode());
            if (!(null == voByCode || null != masterPlanVo.getId() && voByCode.getId().equals(masterPlanVo.getId()))) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else {
            CommonResponse codeResp = this.billCodeApi.getCodeBatchByRuleCode("MATERIAL_MASTER_PLAN", InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
            }
            masterPlanVo.setPlanCode((String)codeResp.getData());
        }
        MaterialMasterPlanVO voByProject = this.materialMasterPlanService.queryByProjectId(masterPlanVo.getProjectId());
        if (!(null == voByProject || null != masterPlanVo.getId() && voByProject.getId().equals(masterPlanVo.getId()))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u7269\u8d44\u603b\u8ba1\u5212\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        MaterialMasterPlanEntity saveEntity = null;
        if (null == masterPlanVo.getId()) {
            saveEntity = (MaterialMasterPlanEntity)((Object)BeanMapper.map((Object)masterPlanVo, MaterialMasterPlanEntity.class));
            saveEntity.setChangeState(0);
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(1);
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.getById(masterPlanVo.getId()));
            saveEntity.setProjectId(masterPlanVo.getProjectId());
            saveEntity.setProjectName(masterPlanVo.getProjectName());
            saveEntity.setOrgId(masterPlanVo.getOrgId());
            saveEntity.setOrgName(masterPlanVo.getOrgName());
            saveEntity.setRemark(masterPlanVo.getRemark());
            saveEntity.setPlanCode(masterPlanVo.getPlanCode());
            saveEntity.setTotalPlanAmt(masterPlanVo.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMaterialSubList(BeanMapper.mapList((Iterable)masterPlanVo.getMaterialSubList(), MaterialMasterPlanSubEntity.class));
        }
        if (null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        saveEntity = this.materialMasterPlanService.saveOrUpdateMasterPlan(saveEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)saveEntity), MaterialMasterPlanVO.class));
    }

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<MaterialMasterPlanVO>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("planCode");
        queryParam.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.materialMasterPlanService.queryPage(queryParam);
        Page resp = new Page();
        resp.setSize(pageData.getSize());
        resp.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), MaterialMasterPlanVO.class));
        resp.setCurrent(pageData.getCurrent());
        resp.setTotal(pageData.getTotal());
        resp.setPages(pageData.getPages());
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u7269\u8d44\u603b\u8ba1\u5212\u5217\u8868\u6210\u529f", (Object)resp);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        ArrayList<Long> childIds = new ArrayList<Long>();
        childIds.addAll(((List)childOrgResp.getData()).stream().filter(org -> 5 == org.getOrgType()).map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(childIds)) {
            childIds.add(1L);
        }
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        return c1;
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<MaterialMasterPlanVO> queryDetail(@RequestParam(value="id") Long id) {
        MaterialMasterPlanVO vo = null;
        MaterialMasterPlanEntity dbEntity = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.selectById(id));
        if (null != dbEntity && MaterialMasterPlanVO.PLAN_CHANGE_STATE_CHANGED == (vo = (MaterialMasterPlanVO)BeanMapper.map((Object)((Object)dbEntity), MaterialMasterPlanVO.class)).getChangeState()) {
            List<PlanChangeHisVO> changeHisList = this.loadChangeHisList(vo.getId());
            vo.setPlanChangeHisList(changeHisList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u603b\u8ba1\u5212\u8be6\u60c5\u6210\u529f\uff01", vo);
    }

    private List<PlanChangeHisVO> loadChangeHisList(Long planId) {
        List<Object> resp = new ArrayList<PlanChangeHisVO>();
        QueryWrapper hisQuery = new QueryWrapper();
        hisQuery.eq((Object)"source_plan_id", (Object)planId);
        hisQuery.orderByDesc((Object)"create_time");
        List list = this.planChangeHisService.list((Wrapper)hisQuery);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = BeanMapper.mapList((Iterable)list, PlanChangeHisVO.class);
        }
        return resp;
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<MaterialMasterPlanVO> vos) {
        List ids;
        if (CollectionUtils.isNotEmpty(vos) && CollectionUtils.isNotEmpty(ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList()))) {
            this.materialMasterPlanService.removeByIds(ids);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"projectPlanCheck"})
    public CommonResponse<String> projectPlanCheck(@RequestParam(value="projectId") Long projectId, @RequestParam(value="billId", required=false) Long billId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        MaterialMasterPlanEntity entityByProject = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.getOne((Wrapper)query));
        if (!(null == entityByProject || null != billId && entityByProject.getId().equals(billId))) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u7269\u8d44\u603b\u8ba1\u5212\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u9002\u7528\u5f53\u524d\u603b\u8ba1\u5212\uff01");
    }

    @GetMapping(value={"planMaterialListRefer"})
    public CommonResponse<IPage<MaterialMasterPlanSubVO>> planMaterialListRefer(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam int pageSize, @RequestParam int pageNumber) {
        Page resp = new Page();
        QueryParam queryParam = new QueryParam();
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("material_category_name");
        queryParam.getFuzzyFields().add("material_name");
        queryParam.getFuzzyFields().add("spec");
        queryParam.getOrderMap().put("id", "asc");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("projectId")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        ArrayList<Integer> approvedBillState = new ArrayList<Integer>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", conditionMap.get("projectId"));
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryWrapper.in((Object)"bill_state", approvedBillState);
        MaterialMasterPlanEntity entity = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.getOne((Wrapper)queryWrapper));
        if (null == entity) {
            resp.setTotal(0L);
            resp.setSize((long)pageSize);
            resp.setCurrent((long)pageNumber);
            resp.setRecords(new ArrayList());
            resp.setPages(0L);
        } else {
            queryParam.getParams().put("materialMasterPlanId", new Parameter("eq", (Object)entity.getId()));
            Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
            wrapper.eq((Object)"dr", (Object)0);
            wrapper.groupBy(new Object[]{"material_id"});
            List<MaterialMasterPlanSubVO> list = this.materialMasterPlanSubService.queryPlanSubList((IPage<MaterialMasterPlanSubVO>)page, wrapper);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(list);
            resp.setPages(pageData.getPages());
            resp.setCurrent(pageData.getCurrent());
            resp.setTotal(pageData.getTotal());
            resp.setSize(pageData.getSize());
            List dataList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
                dataList = BeanMapper.mapList((Iterable)pageData.getRecords(), MaterialMasterPlanSubVO.class);
            }
            resp.setRecords(dataList);
        }
        return CommonResponse.success((Object)resp);
    }
}

