/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storeCheck.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.storeCheck.bean.StoreCheckEntity;
import com.ejianc.business.storeCheck.mapper.StoreCheckMapper;
import com.ejianc.business.storeCheck.mapper.StoreCheckSubMapper;
import com.ejianc.business.storeCheck.service.IStoreCheckService;
import com.ejianc.business.storeCheck.vo.StoreCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="storeCheckService")
public class StoreCheckServiceImpl
extends BaseServiceImpl<StoreCheckMapper, StoreCheckEntity>
implements IStoreCheckService {
    @Autowired
    private StoreCheckMapper storeCheckMapper;
    @Autowired
    private StoreCheckSubMapper storeCheckSubMapper;

    @Override
    public StoreCheckVO queryByCode(String billCode) {
        StoreCheckVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)billCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        StoreCheckEntity entity = (StoreCheckEntity)((Object)this.storeCheckMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (StoreCheckVO)BeanMapper.map((Object)((Object)entity), StoreCheckVO.class);
        }
        return resp;
    }

    @Override
    public StoreCheckVO queryInvalidBillByStoreId(Long storeId) {
        StoreCheckVO resp = null;
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"store_id", (Object)storeId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"bill_state", billStates);
        StoreCheckEntity entity = (StoreCheckEntity)((Object)this.storeCheckMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (StoreCheckVO)BeanMapper.map((Object)((Object)entity), StoreCheckVO.class);
        }
        return resp;
    }

    @Override
    public StoreCheckVO saveCheckStore(StoreCheckEntity saveEntity) {
        if (null != saveEntity.getId()) {
            this.storeCheckSubMapper.delByStoreId(saveEntity.getId());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        return (StoreCheckVO)BeanMapper.map((Object)((Object)saveEntity), StoreCheckVO.class);
    }

    @Override
    public StoreCheckVO getLatestStoreCheck(Long storeId) {
        StoreCheckVO vo = null;
        StoreCheckEntity entity = this.storeCheckMapper.getLatestStoreCheck(storeId);
        if (null != entity) {
            vo = (StoreCheckVO)BeanMapper.map((Object)((Object)entity), StoreCheckVO.class);
        }
        return vo;
    }
}

