package com.ejianc.business.material.mapper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.vo.MaterialSubjectsVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Mapper
public interface StatisticsMapper {
    Long queryInStoreDetailsPageListCount(@Param("sql") String sql,String status);
    List<JSONObject> queryInStoreDetailsPageList(@Param("sql") String sql,@Param("startLine") Integer startLine,@Param("pageSize") Integer pageSize ,String status);

    Long queryOutStoreDetailsPageListCount(@Param("sql") String sql ,String status);
    List<JSONObject> queryOutStoreDetailsPageList(@Param("sql") String sql,@Param("startLine") Integer startLine,@Param("pageSize") Integer pageSize ,String status);

    Long queryInOutStorePageListCount(@Param("maps") Map<String,String> maps,@Param("searchText") String searchText, @Param("orgIds") String orgIds, @Param("miDate") String miDate, @Param("moDate") String moDate,@Param("projectIds") List<Long> projectIds,@Param("materialCategoryIds") List<Long> materialCategoryIds,@Param("materialNames") List<Long> materialNames);
    List<JSONObject> queryInOutStorePageList(@Param("maps") Map<String,String> maps,@Param("searchText") String searchText, @Param("orgIds") String orgIds, @Param("miDate") String miDate, @Param("moDate") String moDate, @Param("startLine") Integer startLine, @Param("pageSize") Integer pageSize,@Param("projectIds") List<Long> projectIds,@Param("materialCategoryIds") List<Long> materialCategoryIds,@Param("materialNames") List<Long> materialNames);

    BigDecimal queryOutStoreNumByStoreIdAndMaterialId(@Param("orgIds") String orgIds, @Param("ciDate") String ciDate, @Param("moDate") String moDate, @Param("storeId") String storeId, @Param("materialId") String materialId);

    BigDecimal queryReturnStoreNumByStoreIdAndMaterialId(@Param("orgIds") String orgIds,@Param("ciDate") String ciDate,@Param("moDate") String moDate, @Param("storeId") String storeId, @Param("materialId") String materialId);

    Long queryPlanInOutStorePageListCount(@Param("maps") Map<String,String> maps,@Param("projectId") String projectId,@Param("startDay") String startDay,@Param("endDay") String endDay);
    List<JSONObject> queryPlanInOutStorePageList(@Param("maps") Map<String,String> maps,@Param("projectId") String projectId,@Param("startDay") String startDay,@Param("endDay") String endDay,@Param("startLine") Integer startLine,@Param("pageSize") Integer pageSize);

    List<JSONObject> queryPlanOutStoreListTopN(@Param("projectId") String projectId,@Param("topN") Integer topN);

    Map<String,BigDecimal> queryReturnStoreNumByProjectIdAndMaterialId(@Param("projectId") String projectId,@Param("startDay") String startDay,@Param("endDay") String endDay, @Param("materialId") String materialId);

    List<MaterialSubjectsVO> queryMaterialCost(@Param("projectId") Long projectId, @Param("tenantId") Long tenantId);
}
