package com.ejianc.business.plan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.plan.bean.BatchPlanSubEntity;
/**
 * 批次计划主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_batch_plan")
public class BatchPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 所属项目Id
    @TableField(value="project_name")
    private String projectName; // 所属项目名称
    @TableField(value="bill_code")
    private String billCode; // 计划编码
    @TableField(value="total_plan_mny")
    private BigDecimal totalPlanMny; // 批次计划金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="org_id")
    private Long orgId; // 所属项目部Id
    @TableField(value="org_name")
    private String orgName; // 所属项目部名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="modify_user_name")
    private String modifyUserName; // 修改人名称
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="batchPlanSubService", pidName = "planId")//此处有pid="xxx"，默认值pid="pid"
    private List<BatchPlanSubEntity> batchPlanSubList = new ArrayList<>(); // 批次计划物资实体
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getTotalPlanMny() {
        return totalPlanMny;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setTotalPlanMny(BigDecimal totalPlanMny) {
        this.totalPlanMny = totalPlanMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    
    public List<BatchPlanSubEntity> getBatchPlanSubList() {
        return batchPlanSubList;
    }

    public void setBatchPlanSubList(List<BatchPlanSubEntity> batchPlanSubList) {
        this.batchPlanSubList = batchPlanSubList;
    }
}
