/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.ejianc.business.material.bean.ContractChangeEntity;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.ContractChangeVO;
import com.ejianc.business.material.vo.ContractDetailChangeVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/materialContractChange/"})
public class MaterialContractChangeController {
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private final String DEFAULT_RULE_CODE = "materialContract";

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<ContractChangeVO> save(@RequestBody ContractChangeVO contractChangeVO) {
        boolean checkResult;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("material_contract_id", new Parameter("eq", (Object)contractChangeVO.getMaterialContractId()));
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.COMMITED_STATE.getBillStateCode()));
        queryParam.getComplexParams().add(c1);
        queryParam.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)contractChangeVO.getId()));
        List list = this.contractChangeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u53d8\u66f4\u8bb0\u5f55\uff01");
        }
        if (StringUtils.isBlank((CharSequence)contractChangeVO.getCode())) {
            contractChangeVO.setCode(this.getAutoCode());
        }
        if (!(checkResult = this.materialContractService.codeCheck(contractChangeVO.getMaterialContractId(), contractChangeVO.getCode()))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5408\u540c\u7f16\u7801\u91cd\u590d");
        }
        ContractChangeVO resp = this.contractChangeService.save(contractChangeVO);
        this.queryPrice(resp);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    private String getAutoCode() {
        String code = null;
        while (StringUtils.isBlank(code)) {
            CommonResponse resp = this.billCodeApi.getCodeBatchByRuleCode("materialContract", InvocationInfoProxy.getTenantid());
            if (!resp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5408\u540c\u53d8\u66f4\u4fe1\u606f\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u7f16\u7801\u5931\u8d25\uff01");
            }
            boolean checkResult = this.materialContractService.codeCheck(null, (String)resp.getData());
            if (!checkResult) continue;
            code = (String)resp.getData();
        }
        return code;
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<ContractChangeVO> detail(@RequestParam(value="id") Long id) {
        ContractChangeVO vo = null;
        ContractChangeEntity e = (ContractChangeEntity)((Object)this.contractChangeService.selectById(id));
        if (e != null) {
            vo = (ContractChangeVO)BeanMapper.map((Object)((Object)e), ContractChangeVO.class);
            this.queryPrice(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    private void queryPrice(ContractChangeVO vo) {
        List materialDetailList = vo.getMaterialDetailList();
        if (CollectionUtils.isNotEmpty((Collection)materialDetailList)) {
            MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
            ArrayList detail = new ArrayList();
            materialDetailList.forEach(item -> {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(item.getMaterialId()));
                detail.add(materialPriceVO);
            });
            priceVO.setDetail(detail);
            Integer isJc = vo.getPurchaseMode().equals("1") ? 1 : 0;
            MaterialPriceVO materialPriceVO = this.materialContractService.queryPrice(isJc, vo.getMaterialContractId(), priceVO);
            List dd = materialPriceVO.getDetail();
            if (CollectionUtils.isNotEmpty((Collection)dd)) {
                Map<Long, MaterialPriceVO> priceVOMap = dd.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (ContractDetailChangeVO v : materialDetailList) {
                    String materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVOMap.get(Long.valueOf(materialId));
                    if (null == p) continue;
                    v.setPlanNum(p.getPlanNum());
                    v.setPlanPrice(p.getPlanPrice());
                    v.setMinPrice(p.getMinPrice());
                    v.setMaxPrice(p.getMaxPrice());
                    v.setPriceArea(p.getPriceArea());
                }
            }
        }
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<ContractChangeVO> vos) {
        this.contractChangeService.deleteById(vos.get(0).getId(), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

