/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.PickRegisterEntity;
import com.ejianc.business.material.service.IPickRegisterService;
import com.ejianc.business.material.vo.PickRegisterDetailVO;
import com.ejianc.business.material.vo.PickRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"pickRegister"})
public class PickRegisterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;
    private static final String BILL_CODE = "PICK-REGISTER";
    @Autowired
    private IPickRegisterService pickRegisterService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PickRegisterVO> saveOrUpdate(@RequestBody PickRegisterVO saveOrUpdateVO) {
        PickRegisterEntity entity = (PickRegisterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PickRegisterEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            List<PickRegisterEntity> list = this.pickRegisterService.queryByProjectAndSupplier(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getSupplierId(), saveOrUpdateVO.getId());
            if (CollectionUtils.isNotEmpty(list)) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672c\u9879\u76ee+\u9886\u6599\u5355\u4f4d\u5df2\u5b58\u5728\u9650\u9886\u6570\u91cf\u5355\u636e\uff0c\u8bf7\u66f4\u6362\u9879\u76ee\u6216\u9886\u6599\u5355\u4f4d\uff01");
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.pickRegisterService.saveOrUpdate((Object)entity, false);
        PickRegisterVO vo = (PickRegisterVO)BeanMapper.map((Object)((Object)entity), PickRegisterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PickRegisterVO> queryDetail(Long id) {
        PickRegisterEntity entity = (PickRegisterEntity)((Object)this.pickRegisterService.selectById(id));
        PickRegisterVO vo = (PickRegisterVO)BeanMapper.map((Object)((Object)entity), PickRegisterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PickRegisterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PickRegisterVO pickRegisterVO : vos) {
            }
        }
        this.pickRegisterService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PickRegisterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.pickRegisterService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PickRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"projectSupplierCheck"})
    @ResponseBody
    public CommonResponse<String> projectSupplierCheck(@RequestParam(value="projectId") Long projectId, @RequestParam(value="supplierId") Long supplierId, @RequestParam(value="billId", required=false) Long billId) {
        QueryWrapper query = new QueryWrapper();
        if (billId != null) {
            query.notIn((Object)"id", new Object[]{billId});
        }
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"supplier_id", (Object)supplierId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List list = this.pickRegisterService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u672c\u9879\u76ee+\u9886\u6599\u5355\u4f4d\u5df2\u5b58\u5728\u9650\u9886\u6570\u91cf\u5355\u636e\uff0c\u8bf7\u66f4\u6362\u9879\u76ee\u6216\u9886\u6599\u5355\u4f4d\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u3001\u4f9b\u5e94\u5546\u9002\u7528\u5f53\u524d\u9886\u6599\u767b\u8bb0\uff01");
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"pick-register-material-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<PickRegisterDetailVO> successList = new ArrayList<PickRegisterDetailVO>();
        ArrayList<PickRegisterDetailVO> errorList = new ArrayList<PickRegisterDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 4) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            HashMap<Long, String> indexMap = new HashMap<Long, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PickRegisterDetailVO registerDetailVO = new PickRegisterDetailVO();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    registerDetailVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(0)).length() > 20) {
                    registerDetailVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u586b\u5199\u957f\u5ea6\u4e3a0~20\u5b57");
                } else {
                    registerDetailVO.setMaterialName((String)datas.get(0));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    registerDetailVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(1)).length() > 200) {
                    registerDetailVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u586b\u5199\u957f\u5ea6\u4e3a0~200\u5b57");
                } else {
                    registerDetailVO.setMaterialSpec((String)datas.get(1));
                }
                registerDetailVO.setMaterialUnitName((String)datas.get(2));
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    registerDetailVO.setRestrictNum(new BigDecimal((String)datas.get(3)));
                }
                if (StringUtils.isBlank((String)registerDetailVO.getErrorMessage())) {
                    MaterialVO vo = new MaterialVO();
                    vo.setName(registerDetailVO.getMaterialName());
                    vo.setSpec(registerDetailVO.getMaterialSpec());
                    vo.setUnitName(registerDetailVO.getMaterialUnitName());
                    CommonResponse listCommonResponse = this.materialApi.queryMaterialList(vo);
                    if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
                        MaterialVO materialVo = (MaterialVO)((List)listCommonResponse.getData()).get(0);
                        registerDetailVO.setMaterialCategoryId(materialVo.getCategoryId());
                        registerDetailVO.setMaterialCategoryName(materialVo.getCategoryName());
                        registerDetailVO.setMaterialId(materialVo.getId());
                        if (indexMap.containsKey(materialVo.getId())) {
                            registerDetailVO.setErrorMessage("\u6750\u6599\u91cd\u590d");
                            registerDetailVO.setId(Long.valueOf(i));
                            errorList.add(registerDetailVO);
                            continue;
                        }
                        indexMap.put(materialVo.getId(), materialVo.getName());
                        successList.add(registerDetailVO);
                        continue;
                    }
                    registerDetailVO.setErrorMessage("\u8be5\u7269\u8d44\u4e0d\u5b58\u5728");
                    registerDetailVO.setId(Long.valueOf(i));
                    errorList.add(registerDetailVO);
                    continue;
                }
                registerDetailVO.setId(Long.valueOf(i));
                errorList.add(registerDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.pickRegisterService.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, PickRegisterVO.class);
        vos.forEach(item -> item.setCreateTimeStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)item.getCreateTime())));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("pickRegisterListExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPickRegisterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PickRegisterVO>> refPickRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.pickRegisterService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PickRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

