package com.ejianc.business.material.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.mapper.OutStoreSubMapper;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class OutStoreSubService extends BaseServiceImpl<OutStoreSubMapper, OutStoreSubEntity> implements IOutStoreSubService {

	@Autowired
	private OutStoreSubMapper outStoreSubMapper;

	@Override
	public IPage<OutStoreSubVO> queryOutStoreMaterialList(int pageNumber, int pageSize, Long storeId, String outDate, String storeType, String searchText ,String searchObject) {
		IPage<OutStoreSubVO> page = new Page<OutStoreSubVO>();
		page.setCurrent(pageNumber);
		page.setSize(pageSize);
		String materialCategoryName="";
		String materialName="";
		String materialSpec="";
		if (StringUtils.isNotBlank(searchObject)) {
			JSONObject search = JSONObject.parseObject(searchObject);
			if(search.get("materialCategoryName")!=null){
				materialCategoryName = search.get("materialCategoryName").toString();
			}
			if(search.get("materialName")!=null){
				materialName = search.get("materialName").toString();
			}
			if(search.get("materialSpec")!=null){
				materialSpec = search.get("materialSpec").toString();
			}
		}
		Long count =outStoreSubMapper.countOutStoreMaterial(storeId, outDate, storeType,materialCategoryName,materialName,materialSpec, searchText);
		page.setTotal(count);
		List<OutStoreSubVO> list = new ArrayList<>();
		if(count>0){
			Integer startLine = ((pageNumber>0?pageNumber:1)-1)*pageSize;
			list = outStoreSubMapper.queryOutStoreMaterialList(startLine,pageSize,storeId,outDate, storeType,materialCategoryName,materialName,materialSpec, searchText);
			page.setRecords(list);
		}else{
			page.setRecords(null); 
		}
		return page;
	}

	/**
	 * 根据项目下的物资明细 查询该明细退货数量
	 */
	@Override
	public List<OutStoreSubVO> queryReturnGoodsMaterialNum(Map<String, Object> param) {
		return baseMapper.queryReturnGoodsMaterialNum(param);
	}
}
