package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostSettingApi;
import com.ejianc.business.cost.vo.SubjectMaterialVO;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.mapper.OutStoreSubMapper;
import com.ejianc.business.material.mapper.StatisticsMapper;
import com.ejianc.business.material.service.IStatisticsService;
import com.ejianc.business.material.vo.MaterialCostVO;
import com.ejianc.business.material.vo.MaterialSubjectVO;
import com.ejianc.business.material.vo.MaterialSubjectsVO;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Service
public class StatisticsService implements IStatisticsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private StatisticsMapper statisticsMapper;

    @Autowired
    private OutStoreSubMapper outStoreSubMapper;

    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;

    @Autowired
    private ICostSettingApi costSettingApi;

    @Autowired
    private IMaterialMasterPlanService materialMasterPlanService;

    @Autowired
    private IMaterialApi materialApi;

    @Override
    public IPage<JSONObject> queryInStoreDetailsPageList(QueryParam param) {
        if (null != param.getParams().get("m.contractType")) {
            param.getParams().put("m.contractType", new Parameter(QueryParam.EQ, param.getParams().get("m.contractType").getValue()));
        }
        String status = null;
        if (null!=param.getParams().get("status")){
            status = (String) param.getParams().get("status").getValue();
            param.getParams().remove("status");
        }

        String sql = getSql(param);
        if (StringUtils.isNotEmpty(sql) && sql.contains("material_name")) {
            sql = sql.replace("material_name", "s.material_name");
        }
        if (StringUtils.isNotEmpty(sql) && sql.contains("org_id")) {
            sql = sql.replace("org_id", "m.org_id");
        }
        if (StringUtils.isNotEmpty(sql) && sql.contains("org_name")) {
            if (sql.contains("m.org_name")) {
                sql = this.replaceOccurrence(sql, "org_name", "m.org_name", 2);
            } else {
                sql = sql.replace("org_name", "m.org_name");
            }
        }
        List<JSONObject> map = statisticsMapper.queryInStoreDetailsPageList(sql, (param.getPageIndex() - 1) * param.getPageSize(), param.getPageSize(), status);
        IPage<JSONObject> page = new Page<>();
        page.setCurrent(param.getPageIndex());
        page.setSize(param.getPageSize());
        page.setRecords(map);
        page.setTotal(statisticsMapper.queryInStoreDetailsPageListCount(sql, status));
        return page;
    }

    /**
     * 替换指定位置的字符串
     *
     * @param text            原字符串
     * @param replaceFrom     要替换的字符串
     * @param replaceTo       替换成的字符串,
     * @param occurrenceIndex 第几个
     *
     * @return {@link String}
     */
    private String replaceOccurrence(String text, String replaceFrom, String replaceTo, int occurrenceIndex) {
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(replaceFrom);
        Matcher m = p.matcher(text);
        int count = 0;
        while (m.find()) {
            if (count++ == occurrenceIndex - 1) {
                m.appendReplacement(sb, replaceTo);
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public IPage<JSONObject> queryOutStoreDetailsPageList(QueryParam param) {
        String status = null;
        if (null != param.getParams().get("status")) {
            status = (String) param.getParams().get("status").getValue();
            param.getParams().remove("status");

        }
        String sql = getCustomSql(param);

        List<JSONObject> map = statisticsMapper.queryOutStoreDetailsPageList(sql, (param.getPageIndex() - 1) * param.getPageSize(), param.getPageSize(),status);
        IPage<JSONObject> page = new Page<>();
        page.setCurrent(param.getPageIndex());
        page.setSize(param.getPageSize());
        page.setRecords(map);
        page.setTotal(statisticsMapper.queryOutStoreDetailsPageListCount(sql,status));
        return page;
    }

    /**
     * @description: 根据param 构建sql key不转下滑分隔线格式
     *
     * @param param
     * @return {@link String}
     * @author songlx
     * @date: 2022/8/17
     */
    private String getCustomSql(QueryParam param) {
        StringBuffer sql = new StringBuffer(" AND ");

        /** 模糊查询配置的字段 */
        boolean hasData = false;
        if (StringUtils.isNotBlank(param.getSearchText()) && !ListUtil.isEmpty(param.getFuzzyFields())) {
            hasData = true;
            String searchText = param.getSearchText();
            List<String> fuzzyFields = param.getFuzzyFields();
            if (param.getFuzzyFields().size() == 1) {
                sql.append(fuzzyFields.get(0)).append(" like '%").append(StringEscapeUtils.escapeSql(searchText)).append("%' ");
            } else {
                sql.append(" ( ");
                for (int i = 0, fuzzyFieldsSize = fuzzyFields.size(); i < fuzzyFieldsSize; i++) {
                    String key = fuzzyFields.get(i);
                    sql.append(key).append(" like '%").append(StringEscapeUtils.escapeSql(searchText)).append("%' ");
                    if (i != fuzzyFieldsSize - 1) {
                        sql.append(" or ");
                    }
                }
                sql.append(" ) ");
            }
        }

        if (param.getParams().size() > 0) {
            if (hasData) {
                sql.append(" AND  ( ");
            }
            int i = 1;
            for (String key : param.getParams().keySet()) {
                Parameter parameter = param.getParams().get(key);
                String type = parameter.getType();
                switch (type) {
                    case QueryParam.EQ:
                        if (null == parameter.getValue()) {
                            sql.append(key).append(" IS NULL ");
                        } else {
                            sql.append(key).append(" = '").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("' ");
                        }
                        break;
                    case QueryParam.NE:
                        if (null == parameter.getValue()) {
                            sql.append(key).append(" IS NOT NULL ");
                        } else {
                            sql.append(key).append(" != '").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("' ");
                        }
                        break;
                    case QueryParam.IN:
                        if (parameter.getValue() instanceof List) {
                            sql.append(key).append(" IN (").append(String.join(",", ((List<Object>) parameter.getValue()).stream().map(Object::toString).collect(Collectors.toList()))).append(") ");
                        } else if (parameter.getValue() instanceof String) {
                            String[] paramArr = parameter.getValue().toString().split(",");
                            sql.append(key).append(" IN (").append(String.join(",", Arrays.asList(paramArr))).append(") ");
                        }
                        break;
                    case QueryParam.NOT_IN:
                        if (parameter.getValue() instanceof List) {
                            sql.append(key).append(" NOT IN (").append(String.join(",", ((List<Object>) parameter.getValue()).stream().map(Object::toString).collect(Collectors.toList()))).append(") ");
                        } else if (parameter.getValue() instanceof String) {
                            String[] paramArr = parameter.getValue().toString().split(",");
                            sql.append(key).append(" NOT IN (").append(String.join(",", Arrays.asList(paramArr))).append(") ");

                        }
                        break;
                    case QueryParam.LIKE:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(key).append(" LIKE '%").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("%' ");
                        }
                        break;
                    case QueryParam.NOT_LIKE:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(key).append(" NOT LIKE '%").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("%' ");
                        }
                        break;
                    case QueryParam.LIKE_LEFT:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(key).append(" LIKE '").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("%' ");
                        }
                        break;
                    case QueryParam.LIKE_RIGHT:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(key).append(" LIKE '%").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("' ");
                        }
                        break;
                    case QueryParam.BETWEEN:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            String[] paramArr = parameter.getValue().toString().split(",");
                            sql.append(key).append(" BETWEEN '").append(paramArr[0]).append("' AND '").append(paramArr[1]).append("' ");
                        }
                        break;
                    case QueryParam.LT:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(key).append(" < ").append(parameter.getValue()).append(" ");
                        }
                        break;
                    case QueryParam.LE:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(key).append(" <= ").append(parameter.getValue()).append(" ");
                        }
                        break;
                    case QueryParam.GT:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(key).append(" > ").append(parameter.getValue()).append(" ");
                        }
                        break;
                    case QueryParam.GE:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(key).append(" >= ").append(parameter.getValue()).append(" ");
                        }
                        break;
                }
                if (i != param.getParams().size()) {
                    sql.append(" AND ");
                }
                i++;
            }
            if (hasData) {
                sql.append(" ) ");
            }
            hasData = true;
        }

        if (StringUtils.isNotEmpty(param.getSearchObject())) {
            JSONObject searchObject = JSONObject.parseObject(param.getSearchObject());
            if (hasData) {
                sql.append(" AND ");
            }
            int i = 1;
            for (String key : searchObject.keySet()) {
                sql.append(key).append(" = '").append(searchObject.get(key)).append("' ");
                if (i != searchObject.size()) {
                    sql.append(" AND ");
                }
                i++;
            }
        }

        if (sql.length() == 5) {
            return null;
        }
        return sql.toString();
    }


    @Override
    public IPage<JSONObject> queryInOutStorePageList(QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        String ciDate = null;
        String miDate = null;
        String moDate = null;
        List<Long> orgIds = (List<Long>) param.getParams().get("orgId").getValue();
        String orgId = "(" + String.join(",", orgIds.stream().map(Object::toString).collect(Collectors.toList())) + ")";
        if (params.get("dateIn") != null) {
            Parameter p = params.get("dateIn");
            ciDate = " AND ( c.instore_date BETWEEN '" + p.getValue().toString().split(",")[0] + " 00:00:00' AND '" + p.getValue().toString().split(",")[1] + " 00:00:00' ) ";
            miDate = " AND ( b.instore_date BETWEEN '" + p.getValue().toString().split(",")[0] + " 00:00:00' AND '" + p.getValue().toString().split(",")[1] + " 00:00:00' ) ";
            moDate = " AND ( m.out_date BETWEEN '" + p.getValue().toString().split(",")[0] + " 00:00:00' AND '" + p.getValue().toString().split(",")[1] + " 00:00:00' ) ";
        }

        Map<String, String> maps = new HashMap<>();
        for (String key : params.keySet()) {
            if (params.get(key).getValue() != null && StringUtils.isNotEmpty(params.get(key).getValue().toString())) {
                maps.put(key, params.get(key).getValue().toString());
            }
        }
        //筛选项目
        List<Long> projectIds = null;
        if (null != param.getParams().get("pIds")) {
            projectIds = new ArrayList<>();
            String[] con = String.valueOf(param.getParams().get("pIds").getValue()).split(",");
            for (int i = 0; i < con.length; i++) {
                projectIds.add(Long.valueOf(con[i]));
            }
        }

        //物资分类
        List<Long> materialCategoryIds = null;
        if (null != param.getParams().get("mcIds")) {
            materialCategoryIds = new ArrayList<>();
            String[] con = String.valueOf(param.getParams().get("mcIds").getValue()).split(",");
            for (int i = 0; i < con.length; i++) {
                materialCategoryIds.add(Long.valueOf(con[i]));
            }
            Map<String, Object> map = new HashMap<>();
            map.put("innerCodes", materialCategoryIds);

            //根据当前传的物资id，请求接口去查询本下  单选需要本操作，如果是多选，可以注释
            CommonResponse<List<MaterialCategoryVO>> listCommonResponse = materialApi.queryListByInnerCode(map);
            System.out.print(listCommonResponse);
            if (listCommonResponse.getCode() == 0) {
                if (CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
                    materialCategoryIds.clear();
                    List<MaterialCategoryVO> data = listCommonResponse.getData();
                    System.out.print(data);
                    for (MaterialCategoryVO mc : data) {
                        materialCategoryIds.add(mc.getId());
                    }
                }
            }


        }

        //筛选物资名称
        List<Long> materialNames = null;
        if (null != param.getParams().get("mIds")) {
            materialNames = new ArrayList<>();
            String[] con = String.valueOf(param.getParams().get("mIds").getValue()).split(",");
            for (int i = 0; i < con.length; i++) {
                materialNames.add(Long.valueOf(con[i]));
            }
        }

        List<JSONObject> map = statisticsMapper.queryInOutStorePageList(maps, param.getSearchText(), orgId, miDate, moDate, (param.getPageIndex() - 1) * param.getPageSize(), param.getPageSize(), projectIds, materialCategoryIds, materialNames);
        setInOutStorePageTotalOutAndSurplus(map, orgId, ciDate, moDate);
        IPage<JSONObject> page = new Page<>();
        page.setCurrent(param.getPageIndex());
        page.setSize(param.getPageSize());
        page.setRecords(map);
        page.setTotal(statisticsMapper.queryInOutStorePageListCount(maps, param.getSearchText(), orgId, miDate, moDate, projectIds, materialCategoryIds, materialNames));
        return page;
    }

    @Override
    public IPage<JSONObject> queryPlanInOutStorePageList(QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        IPage<JSONObject> page = new Page<>();
        if (params.get("projectId") == null) {
            return page;
        }
        String projectId = (String) params.get("projectId").getValue();
        String startDay = params.get("startDay") != null ? ((String) params.get("startDay").getValue()) : null;
        String endDay = params.get("endDay") != null ? ((String) params.get("endDay").getValue()) : null;
        int startLine = (param.getPageIndex() - 1) * param.getPageSize(), pageSize = param.getPageSize();

        Map<String, String> maps = new HashMap<>();
        for (String key : params.keySet()) {
            if (params.get(key).getValue() != null && StringUtils.isNotEmpty(params.get(key).getValue().toString())) {
                maps.put(key, params.get(key).getValue().toString());
            }
        }

        List<JSONObject> map = statisticsMapper.queryPlanInOutStorePageList(maps, projectId, startDay, endDay, startLine, pageSize);
        setPlanInOutStorePageTotalOutAndSurplus(map, projectId, startDay, endDay);
        page.setCurrent(param.getPageIndex());
        page.setSize(param.getPageSize());
        page.setRecords(map);
        page.setTotal(statisticsMapper.queryPlanInOutStorePageListCount(maps, projectId, startDay, endDay));

        return page;
    }

    /**
     * 设置计划与出入库对比表表格合并
     */
    private void setPlanInOutStorePageTotalOutAndSurplus(List<JSONObject> objectList, String projectId, String startDay, String endDay) {
        /** 物资id 作为key，分组*/
        Map<String, List<JSONObject>> materials = new HashMap<>();
        if (ListUtil.isNotEmpty(objectList)) {
            for (int i = 0; i < objectList.size(); i++) {
                Map<String, Object> vo = objectList.get(i);
                String newKey = vo.get("material_id").toString();
                List<JSONObject> material = materials.get(newKey);
                if (ListUtil.isEmpty(material)) {
                    material = new ArrayList<>();
                    materials.put(newKey, material);
                }
                material.add(objectList.get(i));
            }
            /** 循环物资入库价作为分组处理数据 */
            for (String key : materials.keySet()) {
                List<JSONObject> material = materials.get(key);
                /** 同一条物资 */
                for (int i = 0; i < material.size(); i++) {
                    Map<String, Object> vo = material.get(i);
                    Map<String, BigDecimal> returnStoreInfo = statisticsMapper.queryReturnStoreNumByProjectIdAndMaterialId(projectId, startDay, endDay, key);
                    if (returnStoreInfo == null) {
                        returnStoreInfo = new HashMap<>();
                        returnStoreInfo.put("rNum", new BigDecimal("0.00"));
                        returnStoreInfo.put("rAmount", new BigDecimal("0.00"));
                    }
                    BigDecimal oNum = (BigDecimal) vo.get("oNum");
                    BigDecimal oAmount = (BigDecimal) vo.get("oAmount");
                    if (oNum == null) {
                        oNum = new BigDecimal("0.00");
                    }
                    /** 出库数减去退库数 */
                    oNum = oNum.subtract(returnStoreInfo.get("rNum")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    if (oAmount == null) {
                        oAmount = new BigDecimal("0.00");
                    }
                    /** 出库金额减去退库金额 */
                    oAmount = oAmount.subtract(returnStoreInfo.get("rAmount")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    /**  同一条物资合并行 */
                    if (i == 0) {
                        vo.put("materialRowSpan", material.size());
                        vo.put("oNum", oNum);
                        vo.put("oAmount", oAmount);
                        if (vo.get("pNum") != null) {
                            vo.put("pNum", (new BigDecimal(vo.get("pNum").toString())).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }
                        if (vo.get("pPrice") != null) {
                            vo.put("pPrice", (new BigDecimal(vo.get("pPrice").toString())).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }
                        if (vo.get("pAmount") != null) {
                            vo.put("pAmount", (new BigDecimal(vo.get("pAmount").toString())).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }
                        if (vo.get("aNum") != null) {
                            vo.put("aNum", (new BigDecimal(vo.get("aNum").toString())).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }
                        if (vo.get("aAmount") != null) {
                            vo.put("aAmount", (new BigDecimal(vo.get("aAmount").toString())).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }
                    } else {
                        vo.put("materialRowSpan", 0);
                    }
                    if (vo.get("iUnitPrice") == null) {
                        /** 入库价为空 */
                        vo.put("iUnitPriceRowSpan", 1);
                    } else {
                        vo.put("iUnitPriceRowSpan", 1);
                        vo.put("iNum", ((BigDecimal) vo.get("iNum")).setScale(2, BigDecimal.ROUND_HALF_UP));
                        vo.put("iUnitPrice", ((BigDecimal) vo.get("iUnitPrice")).setScale(2, BigDecimal.ROUND_HALF_UP));
                        vo.put("iAmount", ((BigDecimal) vo.get("iAmount")).setScale(2, BigDecimal.ROUND_HALF_UP));
                    }
                }
            }
        }
    }

    /**
     * 设置出入库汇总表出库数量和剩余量
     */
    private void setInOutStorePageTotalOutAndSurplus(List<JSONObject> objectList, String orgIds, String ciDate, String moDate) {
        /** 物资id和仓库id作为key，分组*/
        Map<String, List<JSONObject>> materials = new HashMap<>();
        if (ListUtil.isNotEmpty(objectList)) {
            for (int i = 0; i < objectList.size(); i++) {
                Map<String, Object> vo = objectList.get(i);
                String newKey = vo.get("newKey").toString();
                List<JSONObject> material = materials.get(newKey);
                if (ListUtil.isEmpty(material)) {
                    material = new ArrayList<>();
                    materials.put(newKey, material);
                }
                material.add(objectList.get(i));
            }
            /** 循环物资id和仓库id作为分组处理数据 */
            for (String key : materials.keySet()) {
                String storeId = key.split("\\|")[0];
                String materialId = key.split("\\|")[1];
                BigDecimal outNum = statisticsMapper.queryOutStoreNumByStoreIdAndMaterialId(orgIds, ciDate, moDate, storeId, materialId);
                BigDecimal returnNum = statisticsMapper.queryReturnStoreNumByStoreIdAndMaterialId(orgIds, ciDate, moDate, storeId, materialId);
                if (outNum == null) {
                    outNum = new BigDecimal("0.00");
                }
                if (returnNum == null) {
                    returnNum = new BigDecimal("0.00");
                }
                outNum = outNum.subtract(returnNum).setScale(8, BigDecimal.ROUND_HALF_UP);
                BigDecimal inNum = new BigDecimal("0.00");
                List<JSONObject> material = materials.get(key);
                Map<String, List<JSONObject>> supply = new HashMap<>();
                /** 同一仓库同一条物资 */
                for (int i = 0; i < material.size(); i++) {
                    Map<String, Object> vo = material.get(i);
                    if (vo.get("instoreNumber") == null) {
                        /** 只有出库没入库 不处理 */
                    } else {
                        inNum = inNum.add((BigDecimal) vo.get("instoreNumber"));
                        /** 同一仓库同一条物资合并行 */
                        if (i == 0) {
                            vo.put("newKeyRowSpan", material.size());
                        } else {
                            vo.put("newKeyRowSpan", 0);
                        }
                        vo.put("instoreNumber", ((BigDecimal) vo.get("instoreNumber")).setScale(2, BigDecimal.ROUND_HALF_UP));
                        if (vo.get("supplierName") != null) {
                            /** 同一仓库同一条物资，不同供应商分组  */
                            List<JSONObject> supList = supply.get(vo.get("supplierName").toString());
                            if (ListUtil.isEmpty(supList)) {
                                supList = new ArrayList<>();
                                supply.put(vo.get("supplierName").toString(), supList);
                            }
                            supList.add(material.get(i));
                        }
                    }
                }
                /** 循环同一仓库同一条物资不同供应商分组，处理数据  */
                for (String supKey : supply.keySet()) {
                    List<JSONObject> supp = supply.get(supKey);
                    Map<String, List<JSONObject>> supplyPrice = new HashMap<>();
                    for (int i = 0; i < supp.size(); i++) {
                        Map<String, Object> suppVo = supp.get(i);
                        /** 相同供应商分组，合并行  */
                        if (i == 0) {
                            suppVo.put("supplyRowSpan", supp.size());
                        } else {
                            suppVo.put("supplyRowSpan", 0);
                        }
                        /** 相同供应商，不同价格分组  */
                        List<JSONObject> suPrice = supplyPrice.get(supKey + suppVo.get("unitPrice"));
                        if (ListUtil.isEmpty(suPrice)) {
                            suPrice = new ArrayList<>();
                            supplyPrice.put(supKey + suppVo.get("unitPrice"), suPrice);
                        }
                        suPrice.add(supp.get(i));
                    }
                    /** 相同供应商，不同价格,处理数据  */
                    for (String priceKey : supplyPrice.keySet()) {
                        List<JSONObject> price = supplyPrice.get(priceKey);
                        for (int i = 0; i < price.size(); i++) {
                            Map<String, Object> priceVo = price.get(i);
                            /** 相同价格分组，合并行  */
                            if (i == 0) {
                                priceVo.put("priceRowSpan", price.size());
                                /** 合并相同价额入库数量 */
                                BigDecimal inStoreNum = new BigDecimal("0.00");
                                for (int j = 0; j < price.size(); j++) {
                                    inStoreNum = inStoreNum.add((BigDecimal) priceVo.get("instoreNumber"));
                                }
                                priceVo.put("instoreNumber", inStoreNum);
                            } else {
                                priceVo.put("priceRowSpan", 0);
                            }
                        }
                    }
                }
                for (int i = 0; i < material.size(); i++) {
                    Map<String, Object> vo = material.get(i);
                    vo.put("outStoreNumber", outNum.setScale(2, BigDecimal.ROUND_HALF_UP));
                    vo.put("surplusNumber", inNum.subtract(outNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                }
            }
        }
    }

    private String getSql(QueryParam param) {
        StringBuffer sql = new StringBuffer(" AND ");

        /** 模糊查询配置的字段 */
        boolean hasData = false;
        if (StringUtils.isNotBlank(param.getSearchText()) && !ListUtil.isEmpty(param.getFuzzyFields())) {
            hasData = true;
            String searchText = param.getSearchText();
            List<String> fuzzyFields = param.getFuzzyFields();
            if (param.getFuzzyFields().size() == 1) {
                sql.append(CamelAndUnderLineConverter.humpToLine(fuzzyFields.get(0))).append(" like '%").append(StringEscapeUtils.escapeSql(searchText)).append("%' ");
            } else {
                sql.append(" ( ");
                for (int i = 0, fuzzyFieldsSize = fuzzyFields.size(); i < fuzzyFieldsSize; i++) {
                    String key = fuzzyFields.get(i);
                    sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" like '%").append(StringEscapeUtils.escapeSql(searchText)).append("%' ");
                    if (i != fuzzyFieldsSize - 1) {
                        sql.append(" or ");
                    }
                }
                sql.append(" ) ");
            }
        }

        if (param.getParams().size() > 0) {
            if (hasData) {
                sql.append(" AND  ( ");
            }
            int i = 1;
            for (String key : param.getParams().keySet()) {
                Parameter parameter = param.getParams().get(key);
                String type = parameter.getType();
                switch (type) {
                    case QueryParam.EQ:
                        if (null == parameter.getValue()) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" IS NULL ");
                        } else {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" = '").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("' ");
                        }
                        break;
                    case QueryParam.NE:
                        if (null == parameter.getValue()) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" IS NOT NULL ");
                        } else {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" != '").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("' ");
                        }
                        break;
                    case QueryParam.IN:
                        if (parameter.getValue() instanceof List) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" IN (").append(String.join(",", ((List<Object>) parameter.getValue()).stream().map(Object::toString).collect(Collectors.toList()))).append(") ");
                        } else if (parameter.getValue() instanceof String) {
                            String[] paramArr = parameter.getValue().toString().split(",");
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" IN (").append(String.join(",", Arrays.asList(paramArr))).append(") ");
                        }
                        break;
                    case QueryParam.NOT_IN:
                        if (parameter.getValue() instanceof List) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" NOT IN (").append(String.join(",", ((List<Object>) parameter.getValue()).stream().map(Object::toString).collect(Collectors.toList()))).append(") ");
                        } else if (parameter.getValue() instanceof String) {
                            String[] paramArr = parameter.getValue().toString().split(",");
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" NOT IN (").append(String.join(",", Arrays.asList(paramArr))).append(") ");

                        }
                        break;
                    case QueryParam.LIKE:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" LIKE '%").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("%' ");
                        }
                        break;
                    case QueryParam.NOT_LIKE:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" NOT LIKE '%").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("%' ");
                        }
                        break;
                    case QueryParam.LIKE_LEFT:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" LIKE '").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("%' ");
                        }
                        break;
                    case QueryParam.LIKE_RIGHT:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" LIKE '%").append(StringEscapeUtils.escapeSql(parameter.getValue().toString())).append("' ");
                        }
                        break;
                    case QueryParam.BETWEEN:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            String[] paramArr = parameter.getValue().toString().split(",");
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" BETWEEN '").append(paramArr[0]).append("' AND '").append(paramArr[1]).append("' ");
                        }
                        break;
                    case QueryParam.LT:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" < ").append(parameter.getValue()).append(" ");
                        }
                        break;
                    case QueryParam.LE:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" <= ").append(parameter.getValue()).append(" ");
                        }
                        break;
                    case QueryParam.GT:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" > ").append(parameter.getValue()).append(" ");
                        }
                        break;
                    case QueryParam.GE:
                        if (parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
                            sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" >= ").append(parameter.getValue()).append(" ");
                        }
                        break;
                }
                if (i != param.getParams().size()) {
                    sql.append(" AND ");
                }
                i++;
            }
            if (hasData) {
                sql.append(" ) ");
            }
            hasData = true;
        }

        if (StringUtils.isNotEmpty(param.getSearchObject())) {
            JSONObject searchObject = JSONObject.parseObject(param.getSearchObject());
            if (hasData) {
                sql.append(" AND ");
            }
            int i = 1;
            for (String key : searchObject.keySet()) {
                sql.append(CamelAndUnderLineConverter.humpToLine(key)).append(" = '").append(searchObject.get(key)).append("' ");
                if (i != searchObject.size()) {
                    sql.append(" AND ");
                }
                i++;
            }
        }

        if (sql.length() == 5) {
            return null;
        }
        return sql.toString();
    }

    /**
     * @param projectId
     * @Author mrsir_wxp
     * @Date 2021/3/22 根据项目查询物资看板
     * @Description queryMaterialViewBoardByProjectId
     * @Param [projectId]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @Override
    public CommonResponse<JSONObject> queryMaterialViewBoardByProjectId(Long projectId) {
        JSONObject resp = new JSONObject();
        Map<String, BigDecimal> leftMoney = instoreMaterialMapper.queryStoreLeftMoneyAndMaterialTypeNumByProjectId(projectId);
        if (leftMoney == null) {
            leftMoney = new HashMap<>();
            leftMoney.put("inventoryAmount", BigDecimal.ZERO);
            leftMoney.put("materialTypeNumber", BigDecimal.ZERO);
        }
        resp.put("target", leftMoney);
        List<OutStoreSubVO> top5 = outStoreSubMapper.queryMaterialCostTopNByProjectId(5, projectId);
        if (ListUtil.isNotEmpty(top5)) {
            JSONObject respTop5 = new JSONObject();
            List<String> label = new ArrayList<>();
            List<BigDecimal> value = new ArrayList<>();
            for (OutStoreSubVO vo : top5) {
                label.add(vo.getMaterialName());
                value.add(vo.getAmount());
            }
            respTop5.put("label", label);
            respTop5.put("value", value);
            resp.put("materialConsumptionTop5", respTop5);
        } else {
            resp.put("materialConsumptionTop5", null);
        }
        List<JSONObject> top10 = statisticsMapper.queryPlanOutStoreListTopN(projectId.toString(), 10);
        resp.put("materialConsumptionTop10", top10);
        return CommonResponse.success(resp);
    }

    @Override
    public CommonResponse<MaterialCostVO> queryMaterialCostByProjectId(Long projectId) {
        MaterialCostVO resVo = new MaterialCostVO();
        List<MaterialSubjectVO> res = new ArrayList<>();
        CommonResponse<List<SubjectMaterialVO>> subjectRes = costSettingApi.querySubjectsByProj(projectId);
        if (subjectRes.isSuccess() && CollectionUtils.isNotEmpty(subjectRes.getData())) {
            List<SubjectMaterialVO> subjectMaterialVOS = subjectRes.getData();
            List<MaterialSubjectsVO> materialSubjectVOS = BeanMapper.mapList(subjectMaterialVOS, MaterialSubjectsVO.class);
            List<MaterialSubjectsVO> list = statisticsMapper.queryMaterialCost(projectId, InvocationInfoProxy.getTenantid());
            LambdaQueryWrapper<MaterialMasterPlanEntity> lambda = Wrappers.<MaterialMasterPlanEntity>lambdaQuery();
            lambda.eq(MaterialMasterPlanEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambda.eq(MaterialMasterPlanEntity::getProjectId, projectId);
            lambda.in(MaterialMasterPlanEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
            List<MaterialMasterPlanEntity> materialMasterPlanEntities = materialMasterPlanService.list(lambda);
            if (CollectionUtils.isNotEmpty(materialMasterPlanEntities)) {
                BigDecimal totalPlanAmt = materialMasterPlanEntities.stream().map(e -> e.getTotalPlanAmt() == null ? BigDecimal.ZERO : e.getTotalPlanAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
                resVo.setPlanMoney(totalPlanAmt == null ? BigDecimal.ZERO : totalPlanAmt);
            } else {
                resVo.setPlanMoney(BigDecimal.ZERO);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                list.forEach(e -> {
                    e.setLeafFlag(true);
                    if ("0".equals(subjectMaterialVOS.get(0).getTaxFlag())) {
                        e.setAmount(e.getHappenTaxMny() == null ? BigDecimal.ZERO : e.getHappenTaxMny());
                    } else {
                        e.setAmount(e.getHappenMny() == null ? BigDecimal.ZERO : e.getHappenMny());
                    }
                });
                if ("0".equals(subjectMaterialVOS.get(0).getMaterialCost())) {
                    BigDecimal costMoney = list.stream().map(e -> e.getAmount() == null ? BigDecimal.ZERO : e.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    resVo.setCostMoney(costMoney);
                    materialSubjectVOS.addAll(list);
                }
                for (int i = 0; i < materialSubjectVOS.size(); i++) {
                    materialSubjectVOS.get(i).setNumber(i + 1);
                }
                MaterialSubjectsVO tempVo = new MaterialSubjectsVO();
                tempVo.setId(999L);
                tempVo.setNumber(0);
                tempVo.setParentId(000L);
                materialSubjectVOS.add(tempVo);
                List<MaterialSubjectsVO> listres = new ArrayList<>();
                MaterialSubjectsVO vo = calculateValue(materialSubjectVOS);
                printGoal(vo, listres);
                listres = listres.stream().sorted(Comparator.comparing(MaterialSubjectsVO::getNumber)).collect(Collectors.toList());
                listres.remove(0);
                res = BeanMapper.mapList(listres, MaterialSubjectVO.class);
            } else {
                res = BeanMapper.mapList(subjectMaterialVOS, MaterialSubjectVO.class);
                resVo.setCostMoney(BigDecimal.ZERO);
            }
            res = TreeNodeBUtil.buildTree(res);
        }
        resVo.setSubjectDetails(res);
        return CommonResponse.success(resVo);
    }

    //找到最底层的叶子节点
    public List<MaterialSubjectsVO> getBottomNode(List<MaterialSubjectsVO> listGoal) {
        Map<Long, MaterialSubjectsVO> map = new HashMap<Long, MaterialSubjectsVO>();
        for (MaterialSubjectsVO g : listGoal) {
            map.put(g.getId(), g);
        }

        for (MaterialSubjectsVO g : listGoal) {
            Long pid = g.getParentId();
            if (map.containsKey(pid)) {
                map.remove(pid);
            }
        }
        return new ArrayList<MaterialSubjectsVO>(map.values());
    }

    public List<MaterialSubjectsVO> setParentValue(List<MaterialSubjectsVO> listAllGoal, List<MaterialSubjectsVO> listBottomGoal) {

        Map<Long, List<MaterialSubjectsVO>> map = new HashMap<Long, List<MaterialSubjectsVO>>();
        for (MaterialSubjectsVO g : listBottomGoal) {
            Long pid = g.getParentId();
            List<MaterialSubjectsVO> listGoal = map.get(pid);
            if (listGoal == null) {
                listGoal = new ArrayList<MaterialSubjectsVO>();
            }
            listGoal.add(g);
            map.put(pid, listGoal);
        }

        for (Long i : map.keySet()) {
            List<MaterialSubjectsVO> tempListGoal = map.get(i);
            BigDecimal result = BigDecimal.ZERO;
            BigDecimal result2 = BigDecimal.ZERO;
            for (MaterialSubjectsVO g : tempListGoal) {
                result = result.add(g.getAmount() == null ? BigDecimal.ZERO : g.getAmount());
                result2 = result2.add(g.getStoreNumber() == null ? BigDecimal.ZERO : g.getStoreNumber());
            }
            for (MaterialSubjectsVO g : listAllGoal) {
                Long id = g.getId();
                if (id.longValue() == i.longValue()) {
                    List<MaterialSubjectsVO> tempList = g.getChildren();
                    if (tempList != null) {
                        tempListGoal.addAll(tempList);
                    }
                    g.setChildren(tempListGoal);
                    BigDecimal score = g.getAmount() == null ? BigDecimal.ZERO : g.getAmount();
                    BigDecimal score2 = g.getStoreNumber() == null ? BigDecimal.ZERO : g.getStoreNumber();
                    score = score.add(result);
                    score2 = score2.add(result2);
                    g.setAmount(score);
                    g.setStoreNumber(score2);
                }
            }
        }

        for (MaterialSubjectsVO g : listBottomGoal) {
            listAllGoal.remove(g);
        }

        return listAllGoal;
    }

    public MaterialSubjectsVO calculateValue(List<MaterialSubjectsVO> listGoal) {
        if (listGoal.size() == 1) {
            return listGoal.get(0);
        } else {
            List<MaterialSubjectsVO> listBottomGoal = getBottomNode(listGoal);
            List<MaterialSubjectsVO> list = setParentValue(listGoal, listBottomGoal);
            return calculateValue(list);
        }
    }


    public void printGoal(MaterialSubjectsVO goal, List<MaterialSubjectsVO> list) {
        list.add(goal);
        List<MaterialSubjectsVO> listGoal = goal.getChildren();
        if (listGoal == null || listGoal.size() == 0) {
            return;
        }
        for (MaterialSubjectsVO g : listGoal) {
            printGoal(g, list);
        }
    }
}