/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementMaterialDetailService;
import com.ejianc.business.material.service.IPurchaseSettlementOtherFeeService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.PurchaseSettlementMaterialDetailVO;
import com.ejianc.business.material.vo.PurchaseSettlementRefVO;
import com.ejianc.business.material.vo.PurchaseSettlementVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/purchaseSettlement/"})
public class PurchaseSettlementController
implements Serializable {
    private static final long serialVersionUID = 2779265683203439571L;
    private static final String BILL_CODE = "purchaseSettlement";
    @Autowired
    IPurchaseSettlementService iPurchaseSettlementService;
    @Autowired
    IPurchaseSettlementOtherFeeService iPurchaseSettlementOtherFeeService;
    @Autowired
    IPurchaseSettlementMaterialDetailService iPurchaseSettlementMaterialDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IVoucherApi voucherApi;

    @RequestMapping(value={"/pushVoucher"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull((Object)billId, (String)"\u5355\u636ebillId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)this.iPurchaseSettlementService.selectById(billId));
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200610000000004", (Object)((Object)entity), (SystemCodeEnum)SystemCodeEnum.MATERIAL);
        CommonResponse response = this.voucherApi.handleVoucher(voucherParams, "save");
        if (response.isSuccess()) {
            voucherInfo = (VoucherInfo)response.getData();
            LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
            lambda.eq(BaseEntity::getId, (Object)entity.getId());
            lambda.set(PurchaseSettlementEntity::getVoucherInfo, (Object)DataConvertUtil.objToString((Object)voucherInfo));
            lambda.set(PurchaseSettlementEntity::getVoucherFlag, (Object)voucherInfo.getVoucherFlag());
            this.iPurchaseSettlementService.update((Wrapper)lambda);
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(@RequestBody PurchaseSettlementVO vo) {
        this.beforeSave(vo);
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)BeanMapper.map((Object)((Object)vo), PurchaseSettlementEntity.class));
        List<PurchaseSettlementEntity> entities = this.getHasPurchased(entity.getContractId(), entity.getOrgId());
        if (entity.getId() == null || entity.getId() == 0L) {
            if (ListUtil.isNotEmpty(entities)) {
                throw new BusinessException("\u6240\u9009\u5408\u540c\u548c\u7ec4\u7ec7\u5b58\u5728\u672a\u5b8c\u6210\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u53ef\u518d\u6b21\u65b0\u589e\u7ed3\u7b97\u5355\uff0c\u5982\u9700\u65b0\u589e\uff0c\u8bf7\u5148\u5b8c\u6210\u5355\u636e\u7f16\u53f7\u4e3a\u3010" + entities.get(0).getBillCode() + "\u3011\u7684\u7ed3\u7b97\u5355\u3002");
            }
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else if (ListUtil.isNotEmpty(entities) && entities.size() == 1 && !Objects.equals(entities.get(0).getId(), entity.getId())) {
            throw new BusinessException("\u4e0d\u80fd\u6839\u636e\u6240\u9009\u5408\u540c\u548c\u7ec4\u7ec7\u4fee\u6539\u4fdd\u5b58\u8be5\u7ed3\u7b97\u5355\uff0c\u56e0\u4e3a\u5b58\u5728\u76f8\u540c\u5408\u540c\u548c\u7ec4\u7ec7\u672a\u5b8c\u6210\u7684\u7ed3\u7b97\u5355\u3010" + entities.get(0).getBillCode() + "\u3011\uff0c\u5982\u786e\u987b\u4fee\u6539\uff0c\u8bf7\u5148\u5b8c\u6210\u5355\u636e\u7f16\u53f7\u4e3a\u3010" + entities.get(0).getBillCode() + "\u3011\u7684\u7ed3\u7b97\u5355\u518d\u4fee\u6539\u3002");
        }
        this.materialContractService.checkContract(entity.getContractId());
        entity.setRemainCanApplyAmount(entity.getCurrentSettlementAmountTax().subtract(entity.getOffsetAmountInCurrentPeriod()).setScale(2, 4));
        this.iPurchaseSettlementService.saveOrUpdate((Object)entity, false);
        PurchaseSettlementVO backVo = (PurchaseSettlementVO)((Object)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)backVo));
    }

    private void beforeSave(PurchaseSettlementVO vo) {
        if (vo.getTaxRate() == null) {
            vo.setTaxRate(new BigDecimal("0.00"));
        }
        if (ListUtil.isNotEmpty(vo.getFeeEntities())) {
            vo.getFeeEntities().forEach(sub -> sub.setTaxRate(vo.getTaxRate()));
        }
        if (ListUtil.isNotEmpty(vo.getMaterialDetails())) {
            vo.getMaterialDetails().forEach(sub -> sub.setTaxRate(vo.getTaxRate()));
        }
    }

    @RequestMapping(value={"pushToCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> pushToCost(@RequestBody PurchaseSettlementVO vo) {
        this.beforeSave(vo);
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)BeanMapper.map((Object)((Object)vo), PurchaseSettlementEntity.class));
        this.iPurchaseSettlementService.processCost(entity);
        this.iPurchaseSettlementService.saveOrUpdate((Object)entity, false);
        PurchaseSettlementVO backVo = (PurchaseSettlementVO)((Object)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u5173\u8054\u6210\u529f\uff01", (Object)((Object)backVo));
    }

    public List<PurchaseSettlementEntity> getHasPurchased(Long contractId, Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode())));
        return this.iPurchaseSettlementService.queryList(param, false);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> queryDetail(Long id) {
        List<PurchaseSettlementMaterialDetailVO> materialDetailList;
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)this.iPurchaseSettlementService.selectById(id));
        PurchaseSettlementVO vo = null;
        if (entity != null && CollectionUtils.isNotEmpty(materialDetailList = (vo = (PurchaseSettlementVO)((Object)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class))).getMaterialDetails())) {
            MaterialPriceVO priceVO = new MaterialPriceVO(entity.getProjectId());
            ArrayList detail = new ArrayList();
            materialDetailList.forEach(item -> {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(item.getMaterialId()));
                detail.add(materialPriceVO);
            });
            priceVO.setDetail(detail);
            Integer isJc = entity.getBelongToProject().equals("0") ? 1 : 0;
            MaterialPriceVO materialPriceVO = this.materialContractService.queryPrice(isJc, entity.getContractId(), priceVO);
            List dd = materialPriceVO.getDetail();
            if (CollectionUtils.isNotEmpty((Collection)dd)) {
                Map<Long, MaterialPriceVO> priceVOMap = dd.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (PurchaseSettlementMaterialDetailVO v : materialDetailList) {
                    Long materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVOMap.get(materialId);
                    if (null == p) continue;
                    v.setPlanNum(p.getPlanNum());
                    v.setPlanPrice(p.getPlanPrice());
                    v.setMinPrice(p.getMinPrice());
                    v.setMaxPrice(p.getMaxPrice());
                    v.setPriceArea(p.getMinPrice().setScale(2, 4) + "~" + p.getMaxPrice().setScale(2, 4));
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchaseSettlementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("purchaseMethod");
        fuzzyFields.add("creatorName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("memo");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.iPurchaseSettlementService.queryForList(param, false));
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PurchaseSettlement", this.iPurchaseSettlementService.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseSettlementVO> vos) {
        this.iPurchaseSettlementService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("creatorName");
        fuzzyFields.add("purchaseMethod");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage<PurchaseSettlementVO> voPage = this.iPurchaseSettlementService.queryForList(queryParam, false);
        List list = voPage.getRecords();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("purchaseSettlementListExport.xlsx", beans, response);
    }

    @GetMapping(value={"/querySettlementRecords"})
    @ResponseBody
    public CommonResponse<JSONObject> querySettlementRecords(@RequestParam(value="id") Long id) {
        List settleList;
        JSONObject resp = new JSONObject();
        List changeRecords = new ArrayList();
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.materialContractService.selectById(id));
        BigDecimal totalSettlementAmount = new BigDecimal(0).setScale(8, 4);
        BigDecimal totalSettlementAmountNoTax = new BigDecimal(0).setScale(8, 4);
        BigDecimal settlementRatio = new BigDecimal(0).setScale(8, 4);
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7ed3\u7b97\u8bb0\u5f55\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgIds = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        if (!"1".equals(contract.getDependOnProject())) {
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
            resp.put("contractId", (Object)id);
        }
        if (CollectionUtils.isNotEmpty((Collection)(settleList = this.iPurchaseSettlementService.queryList(queryParam, false)))) {
            changeRecords = BeanMapper.mapList((Iterable)settleList, PurchaseSettlementVO.class);
            totalSettlementAmount = this.iPurchaseSettlementService.calculateTotalSettlement(queryParam);
            totalSettlementAmountNoTax = this.iPurchaseSettlementService.calculateTotalSettlementNoTax(queryParam);
        }
        if ("1".equals(contract.getDependOnProject())) {
            List<PurchaseSettlementEntity> list = this.getHasPurchased(contract.getId(), contract.getOrgId());
            if (CollectionUtils.isNotEmpty(list)) {
                resp.put("settlementId", (Object)list.get(0).getId());
            } else {
                resp.put("contractId", (Object)id);
            }
        }
        if (null != contract.getAmountWithTax() && contract.getAmountWithTax().doubleValue() != 0.0) {
            settlementRatio = totalSettlementAmount.divide(contract.getAmountWithTax(), 4, 4).multiply(new BigDecimal(100));
        }
        resp.put("id", (Object)id);
        resp.put("state", (Object)contract.getState());
        resp.put("contractAmountWithTax", (Object)contract.getAmountWithTax());
        resp.put("totalSettlementAmount", (Object)totalSettlementAmount);
        resp.put("totalSettlementAmountNoTax", (Object)totalSettlementAmountNoTax);
        resp.put("settlementRatio", (Object)settlementRatio);
        resp.put("changeRecords", changeRecords);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"/calculateAlreadyPurchaseMoney"})
    @ResponseBody
    public CommonResponse<JSONObject> calculateAlreadyPurchaseMoney(@RequestParam Long contractId, @RequestParam(required=false) Long orgId) {
        if (contractId == null) {
            return CommonResponse.error((String)"\u53c2\u6570\u9519\u8bef\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getOrderMap().put("settlementDate", "desc");
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List entities = this.iPurchaseSettlementService.queryList(param, false);
        String lastTime = null;
        BigDecimal[] alreadyPurchaseMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
        if (ListUtil.isNotEmpty((List)entities)) {
            lastTime = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)((PurchaseSettlementEntity)((Object)entities.get(0))).getSettlementDate());
            entities.forEach(e -> {
                if (orgId == null) {
                    alreadyPurchaseMoney[0] = ComputeUtil.safeAdd((BigDecimal)alreadyPurchaseMoney[0], (BigDecimal)e.getCurrentSettlementAmountTax());
                } else if (orgId.equals(e.getOrgId())) {
                    alreadyPurchaseMoney[0] = ComputeUtil.safeAdd((BigDecimal)alreadyPurchaseMoney[0], (BigDecimal)e.getCurrentSettlementAmountTax());
                }
                alreadyPurchaseMoney[1] = alreadyPurchaseMoney[1].add(e.getOffsetAmountInCurrentPeriod() == null ? new BigDecimal("0.00").setScale(2, 4) : e.getOffsetAmountInCurrentPeriod());
            });
        }
        JSONObject data = new JSONObject();
        data.put("purchaseMoney", (Object)alreadyPurchaseMoney[0].toString());
        data.put("offsetAmountInCurrentPeriod", (Object)alreadyPurchaseMoney[1].toString());
        data.put("lastTime", (Object)lastTime);
        return CommonResponse.success((String)"\u8ba1\u7b97\u6210\u529f\uff01", (Object)data);
    }

    @GetMapping(value={"/hasNoFinishedPurchase"})
    @ResponseBody
    public CommonResponse<Long> hasNoFinishedPurchase(@RequestParam Long contractId, @RequestParam Long orgId) {
        if (contractId == null || orgId == null) {
            return CommonResponse.error((String)"\u53c2\u6570\u9519\u8bef\uff01");
        }
        List<PurchaseSettlementEntity> entities = this.getHasPurchased(contractId, orgId);
        if (ListUtil.isEmpty(entities)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)entities.get(0).getId());
    }

    @RequestMapping(value={"/refPurchaseData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseSettlementRefVO>> refPurchaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("creatorName");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject con = JSONObject.parseObject((String)condition);
            if (condition.contains("contractId")) {
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)con.getLong("contractId")));
            }
            if (condition.contains("orgId")) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)con.getLong("orgId")));
            }
            if (condition.contains("supplierId")) {
                queryParam.getParams().put("supplierId", new Parameter("eq", (Object)con.getLong("supplierId")));
            }
            if (condition.contains("belongToProject")) {
                queryParam.getParams().put("belongToProject", new Parameter("eq", (Object)con.getString("belongToProject")));
            }
        }
        List pList = queryParam.getComplexParams();
        ComplexParam p = new ComplexParam();
        p.setLogic("and");
        pList.add(p);
        List cList = p.getComplexParams();
        ComplexParam p1 = new ComplexParam();
        p1.setLogic("or");
        p1.getParams().put("remainCanApplyAmount", new Parameter("gt", (Object)0));
        ComplexParam p2 = new ComplexParam();
        p2.setLogic("or");
        p2.getParams().put("remainCanApplyAmount", new Parameter("eq", null));
        cList.add(p1);
        cList.add(p2);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage<PurchaseSettlementVO> voPage = this.iPurchaseSettlementService.queryForList(queryParam, false);
        List purchaseSettlementRefVos = BeanMapper.mapList((Iterable)voPage.getRecords(), PurchaseSettlementRefVO.class);
        if (CollectionUtils.isNotEmpty((Collection)purchaseSettlementRefVos)) {
            List settleIds = purchaseSettlementRefVos.stream().map(e -> e.getId()).collect(Collectors.toList());
            CommonResponse applyMnyHasFreeRes = this.payContractApi.getApplyMnyHasFree(settleIds);
            Map settleApplyData = (Map)applyMnyHasFreeRes.getData();
            for (PurchaseSettlementRefVO purchaseSettlementRefVo : purchaseSettlementRefVos) {
                purchaseSettlementRefVo.setSettleType(5);
                BigDecimal sumApplyMnyHasFree = (BigDecimal)settleApplyData.get(purchaseSettlementRefVo.getId());
                purchaseSettlementRefVo.setCurrentApplyAmount(sumApplyMnyHasFree);
                BigDecimal surplusApplyMny = ComputeUtil.safeSub((BigDecimal)purchaseSettlementRefVo.getCurrentSettlementAmountTax(), (BigDecimal[])new BigDecimal[]{purchaseSettlementRefVo.getOffsetAmountInCurrentPeriod(), sumApplyMnyHasFree});
                purchaseSettlementRefVo.setRemainCanApplyAmount(surplusApplyMny);
            }
        }
        Page page = new Page();
        page.setSize(voPage.getSize());
        page.setRecords(purchaseSettlementRefVos);
        page.setPages(voPage.getPages());
        page.setCurrent(voPage.getCurrent());
        page.setTotal(voPage.getTotal());
        return CommonResponse.success((String)"\u67e5\u8be2\u7ed3\u7b97\u53c2\u7167\u6210\u529f\uff01", (Object)page);
    }

    @PostMapping(value={"checkParams/{isJc}/{contractId}"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@PathVariable(name="isJc") Integer isJc, @PathVariable(name="contractId") Long contractId, @RequestBody MaterialPriceVO vo) {
        BigDecimal currentSettlementAmount = vo.getCurrentSettlementAmount();
        BigDecimal contractAmount = vo.getContractAmount();
        BigDecimal settledAmount = vo.getSettledAmount();
        String purchaseMethod = vo.getPurchaseMethod();
        ParamsCheckVO paramsCheckVO = this.iPurchaseSettlementService.checkParams(isJc, contractId, settledAmount, currentSettlementAmount, contractAmount, purchaseMethod, vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @PostMapping(value={"queryPrice/{isJc}/{contractId}"})
    @ResponseBody
    public CommonResponse<List<MaterialPriceVO>> queryPrice(@PathVariable(name="isJc") Integer isJc, @PathVariable(name="contractId") Long contractId, @RequestBody MaterialPriceVO vo) {
        this.materialContractService.queryPrice(isJc, contractId, vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo.getDetail());
    }
}

