/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.mapper.UseApplySubMapper;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.MaterialApplyCountVO;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.material.vo.UseApplyVO;
import com.ejianc.business.plan.api.IBudgetPlanApi;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.MaterialMasterPlanSubVO;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UseApplyService
extends BaseServiceImpl<UseApplyMapper, UseApplyEntity>
implements IUseApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    IBudgetPlanApi budgetPlanApi;
    @Autowired
    public IOutStoreSubService outStoreSubService;
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    @Autowired
    private UseApplyMapper useApplyMapper;
    @Autowired
    private UseApplySubMapper useApplySubMapper;
    private static String PARAM_PLAN_COUNT = "P-P902i028";
    private static String PARAM_PLAN_ALL_COUNT = "P-F8k54925";

    @Override
    public IPage<UseApplyVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), UseApplyVO.class));
        }
        return voPage;
    }

    @Override
    public ParamsCheckVO checkParams(UseApplyVO vo) {
        List<UseApplySubVO> detailList = vo.getUseApplySubEntities();
        HashMap numberMap = new HashMap();
        detailList.forEach(detail -> {
            UseApplySubVO useApplySubVO = (UseApplySubVO)((Object)((Object)numberMap.get(detail.getMaterialId())));
            if (useApplySubVO != null) {
                useApplySubVO.setApplyNum(ComputeUtil.safeAdd((BigDecimal)useApplySubVO.getApplyNum(), (BigDecimal)detail.getApplyNum()));
            } else {
                numberMap.put(detail.getMaterialId(), detail);
            }
        });
        vo.setUseApplySubEntities(new ArrayList<UseApplySubVO>(numberMap.values()));
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isEmpty(useApplySubEntities)) {
            return paramsCheckVO;
        }
        CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)countParamByCode.getData();
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            ArrayList checkDsVOS = new ArrayList();
            if (0 != billParamVO.getControlType()) {
                RecalculateVO cal = RecalculateVO.intsance((Long)vo.getProjectId(), null);
                cal.setMonthEndDate(DateUtil.format((Date)vo.getApplyDate(), (String)"yyyy-MM-dd"));
                CommonResponse planNum = this.budgetPlanApi.getPlanNum(cal);
                if (planNum.isSuccess()) {
                    RecalculateVO recalculateVO = (RecalculateVO)planNum.getData();
                    Map planNumMap = recalculateVO.getPlanNumMap();
                    Map budgetNumMap = recalculateVO.getBudgetNumMap();
                    if (MapUtils.isEmpty((Map)planNumMap)) {
                        this.logger.info("\u7528\u6599\u7533\u8bf7\u67e5\u8be2\u8ba1\u5212\u7269\u6599\u8ba1\u5212\u5de5\u7a0b\u91cf*\u8017\u91cf\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a!");
                    }
                    Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
                    HashMap<Long, BigDecimal> numMap = new HashMap<Long, BigDecimal>();
                    listMap.forEach((k, v) -> numMap.put((Long)k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
                    ArrayList<Long> materialIds = new ArrayList<Long>(listMap.keySet());
                    HashMap<String, Object> queryParam = new HashMap<String, Object>();
                    queryParam.put("projectId", vo.getProjectId());
                    queryParam.put("pId", vo.getId());
                    queryParam.put("endMonth", recalculateVO.getEndMonth());
                    queryParam.put("materialIds", materialIds);
                    List<UseApplySubVO> useApplySubVOS = ((UseApplyMapper)this.baseMapper).countApplyNum(queryParam);
                    if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
                        Map<Long, BigDecimal> level3Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
                        HashMap newNumMap = new HashMap();
                        numMap.forEach((k, v) -> {
                            BigDecimal b = (BigDecimal)level3Map.get(k);
                            newNumMap.put(k, MathUtil.safeAdd((BigDecimal)v, (BigDecimal)b));
                        });
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal ratio = roleValue.divide(BigDecimal.valueOf(100L));
                        useApplySubEntities.forEach(d -> {
                            Long materialId = d.getMaterialId();
                            BigDecimal oldNum = (BigDecimal)numMap.get(materialId);
                            BigDecimal num = (BigDecimal)newNumMap.get(materialId);
                            BigDecimal _planNum = MapUtils.isEmpty((Map)planNumMap) ? BigDecimal.ZERO : (BigDecimal)planNumMap.get(materialId);
                            BigDecimal applyed = (BigDecimal)level3Map.get(materialId);
                            BigDecimal budgetNum = MapUtils.isEmpty((Map)budgetNumMap) ? BigDecimal.ZERO : (BigDecimal)budgetNumMap.get(materialId);
                            BigDecimal zsPlanNum = ComputeUtil.safeMultiply((BigDecimal)ratio, (BigDecimal)budgetNum);
                            BigDecimal extra = ComputeUtil.safeSub((BigDecimal)num, (BigDecimal)zsPlanNum);
                            if (ComputeUtil.isGreaterThan((BigDecimal)num, (BigDecimal)zsPlanNum)) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "applyNum");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getModel()) ? " [" + d.getModel() + "]" : ""));
                                paramsCheckDsVO.setWarnName("\u7533\u8bf7\u6750\u6599\u6570\u91cf\u5927\u4e8e\u9879\u76ee\u9884\u7b97\u6570\u91cf");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("\u672c\u6b21\u7533\u8bf7\u6570\u91cf\uff1a").append(oldNum.setScale(2, 4)).append("\uff0c\u5df2\u7533\u8bf7\u6570\u91cf\uff1a").append(ComputeUtil.nullToZero((BigDecimal)applyed).setScale(2, 4)).append("\uff0c\u9879\u76ee\u9884\u7b97\u6570\u91cf * ").append(roleValue).append("%: ").append(zsPlanNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(extra.setScale(2, 4));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        });
                    }
                } else {
                    this.logger.error("\u7528\u6599\u7533\u8bf7\u67e5\u8be2\u8ba1\u5212\u7269\u6599\u8ba1\u5212\u5de5\u7a0b\u91cf*\u8017\u91cf\u8fd4\u56de\u4fe1\u606f:" + planNum.getMsg());
                    Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
                    HashMap<Long, BigDecimal> numMap = new HashMap<Long, BigDecimal>();
                    listMap.forEach((k, v) -> numMap.put((Long)k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
                    ArrayList<Long> materialIds = new ArrayList<Long>(listMap.keySet());
                    HashMap<String, Object> queryParam = new HashMap<String, Object>();
                    queryParam.put("projectId", vo.getProjectId());
                    queryParam.put("pId", vo.getId());
                    queryParam.put("materialIds", materialIds);
                    List<UseApplySubVO> useApplySubVOS = ((UseApplyMapper)this.baseMapper).countApplyNum(queryParam);
                    if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
                        Map<Long, BigDecimal> level3Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
                        HashMap newNumMap = new HashMap();
                        numMap.forEach((k, v) -> {
                            BigDecimal b = (BigDecimal)level3Map.get(k);
                            newNumMap.put(k, MathUtil.safeAdd((BigDecimal)v, (BigDecimal)b));
                        });
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        useApplySubEntities.forEach(d -> {
                            Long materialId = d.getMaterialId();
                            BigDecimal oldNum = (BigDecimal)numMap.get(materialId);
                            BigDecimal num = (BigDecimal)newNumMap.get(materialId);
                            BigDecimal applyed = (BigDecimal)level3Map.get(materialId);
                            BigDecimal zsPlanNum = BigDecimal.ZERO;
                            BigDecimal extra = ComputeUtil.safeSub((BigDecimal)num, (BigDecimal)zsPlanNum);
                            if (ComputeUtil.isGreaterThan((BigDecimal)num, (BigDecimal)zsPlanNum)) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "applyNum");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getModel()) ? " [" + d.getModel() + "]" : ""));
                                paramsCheckDsVO.setWarnName("\u7533\u8bf7\u6750\u6599\u6570\u91cf\u5927\u4e8e\u9879\u76ee\u9884\u7b97\u6570\u91cf");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("\u672c\u6b21\u7533\u8bf7\u6570\u91cf\uff1a").append(oldNum.setScale(2, 4)).append("\uff0c\u5df2\u7533\u8bf7\u6570\u91cf\uff1a").append(ComputeUtil.nullToZero((BigDecimal)applyed).setScale(2, 4)).append("\uff0c\u9879\u76ee\u9884\u7b97\u6570\u91cf * ").append(roleValue).append("%: ").append(zsPlanNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(extra.setScale(2, 4));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        });
                    }
                }
                paramsCheckVO.setDataSource(checkDsVOS);
            }
        } else {
            this.logger.info(countParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO checkAllParams(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isEmpty(useApplySubEntities)) {
            return paramsCheckVO;
        }
        CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_ALL_COUNT);
        if (!countParamByCode.isSuccess() || null == countParamByCode.getData()) {
            this.logger.info(countParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        BigDecimal manageRate = ((BillParamVO)countParamByCode.getData()).getRoleValue();
        BillParamVO billParamVO = (BillParamVO)countParamByCode.getData();
        paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
        if (billParamVO.getControlType() == 0) {
            return paramsCheckVO;
        }
        ArrayList checkDsVOS = new ArrayList();
        Long projectId = vo.getProjectId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.in((Object)"bill_state", new Object[]{1, 3});
        List materialMasterPlanEntities = this.materialMasterPlanMapper.selectList((Wrapper)wrapper);
        QueryWrapper planSubWrapper = new QueryWrapper();
        ArrayList<Long> ids = new ArrayList<Long>();
        materialMasterPlanEntities.forEach(item -> ids.add(item.getId()));
        ids.add(1L);
        planSubWrapper.in((Object)"material_master_plan_id", ids);
        planSubWrapper.eq((Object)"dr", (Object)0);
        List materialMasterPlanSubEntities = this.materialMasterPlanSubMapper.selectList((Wrapper)planSubWrapper);
        HashMap planMap = new HashMap();
        materialMasterPlanSubEntities.forEach(item -> {
            Double num = item.getNum();
            if (planMap.get(item.getMaterialId()) != null) {
                planMap.put(item.getMaterialId(), ComputeUtil.safeAdd((BigDecimal)BigDecimal.valueOf(num), (BigDecimal)((BigDecimal)planMap.get(item.getMaterialId()))));
            } else {
                planMap.put(item.getMaterialId(), BigDecimal.valueOf(num));
            }
        });
        QueryWrapper appWrapper = new QueryWrapper();
        appWrapper.eq((Object)"project_id", (Object)projectId);
        appWrapper.eq((Object)"dr", (Object)0);
        appWrapper.in((Object)"bill_state", new Object[]{1, 3});
        List useApplyEntities = this.useApplyMapper.selectList((Wrapper)appWrapper);
        ids.clear();
        useApplyEntities.forEach(item -> ids.add(item.getId()));
        ArrayList noIds = new ArrayList();
        useApplySubEntities.forEach(item -> {
            if (item.getId() != null) {
                noIds.add(item.getId());
            }
        });
        ids.add(1L);
        QueryWrapper appSubWrapper = new QueryWrapper();
        appSubWrapper.in((Object)"pid", ids);
        appSubWrapper.notIn((Object)"id", noIds);
        appSubWrapper.eq((Object)"dr", (Object)0);
        List useApplySubEntities1 = this.useApplySubMapper.selectList((Wrapper)appSubWrapper);
        List useApplySubEntities2 = BeanMapper.mapList(useApplySubEntities, UseApplySubEntity.class);
        HashMap<Long, UseApplySubEntity> thisMap = new HashMap<Long, UseApplySubEntity>();
        useApplySubEntities2.forEach(item -> {
            if (thisMap.containsKey(item.getMaterialId())) {
                UseApplySubEntity useApplySubEntity = (UseApplySubEntity)((Object)((Object)thisMap.get(item.getMaterialId())));
                useApplySubEntity.setApplyNum(ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)useApplySubEntity.getApplyNum(), (BigDecimal)item.getApplyNum())));
            } else {
                thisMap.put(item.getMaterialId(), (UseApplySubEntity)((Object)item));
            }
        });
        HashMap oldAppMap = new HashMap();
        useApplySubEntities1.forEach(item -> {
            BigDecimal applyNum = item.getApplyNum();
            if (oldAppMap.containsKey(item.getMaterialId())) {
                BigDecimal bigDecimal = (BigDecimal)oldAppMap.get(item.getMaterialId());
                oldAppMap.put(item.getMaterialId(), ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)applyNum, (BigDecimal)bigDecimal)));
            } else {
                oldAppMap.put(item.getMaterialId(), applyNum);
            }
        });
        thisMap.forEach((k, item) -> {
            BigDecimal appNumber;
            Long materialId = item.getMaterialId();
            BigDecimal applyNum = item.getApplyNum();
            BigDecimal oldApplyNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)oldAppMap.get(materialId);
            BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)planMap.get(materialId);
            BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100L));
            if (planNumber.compareTo(appNumber = ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)oldApplyNum, (BigDecimal)applyNum))) == -1) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)item.getModel()) ? " [" + item.getModel() + "]" : ""));
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u7533\u8bf7\u6570\u91cf\u8d85\u51fa\u603b\u8ba1\u5212*\u6bd4\u4f8b");
                paramsCheckDsVO.setContent("\u672c\u6b21\u7533\u8bf7\u6570\u91cf:" + applyNum.setScale(2, 4) + ",\u7d2f\u8ba1\u5df2\u7533\u8bf7\u6570\u91cf" + oldApplyNum.setScale(2, 4) + ",\u603b\u8ba1\u5212\u6570\u91cf" + planNum.setScale(2, 4) + ",\u603b\u8ba1\u5212\u6570\u91cf\u6bd4\u4f8b" + manageRate.setScale(2, 4) + "%,\u8d85\u989d" + appNumber.subtract(planNumber).setScale(2, 4));
                checkDsVOS.add(paramsCheckDsVO);
            }
            paramsCheckVO.setDataSource(checkDsVOS);
        });
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<UseApplyVO> getSumNum(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        RecalculateVO cal = RecalculateVO.intsance((Long)vo.getProjectId(), null);
        cal.setMonthEndDate(DateUtil.format((Date)vo.getApplyDate(), (String)"yyyy-MM-dd"));
        CommonResponse planNum = this.budgetPlanApi.getPlanNum(cal);
        Map planNumMap = null;
        Map budgetNumMap = null;
        if (planNum.isSuccess()) {
            RecalculateVO recalculateVO = (RecalculateVO)planNum.getData();
            planNumMap = recalculateVO.getPlanNumMap();
            budgetNumMap = recalculateVO.getBudgetNumMap();
            if (MapUtils.isEmpty((Map)planNumMap)) {
                this.logger.info("\u7528\u6599\u7533\u8bf7\u67e5\u8be2\u8ba1\u5212\u7269\u6599\u8ba1\u5212\u5de5\u7a0b\u91cf*\u8017\u91cf\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a!");
            }
        } else {
            this.logger.info(planNum.getMsg());
        }
        CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
        BillParamVO billParamVO = (BillParamVO)countParamByCode.getData();
        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
            HashMap numMap = new HashMap();
            listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
            ArrayList<Long> materialIds = new ArrayList<Long>(listMap.keySet());
            HashMap<String, Object> queryParam = new HashMap<String, Object>();
            queryParam.put("projectId", vo.getProjectId());
            queryParam.put("pId", vo.getId());
            queryParam.put("materialIds", materialIds);
            List<UseApplySubVO> useApplySubVOS = ((UseApplyMapper)this.baseMapper).countApplyNum(queryParam);
            if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
                Map<Long, BigDecimal> level3Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal ratio = roleValue.divide(BigDecimal.valueOf(100L));
                Map<Long, List<UseApplySubVO>> level4Map = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
                HashMap sumAppluNumMap = new HashMap();
                level4Map.forEach((k, v) -> sumAppluNumMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
                for (UseApplySubVO d : useApplySubEntities) {
                    Long materialId = d.getMaterialId();
                    BigDecimal budgetNum = MapUtils.isEmpty((Map)budgetNumMap) ? BigDecimal.ZERO : (BigDecimal)budgetNumMap.get(materialId);
                    BigDecimal _planNum = MapUtils.isEmpty((Map)planNumMap) ? BigDecimal.ZERO : (BigDecimal)planNumMap.get(materialId);
                    BigDecimal applyed = level3Map.get(materialId);
                    BigDecimal thisAddApplyed = ComputeUtil.safeAdd((BigDecimal)applyed, (BigDecimal)d.getApplyNum());
                    BigDecimal zsPlanNum = ComputeUtil.safeMultiply((BigDecimal)ratio, (BigDecimal)_planNum);
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("projectId", vo.getProjectId());
                    param.put("materialId", d.getMaterialId());
                    List<OutStoreSubVO> outStoreSubVOS = this.outStoreSubService.queryReturnGoodsMaterialNum(param);
                    Map<Long, BigDecimal> outStoreMap = outStoreSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getOutStoreNumber()));
                    BigDecimal returnGoodsNum = outStoreMap.get(materialId);
                    applyed = BigDecimalUtils.safeSub((BigDecimal)applyed, (BigDecimal)returnGoodsNum);
                    if (applyed.compareTo(BigDecimal.ZERO) < 0) {
                        applyed = new BigDecimal(0);
                    }
                    if ((thisAddApplyed = ComputeUtil.safeAdd((BigDecimal)applyed, (BigDecimal)((BigDecimal)sumAppluNumMap.get(materialId)))).compareTo(BigDecimal.ZERO) < 0) {
                        thisAddApplyed = new BigDecimal(0);
                    }
                    List<MaterialMasterPlanSubVO> masterPlanSubVOS = this.materialMasterPlanSubMapper.queryMasterPlanSubNum(param);
                    Map<Long, Double> masterPlanMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getNum()));
                    Double masterPlanNum = masterPlanMap.get(materialId);
                    d.setOrderNum(ComputeUtil.nullToZero((BigDecimal)thisAddApplyed));
                    d.setSumApplyNum(ComputeUtil.nullToZero((BigDecimal)applyed));
                    d.setPlanNum(ComputeUtil.nullToZero((BigDecimal)zsPlanNum));
                    d.setTotalNum(ComputeUtil.nullToZero((BigDecimal)budgetNum));
                    d.setMasterPlanNum(masterPlanNum != null ? new BigDecimal(masterPlanNum) : BigDecimal.ZERO.setScale(8));
                    d.setIsFinish(0);
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u7d2f\u8ba1\u91cf,\u8fdb\u5ea6\u91cf,\u603b\u91cf\u6210\u529f!", (Object)((Object)vo));
    }

    @Override
    public CommonResponse<UseApplyVO> getSumNumCommon(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        RecalculateVO cal = RecalculateVO.intsance((Long)vo.getProjectId(), null);
        cal.setMonthEndDate(DateUtil.format((Date)vo.getApplyDate(), (String)"yyyy-MM-dd"));
        CommonResponse planNum = this.budgetPlanApi.getPlanNum(cal);
        Map planNumMap = null;
        Map budgetNumMap = null;
        if (planNum.isSuccess()) {
            RecalculateVO recalculateVO = (RecalculateVO)planNum.getData();
            planNumMap = recalculateVO.getPlanNumMap();
            budgetNumMap = recalculateVO.getBudgetNumMap();
            if (MapUtils.isEmpty((Map)planNumMap)) {
                this.logger.info("\u7528\u6599\u7533\u8bf7\u67e5\u8be2\u8ba1\u5212\u7269\u6599\u8ba1\u5212\u5de5\u7a0b\u91cf*\u8017\u91cf\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a!");
            }
        } else {
            this.logger.info(planNum.getMsg());
        }
        CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
        BillParamVO billParamVO = (BillParamVO)countParamByCode.getData();
        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
            HashMap numMap = new HashMap();
            listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
            ArrayList<Long> materialIds = new ArrayList<Long>(listMap.keySet());
            HashMap<String, Object> queryParam = new HashMap<String, Object>();
            queryParam.put("projectId", vo.getProjectId());
            queryParam.put("pId", vo.getId());
            queryParam.put("materialIds", materialIds);
            List<UseApplySubVO> useApplySubVOS = ((UseApplyMapper)this.baseMapper).countApplyNumCommon(queryParam);
            if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
                Map<Long, BigDecimal> level3Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal ratio = roleValue.divide(BigDecimal.valueOf(100L));
                Map<Long, List<UseApplySubVO>> level4Map = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
                HashMap sumAppluNumMap = new HashMap();
                level4Map.forEach((k, v) -> sumAppluNumMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
                for (UseApplySubVO d : useApplySubEntities) {
                    Long materialId = d.getMaterialId();
                    BigDecimal budgetNum = MapUtils.isEmpty((Map)budgetNumMap) ? BigDecimal.ZERO : (BigDecimal)budgetNumMap.get(materialId);
                    BigDecimal _planNum = MapUtils.isEmpty((Map)planNumMap) ? BigDecimal.ZERO : (BigDecimal)planNumMap.get(materialId);
                    BigDecimal applyed = level3Map.get(materialId);
                    BigDecimal thisAddApplyed = ComputeUtil.safeAdd((BigDecimal)applyed, (BigDecimal)d.getApplyNum());
                    BigDecimal zsPlanNum = ComputeUtil.safeMultiply((BigDecimal)ratio, (BigDecimal)_planNum);
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("projectId", vo.getProjectId());
                    param.put("materialId", d.getMaterialId());
                    List<OutStoreSubVO> outStoreSubVOS = this.outStoreSubService.queryReturnGoodsMaterialNum(param);
                    Map<Long, BigDecimal> outStoreMap = outStoreSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getOutStoreNumber()));
                    BigDecimal returnGoodsNum = outStoreMap.get(materialId);
                    applyed = BigDecimalUtils.safeSub((BigDecimal)applyed, (BigDecimal)returnGoodsNum);
                    if (applyed.compareTo(BigDecimal.ZERO) < 0) {
                        applyed = new BigDecimal(0);
                    }
                    if ((thisAddApplyed = ComputeUtil.safeAdd((BigDecimal)applyed, (BigDecimal)((BigDecimal)sumAppluNumMap.get(materialId)))).compareTo(BigDecimal.ZERO) < 0) {
                        thisAddApplyed = new BigDecimal(0);
                    }
                    List<MaterialMasterPlanSubVO> masterPlanSubVOS = this.materialMasterPlanSubMapper.queryMasterPlanSubNum(param);
                    Map<Long, Double> masterPlanMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getNum()));
                    Double masterPlanNum = masterPlanMap.get(materialId);
                    d.setOrderNum(ComputeUtil.nullToZero((BigDecimal)thisAddApplyed));
                    d.setSumApplyNum(ComputeUtil.nullToZero((BigDecimal)applyed));
                    d.setPlanNum(ComputeUtil.nullToZero((BigDecimal)zsPlanNum));
                    d.setTotalNum(ComputeUtil.nullToZero((BigDecimal)budgetNum));
                    d.setMasterPlanNum(masterPlanNum != null ? new BigDecimal(masterPlanNum) : BigDecimal.ZERO.setScale(8));
                    d.setIsFinish(0);
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u7d2f\u8ba1\u91cf,\u8fdb\u5ea6\u91cf,\u603b\u91cf\u6210\u529f!", (Object)((Object)vo));
    }

    @Override
    public List<UseApplyFinishVO> materialFinishCount(Map<String, Object> queryParam) {
        return ((UseApplyMapper)this.baseMapper).materialFinishCount(queryParam);
    }

    @Override
    public List<MaterialApplyCountVO> queryMaterialApplyCount(Long projectId, List<Long> materialIds) {
        return ((UseApplyMapper)this.baseMapper).queryMaterialApplyCount(projectId, materialIds);
    }
}

