package com.ejianc.business.material.service.impl;

import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("pickReturn")
public class PickReturnBpmService implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IInstoreService iInstoreService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private ICostDetailApi iCostDetailApi;
    
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        InstoreEntity entity = iInstoreService.selectById(billId);
        if(entity==null){
            CommonResponse.error("没有找到相关入库单！");
        }
        if(!ListUtil.isEmpty(entity.getInstoreMaterialList())){
        	for(InstoreMaterialEntity sub : entity.getInstoreMaterialList()){
                sub.setStoreState(MaterialStoreState.STORED.getCode());
        	}
        }
        /** 领料退库 & 直入直出 成本处理*/
        processCostState(entity,1);
        iInstoreService.saveOrUpdate(entity,false);
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        InstoreEntity entity = iInstoreService.selectById(billId);
        if(entity==null){
            CommonResponse.error("没有找到相关入库单！");
        }
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()) {
            logger.info("领料退库单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}",billId,billTypeCode, resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }
        if(!ListUtil.isEmpty(entity.getInstoreMaterialList())){
        	for(InstoreMaterialEntity sub : entity.getInstoreMaterialList()){
                sub.setStoreState(MaterialStoreState.STORING.getCode());
        	}
        }
        /** 领料退库 & 直入直出 成本处理*/
        processCostState(entity,0);
        iInstoreService.saveOrUpdate(entity,false);
        return CommonResponse.success();
    }
    /** 成本处理  */
    public void processCostState(InstoreEntity entity,Integer process){
        if(process == 1){//审批通过
            iInstoreService.processCost(entity);
        }else {//弃审
            iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }
}
