package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.mapper.UseApplySubMapper;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.plan.api.IBudgetPlanApi;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.MaterialMasterPlanSubVO;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Service
public class UseApplyService extends BaseServiceImpl<UseApplyMapper, UseApplyEntity> implements IUseApplyService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    IBudgetPlanApi budgetPlanApi;
    @Autowired
    public IOutStoreSubService outStoreSubService;

    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    @Autowired
    private UseApplyMapper useApplyMapper;
    @Autowired
    private UseApplySubMapper useApplySubMapper;

    private static String PARAM_PLAN_COUNT = "P-P902i028";
    private static String PARAM_PLAN_ALL_COUNT = "P-F8k54925";


    @Override
    public IPage<UseApplyVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<UseApplyVO> voPage = null;
        IPage<UseApplyEntity> entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(), UseApplyVO.class));
        }
        return voPage;
    }

    @Override
    public ParamsCheckVO checkParams(UseApplyVO vo) {
        List<UseApplySubVO> detailList = vo.getUseApplySubEntities();
        Map<Long,UseApplySubVO> numberMap = new HashMap<>();
        detailList.forEach(detail->{
            UseApplySubVO useApplySubVO = numberMap.get(detail.getMaterialId());
            if(useApplySubVO != null){
                useApplySubVO.setApplyNum(ComputeUtil.safeAdd(useApplySubVO.getApplyNum(),detail.getApplyNum()));
            }else{
                numberMap.put(detail.getMaterialId(),detail);
            }
        });
        vo.setUseApplySubEntities(new ArrayList<>(numberMap.values()));

        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isEmpty(useApplySubEntities)) {
            return paramsCheckVO;
        }
        CommonResponse<BillParamVO> countParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);

        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            BillParamVO billParamVO = countParamByCode.getData();
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
            if (0 != billParamVO.getControlType()) {
                RecalculateVO cal = RecalculateVO.intsance(vo.getProjectId(), null);
                cal.setMonthEndDate(DateUtil.format(vo.getApplyDate(), DateUtil.DATE));
                CommonResponse<RecalculateVO> planNum = budgetPlanApi.getPlanNum(cal);

                if (planNum.isSuccess()) {
                    RecalculateVO recalculateVO = planNum.getData();
                    Map<Long, BigDecimal> planNumMap = recalculateVO.getPlanNumMap();
                    Map<Long, BigDecimal> budgetNumMap = recalculateVO.getBudgetNumMap();
                    if (MapUtils.isEmpty(planNumMap)) {
                        logger.info("用料申请查询计划物料计划工程量*耗量返回信息为空!");
                    }

                    Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
                    //当前单子累计物资量
                    Map<Long, BigDecimal> numMap = new HashMap<>();
                    listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));

                    List<Long> materialIds = new ArrayList<>(listMap.keySet());
                    Map<String, Object> queryParam = new HashMap<>();
                    queryParam.put("projectId", vo.getProjectId());
                    queryParam.put("pId", vo.getId());
                    //queryParam.put("startMonth", recalculateVO.getStartMonth());
                    queryParam.put("endMonth", recalculateVO.getEndMonth());
                    queryParam.put("materialIds", materialIds);
                    List<UseApplySubVO> useApplySubVOS = baseMapper.countApplyNum(queryParam);
                    if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
                        Map<Long, BigDecimal> level3Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
                        Map<Long, BigDecimal> newNumMap = new HashMap<>();
                        numMap.forEach((k, v) -> {
                            BigDecimal b = level3Map.get(k);
                            newNumMap.put(k, MathUtil.safeAdd(v, b));
                        });
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal ratio = roleValue.divide(BigDecimal.valueOf(100));

                        useApplySubEntities.forEach((d) -> {
                            Long materialId = d.getMaterialId();
                            BigDecimal oldNum = numMap.get(materialId);
                            BigDecimal num = newNumMap.get(materialId);
                            BigDecimal _planNum = MapUtils.isEmpty(planNumMap) ? BigDecimal.ZERO : planNumMap.get(materialId);
                            BigDecimal applyed = level3Map.get(materialId);
                            BigDecimal budgetNum = MapUtils.isEmpty(budgetNumMap) ? BigDecimal.ZERO : budgetNumMap.get(materialId);

                            BigDecimal zsPlanNum = ComputeUtil.safeMultiply(ratio, budgetNum);
                            BigDecimal extra = ComputeUtil.safeSub(num, zsPlanNum);
                            if (ComputeUtil.isGreaterThan(num, zsPlanNum)) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "applyNum");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getModel()) ? " [" + d.getModel() + "]" : ""));
                                paramsCheckDsVO.setWarnName("申请材料数量大于项目预算数量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次申请数量：").append(oldNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，已申请数量：").append(ComputeUtil.nullToZero(applyed).setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，项目预算数量 * ").append(roleValue).append("%: ").append(zsPlanNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(extra.setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        });
                    }
                } else {
                    logger.error("用料申请查询计划物料计划工程量*耗量返回信息:" + planNum.getMsg());
                    Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
                    //当前单子累计物资量
                    Map<Long, BigDecimal> numMap = new HashMap<>();
                    listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));

                    List<Long> materialIds = new ArrayList<>(listMap.keySet());
                    Map<String, Object> queryParam = new HashMap<>();
                    queryParam.put("projectId", vo.getProjectId());
                    queryParam.put("pId", vo.getId());
                    queryParam.put("materialIds", materialIds);
                    List<UseApplySubVO> useApplySubVOS = baseMapper.countApplyNum(queryParam);
                    if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
                        Map<Long, BigDecimal> level3Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
                        Map<Long, BigDecimal> newNumMap = new HashMap<>();
                        numMap.forEach((k, v) -> {
                            BigDecimal b = level3Map.get(k);
                            newNumMap.put(k, MathUtil.safeAdd(v, b));
                        });
                        BigDecimal roleValue = billParamVO.getRoleValue();


                        useApplySubEntities.forEach((d) -> {
                            Long materialId = d.getMaterialId();
                            BigDecimal oldNum = numMap.get(materialId);
                            BigDecimal num = newNumMap.get(materialId);
                            BigDecimal applyed = level3Map.get(materialId);
                            BigDecimal zsPlanNum = BigDecimal.ZERO;
                            BigDecimal extra = ComputeUtil.safeSub(num, zsPlanNum);
                            if (ComputeUtil.isGreaterThan(num, zsPlanNum)) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "applyNum");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getModel()) ? " [" + d.getModel() + "]" : ""));
                                paramsCheckDsVO.setWarnName("申请材料数量大于项目预算数量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次申请数量：").append(oldNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，已申请数量：").append(ComputeUtil.nullToZero(applyed).setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，项目预算数量 * ").append(roleValue).append("%: ").append(zsPlanNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(extra.setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        });

                    }
                }
                paramsCheckVO.setDataSource(checkDsVOS);
            }


        } else {
            logger.info(countParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO checkAllParams(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isEmpty(useApplySubEntities)) {
            return paramsCheckVO;
        }
        CommonResponse<BillParamVO> countParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_ALL_COUNT);

        if (!countParamByCode.isSuccess() || null == countParamByCode.getData()) {
            logger.info(countParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        // 管理费率
        BigDecimal manageRate = countParamByCode.getData().getRoleValue();

        BillParamVO billParamVO = countParamByCode.getData();
        paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
        if(billParamVO.getControlType() == 0){
            return paramsCheckVO;
        }
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        // 根据项目取得总计划数据
        Long projectId = vo.getProjectId();
        QueryWrapper<MaterialMasterPlanEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id",projectId);
        wrapper.eq("dr",0);
        wrapper.in("bill_state",1,3);
        List<MaterialMasterPlanEntity> materialMasterPlanEntities = materialMasterPlanMapper.selectList(wrapper);

        QueryWrapper<MaterialMasterPlanSubEntity> planSubWrapper = new QueryWrapper<>();
        List<Long> ids = new ArrayList<>();
        materialMasterPlanEntities.forEach(item->{
            ids.add(item.getId());
        });
        // list添加一个数据，防止数据为空时，in查询sql拼接错误。
        ids.add(000001L);
        planSubWrapper.in("material_master_plan_id",ids);
        planSubWrapper.eq("dr",0);
        List<MaterialMasterPlanSubEntity> materialMasterPlanSubEntities = materialMasterPlanSubMapper.selectList(planSubWrapper);
        Map<Long,BigDecimal> planMap = new HashMap<>();
        materialMasterPlanSubEntities.forEach(item->{
            Double num = item.getNum();
            if(planMap.get(item.getMaterialId())!=null){
                planMap.put(item.getMaterialId(),ComputeUtil.safeAdd(BigDecimal.valueOf(num),planMap.get(item.getMaterialId())));
            }else{
                planMap.put(item.getMaterialId(), BigDecimal.valueOf(num));
            }
        });
        // 根据项目id取得原申请过的数据。
        QueryWrapper<UseApplyEntity> appWrapper = new QueryWrapper<>();
        appWrapper.eq("project_id",projectId);
        appWrapper.eq("dr",0);
        appWrapper.in("bill_state",1,3);
        List<UseApplyEntity> useApplyEntities = useApplyMapper.selectList(appWrapper);
        ids.clear();
        useApplyEntities.forEach(item->{
            ids.add(item.getId());
        });
        // 查询旧数据时，剔除掉本次申请的物资
        List<Long> noIds = new ArrayList<>();
        useApplySubEntities.forEach(item->{
            if(item.getId() != null){
                noIds.add(item.getId());
            }
        });
        // list添加一个数据，防止数据为空时，in查询sql拼接错误。
        ids.add(000001L);
        QueryWrapper<UseApplySubEntity> appSubWrapper = new QueryWrapper<>();
        appSubWrapper.in("pid",ids);
        appSubWrapper.notIn("id",noIds);
        appSubWrapper.eq("dr",0);
        List<UseApplySubEntity> useApplySubEntities1 = useApplySubMapper.selectList(appSubWrapper);
        List<UseApplySubEntity> useApplySubEntities2 = BeanMapper.mapList(useApplySubEntities, UseApplySubEntity.class);
        Map<Long,UseApplySubEntity> thisMap = new HashMap<>();
        useApplySubEntities2.forEach(item->{
            if(thisMap.containsKey(item.getMaterialId())){
                UseApplySubEntity useApplySubEntity = thisMap.get(item.getMaterialId());
                useApplySubEntity.setApplyNum(ComputeUtil.nullToZero(ComputeUtil.safeAdd(useApplySubEntity.getApplyNum(),item.getApplyNum())));
            }else{
                thisMap.put(item.getMaterialId(),item);
            }
        });

        Map<Long,BigDecimal> oldAppMap = new HashMap<>();
        useApplySubEntities1.forEach(item->{
            BigDecimal applyNum = item.getApplyNum();
            if(oldAppMap.containsKey(item.getMaterialId())){
                BigDecimal bigDecimal = oldAppMap.get(item.getMaterialId());
                oldAppMap.put(item.getMaterialId(),ComputeUtil.nullToZero(ComputeUtil.safeAdd(applyNum,bigDecimal)));
            }else{
                oldAppMap.put(item.getMaterialId(),applyNum);
            }
        });

        thisMap.forEach((k,item)->{
            Long materialId = item.getMaterialId();
            //本次申请数量
            BigDecimal applyNum = item.getApplyNum();
            //原有的数量 如果为空取0
            BigDecimal oldApplyNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : oldAppMap.get(materialId);
            //总计划数量 如果为空 则表示未做计划，取0
            BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : planMap.get(materialId);

            BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100));
            BigDecimal appNumber = ComputeUtil.nullToZero(ComputeUtil.safeAdd(oldApplyNum,applyNum));

            if(planNumber.compareTo(appNumber) == -1){
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty(item.getModel()) ? " [" + item.getModel() + "]" : ""));
                paramsCheckDsVO.setWarnName("累计申请数量超出总计划*比例");
                paramsCheckDsVO.setContent("本次申请数量:"+applyNum.setScale(2, BigDecimal.ROUND_HALF_UP)
                        +",累计已申请数量"+oldApplyNum.setScale(2, BigDecimal.ROUND_HALF_UP)
                        +",总计划数量"+planNum.setScale(2, BigDecimal.ROUND_HALF_UP)
                        +",总计划数量比例"+manageRate.setScale(2, BigDecimal.ROUND_HALF_UP)
                        +"%,超额"+appNumber.subtract(planNumber).setScale(2, BigDecimal.ROUND_HALF_UP)
                );
                checkDsVOS.add(paramsCheckDsVO);
            }
            paramsCheckVO.setDataSource(checkDsVOS);
        });
        return paramsCheckVO;
    }


    @Override
    public CommonResponse<UseApplyVO> getSumNum(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();

        RecalculateVO cal = RecalculateVO.intsance(vo.getProjectId(), null);
        cal.setMonthEndDate(DateUtil.format(vo.getApplyDate(), DateUtil.DATE));
        CommonResponse<RecalculateVO> planNum = budgetPlanApi.getPlanNum(cal);
        Map<Long, BigDecimal> planNumMap = null;
        Map<Long, BigDecimal> budgetNumMap = null;
        if (planNum.isSuccess()) {
            RecalculateVO recalculateVO = planNum.getData();
            planNumMap = recalculateVO.getPlanNumMap();
            budgetNumMap = recalculateVO.getBudgetNumMap();
            if (MapUtils.isEmpty(planNumMap)) {
                logger.info("用料申请查询计划物料计划工程量*耗量返回信息为空!");
            }
        } else {
            logger.info(planNum.getMsg());
        }

        CommonResponse<BillParamVO> countParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
        BillParamVO billParamVO = countParamByCode.getData();
        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
            //当前单子累计物资量
            Map<Long, BigDecimal> numMap = new HashMap<>();
            listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));

            List<Long> materialIds = new ArrayList<>(listMap.keySet());
            Map<String, Object> queryParam = new HashMap<>();
            queryParam.put("projectId", vo.getProjectId());
            queryParam.put("pId", vo.getId());
            queryParam.put("materialIds", materialIds);
            List<UseApplySubVO> useApplySubVOS = baseMapper.countApplyNum(queryParam);
            if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
                Map<Long, BigDecimal> level3Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal ratio = roleValue.divide(BigDecimal.valueOf(100));

                Map<Long, List<UseApplySubVO>> level4Map = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
                Map<Long, BigDecimal> sumAppluNumMap = new HashMap<>();
                level4Map.forEach((k, v) -> sumAppluNumMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));

                for(UseApplySubVO d : useApplySubEntities){
                    Long materialId = d.getMaterialId();
                    BigDecimal budgetNum = MapUtils.isEmpty(budgetNumMap) ? BigDecimal.ZERO : budgetNumMap.get(materialId);
                    BigDecimal _planNum = MapUtils.isEmpty(planNumMap) ? BigDecimal.ZERO : planNumMap.get(materialId);
                    BigDecimal applyed = level3Map.get(materialId);
                    BigDecimal thisAddApplyed = ComputeUtil.safeAdd(applyed, d.getApplyNum());
                    BigDecimal zsPlanNum = ComputeUtil.safeMultiply(ratio, _planNum);
                    /** 获取该项目下物资退货数量 **/
                    Map<String, Object> param = new HashMap<>();
                    param.put("projectId", vo.getProjectId());
                    param.put("materialId", d.getMaterialId());
                    List <OutStoreSubVO> outStoreSubVOS = outStoreSubService.queryReturnGoodsMaterialNum(param);
                    Map<Long, BigDecimal> outStoreMap = outStoreSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(),k ->k.getOutStoreNumber()));
                    BigDecimal returnGoodsNum = outStoreMap.get(materialId);
                    applyed = BigDecimalUtils.safeSub(applyed,returnGoodsNum);
                    if(applyed.compareTo(BigDecimal.ZERO)<0){
                        applyed = new BigDecimal(0);
                    }
                    /** 获取该项目下物资退货数量 **/
//                    thisAddApplyed = ComputeUtil.safeAdd(applyed, d.getApplyNum());
                    thisAddApplyed = ComputeUtil.safeAdd(applyed,sumAppluNumMap.get(materialId));
                    if(thisAddApplyed.compareTo(BigDecimal.ZERO)<0){
                        thisAddApplyed = new BigDecimal(0);
                    }
                    /** 获取该项目下物资总计划数量 **/
                    List<MaterialMasterPlanSubVO> masterPlanSubVOS =  materialMasterPlanSubMapper.queryMasterPlanSubNum(param);
                    Map<Long, Double> masterPlanMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(),k ->k.getNum()));
                    Double masterPlanNum = masterPlanMap.get(materialId);
                    /** 获取该项目下物资总计划数量 **/
                    d.setOrderNum(ComputeUtil.nullToZero(thisAddApplyed));
                    d.setSumApplyNum(ComputeUtil.nullToZero(applyed));
                    d.setPlanNum(ComputeUtil.nullToZero(zsPlanNum));
                    d.setTotalNum(ComputeUtil.nullToZero(budgetNum));
                    d.setMasterPlanNum(masterPlanNum !=null ? new BigDecimal(masterPlanNum) : BigDecimal.ZERO.setScale(8));
                    d.setIsFinish(0);
                }
            }
        }
        return CommonResponse.success("查询物资累计量,进度量,总量成功!", vo);
    }

    @Override
    public CommonResponse<UseApplyVO> getSumNumCommon(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();

        RecalculateVO cal = RecalculateVO.intsance(vo.getProjectId(), null);
        cal.setMonthEndDate(DateUtil.format(vo.getApplyDate(), DateUtil.DATE));
        CommonResponse<RecalculateVO> planNum = budgetPlanApi.getPlanNum(cal);
        Map<Long, BigDecimal> planNumMap = null;
        Map<Long, BigDecimal> budgetNumMap = null;
        if (planNum.isSuccess()) {
            RecalculateVO recalculateVO = planNum.getData();
            planNumMap = recalculateVO.getPlanNumMap();
            budgetNumMap = recalculateVO.getBudgetNumMap();
            if (MapUtils.isEmpty(planNumMap)) {
                logger.info("用料申请查询计划物料计划工程量*耗量返回信息为空!");
            }
        } else {
            logger.info(planNum.getMsg());
        }

        CommonResponse<BillParamVO> countParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
        BillParamVO billParamVO = countParamByCode.getData();
        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
            //当前单子累计物资量
            Map<Long, BigDecimal> numMap = new HashMap<>();
            listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));

            List<Long> materialIds = new ArrayList<>(listMap.keySet());
            Map<String, Object> queryParam = new HashMap<>();
            queryParam.put("projectId", vo.getProjectId());
            queryParam.put("pId", vo.getId());
            queryParam.put("materialIds", materialIds);
            List<UseApplySubVO> useApplySubVOS = baseMapper.countApplyNumCommon(queryParam);
            if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
                Map<Long, BigDecimal> level3Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal ratio = roleValue.divide(BigDecimal.valueOf(100));
                Map<Long, List<UseApplySubVO>> level4Map = useApplySubEntities.stream().collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
                Map<Long, BigDecimal> sumAppluNumMap = new HashMap<>();
                level4Map.forEach((k, v) -> sumAppluNumMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));



                for(UseApplySubVO d : useApplySubEntities){
                    Long materialId = d.getMaterialId();
                    BigDecimal budgetNum = MapUtils.isEmpty(budgetNumMap) ? BigDecimal.ZERO : budgetNumMap.get(materialId);
                    BigDecimal _planNum = MapUtils.isEmpty(planNumMap) ? BigDecimal.ZERO : planNumMap.get(materialId);
                    BigDecimal applyed = level3Map.get(materialId);
                    BigDecimal thisAddApplyed = ComputeUtil.safeAdd(applyed, d.getApplyNum());
                    BigDecimal zsPlanNum = ComputeUtil.safeMultiply(ratio, _planNum);
                    /** 获取该项目下物资退货数量 **/
                    Map<String, Object> param = new HashMap<>();
                    param.put("projectId", vo.getProjectId());
                    param.put("materialId", d.getMaterialId());
                    List <OutStoreSubVO> outStoreSubVOS = outStoreSubService.queryReturnGoodsMaterialNum(param);
                    Map<Long, BigDecimal> outStoreMap = outStoreSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(),k ->k.getOutStoreNumber()));
                    BigDecimal returnGoodsNum = outStoreMap.get(materialId);
                    applyed = BigDecimalUtils.safeSub(applyed,returnGoodsNum);
                    if(applyed.compareTo(BigDecimal.ZERO)<0){
                        applyed = new BigDecimal(0);
                    }
                    /** 获取该项目下物资退货数量 **/
//                    thisAddApplyed = ComputeUtil.safeAdd(applyed, d.getApplyNum());
                    thisAddApplyed = ComputeUtil.safeAdd(applyed,sumAppluNumMap.get(materialId));
                    if(thisAddApplyed.compareTo(BigDecimal.ZERO)<0){
                        thisAddApplyed = new BigDecimal(0);
                    }
                    /** 获取该项目下物资总计划数量 **/
                    List<MaterialMasterPlanSubVO> masterPlanSubVOS =  materialMasterPlanSubMapper.queryMasterPlanSubNum(param);
                    Map<Long, Double> masterPlanMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(),k ->k.getNum()));
                    Double masterPlanNum = masterPlanMap.get(materialId);
                    /** 获取该项目下物资总计划数量 **/
                    d.setOrderNum(ComputeUtil.nullToZero(thisAddApplyed));
                    d.setSumApplyNum(ComputeUtil.nullToZero(applyed));
                    d.setPlanNum(ComputeUtil.nullToZero(zsPlanNum));
                    d.setTotalNum(ComputeUtil.nullToZero(budgetNum));
                    d.setMasterPlanNum(masterPlanNum !=null ? new BigDecimal(masterPlanNum) : BigDecimal.ZERO.setScale(8));
                    d.setIsFinish(0);
                }
            }
        }
        return CommonResponse.success("查询物资累计量,进度量,总量成功!", vo);
    }

    /**
     * @param queryParam
     * @description: 查询项目用料, 物资已完成状态, 施工计划 使用
     * 世纪阳光专业分包模式使用
     * @return: java.util.List<com.ejianc.business.material.vo.UseApplySubVO>
     * @author songlx
     * @date: 2021/9/28
     */
    @Override
    public List<UseApplyFinishVO> materialFinishCount(Map<String, Object> queryParam) {
        return baseMapper.materialFinishCount(queryParam);
    }

    /**
     *
     * @param projectId
     * @param materialIds
     * @return
     */
    @Override
    public List<MaterialApplyCountVO> queryMaterialApplyCount(Long projectId, List<Long> materialIds) {
        return baseMapper.queryMaterialApplyCount(projectId,materialIds);
    }

    @Override
    public SupplierVO querySupplierByName(String supplierName) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        return baseMapper.querySupplierByName(supplierName,tenantid);
    }
}