/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialApplyCountVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="instoreMaterialService")
public class InstoreMaterialService
extends BaseServiceImpl<InstoreMaterialMapper, InstoreMaterialEntity>
implements IInstoreMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-D80E4406";
    private static String PARAM_APPLY_COUNT = "P-Zm16p834";
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private IUseApplyService useApplyService;

    @Override
    public List<InstoreMaterialVO> querylist(QueryWrapper<InstoreMaterialEntity> queryWrapper) {
        List list = this.list((Wrapper)queryWrapper);
        return BeanMapper.mapList((Iterable)list, InstoreMaterialVO.class);
    }

    @Override
    public BigDecimal countAmount(QueryParam param) {
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        queryWrapper.eq((Object)"dr", (Object)0);
        return this.instoreMaterialMapper.countAmount((QueryWrapper<InstoreEntity>)queryWrapper);
    }

    @Override
    public IPage<InstoreMaterialVO> queryStoreCanUseNumPageData(String searchText, String searchObject, String outDate, Long storeId, Integer pageNum, Integer pageSize) {
        Page page = new Page();
        page.setCurrent((long)pageNum.intValue());
        page.setPages((long)pageSize.intValue());
        page.setSize((long)pageSize.intValue());
        String materialTypeName = "";
        String materialName = "";
        String materialSpec = "";
        String materialUnit = "";
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            if (search.get((Object)"materialCategoryName") != null) {
                materialTypeName = search.get((Object)"materialCategoryName").toString();
            }
            if (search.get((Object)"materialName") != null) {
                materialName = search.get((Object)"materialName").toString();
            }
            if (search.get((Object)"materialSpec") != null) {
                materialSpec = search.get((Object)"materialSpec").toString();
            }
            if (search.get((Object)"materialUnit") != null) {
                materialUnit = search.get((Object)"materialUnit").toString();
            }
        }
        Long count = this.instoreMaterialMapper.queryStoreCanUseNumPageDataCount(searchText, outDate, storeId, materialTypeName, materialName, materialSpec, materialUnit);
        page.setTotal(count.longValue());
        List<InstoreMaterialVO> records = this.instoreMaterialMapper.queryStoreCanUseNumPageData(searchText, outDate, storeId, (pageNum - 1) * pageSize, pageSize, materialTypeName, materialName, materialSpec, materialUnit);
        page.setRecords(records);
        return page;
    }

    @Override
    public IPage<InstoreMaterialVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize) {
        Page page = new Page();
        Long count = this.instoreMaterialMapper.countStorematerialList(storeId, searchText);
        if (count > 0L) {
            Integer startLine = null;
            if (pageNumber != null) {
                startLine = ((pageNumber > 0 ? pageNumber : 1) - 1) * pageSize;
                page.setCurrent((long)pageNumber.intValue());
                page.setSize((long)pageSize.intValue());
            }
            List<InstoreMaterialVO> list = this.instoreMaterialMapper.storematerialList(storeId, searchText, startLine, pageSize);
            page.setRecords(list);
        }
        page.setTotal(count.longValue());
        return page;
    }

    @Override
    public InstoreMaterialVO censusStorematerial(Long storeIid) {
        return this.instoreMaterialMapper.censusStorematerial(storeIid);
    }

    @Override
    public IPage<InstoreMaterialVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds, HashMap<String, String> map) {
        Page page = new Page();
        page.setCurrent((long)pageNumber.intValue());
        page.setPages((long)pageSize.intValue());
        page.setSize((long)pageSize.intValue());
        Long count = this.instoreMaterialMapper.queryUsableSubMaterialCount(searchText, outDate, storeId, materialIds, map);
        page.setTotal(count.longValue());
        List<InstoreMaterialVO> records = this.instoreMaterialMapper.queryUsableSubMaterialPageList(searchText, outDate, storeId, (pageNumber - 1) * pageSize, pageSize, materialIds, map);
        page.setRecords(records);
        return page;
    }

    @Override
    public List<InstoreMaterialVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory) {
        return this.instoreMaterialMapper.querySubMaterialStoreInfo(storeId, checkDate, materialId, inventory);
    }

    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        List detailList = vo.getDetail();
        HashMap numMap = new HashMap();
        detailList.forEach(detail -> {
            MaterialPriceVO materialPriceVO = (MaterialPriceVO)numMap.get(detail.getMaterialId());
            if (materialPriceVO != null) {
                materialPriceVO.setNum(ComputeUtil.safeAdd((BigDecimal)materialPriceVO.getNum(), (BigDecimal)detail.getNum()));
            } else {
                numMap.put(detail.getMaterialId(), detail);
            }
        });
        vo.setDetail(new ArrayList(numMap.values()));
        Integer controlType = 0;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List detail2 = vo.getDetail();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isEmpty((Collection)detail2)) {
            return paramsCheckVO;
        }
        CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)countParamByCode.getData();
            if (0 != billParamVO.getControlType()) {
                List<Long> materialIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                List<MaterialPriceVO> vos = this.instoreMaterialMapper.queryMaterialInstoreCount(vo.getId(), vo.getProjectId(), materialIds);
                List<MaterialPriceVO> materialPriceVOS = this.materialContractMapper.queryPlanPriceByProjectId(vo.getProjectId(), materialIds);
                if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                    Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                    for (MaterialPriceVO v : detail2) {
                        Long materialId = v.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (null == p) continue;
                        v.setPlanNum(p.getPlanNum());
                        v.setPlanPrice(p.getPlanPrice());
                    }
                }
                Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                for (MaterialPriceVO d : detail2) {
                    BigDecimal _planNum;
                    BigDecimal num = d.getNum();
                    BigDecimal planNum = d.getPlanNum();
                    BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                    BigDecimal allNum = hasNum.add(num);
                    if (allNum.compareTo(_planNum = planNum.multiply(divide)) <= 0) continue;
                    controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                    paramsCheckDsVO.setWarnName("\u6750\u6599\u5165\u5e93\u6570\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u6570\u91cf");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5165\u5e93\u6570\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u5df2\u5165\u5e93\u6570\u91cf\uff1a").append(hasNum.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue).append("%: ").append(_planNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(allNum.subtract(_planNum).setScale(2, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                }
            }
        } else {
            this.logger.info(countParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        CommonResponse applyParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_APPLY_COUNT);
        if (applyParamByCode.isSuccess() && null != applyParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)applyParamByCode.getData();
            if (0 != billParamVO.getControlType()) {
                List<Long> materialIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                List<MaterialPriceVO> vos = this.instoreMaterialMapper.queryMaterialInstoreCount(vo.getId(), vo.getProjectId(), materialIds);
                List<MaterialApplyCountVO> applyCountVOS = this.useApplyService.queryMaterialApplyCount(vo.getProjectId(), materialIds);
                Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                Map<Long, BigDecimal> applyVOMap = applyCountVOS.stream().collect(Collectors.toMap(MaterialApplyCountVO::getMaterialId, MaterialApplyCountVO::getApplyNum));
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                for (MaterialPriceVO d : detail2) {
                    BigDecimal _applyNum;
                    BigDecimal num = d.getNum();
                    BigDecimal applyNum = applyVOMap.get(d.getMaterialId()) != null ? applyVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                    BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                    BigDecimal allNum = ComputeUtil.safeAdd((BigDecimal)hasNum, (BigDecimal)num);
                    if (allNum.compareTo(_applyNum = applyNum.multiply(divide)) <= 0) continue;
                    controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                    paramsCheckDsVO.setWarnName("\u9879\u76ee\u5165\u5e93\u6570\u91cf\u8d85\u9879\u76ee\u7528\u6599\u7533\u8bf7\u91cf");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5165\u5e93\u6570\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5165\u5e93\u6570\u91cf\uff1a").append(allNum.setScale(2, 4)).append("\uff0c\u7528\u6599\u7533\u8bf7\u6570\u91cf*").append(roleValue).append("%: ").append(_applyNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)allNum, (BigDecimal)_applyNum).setScale(2, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                }
            }
        } else {
            this.logger.info(countParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setWarnType(paramsArray[controlType]);
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }
}

