package com.ejianc.business.material.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.material.bean.PickRegisterDetailEntity;
import com.ejianc.business.material.bean.PickRegisterEntity;
import com.ejianc.business.material.service.IPickRegisterDetailService;
import com.ejianc.business.material.service.IPickRegisterService;
import com.ejianc.business.material.vo.PickRegisterDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/pickRegister/")
public class MaterialPickRegisterApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IPickRegisterService pickRegisterService;

    @Autowired
    IPickRegisterDetailService pickRegisterDetailService;

    /**
     * 更新领料登记主子表扣款金额
     * @param vos
     * @return
     */
    @RequestMapping(value = "updateDeductMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateDeductMny(@RequestBody List<PickRegisterDetailVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)){
            Map<Long,BigDecimal> map = vos.stream().collect(Collectors.toMap(PickRegisterDetailVO::getId, PickRegisterDetailVO::getDeductMny,(key1, key2) ->key2));
            LambdaQueryWrapper<PickRegisterDetailEntity> detailEntity = new LambdaQueryWrapper<>();
            detailEntity.in(PickRegisterDetailEntity::getId,map.keySet());
            List<PickRegisterDetailEntity> list = pickRegisterDetailService.list(detailEntity);
            //定义主表汇总金额
            BigDecimal totalDeductMny = BigDecimal.ZERO;
            //更新子表金额
            for (PickRegisterDetailEntity entity : list) {
                BigDecimal deductMny = ComputeUtil.safeAdd(entity.getDeductMny(), map.get(entity.getId()));
                totalDeductMny = ComputeUtil.safeAdd(totalDeductMny, deductMny);
                LambdaUpdateWrapper<PickRegisterDetailEntity> detailWrapper = new LambdaUpdateWrapper<>();
                detailWrapper.set(PickRegisterDetailEntity::getDeductMny,deductMny);
                detailWrapper.eq(PickRegisterDetailEntity::getId,entity.getId());
                pickRegisterDetailService.update(detailWrapper);
            }
            //修改对应主表金额
            LambdaUpdateWrapper<PickRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(PickRegisterEntity::getTotalDeductMny,totalDeductMny);
            wrapper.eq(PickRegisterEntity::getId,vos.get(0).getRegisterId());
            pickRegisterService.update(wrapper);
        }
        return CommonResponse.success("更新数据成功！");
    }


}
