package com.ejianc.business.plan.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.service.ISectionPlanService;
import com.ejianc.business.plan.vo.PlanChangeSubVO;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.business.plan.vo.SectionPlanChangeSubVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.plan.service.ISectionPlanChangeService;
import com.ejianc.business.plan.vo.SectionPlanChangeVO;

/**
 * 标段计划变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sectionPlanChange")
public class SectionPlanChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ArchivesUtil archivesUtil;

    @Autowired
    private ISectionPlanChangeService service;

    @Autowired
    private ISectionPlanService planService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SectionPlanChangeVO> saveOrUpdate(@RequestBody SectionPlanChangeVO planVo) {
        //校验项目是否存在未完成的变更计划单存在
        QueryWrapper<SectionPlanChangeEntity> query = new QueryWrapper<>();
        query.eq("source_plan_id", planVo.getSourcePlanId());
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.ne(planVo.getId() != null, "id", planVo.getId());
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        billStates.add(BillStateEnum.SUSPEND.getBillStateCode());
        query.in("bill_state", billStates);
        int count = service.count(query);
        if(count > 0) {
            return CommonResponse.error("保存失败，该项目存在未完成的变更计划！");
        }

        SectionPlanEntity masterPlan = planService.getById(planVo.getSourcePlanId());
        UserContext userContext = sessionManager.getUserContext();
        SectionPlanChangeEntity saveEntity = null;
        if(null == planVo.getId()) {

            saveEntity = BeanMapper.map(planVo, SectionPlanChangeEntity.class);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            //设置变更人
            saveEntity.setChangeUserName(userContext.getUserName());

            saveEntity.setPlanCode(masterPlan.getPlanCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());

        } else {
            saveEntity = service.getById(planVo.getId());
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
            saveEntity.setPlanCode(planVo.getPlanCode());
            saveEntity.setTotalPlanAmt(planVo.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMaterialSubList(BeanMapper.mapList(planVo.getMaterialSubList(), SectionPlanChangeSubEntity.class));
        }
        saveEntity.setChangeReason(planVo.getChangeReason());
        if(null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        List<SectionPlanChangeSubVO> materialSubList = planVo.getMaterialSubList();
        if (CollectionUtils.isNotEmpty(materialSubList)){
            for (SectionPlanChangeSubVO planChangeSubVO : materialSubList) {
                String onlykey= planChangeSubVO.getMaterialCategoryName()+planChangeSubVO.getMaterialName()+planChangeSubVO.getUnit()+planChangeSubVO.getSpec()+planChangeSubVO.getMaterialCode();
                planChangeSubVO.setOnlyKey(onlykey);
            }
            JSONObject jsonObject = archivesUtil.batchSaveArchive(materialSubList, "materialCategoryId", "materialId",
                    "materialCategoryName", "materialName", "materialCode","unit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString(jsonObject.get("sourceList"), SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat);
            List<SectionPlanChangeSubVO> list = JSONObject.parseArray(sourceList, SectionPlanChangeSubVO.class);
            List<SectionPlanChangeSubEntity> materialMasterPlanSubEntities = BeanMapper.mapList(list, SectionPlanChangeSubEntity.class);
            saveEntity.setMaterialSubList(materialMasterPlanSubEntities);
        }

        saveEntity = service.saveOrUpdatePlanChange(saveEntity);

        return CommonResponse.success("保存成功！", BeanMapper.map(saveEntity, SectionPlanChangeVO.class));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SectionPlanChangeVO> queryDetail(Long id) {
    	SectionPlanChangeEntity entity = service.selectById(id);
    	SectionPlanChangeVO vo = BeanMapper.map(entity, SectionPlanChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SectionPlanChangeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SectionPlanChangeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SectionPlanChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

}
