package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.bean.SectionPlanEntity;
import com.ejianc.business.plan.bean.SectionPlanSubEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.mapper.SectionPlanMapper;
import com.ejianc.business.plan.mapper.SectionPlanSubMapper;
import com.ejianc.business.plan.service.ISectionPlanService;
import com.ejianc.business.plan.vo.SectionPlanSubVO;
import com.ejianc.business.plan.vo.SectionPlanVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标段计划
 *
 * @author generator
 *
 */
@Service("sectionPlanService")
public class SectionPlanServiceImpl extends BaseServiceImpl<SectionPlanMapper, SectionPlanEntity> implements ISectionPlanService {

    @Autowired
    private SectionPlanSubMapper sectionPlanSubMapper;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;

    private static String PARAM_SECTION_PLAN_NUM = "P-6C8EFs85";
    private static String PARAM_SECTION_PLAN_PRICE = "P-6h53s184";

    @Override
    public ParamsCheckVO checkParams(SectionPlanVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<SectionPlanSubVO> materialSubList = vo.getMaterialSubList();
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());

        if (CollectionUtils.isNotEmpty(materialSubList) && (int) materialSubList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            materialSubList = materialSubList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());

            // 根据项目取得总计划数据
            Long projectId = vo.getProjectId();
            QueryWrapper<MaterialMasterPlanEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("project_id", projectId);
            wrapper.eq("dr", 0);
            List<MaterialMasterPlanEntity> materialMasterPlanEntities = materialMasterPlanMapper.selectList(wrapper);

            QueryWrapper<MaterialMasterPlanSubEntity> planSubWrapper = new QueryWrapper<>();
            List<Long> ids = new ArrayList<>();
            materialMasterPlanEntities.forEach(item -> {
                ids.add(item.getId());
            });
            // list添加一个数据，防止数据为空时，in查询sql拼接错误。
            ids.add(000001L);
            planSubWrapper.in("material_master_plan_id", ids);
            planSubWrapper.eq("dr", 0);
            List<MaterialMasterPlanSubEntity> materialMasterPlanSubEntities = materialMasterPlanSubMapper.selectList(planSubWrapper);

            // 【物资总计划量】控【批次计划量】
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_SECTION_PLAN_NUM, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("【物资总计划量】控【标段计划量】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            List<BillParamVO> billParamVOS = response.getData();

            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    BigDecimal manageRate = billParamVO.getRoleValue();
                    Map<Long, BigDecimal> planMap = new HashMap<>();
                    materialMasterPlanSubEntities.forEach(item -> {
                        Double num = item.getNum();
                        //物资计划物资id是重复的所以需要按照物资id合计
                        if (planMap.containsKey(item.getMaterialId())) {
                            planMap.put(item.getMaterialId(), ComputeUtil.safeAdd(planMap.get(item.getMaterialId()), BigDecimal.valueOf(num)));
                        } else {
                            planMap.put(item.getMaterialId(), BigDecimal.valueOf(num));
                        }
                    });

                    // 根据项目id取得批次计划数据。
                    QueryWrapper<SectionPlanSubEntity> appWrapper = new QueryWrapper<>();
                    appWrapper.eq("project_id", projectId);
                    List<SectionPlanSubEntity> batchPlanEntities = sectionPlanSubMapper.selectList(appWrapper);
                    ids.clear();
                    batchPlanEntities.forEach(item -> {
                        ids.add(item.getId());
                    });
                    // 查询旧数据时，剔除掉本次申请的物资
                    List<Long> noIds = new ArrayList<>();
                    materialSubList.forEach(item -> {
                        if (item.getId() != null) {
                            noIds.add(item.getId());
                        }
                    });
                    // list添加一个数据，防止数据为空时，in查询sql拼接错误。
                    ids.add(000001L);
                    QueryWrapper<SectionPlanSubEntity> appSubWrapper = new QueryWrapper<>();
                    appSubWrapper.in("plan_id", ids);
                    appSubWrapper.notIn("id", noIds);
                    List<SectionPlanSubEntity> batchPlanSubEntities1 = sectionPlanSubMapper.selectList(appSubWrapper);
                    List<SectionPlanSubEntity> batchPlanSubEntities2 = BeanMapper.mapList(materialSubList, SectionPlanSubEntity.class);
                    Map<Long, SectionPlanSubEntity> thisMap = new HashMap<>();
                    batchPlanSubEntities2.forEach(item -> {
                        if (thisMap.containsKey(item.getMaterialId())) {
                            SectionPlanSubEntity sectionPlanSubEntity = thisMap.get(item.getMaterialId());
                            sectionPlanSubEntity.setNum(sectionPlanSubEntity.getNum().add(item.getNum()));
                        } else {
                            thisMap.put(item.getMaterialId(), item);
                        }
                    });
                    Map<Long, BigDecimal> oldAppMap = new HashMap<>();
                    batchPlanSubEntities1.forEach(item -> {
                        BigDecimal applyNum = item.getNum();
                        if (oldAppMap.containsKey(item.getMaterialId())) {
                            BigDecimal bigDecimal = oldAppMap.get(item.getMaterialId());
                            oldAppMap.put(item.getMaterialId(), applyNum.add(bigDecimal));
                        } else {
                            oldAppMap.put(item.getMaterialId(), applyNum);
                        }
                    });

                    thisMap.forEach((k, item) -> {
                        Long materialId = item.getMaterialId();
                        //本次批次计划数量
                        BigDecimal batNum = item.getNum();
                        //原有的数量 如果为空取0
                        BigDecimal oldBatNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : oldAppMap.get(materialId);
                        //总计划数量 如果为空 则表示未做计划，取0
                        BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : planMap.get(materialId);

                        BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100));
                        BigDecimal batNumber = ComputeUtil.nullToZero(ComputeUtil.safeAdd(oldBatNum, batNum));

                        if (ComputeUtil.isLessThan(planNumber, batNumber)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty(item.getSpec()) ? " [" + item.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("累计标段计划量大于总计划量");
                            paramsCheckDsVO.setContent("本次计划数量:" + batNum.setScale(2, BigDecimal.ROUND_HALF_UP)
                                    + ",含本次累计计划数量:" + batNumber.setScale(2, BigDecimal.ROUND_HALF_UP)
                                    + ",总计划数量*" + manageRate + "%:" + planNumber.setScale(2, BigDecimal.ROUND_HALF_UP)
                                    + ",超出数量:" + ComputeUtil.safeSub(batNumber, planNumber).setScale(2, BigDecimal.ROUND_HALF_UP)
                            );
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    });
                }
            }

            // 【物资总计划单价】控制【标段计划单价】
            CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_SECTION_PLAN_PRICE, curOrgId);
            if (!response1.isSuccess()) {
                throw new BusinessException("【物资总计划单价】控制【标段计划单价】，获取控制参数失败，失败原因：" + response1.getMsg());
            }
            List<BillParamVO> billParamVOS1 = response1.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS1)) {

                Map<Long, BigDecimal> planMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(materialMasterPlanEntities)) {
                    materialMasterPlanSubEntities.forEach(item -> {
                        BigDecimal price = item.getPrice();
                        Long materialId = item.getMaterialId();
                        //根据物资id取出总计划物资单价，若物资id相同则取单价最小值
                        if (!planMap.containsKey(materialId) || ComputeUtil.isLessThan(price, planMap.get(item.getMaterialId()))) {
                            planMap.put(materialId, price);
                        }
                    });
                }
                for (BillParamVO billParamVO : billParamVOS1) {
                    if (0 != billParamVO.getControlType()) {
                        // 比例
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        materialSubList.forEach((item) -> {
                            Long materialId = item.getMaterialId();
                            //本次材料申请单价
                            BigDecimal estimatePrice = item.getPrice();
                            //总计划单价 如果为空 则表示未做计划，取0
                            BigDecimal price = ComputeUtil.nullToZero(planMap.get(materialId));
                            //预警价
                            BigDecimal _planPrice = price.multiply(divide);
                            if (ComputeUtil.isGreaterThan(estimatePrice, _planPrice)) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty(item.getSpec()) ? " [" + item.getSpec() + "]" : ""));
                                paramsCheckDsVO.setWarnName("标段计划单价大于总计划单价");
                                paramsCheckDsVO.setContent("本次标段计划单价：" + estimatePrice.setScale(2, BigDecimal.ROUND_HALF_UP)
                                        + ",总计划单价*" + roleValue + "%:" + _planPrice.setScale(2, BigDecimal.ROUND_HALF_UP)
                                        + ",超出单价" + estimatePrice.subtract(_planPrice).setScale(2, BigDecimal.ROUND_HALF_UP)
                                );
                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        });
                    }
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}
