/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.bean.SectionPlanEntity;
import com.ejianc.business.plan.bean.SectionPlanSubEntity;
import com.ejianc.business.plan.service.ISectionPlanChangeHisService;
import com.ejianc.business.plan.service.ISectionPlanService;
import com.ejianc.business.plan.service.ISectionPlanSubService;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.SectionPlanChangeHisVO;
import com.ejianc.business.plan.vo.SectionPlanSubVO;
import com.ejianc.business.plan.vo.SectionPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sectionPlan"})
public class SectionPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISectionPlanChangeHisService planChangeHisService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SECTION_PLAN_CODE";
    @Autowired
    private ISectionPlanService service;
    @Autowired
    private ISectionPlanSubService planSubService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ArchivesUtil archivesUtil;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SectionPlanVO> saveOrUpdate(@RequestBody SectionPlanVO sectionPlanVO) {
        List materialSubList;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SectionPlanEntity::getProjectId, (Object)sectionPlanVO.getProjectId());
        queryWrapper.eq(SectionPlanEntity::getSectionId, (Object)sectionPlanVO.getSectionId());
        queryWrapper.ne(sectionPlanVO.getId() != null, BaseEntity::getId, (Object)sectionPlanVO.getId());
        int c = this.service.count((Wrapper)queryWrapper);
        if (c > 0) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5728\u8be5\u6807\u6bb5\u5df2\u5b58\u5728\u8ba1\u5212\uff01");
        }
        String planCode = sectionPlanVO.getPlanCode();
        if (StringUtils.isNotBlank((CharSequence)planCode)) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"plan_code", (Object)planCode);
            query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            query.ne(sectionPlanVO.getId() != null, (Object)"id", (Object)sectionPlanVO.getId());
            int count = this.service.count((Wrapper)query);
            if (count > 0) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else {
            CommonResponse codeResp = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
            }
            sectionPlanVO.setPlanCode((String)codeResp.getData());
        }
        UserContext userContext = this.sessionManager.getUserContext();
        SectionPlanEntity saveEntity = null;
        if (null == sectionPlanVO.getId()) {
            saveEntity = (SectionPlanEntity)((Object)BeanMapper.map((Object)sectionPlanVO, SectionPlanEntity.class));
            saveEntity.setChangeState(0);
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(1);
        } else {
            saveEntity = (SectionPlanEntity)((Object)this.service.getById(sectionPlanVO.getId()));
            saveEntity.setProjectId(sectionPlanVO.getProjectId());
            saveEntity.setProjectName(sectionPlanVO.getProjectName());
            saveEntity.setOrgId(sectionPlanVO.getOrgId());
            saveEntity.setOrgName(sectionPlanVO.getOrgName());
            saveEntity.setRemark(sectionPlanVO.getRemark());
            saveEntity.setPlanCode(sectionPlanVO.getPlanCode());
            saveEntity.setTotalPlanAmt(sectionPlanVO.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMaterialSubList(BeanMapper.mapList((Iterable)sectionPlanVO.getMaterialSubList(), SectionPlanSubEntity.class));
        }
        if (null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if (CollectionUtils.isNotEmpty((Collection)(materialSubList = sectionPlanVO.getMaterialSubList()))) {
            for (SectionPlanSubVO materialMasterPlanSubVO : materialSubList) {
                String onlykey = materialMasterPlanSubVO.getMaterialCategoryName() + materialMasterPlanSubVO.getMaterialName() + materialMasterPlanSubVO.getUnit() + materialMasterPlanSubVO.getSpec() + materialMasterPlanSubVO.getMaterialCode();
                materialMasterPlanSubVO.setOnlyKey(onlykey);
            }
            JSONObject jsonObject = this.archivesUtil.batchSaveArchive(materialSubList, "materialCategoryId", "materialId", "materialCategoryName", "materialName", "materialCode", "unit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString((Object)jsonObject.get((Object)"sourceList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
            List list = JSONObject.parseArray((String)sourceList, SectionPlanSubVO.class);
            List materialMasterPlanSubEntities = BeanMapper.mapList((Iterable)list, SectionPlanSubEntity.class);
            saveEntity.setMaterialSubList(materialMasterPlanSubEntities);
        }
        this.service.saveOrUpdateNoES((Object)saveEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)saveEntity), SectionPlanVO.class));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SectionPlanVO> queryDetail(Long id) {
        SectionPlanVO vo = null;
        SectionPlanEntity entity = (SectionPlanEntity)((Object)this.service.selectById(id));
        if (null != entity && MaterialMasterPlanVO.PLAN_CHANGE_STATE_CHANGED == (vo = (SectionPlanVO)BeanMapper.map((Object)((Object)entity), SectionPlanVO.class)).getChangeState()) {
            List<SectionPlanChangeHisVO> changeHisList = this.loadChangeHisList(vo.getId());
            vo.setPlanChangeHisList(changeHisList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", vo);
    }

    private List<SectionPlanChangeHisVO> loadChangeHisList(Long planId) {
        List<Object> resp = new ArrayList<SectionPlanChangeHisVO>();
        QueryWrapper hisQuery = new QueryWrapper();
        hisQuery.eq((Object)"source_plan_id", (Object)planId);
        hisQuery.orderByDesc((Object)"create_time");
        List list = this.planChangeHisService.list((Wrapper)hisQuery);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = BeanMapper.mapList((Iterable)list, SectionPlanChangeHisVO.class);
        }
        return resp;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SectionPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SectionPlanVO sectionPlanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SectionPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("sectionName");
        fuzzyFields.add("planCode");
        fuzzyFields.add("createUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SectionPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("sectionName");
        fuzzyFields.add("planCode");
        fuzzyFields.add("createUserName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("SectionPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSectionPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SectionPlanVO>> refSectionPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SectionPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody SectionPlanVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"/referTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam String condition) {
        if (StringUtils.isEmpty((CharSequence)condition) || !condition.contains("projectId")) {
            throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e\uff01\u8bf7\u4f20\u5165projectId");
        }
        JSONObject conditionJson = JSONObject.parseObject((String)condition);
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.setOrderMap(orderMap);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List dataList = this.service.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (SectionPlanEntity entity : dataList) {
            map = new HashMap();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getPlanCode() + "\u6807\u6bb5\u8ba1\u5212-" + entity.getSectionName());
            map.put("code", entity.getPlanCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if (CollectionUtils.isNotEmpty(resultMapList)) {
            map = new HashMap<String, Object>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "\u5168\u90e8");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/refSubData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SectionPlanSubVO>> refdata(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String relyCondition, @RequestParam(required=false) String condition, String relyNode, String searchText, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        Map param = queryParam.getParams();
        Boolean queryAllFlag = Boolean.FALSE;
        if (!StringUtils.isEmpty((CharSequence)relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if (!"000001".equals(pid)) {
                param.put("materialMasterPlanId", new Parameter("eq", (Object)pid));
            } else {
                queryAllFlag = true;
            }
        } else {
            queryAllFlag = true;
        }
        if (queryAllFlag.booleanValue()) {
            if (StringUtils.isEmpty((CharSequence)condition) || !condition.contains("projectId")) {
                throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e\uff01\u8bf7\u4f20\u5165projectId");
            }
            JSONObject conditionJson = JSONObject.parseObject((String)condition);
            Long projectId = conditionJson.getLong("projectId");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SectionPlanEntity::getProjectId, (Object)projectId);
            queryWrapper.in(SectionPlanEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            List list = this.service.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
                param.put("materialMasterPlanId", new Parameter("in", ids));
            } else {
                param.put("materialMasterPlanId", new Parameter("eq", (Object)1L));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        IPage page = this.planSubService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SectionPlanSubVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", (Object)pageData);
    }
}

