/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialContract")
public class ContractApproveCallbackServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialContractEntity e = (MaterialContractEntity)((Object)this.materialContractService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.materialContractService.saveOrUpdate((Object)e);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialContractEntity e = (MaterialContractEntity)((Object)this.materialContractService.selectById(billId));
        e.setEffectiveDate(new Date());
        this.materialContractService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialContractEntity e = (MaterialContractEntity)((Object)this.materialContractService.selectById(billId));
        if (!e.getDependOnProject().equals("1")) {
            CommonResponse contractOrg = this.orgApi.getOneById(e.getOrgId());
            if (!contractOrg.isSuccess()) {
                this.logger.error("\u5f03\u5ba1\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u3010{}\u3011\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: \u3010{}\u3011", (Object)billId, (Object)contractOrg.getMsg());
                return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            CommonResponse curOrg = this.orgApi.getOneById(InvocationInfoProxy.getOrgId());
            if (!curOrg.isSuccess()) {
                this.logger.error("\u5f03\u5ba1\u5931\u8d25\uff0c\u83b7\u53d6\u83b7\u53d6\u5f53\u524d\u7528\u6237\u3010{}\u3011\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: \u3010{}\u3011", (Object)InvocationInfoProxy.getOrgId(), (Object)curOrg.getMsg());
                return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7528\u6237\u767b\u5f55\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!((OrgVO)contractOrg.getData()).getInnerCode().contains(((OrgVO)curOrg.getData()).getInnerCode())) {
                return CommonResponse.error((String)("\u5f53\u524d\u96c6\u91c7\u5408\u540c\u7f16\u5236\u7ec4\u7ec7\u662f\u3010" + e.getOrgName() + "\u3011, \u4e0d\u53ef\u5f03\u5ba1\uff01"));
            }
        }
        this.logger.info("\u7269\u8d44\u5408\u540c\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u5f03\u5ba1\u524d\u6821\u9a8c\uff01", (Object)billId, (Object)billTypeCode);
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u7269\u8d44\u5408\u540c\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6821\u9a8c\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\u7ed3\u679c\uff1a{}", new Object[]{billId, billTypeCode, JSONObject.toJSONString((Object)resp)});
        if (!resp.isSuccess()) {
            this.logger.info("\u7269\u8d44\u5408\u540c\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u5f03\u5ba1\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", (Object)resp.getMsg());
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }
}

