/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.ProjectFinanceVO;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.mapper.UseApplySubMapper;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.service.impl.InstoreMaterialService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialApplyCountVO;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.material.vo.UseApplyVO;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.vo.MaterialMasterPlanSubVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UseApplyService
extends BaseServiceImpl<UseApplyMapper, UseApplyEntity>
implements IUseApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    public IOutStoreSubService outStoreSubService;
    @Autowired
    public IPayContractApi payContractApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    @Autowired
    private UseApplyMapper useApplyMapper;
    @Autowired
    private UseApplySubMapper useApplySubMapper;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private InstoreMaterialService instoreMaterialService;
    private static String PARAM_PLAN_ALL_COUNT = "P-F8k54925";
    private static String PARAM_PLAN_PRICE = "P-649dG759";
    private static String PARAM_PROJECT_MNY = "P-w112KG65";
    private static String PARAM_COST_MNY = "P-AQ725A75";
    private static String PARAM_BATCH_PLAN_NUM = "P-q4fR4e66";

    @Override
    public IPage<UseApplyVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), UseApplyVO.class));
        }
        return voPage;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkAllParams(UseApplyVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isNotEmpty(useApplySubEntities) && (int)useApplySubEntities.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            CommonResponse response4;
            CommonResponse response3;
            CommonResponse response2;
            CommonResponse response1;
            useApplySubEntities = useApplySubEntities.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_ALL_COUNT, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("\u3010\u603b\u8ba1\u5212\u3011\u63a7\u5236\u3010\u9879\u76ee\u7528\u6599\u7533\u8bf7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            List billParamVOS = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                Long projectId = vo.getProjectId();
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"project_id", (Object)projectId);
                wrapper.eq((Object)"dr", (Object)0);
                List materialMasterPlanEntities = this.materialMasterPlanMapper.selectList((Wrapper)wrapper);
                QueryWrapper planSubWrapper = new QueryWrapper();
                ArrayList<Long> ids = new ArrayList<Long>();
                materialMasterPlanEntities.forEach(item -> ids.add(item.getId()));
                ids.add(1L);
                planSubWrapper.in((Object)"material_master_plan_id", ids);
                planSubWrapper.eq((Object)"dr", (Object)0);
                List materialMasterPlanSubEntities = this.materialMasterPlanSubMapper.selectList((Wrapper)planSubWrapper);
                HashMap planMap = new HashMap();
                materialMasterPlanSubEntities.forEach(item -> {
                    Double num = item.getNum();
                    if (planMap.get(item.getMaterialId()) != null) {
                        planMap.put(item.getMaterialId(), ComputeUtil.safeAdd((BigDecimal)BigDecimal.valueOf(num), (BigDecimal)((BigDecimal)planMap.get(item.getMaterialId()))));
                    } else {
                        planMap.put(item.getMaterialId(), BigDecimal.valueOf(num));
                    }
                });
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal manageRate = billParamVO.getRoleValue();
                    QueryWrapper appWrapper = new QueryWrapper();
                    appWrapper.eq((Object)"project_id", (Object)projectId);
                    appWrapper.eq((Object)"dr", (Object)0);
                    List useApplyEntities = this.useApplyMapper.selectList((Wrapper)appWrapper);
                    ids.clear();
                    useApplyEntities.forEach(item -> ids.add(item.getId()));
                    ArrayList noIds = new ArrayList();
                    useApplySubEntities.forEach(item -> {
                        if (item.getId() != null) {
                            noIds.add(item.getId());
                        }
                    });
                    ids.add(1L);
                    QueryWrapper appSubWrapper = new QueryWrapper();
                    appSubWrapper.in((Object)"pid", ids);
                    appSubWrapper.notIn((Object)"id", noIds);
                    appSubWrapper.eq((Object)"dr", (Object)0);
                    List useApplySubEntities1 = this.useApplySubMapper.selectList((Wrapper)appSubWrapper);
                    List useApplySubEntities2 = BeanMapper.mapList(useApplySubEntities, UseApplySubEntity.class);
                    HashMap<Long, UseApplySubEntity> thisMap = new HashMap<Long, UseApplySubEntity>();
                    useApplySubEntities2.forEach(item -> {
                        if (thisMap.containsKey(item.getMaterialId())) {
                            UseApplySubEntity useApplySubEntity = (UseApplySubEntity)((Object)((Object)thisMap.get(item.getMaterialId())));
                            useApplySubEntity.setApplyNum(ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)useApplySubEntity.getApplyNum(), (BigDecimal)item.getApplyNum())));
                        } else {
                            thisMap.put(item.getMaterialId(), (UseApplySubEntity)((Object)item));
                        }
                    });
                    HashMap oldAppMap = new HashMap();
                    useApplySubEntities1.forEach(item -> {
                        BigDecimal applyNum = item.getApplyNum();
                        if (oldAppMap.containsKey(item.getMaterialId())) {
                            BigDecimal bigDecimal = (BigDecimal)oldAppMap.get(item.getMaterialId());
                            oldAppMap.put(item.getMaterialId(), ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)applyNum, (BigDecimal)bigDecimal)));
                        } else {
                            oldAppMap.put(item.getMaterialId(), applyNum);
                        }
                    });
                    thisMap.forEach((k, item) -> {
                        BigDecimal appNumber;
                        Long materialId = item.getMaterialId();
                        BigDecimal applyNum = item.getApplyNum();
                        BigDecimal oldApplyNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)oldAppMap.get(materialId);
                        BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)planMap.get(materialId);
                        BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100L));
                        if (planNumber.compareTo(appNumber = ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)oldApplyNum, (BigDecimal)applyNum))) == -1) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)item.getModel()) ? " [" + item.getModel() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u7533\u8bf7\u6570\u91cf\u8d85\u51fa\u603b\u8ba1\u5212*\u6bd4\u4f8b");
                            paramsCheckDsVO.setContent("\u672c\u6b21\u7533\u8bf7\u6570\u91cf:" + applyNum.setScale(2, 4) + ",\u7d2f\u8ba1\u5df2\u7533\u8bf7\u6570\u91cf" + oldApplyNum.setScale(2, 4) + ",\u603b\u8ba1\u5212\u6570\u91cf" + planNum.setScale(2, 4) + ",\u603b\u8ba1\u5212\u6570\u91cf\u6bd4\u4f8b" + manageRate.setScale(2, 4) + "%,\u8d85\u989d" + appNumber.subtract(planNumber).setScale(2, 4));
                            UseApplyService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    });
                }
            }
            if (!(response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_PRICE, curOrgId)).isSuccess()) {
                throw new BusinessException("\u3010\u7269\u8d44\u603b\u8ba1\u5212\u5355\u4ef7\u3011\u63a7\u5236\u3010\u7528\u6599\u7533\u8bf7\u5355\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response1.getMsg());
            }
            List billParamVOS1 = (List)response1.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
                Long projectId = vo.getProjectId();
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"project_id", (Object)projectId);
                List materialMasterPlanEntities = this.materialMasterPlanMapper.selectList((Wrapper)wrapper);
                HashMap planMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)materialMasterPlanEntities)) {
                    List planIds = materialMasterPlanEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    QueryWrapper planSubWrapper = new QueryWrapper();
                    planSubWrapper.in((Object)"material_master_plan_id", (Collection)planIds);
                    List materialMasterPlanSubEntities = this.materialMasterPlanSubMapper.selectList((Wrapper)planSubWrapper);
                    materialMasterPlanSubEntities.forEach(item -> {
                        BigDecimal price = item.getPrice();
                        Long materialId = item.getMaterialId();
                        if (!planMap.containsKey(materialId) || ComputeUtil.isLessThan((BigDecimal)price, (BigDecimal)((BigDecimal)planMap.get(item.getMaterialId())))) {
                            planMap.put(materialId, price);
                        }
                    });
                }
                for (BillParamVO billParamVO : billParamVOS1) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                    useApplySubEntities.forEach(item -> {
                        BigDecimal price;
                        BigDecimal _planPrice;
                        Long materialId = item.getMaterialId();
                        BigDecimal estimatePrice = item.getEstimatePrice();
                        if (ComputeUtil.isGreaterThan((BigDecimal)estimatePrice, (BigDecimal)(_planPrice = (price = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)planMap.get(materialId)))).multiply(divide)))) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)item.getModel()) ? " [" + item.getModel() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u7528\u6599\u7533\u8bf7\u5355\u4ef7\u5927\u4e8e\u603b\u8ba1\u5212\u5355\u4ef7");
                            paramsCheckDsVO.setContent("\u672c\u6b21\u7528\u6599\u7533\u8bf7\u5355\u4ef7\uff1a" + estimatePrice.setScale(2, 4) + ",\u603b\u8ba1\u5212\u5355\u4ef7*" + roleValue + "%:" + _planPrice.setScale(2, 4) + ",\u8d85\u51fa\u5355\u4ef7" + estimatePrice.subtract(_planPrice).setScale(2, 4));
                            UseApplyService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    });
                }
            }
            if (!(response2 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PROJECT_MNY, curOrgId)).isSuccess()) {
                throw new BusinessException("\u3010\u9879\u76ee\u53ef\u7528\u8d44\u91d1\u3011\u63a7\u5236\u3010\u7528\u6599\u7533\u8bf7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response2.getMsg());
            }
            List billParamVOS2 = (List)response2.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS2)) {
                Long projectId = vo.getProjectId();
                CommonResponse proFinance = this.payContractApi.getProFinance(projectId);
                if (!proFinance.isSuccess()) {
                    throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u53ef\u7528\u8d44\u91d1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + proFinance.getMsg());
                }
                ProjectFinanceVO proFinanceData = (ProjectFinanceVO)proFinance.getData();
                BigDecimal proSurplusMny = proFinanceData.getProSurplusMny();
                for (BillParamVO billParamVO : billParamVOS2) {
                    if (0 == billParamVO.getControlType() || !ComputeUtil.isLessOrEqual((BigDecimal)proSurplusMny, (BigDecimal)BigDecimal.ZERO)) continue;
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(this.sessionManager.getUserContext().getOrgName());
                    paramsCheckDsVO.setWarnItem(vo.getProjectName());
                    paramsCheckDsVO.setWarnName("\u9879\u76ee\u53ef\u7528\u8d44\u91d1<=0");
                    paramsCheckDsVO.setContent("\u8be5\u9879\u76ee\u53ef\u7528\u8d44\u91d1\uff1a" + proSurplusMny.setScale(2, 4) + "\u5143,\u4e0d\u80fd\u505a\u7528\u6599\u7533\u8bf7\uff1b");
                    UseApplyService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
            if (!(response3 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_BATCH_PLAN_NUM, curOrgId)).isSuccess()) {
                throw new BusinessException("\u3010\u6750\u6599\u6279\u6b21\u8ba1\u5212\u91cf\u3011\u63a7\u5236\u3010\u7528\u6599\u7533\u8bf7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response3.getMsg());
            }
            List billParamVOS3 = (List)response3.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS3)) {
                Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
                ArrayList<Long> materialIds = new ArrayList<Long>(listMap.keySet());
                HashMap<String, Object> queryParam = new HashMap<String, Object>();
                queryParam.put("projectId", vo.getProjectId());
                queryParam.put("pId", vo.getId());
                queryParam.put("materialIds", materialIds);
                List<UseApplySubVO> useApplySubVOS = ((UseApplyMapper)this.baseMapper).countUseApplyNum(queryParam);
                queryParam.put("partNames", 1);
                List<UseApplySubVO> useApplySubVOSForPart = ((UseApplyMapper)this.baseMapper).countUseApplyNum(queryParam);
                List<UseApplySubVO> useApplySubVOSTwo = ((UseApplyMapper)this.baseMapper).countBatchPlanNumCommon(queryParam);
                Map<Long, BigDecimal> level1Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
                Map<String, BigDecimal> applyPartMap = useApplySubVOSForPart.stream().collect(Collectors.toMap(s -> s.getMaterialId() + s.getPartName(), s -> s.getApplyNum()));
                Map<String, BigDecimal> BatchNumMap = useApplySubVOSTwo.stream().collect(Collectors.toMap(s -> s.getMaterialId() + s.getPartName(), s -> s.getBatchPlanNum()));
                for (BillParamVO billParamVO : billParamVOS3) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                    for (UseApplySubVO useApplySubVO : useApplySubEntities) {
                        Long materialId = useApplySubVO.getMaterialId();
                        String partName = useApplySubVO.getPartName();
                        BigDecimal applyNum = useApplySubVO.getApplyNum();
                        BigDecimal alreadyApplyNum = new BigDecimal(0);
                        alreadyApplyNum = useApplySubVO.getPartName() == null ? level1Map.get(materialId) : applyPartMap.get(materialId + partName);
                        BigDecimal batchPlanNum = BatchNumMap.get(materialId + partName);
                        BigDecimal warnNum = ComputeUtil.nullToZero((BigDecimal)batchPlanNum).multiply(divide);
                        BigDecimal sumNum = ComputeUtil.safeAdd((BigDecimal)applyNum, (BigDecimal)alreadyApplyNum);
                        if (!ComputeUtil.isGreaterThan((BigDecimal)sumNum, (BigDecimal)warnNum)) continue;
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(this.sessionManager.getUserContext().getOrgName());
                        paramsCheckDsVO.setWarnItem(useApplySubVO.getMaterialName() + useApplySubVO.getModel());
                        if (StringUtils.isNotEmpty((CharSequence)useApplySubVO.getPartName())) {
                            paramsCheckDsVO.setWarnName("\u3010" + useApplySubVO.getPartName() + "\u3011\u6750\u6599\u7528\u6599\u7533\u8bf7\u6570\u91cf\u5927\u4e8e\u6750\u6599\u6279\u6b21\u8ba1\u5212\u91cf");
                            paramsCheckDsVO.setContent("\u8be5\u9879\u76ee" + Optional.ofNullable("\u3010" + useApplySubVO.getPartName() + "\u3011").orElse("") + "\u672c\u6b21\u7533\u8bf7\u6570\u91cf\uff1a" + ComputeUtil.nullToZero((BigDecimal)applyNum).setScale(2, 4) + "\uff0c\u5df2\u7533\u8bf7\u6570\u91cf\uff1a" + ComputeUtil.nullToZero((BigDecimal)alreadyApplyNum).setScale(2, 4) + "\uff0c\u6279\u6b21\u8ba1\u5212\u6570\u91cf*" + roleValue + "%\uff1a" + warnNum.setScale(2, 4) + "\uff0c\u8d85\u51fa\u6570\u91cf\uff1a" + ComputeUtil.safeSub((BigDecimal)sumNum, (BigDecimal)warnNum).setScale(2, 4));
                        } else {
                            paramsCheckDsVO.setWarnName("\u6750\u6599\u7528\u6599\u7533\u8bf7\u6570\u91cf\u5927\u4e8e\u6750\u6599\u6279\u6b21\u8ba1\u5212\u91cf");
                            paramsCheckDsVO.setContent("\u8be5\u9879\u76ee\u672c\u6b21\u7533\u8bf7\u6570\u91cf\uff1a" + applyNum.setScale(2, 4) + "\uff0c\u5df2\u7533\u8bf7\u6570\u91cf\uff1a" + ComputeUtil.nullToZero((BigDecimal)alreadyApplyNum).setScale(2, 4) + "\uff0c\u6279\u6b21\u8ba1\u5212\u6570\u91cf*" + roleValue + "%\uff1a" + warnNum.setScale(2, 4) + "\uff0c\u8d85\u51fa\u6570\u91cf\uff1a" + ComputeUtil.safeSub((BigDecimal)sumNum, (BigDecimal)warnNum).setScale(2, 4));
                        }
                        UseApplyService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                    }
                }
            }
            if (!(response4 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_COST_MNY, curOrgId)).isSuccess()) {
                throw new BusinessException("\u3010\u9884\u7b97\u96f6\u661f\u6750\u6599\u91d1\u989d\u3011\u63a7\u5236\u3010\u7528\u6599\u7533\u8bf7\u96f6\u661f\u6750\u6599\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response4.getMsg());
            }
            List billParamVOS4 = (List)response4.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS4)) {
                Long projectId = vo.getProjectId();
                BudgetProjectProParamControlVO controlVO = new BudgetProjectProParamControlVO();
                controlVO.setProjectId(projectId);
                controlVO.setCostType(Integer.valueOf(2));
                CommonResponse costMnyResponse = this.budgetProjectProApi.fetchQuantityAndMny(controlVO);
                if (!costMnyResponse.isSuccess()) {
                    throw new BusinessException("\u9884\u7b97\u7f16\u5236\u6570\u636e\u5931\u8d25\u539f\u56e0\uff1a" + costMnyResponse.getMsg());
                }
                BudgetProjectProQuantityAndMnyVO costMnyVo = (BudgetProjectProQuantityAndMnyVO)costMnyResponse.getData();
                if (1 == vo.getSporadicMaterialFlag() && costMnyVo != null && costMnyVo.getSporadicMaterialMny() != null && ComputeUtil.isGreaterThan((BigDecimal)costMnyVo.getSporadicMaterialMny(), (BigDecimal)BigDecimal.ZERO)) {
                    BigDecimal sporadicMaterialMny = costMnyVo.getSporadicMaterialMny();
                    LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
                    wrapper.ne(vo.getId() != null, BaseEntity::getId, (Object)vo.getId());
                    wrapper.eq(UseApplyEntity::getProjectId, (Object)projectId);
                    wrapper.eq(UseApplyEntity::getSporadicMaterialFlag, (Object)1);
                    wrapper.eq(BaseEntity::getDr, (Object)0);
                    List useApplyEntities = this.useApplyMapper.selectList((Wrapper)wrapper);
                    BigDecimal useAppMny = useApplyEntities.stream().filter(v -> null != v.getEstimateMoney()).map(UseApplyEntity::getEstimateMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                    useAppMny = ComputeUtil.safeAdd((BigDecimal)useAppMny, (BigDecimal)vo.getEstimateMoney());
                    for (BillParamVO billParamVO : billParamVOS4) {
                        BigDecimal roleValue;
                        BigDecimal divide;
                        BigDecimal _sporadicMaterialMny;
                        if (0 == billParamVO.getControlType() || !ComputeUtil.isGreaterThan((BigDecimal)useAppMny, (BigDecimal)(_sporadicMaterialMny = sporadicMaterialMny.multiply(divide = (roleValue = billParamVO.getRoleValue()).divide(BigDecimal.valueOf(100L)))))) continue;
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u96f6\u661f\u6750\u6599\u7533\u8bf7\u91d1\u989d\u8d85\u9884\u7b97\u4e2d\u96f6\u661f\u6750\u6599\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u96f6\u661f\u6750\u6599\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u4e2d\u96f6\u661f\u6750\u6599\u91d1\u989d");
                        paramsCheckDsVO.setContent("\u8be5\u9879\u76ee\u96f6\u661f\u6750\u6599\u7533\u8bf7\u91d1\u989d\uff1a" + useAppMny.setScale(2, 4) + "\uff0c\u9884\u7b97\u96f6\u661f\u6750\u6599\u91d1\u989d*" + roleValue + "%:" + _sporadicMaterialMny.setScale(2, 4) + ",\u8d85\u51fa\u91d1\u989d" + ComputeUtil.safeSub((BigDecimal)useAppMny, (BigDecimal)_sporadicMaterialMny).setScale(2, 4));
                        UseApplyService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                    }
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public CommonResponse<UseApplyVO> getSumNumCommon(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
        HashMap numMap = new HashMap();
        listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
        ArrayList<Long> materialIds = new ArrayList<Long>(listMap.keySet());
        if (CollectionUtils.isEmpty(materialIds)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u7d2f\u8ba1\u91cf,\u8fdb\u5ea6\u91cf,\u603b\u91cf\u6210\u529f!", (Object)((Object)vo));
        }
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("projectId", vo.getProjectId());
        queryParam.put("pId", vo.getId());
        queryParam.put("materialIds", materialIds);
        List<UseApplySubVO> useApplySubVOS = ((UseApplyMapper)this.baseMapper).countApplyNumCommon(queryParam);
        queryParam.put("partNameFlag", 1);
        List<UseApplySubVO> useApplySubVOSForPart = ((UseApplyMapper)this.baseMapper).countApplyNumCommon(queryParam);
        List<UseApplySubVO> BatchPartVO = ((UseApplyMapper)this.baseMapper).countBatchPlanNumCommon(queryParam);
        Long orgId = vo.getOrgId();
        List<InstoreMaterialVO> instoreMaterialVOList = null;
        if (orgId != null) {
            instoreMaterialVOList = this.instoreMaterialService.storeNumCount(orgId, materialIds);
        }
        if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
            Map<Object, Object> storeNumMap = new HashMap();
            if (CollectionUtils.isNotEmpty(instoreMaterialVOList)) {
                storeNumMap = instoreMaterialVOList.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getStoreNum()));
            }
            Map<Long, BigDecimal> level3Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
            Map<Long, BigDecimal> level5Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getSumEstimateMny()));
            Map<Long, List<UseApplySubVO>> level4Map = useApplySubEntities.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
            Map<String, BigDecimal> batchNumMap = BatchPartVO.stream().collect(Collectors.toMap(s -> s.getMaterialId() + s.getPartName(), s -> s.getBatchPlanNum()));
            Map<String, BigDecimal> applyPartMap = useApplySubVOSForPart.stream().collect(Collectors.toMap(k -> k.getMaterialId() + k.getPartName(), k -> k.getApplyNum()));
            HashMap sumAppluNumMap = new HashMap();
            level4Map.forEach((k, v) -> sumAppluNumMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
            for (UseApplySubVO d : useApplySubEntities) {
                Long materialId = d.getMaterialId();
                String partName = d.getPartName();
                if (materialId == null) continue;
                BigDecimal applyed = level3Map.get(materialId);
                BigDecimal applyedForPart = applyPartMap.get(materialId + partName);
                BigDecimal thisAddApplyed = ComputeUtil.safeAdd((BigDecimal)applyed, (BigDecimal)d.getApplyNum());
                BigDecimal thisAddApplyedForPart = ComputeUtil.safeAdd((BigDecimal)applyedForPart, (BigDecimal)d.getApplyNum());
                BigDecimal sumEstimateMoney = level5Map.get(materialId);
                BigDecimal thisAddSumEstimateMoney = ComputeUtil.safeAdd((BigDecimal)sumEstimateMoney, (BigDecimal)d.getEstimateMoney());
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("projectId", vo.getProjectId());
                param.put("materialId", d.getMaterialId());
                List<OutStoreSubVO> outStoreSubVOS = this.outStoreSubService.queryReturnGoodsMaterialNum(param);
                Map<Long, BigDecimal> outStoreMap = outStoreSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getOutStoreNumber()));
                BigDecimal returnGoodsNum = outStoreMap.get(materialId);
                applyed = BigDecimalUtils.safeSub((BigDecimal)applyed, (BigDecimal)returnGoodsNum);
                if (applyed.compareTo(BigDecimal.ZERO) < 0) {
                    applyed = new BigDecimal(0);
                }
                if ((thisAddApplyed = ComputeUtil.safeAdd((BigDecimal)applyed, (BigDecimal)((BigDecimal)sumAppluNumMap.get(materialId)))).compareTo(BigDecimal.ZERO) < 0) {
                    thisAddApplyed = new BigDecimal(0);
                }
                List<MaterialMasterPlanSubVO> masterPlanSubVOS = this.materialMasterPlanSubMapper.queryMasterPlanSubNum(param);
                Map<Long, Double> masterPlanMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getNum()));
                Map<Long, BigDecimal> masterPlanMnyMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getAmount()));
                Double masterPlanNum = masterPlanMap.get(materialId);
                d.setOrderNum(ComputeUtil.nullToZero((BigDecimal)thisAddApplyed));
                d.setSumApplyNum(ComputeUtil.nullToZero((BigDecimal)applyed));
                d.setMasterPlanNum(masterPlanNum != null ? new BigDecimal(masterPlanNum) : BigDecimal.ZERO.setScale(8));
                d.setSumApplyNumForPart(ComputeUtil.nullToZero((BigDecimal)applyedForPart));
                d.setOrderNumForPart(ComputeUtil.nullToZero((BigDecimal)thisAddApplyedForPart));
                d.setBatchPlanNum(ComputeUtil.nullToZero((BigDecimal)batchNumMap.get(materialId + partName)));
                d.setSumEstimateMny(sumEstimateMoney);
                d.setThisAddSumEstimateMny(thisAddSumEstimateMoney);
                d.setPlanTotalMny(ComputeUtil.nullToZero((BigDecimal)masterPlanMnyMap.get(materialId)));
                d.setStoreNum(ComputeUtil.nullToZero((BigDecimal)((BigDecimal)storeNumMap.get(materialId))));
                d.setIsFinish(0);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u7d2f\u8ba1\u91cf,\u8fdb\u5ea6\u91cf,\u603b\u91cf\u6210\u529f!", (Object)((Object)vo));
    }

    @Override
    public List<UseApplyFinishVO> materialFinishCount(Map<String, Object> queryParam) {
        return ((UseApplyMapper)this.baseMapper).materialFinishCount(queryParam);
    }

    @Override
    public List<MaterialApplyCountVO> queryMaterialApplyCount(Long projectId, List<Long> materialIds) {
        return ((UseApplyMapper)this.baseMapper).queryMaterialApplyCount(projectId, materialIds);
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyData(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryAllApplyData(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubList(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryApplySubList(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyDataForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryAllApplyDataForPurchaseOrder(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubListForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryApplySubListForPurchaseOrder(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubListForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryApplySubListForInstore(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyDataForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryAllApplyDataForInstore(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public void updatePurchaseFlag(Long id, Integer purchaseFlag) {
        if (id != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(UseApplyEntity::getPurchaseFlag, (Object)purchaseFlag);
            super.update((Wrapper)updateWrapper);
        }
    }
}

