/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.ejianc.business.plan.bean.SectionPlanChangeEntity;
import com.ejianc.business.plan.bean.SectionPlanEntity;
import com.ejianc.business.plan.mapper.SectionPlanChangeMapper;
import com.ejianc.business.plan.mapper.SectionPlanChangeSubMapper;
import com.ejianc.business.plan.service.ISectionPlanChangeService;
import com.ejianc.business.plan.service.ISectionPlanService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sectionPlanChangeService")
public class SectionPlanChangeServiceImpl
extends BaseServiceImpl<SectionPlanChangeMapper, SectionPlanChangeEntity>
implements ISectionPlanChangeService {
    @Autowired
    private ISectionPlanService sectionPlanService;
    @Autowired
    private SectionPlanChangeSubMapper sectionPlanChangeSubMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SectionPlanChangeEntity saveOrUpdatePlanChange(SectionPlanChangeEntity saveEntity) {
        if (CollectionUtils.isNotEmpty(saveEntity.getMaterialSubList()) && null != saveEntity.getId()) {
            this.sectionPlanChangeSubMapper.delByPlanId(saveEntity.getId());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        SectionPlanEntity planEntity = (SectionPlanEntity)((Object)this.sectionPlanService.selectById(saveEntity.getSourcePlanId()));
        if (1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingPlanId(saveEntity.getId());
            this.sectionPlanService.saveOrUpdate((Object)planEntity, false);
        }
        return saveEntity;
    }
}

