package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.InstoreBillEntity;
import com.ejianc.business.material.bean.InstoreBillMaterialEntity;
import com.ejianc.business.material.mapper.InstoreBillMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IInstoreBillMaterialService;
import com.ejianc.business.material.vo.InstoreBillMaterialVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;


@Service("instoreBillMaterialService")
public class InstoreBillMaterialService extends BaseServiceImpl<InstoreBillMaterialMapper, InstoreBillMaterialEntity> implements IInstoreBillMaterialService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private InstoreBillMaterialMapper instoreBillMaterialMapper;


    @Autowired
    private IParamConfigApi paramConfigApi;

    //总计划量
    private static String PARAM_PLAN_COUNT = "P-D80E4406";

    @Autowired
    private MaterialContractMapper materialContractMapper;


    @Override
    public List<InstoreBillMaterialVO> querylist(QueryWrapper<InstoreBillMaterialEntity> queryWrapper) {
        List<InstoreBillMaterialEntity> list = this.list(queryWrapper);
        return BeanMapper.mapList(list, InstoreBillMaterialVO.class);
    }

    @Override
    public BigDecimal countAmount(QueryParam param) {
        QueryWrapper<InstoreBillEntity> queryWrapper = super.changeToQueryWrapper(param);
        queryWrapper.eq("dr", 0);
        return instoreBillMaterialMapper.countAmount(queryWrapper);
    }

    @Override
    public IPage<InstoreBillMaterialVO> queryStoreCanUseNumPageData(String searchText, String outDate, Long storeId, Integer pageNum, Integer pageSize) {
        IPage<InstoreBillMaterialVO> page = new Page<>();
        page.setCurrent(pageNum);
        page.setPages(pageSize);
        page.setSize(pageSize);
        Long count = instoreBillMaterialMapper.queryStoreCanUseNumPageDataCount(searchText, outDate, storeId);
        page.setTotal(count);
        List<InstoreBillMaterialVO> records =
                instoreBillMaterialMapper.queryStoreCanUseNumPageData(searchText, outDate, storeId, (pageNum - 1) * pageSize, pageSize);
        page.setRecords(records);
        return page;
    }

    @Override
    public IPage<InstoreBillMaterialVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize) {
        IPage<InstoreBillMaterialVO> page = new Page<>();
        Long count = instoreBillMaterialMapper.countStorematerialList(storeId, searchText);
        if (count > 0) {
            Integer startLine = null;
            if (pageNumber != null) {
                startLine = ((pageNumber > 0 ? pageNumber : 1) - 1) * pageSize;
                page.setCurrent(pageNumber);
                page.setSize(pageSize);
            }
            List<InstoreBillMaterialVO> list = instoreBillMaterialMapper.storematerialList(storeId, searchText, startLine, pageSize);
            page.setRecords(list);
        }
        page.setTotal(count);
        return page;
    }

    @Override
    public InstoreBillMaterialVO censusStorematerial(Long storeIid) {
        return instoreBillMaterialMapper.censusStorematerial(storeIid);
    }

    @Override
    public IPage<InstoreBillMaterialVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds, HashMap<String, String> map) {
        IPage<InstoreBillMaterialVO> page = new Page<>();
        page.setCurrent(pageNumber);
        page.setPages(pageSize);
        page.setSize(pageSize);
        Long count = instoreBillMaterialMapper.queryUsableSubMaterialCount(searchText, outDate, storeId, materialIds, map);
        page.setTotal(count);
        List<InstoreBillMaterialVO> records =
                instoreBillMaterialMapper.queryUsableSubMaterialPageList(searchText, outDate, storeId, (pageNumber - 1) * pageSize, pageSize, materialIds, map);
        page.setRecords(records);
        return page;
    }

    @Override
    public List<InstoreBillMaterialVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory) {
        return instoreBillMaterialMapper.querySubMaterialStoreInfo(storeId, checkDate, materialId, inventory);
    }

    /**
     * @param vo
     * @description: 参数校验
     * @return: com.ejianc.business.finance.vo.ParamsCheckVO
     * @author songlx
     * @date: 2021-05-27
     */
    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        List<MaterialPriceVO> detailList = vo.getDetail();
        Map<Long, MaterialPriceVO> numMap = new HashMap<>();
        detailList.forEach(detail->{
            MaterialPriceVO materialPriceVO = numMap.get(detail.getMaterialId());
            if(materialPriceVO != null){
                materialPriceVO.setNum(ComputeUtil.safeAdd(materialPriceVO.getNum(),detail.getNum()));
            }else{
                numMap.put(detail.getMaterialId(),detail);
            }
        });
        vo.setDetail(new ArrayList<>(numMap.values()));

        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<MaterialPriceVO> detail = vo.getDetail();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isEmpty(detail)) {
            return paramsCheckVO;
        }
        CommonResponse<BillParamVO> countParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);

        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            BillParamVO billParamVO = countParamByCode.getData();
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
            if (0 != billParamVO.getControlType()) {
                List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                //获取已生效的量
                List<MaterialPriceVO> vos = instoreBillMaterialMapper.queryMaterialInstoreCount(vo.getProjectId(), materialIds);
                //获取计划数量
                List<MaterialPriceVO> materialPriceVOS = materialContractMapper.queryPlanPriceByProjectId(vo.getProjectId(), materialIds);
                if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                    Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                    for (MaterialPriceVO v : detail) {
                        Long materialId = v.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (null != p) {
                            v.setPlanNum(p.getPlanNum());
                            v.setPlanPrice(p.getPlanPrice());
                        }
                    }
                }
                Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                detail.forEach((d) -> {
                    BigDecimal num = d.getNum();
                    BigDecimal planNum = d.getPlanNum();
                    BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                    BigDecimal allNum = hasNum.add(num);
                    //百分比数量
                    BigDecimal _planNum = planNum.multiply(divide);
                    if (allNum.compareTo(_planNum) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : "" ));
                        paramsCheckDsVO.setWarnName("材料入库数量大于总计划数量");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次入库数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("，已入库数量：").append(hasNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("，总计划数量*").append(roleValue).append("%: ").append(_planNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("。超出数量：").append(allNum.subtract(_planNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                });
            }
            paramsCheckVO.setDataSource(checkDsVOS);
        } else {
            logger.info(countParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVO;
    }
}
