package com.ejianc.business.plan.controller;

import com.ejianc.business.plan.bean.SectionPlanChangeHisEntity;
import com.ejianc.business.plan.service.ISectionPlanChangeHisService;
import com.ejianc.business.plan.vo.SectionPlanChangeHisVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 标段计划变更历史
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sectionPlanChangeHis")
public class SectionPlanChangeHisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISectionPlanChangeHisService service;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SectionPlanChangeHisVO> queryDetail(Long id) {
        SectionPlanChangeHisVO vo = null;
        SectionPlanChangeHisEntity dbEntity = service.selectById(id);
        if (null != dbEntity) {
            vo = BeanMapper.map(dbEntity, SectionPlanChangeHisVO.class);
        }
        return CommonResponse.success("查询物资总计划变更详情成功！", vo);
    }


}
