package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.bean.InstoreBillEntity;
import com.ejianc.business.material.bean.InstoreBillMaterialEntity;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.pub.MaterialAllocationState;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.*;
import com.ejianc.business.material.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author liyongjia
 * @Date 2020/6/6 用料申请控制器
 * @Description InstoreController
 */

@Controller
@RequestMapping("/instoreBill/")
public class InstoreBillController {
    private static final String BILL_CODE = "MATERIAL-INSTORE";

    @Autowired
    IInstoreBillService instoreBillService;
    @Autowired
    IInstoreService instoreService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IInstoreBillMaterialService instoreBillMaterialService;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    IStoreService storeService;
    @Autowired
    private SessionManager sessionManager;


    @RequestMapping(value = "checkParamsById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParamsById(@RequestBody MaterialPriceVO vo) {
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        Long id = vo.getId();
        if (id != null) {
            InstoreBillEntity byId = instoreBillService.selectById(id);
            if (null != byId) {
                Long projectId = byId.getProjectId();
                if (null != projectId) {
                    vo.setProjectId(projectId);
                    if (CollectionUtils.isEmpty(vo.getDetail())) {
                        List<InstoreBillMaterialEntity> instoreMaterialList = byId.getInstoreMaterialList();
                        if (CollectionUtils.isNotEmpty(instoreMaterialList)) {
                            List<MaterialPriceVO> detail = new ArrayList<>();
                            instoreMaterialList.forEach(item -> {
                                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                                materialPriceVO.setId(item.getMaterialId());
                                materialPriceVO.setMaterialId(item.getMaterialId());
                                materialPriceVO.setMaterialName(item.getMaterialName());
                                materialPriceVO.setSpec(item.getMaterialSpec());
                                materialPriceVO.setNum(item.getInstoreNumber());
                                detail.add(materialPriceVO);
                            });
                            vo.setDetail(detail);
                        }
                    }
                    paramsCheckVO = instoreBillMaterialService.checkParams(vo);
                }
            }
        }
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }


    /**
     * @param vo
     * @description: 入库参数校验
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.finance.vo.ParamsCheckVO>
     * @author songlx
     * @date: 2021-05-27
     */
    @RequestMapping(value = "checkParams", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody MaterialPriceVO vo) {

        ParamsCheckVO paramsCheckVO = instoreBillMaterialService.checkParams(vo);

        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }


    /**
     * @Author liyongjia
     * @Date 2020/6/10  保存修改
     * @Description saveOrUpdate
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.InstoreBillVO>
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InstoreBillVO> saveOrUpdate(@RequestBody InstoreBillVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        beforeSave(vo);
        InstoreBillEntity entity = BeanMapper.map(vo, InstoreBillEntity.class);
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(vo.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            QueryWrapper<InstoreBillEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("tenant_id", tenantId);
            wrapper.eq("bill_code", vo.getBillCode());
            wrapper.eq(vo.getId() != null,"id", vo.getId());
            int count = instoreBillService.count(wrapper);

            QueryWrapper<InstoreEntity> instoreEntityQueryWrapper = new QueryWrapper<>();
            instoreEntityQueryWrapper.eq("tenant_id", tenantId);
            instoreEntityQueryWrapper.eq("bill_code", vo.getBillCode());
            int count1 = instoreService.count(instoreEntityQueryWrapper);
            if (count>0 || count1 >0) {
                throw new BusinessException("存在相同单号，不允许保存!");
            }
        }
        if (entity.getId() == null || entity.getId() == 0) {
            entity.setUserName(sessionManager.getUserContext().getUserName());
            entity.setPaymentFlag(0);
        }
        instoreBillService.saveOrUpdate(entity, false);
        InstoreBillVO backVo = BeanMapper.map(entity, InstoreBillVO.class);
        return CommonResponse.success("保存或修改单据成功！", backVo);
    }

    public void beforeSave(InstoreBillVO vo) {
        if (vo.getTaxRate() == null && !MaterialStoreType.RETURN_IN_STORE.getCode().equals(vo.getInstoreType())) {
            vo.setTaxRate(new BigDecimal("0.00"));
        }
        BigDecimal totalCount = new BigDecimal(0);
        BigDecimal totalAmount = new BigDecimal(0);
        BigDecimal totalAmountNoTax = new BigDecimal(0);
        if (!ListUtil.isEmpty(vo.getInstoreMaterialList())) {
            String materialName = "";
            for (InstoreBillMaterialVO sub : vo.getInstoreMaterialList()) {
                if (!"del".equals(sub.getRowState())) {
                    sub.setStoreId(vo.getStoreId());
                    sub.setInstoreDate(vo.getInstoreDate());
                    sub.setStoreState(MaterialStoreState.STORING.getCode());
                    sub.setInstoreType(vo.getInstoreType());
                    if (materialName.length() > 0) {
                        materialName += "、" + sub.getMaterialName();
                    } else {
                        materialName += sub.getMaterialName();
                    }
                    totalCount = totalCount.add(sub.getInstoreNumber());
                    totalAmount = totalAmount.add(sub.getAmount());
                    if (!MaterialStoreType.RETURN_IN_STORE.getCode().equals(vo.getInstoreType())) {
                        /** 领料退库由前端传税率 */
                        sub.setTaxRate(vo.getTaxRate());
                    }
                    totalAmountNoTax = totalAmountNoTax.add(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().divide(new BigDecimal("1.00").add(sub.getTaxRate() == null ? new BigDecimal("0.00") : sub.getTaxRate().divide(new BigDecimal("100.00"), 8, BigDecimal.ROUND_HALF_UP)), 8, BigDecimal.ROUND_HALF_UP));
                }
            }
            vo.setMaterialName(materialName);
        }
        vo.setTotalAmount(totalAmount);
        vo.setTotalAmountNoTax(totalAmountNoTax);
        vo.setTotalCount(totalCount);
        if ("hasContract".equals(vo.getContractType())) {
            materialContractService.checkContract(vo.getContractId());
        }
    }


    /***
     * @Author mrsir_wxp
     * @Date 2020/12/22 保存 关联 领料退库使用
     * @Description pushToCost
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.InstoreBillVO>
     */
    @RequestMapping(value = "pushToCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InstoreBillVO> pushToCost(@RequestBody InstoreBillVO vo) {
        beforeSave(vo);
        InstoreBillEntity entity = BeanMapper.map(vo, InstoreBillEntity.class);
        instoreBillService.processCost(entity);
        instoreBillService.saveOrUpdate(entity, false);
        InstoreBillVO backVo = BeanMapper.map(entity, InstoreBillVO.class);
        return CommonResponse.success("保存关联成功！", backVo);
    }


    /**
     * @Author liyongjia
     * @Date 2020/6/2 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.InstoreBillVO>
     */
    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InstoreBillVO> queryDetail(Long id) {
        InstoreBillEntity entity = instoreBillService.selectById(id);
        InstoreBillVO vo = BeanMapper.map(entity, InstoreBillVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/2 收料入库查询详情
     * @Description queryList
     * @Param [id]
     * @Return IPage<InstoreBillVO>
     */
    @RequestMapping(value = "queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InstoreBillVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        //租户隔离
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        //param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<InstoreBillVO> page = instoreBillService.queryForList(param, false);
        List<InstoreBillVO> list = page.getRecords();
        BigDecimal allTotalAmount = new BigDecimal(0);
        if (list != null && list.size() > 0) {
            //获取入库金额合计
            allTotalAmount = instoreBillMaterialService.countAmount(param);
        }
        for (InstoreBillVO vo : list) {
            vo.setAllTotalAmount(allTotalAmount);
        }

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/10 查询打印数据
     * @Description queryPrint
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("store", instoreBillService.selectById(id));
        return CommonResponse.success("查询打印数据成功！", json);
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/10 删除
     * @Description delete
     * @Param [vos]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InstoreBillVO> vos) {
        instoreBillService.removeByIds(vos.stream().map(InstoreBillVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * @Author liyongjia
     * @Date 2020/6/10 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(100000);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");

        /** 数据隔离 本下 */
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InstoreBillVO> voPage = instoreBillService.queryForList(queryParam, false);
        List<InstoreBillVO> list = voPage.getRecords();
        List<InstoreExportVO> exportVOS = new ArrayList<>();
        list.forEach(vo -> {
            InstoreExportVO exportVO = BeanMapper.map(vo, InstoreExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getCreateTime()));
            exportVO.setInstoreDate(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getInstoreDate()));
            if (vo.getReceiveDate() != null) {
                exportVO.setReceiveDate(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getReceiveDate()));
            }
            if (StringUtils.isNotBlank(vo.getReceiveState())) {
                if ("1".equals(vo.getReceiveState())) {
                    exportVO.setReceiveState("待收");
                } else if ("2".equals(vo.getReceiveState())) {
                    exportVO.setReceiveState("已收料");
                } else {
                    exportVO.setReceiveState("已退回：" + vo.getPickReturnReason());
                }
            }
            exportVO.setBillState(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            exportVOS.add(exportVO);
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        String fileName = "instoreListExport.xlsx";
        if (queryParam.getParams().get("instoreType") != null) {
            //收料入库
            if (queryParam.getParams().get("instoreType").getValue().toString().equals(MaterialStoreType.RECEIVE_IN_STORE.getCode().toString())) {
                fileName = "instoreListExport.xlsx";
            }
            //直入直出
            if (queryParam.getParams().get("instoreType").getValue().toString().equals(MaterialStoreType.STRAIGHT_IN_STORE.getCode().toString())) {
                fileName = "straightInoutListExport.xlsx";
            }
            //领料退库
            if (queryParam.getParams().get("instoreType").getValue().toString().equals(MaterialStoreType.RETURN_IN_STORE.getCode().toString())) {
                fileName = "pickReturnListExport.xlsx";
            }
            //调拨入库
            if (queryParam.getParams().get("instoreType").getValue().toString().equals(MaterialStoreType.ALLOCATION_IN_STORE.getCode().toString())) {
                fileName = "allocationInExport.xlsx";
            }
        }
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "material-import.xlsx", "物料导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<InstoreMaterialVO> successList = new ArrayList<>();
            List<InstoreMaterialVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 8) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    InstoreMaterialVO instoreMaterialVO = new InstoreMaterialVO();
                    if (StringUtils.isBlank(datas.get(0))) {
                        instoreMaterialVO.setErrorMessage("物料分类为必填项");
                    } else {
                        String materialCategoryName = datas.get(0).toString().trim();
                        instoreMaterialVO.setMaterialCategoryName(materialCategoryName);
                    }


                    if (StringUtils.isBlank(datas.get(1))) {
                        instoreMaterialVO.setErrorMessage("物资名称为必填项");
                    } else if (datas.get(1).length() > 20) {
                        instoreMaterialVO.setErrorMessage("物资名称填写长度为0~20字");
                    } else {
                        instoreMaterialVO.setMaterialName(datas.get(1));
                    }
                    if (StringUtils.isBlank(datas.get(2))) {
                        instoreMaterialVO.setErrorMessage("规格型号为必填项");
                    } else if (datas.get(2).length() > 200) {
                        instoreMaterialVO.setErrorMessage("规格型号填写长度为0~200字");
                    } else {
                        instoreMaterialVO.setMaterialSpec(datas.get(2));
                    }
                    if (!Objects.isNull(datas.get(3))){
                        instoreMaterialVO.setMaterialUnit(datas.get(3).trim());
                    }

                    instoreMaterialVO.setMaterialSupplierName(datas.get(4));

                    if (StringUtils.isNotBlank(datas.get(7)) && datas.get(7).length() > 64) {
                        instoreMaterialVO.setErrorMessage("物料编码填写长度为0~64字");
                    } else {
                        instoreMaterialVO.setMaterialCode(datas.get(7));
                    }
                    if (StringUtils.isNotBlank(datas.get(8)) && datas.get(6).length() > 50) {
                        instoreMaterialVO.setErrorMessage("备注填写长度为0~50字");
                    } else {
                        instoreMaterialVO.setRemark(datas.get(8));
                    }
                    instoreMaterialVO.setSourceType("import");
                    if (StringUtils.isNotBlank(datas.get(5))) {
                        try {
                            instoreMaterialVO.setInstoreNumber(new BigDecimal(datas.get(5)));
                            if (instoreMaterialVO.getInstoreNumber().longValue() < 0) {
                                instoreMaterialVO.setErrorMessage("入库数量必须大于0");
                            }
                        } catch (Exception e) {
                            instoreMaterialVO.setErrorMessage("入库数量必须为数字");
                        }
                    } else {
                        instoreMaterialVO.setErrorMessage("入库数量为必填项");
                    }
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            instoreMaterialVO.setUnitPrice(new BigDecimal(datas.get(6)));
                            if (instoreMaterialVO.getUnitPrice().doubleValue() < 0) {
                                instoreMaterialVO.setErrorMessage("单价必须大于0");
                            }
                        } catch (Exception e) {
                            instoreMaterialVO.setErrorMessage("单价为必须为数字");
                        }
                    } else {
                        instoreMaterialVO.setUnitPrice(new BigDecimal(0));
                    }
                    if (instoreMaterialVO.getInstoreNumber() != null && instoreMaterialVO.getUnitPrice() != null) {
                        BigDecimal amount = instoreMaterialVO.getUnitPrice().multiply(instoreMaterialVO.getInstoreNumber());
                        instoreMaterialVO.setAmount(amount);
                    }


                    if (StringUtils.isBlank(instoreMaterialVO.getErrorMessage())) {
                        //通过物料名称、规格、计量单位获取物料
                        MaterialVO vo = new MaterialVO();
                        vo.setName(instoreMaterialVO.getMaterialName());
                        vo.setSpec(instoreMaterialVO.getMaterialSpec());
                        vo.setUnitName(instoreMaterialVO.getMaterialUnit());
                        CommonResponse<List<MaterialVO>> listCommonResponse = materialApi.queryMaterialList(vo);
                        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
                            MaterialVO materialVo = listCommonResponse.getData().get(0);
                            instoreMaterialVO.setMaterialCategoryId(materialVo.getCategoryId());
                            instoreMaterialVO.setMaterialCategoryName(materialVo.getCategoryName());
                            instoreMaterialVO.setMaterialId(materialVo.getId());
                            successList.add(instoreMaterialVO);
                            continue;
                        } else {
                            instoreMaterialVO.setErrorMessage("该物资不存在");
                        }
                        instoreMaterialVO.setId((long) i);
                        errorList.add(instoreMaterialVO);
                    } else {
                        errorList.add(instoreMaterialVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/6/18 调拨入库确认收料
     * @Description sureToReceive
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "sureToReceive", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> sureToReceive(@RequestBody InstoreBillVO vo) {
        InstoreBillEntity entity = instoreBillService.selectById(vo.getId());
        if (entity == null) {
            return CommonResponse.error("没有找到该单据！");
        }
        entity.setReceivePerson(vo.getReceivePerson());
        entity.setReceiveDate(vo.getReceiveDate());
        entity.setStoreId(vo.getStoreId());
        entity.setStoreName(vo.getStoreName());
        entity.setBillState(1);
        entity.setReceiveState(MaterialAllocationState.RECEIVED.getCode());
        instoreBillService.sureToReceive(entity);
        return CommonResponse.success("确认收料成功！");
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/18 调拨入库退回收料
     * @Description sureToReceive
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "sureToReturn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> sureToReturn(@RequestBody InstoreBillVO vo) {
        InstoreBillEntity entity = instoreBillService.selectById(vo.getId());
        if (entity == null) {
            return CommonResponse.error("没有找到该单据！");
        }
        entity.setReceivePerson(vo.getReceivePerson());
        entity.setReceiveDate(vo.getReceiveDate());
        entity.setReceiveState(MaterialAllocationState.REJECT.getCode());
        entity.setPickReturnReason(vo.getPickReturnReason());
        instoreBillService.sureToReturn(entity);
        return CommonResponse.success("确认收料成功！");
    }

    /**
     * 入库单参照
     * 本组织无合同已提交、审批通过的直入直出、收料入库单
     *
     * @param
     * @param
     */
    @RequestMapping(value = "queryRefNopaymnetList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InstoreBillVO>> queryRefList(
            @RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required = false) String searchText, @RequestParam(required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        Long orgId = null;
        if (StringUtils.isNotBlank(condition)) {
            JSONObject json = JSONObject.parseObject(condition);
            if (json.get("orgId") != null) {
                orgId = Long.parseLong(json.get("orgId").toString());
            } else {
                return CommonResponse.error("condition条件缺少orgId！");
            }
            if (json.get("contractType") != null) {
                param.getParams().put("contractType", new Parameter(QueryParam.IN, json.get("contractType")));
            }

            if (json.get("supplierId") != null) {
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, json.get("supplierId")));
            }
        } else {
            return CommonResponse.error("缺少condition条件");
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("instoreType", new Parameter(QueryParam.IN, "1,2"));

        ComplexParam c4 = new ComplexParam();
        c4.setLogic(ComplexParam.AND);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic(ComplexParam.OR);
        c5.getParams().put("paymentFlag", new Parameter(QueryParam.EQ, "0"));
        c4.getComplexParams().add(c5);
        ComplexParam c6 = new ComplexParam();
        c6.setLogic(ComplexParam.OR);
        c6.getParams().put("paymentFlag", new Parameter(QueryParam.EQ, null));
        c4.getComplexParams().add(c6);
        param.getComplexParams().add(c4);

        if (StringUtils.isNotBlank(searchText)) {
            param.setSearchText(searchText);
            /** 模糊搜索配置字段示例 */
            List<String> fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("name");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }
        IPage<InstoreBillVO> page = instoreBillService.queryForList(param, false);
        return CommonResponse.success("查询入库单数据成功！", page);
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/7/10 未结算入库的那参照
     * @Description queryRefNotSettlementList
     * @Param [pageNumber, pageSize, searchText, condition]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.material.vo.InstoreBillVO>>
     */
    @RequestMapping(value = "queryRefNotSettlementList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InstoreBillVO>> queryRefNotSettlementList(
            @RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required = false) String searchText, @RequestParam(required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        if (StringUtils.isNotBlank(condition)) {
            JSONObject json = JSONObject.parseObject(condition);
            if (json.get("orgId") != null) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, json.get("orgId")));
            } else {
                return CommonResponse.error("condition条件缺少orgId！");
            }
            if (json.get("contractId") != null) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, json.get("contractId")));
            }
        } else {
            return CommonResponse.error("缺少condition条件");
        }
        param.getParams().put("instoreType", new Parameter(QueryParam.IN, "1,2"));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("settlementFlag", new Parameter(QueryParam.EQ, "0"));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("settlementFlag", new Parameter(QueryParam.EQ, null));
        c1.getComplexParams().add(c3);

        param.getComplexParams().add(c1);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialName");

        IPage<InstoreBillVO> page = instoreBillService.queryForList(param, false);
        setType(page.getRecords());
        return CommonResponse.success("查询入库单数据成功！", page);
    }

    public void setType(List<InstoreBillVO> list) {
        if (ListUtil.isNotEmpty(list)) {
            list.forEach(l -> {
                InstoreBillEntity entity = instoreBillService.selectById(l.getId());
                if (ListUtil.isNotEmpty(entity.getInstoreMaterialList())) {
                    List<InstoreBillMaterialEntity> entities = entity.getInstoreMaterialList();
                    l.setInstoreMaterialList(BeanMapper.mapList(entities, InstoreBillMaterialVO.class));
                }
                l.setInstoreTypeName(MaterialStoreType.getStoreTypeNameByCode(l.getInstoreType()));
            });
        }
    }

    @GetMapping("printDetail")
    @ResponseBody
    public JSONObject printDetail(@RequestParam(value = "id") Long id) {
        JSONObject resp = new JSONObject();
        JSONObject data = new JSONObject();
        InstoreBillEntity entity = instoreBillService.selectById(id);
        Map<String, Object> entityMap = JSONObject.parseObject(JSONObject.toJSONString(entity), Map.class);
        entityMap.put("InstoreMaterial", entityMap.get("instoreMaterialList"));
        entityMap.remove("instoreMaterialList");

        data.put("Instore", entityMap);
        resp.put("data", data);
        resp.put("code", CommonResponse.SUCCESS);
        resp.put("msg", "查询详情成功！");
        return resp;
    }


    /**
     * @Author mrsir_wxp
     * @Date 2021/4/27 	拍照入库 查询列表 直入直出类型
     * @Description queryList
     * @Param [param]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.material.vo.InstoreBillVO>>
     */
    @RequestMapping(value = "queryPhotographList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InstoreBillVO>> queryPhotographList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("billState", new Parameter(QueryParam.IN, "0,4"));
        param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        IPage<InstoreBillVO> page = instoreBillService.queryForList(param, false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/4/27 保存或者新增 拍照入库  直入直出类型
     * @Description saveOrUpdatePhotograph
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.InstoreBillVO>
     */
    @RequestMapping(value = "saveOrUpdatePhotograph", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InstoreBillVO> saveOrUpdatePhotograph(@RequestBody InstoreBillVO vo) {
        if (vo.getId() == null || vo.getId() == 0L) {
            vo.setTaxRate(new BigDecimal("0.00"));
            BigDecimal totalCount = new BigDecimal(0);
            BigDecimal totalAmount = new BigDecimal(0);
            BigDecimal totalAmountNoTax = new BigDecimal(0);
            vo.setTotalAmount(totalAmount);
            vo.setTotalAmountNoTax(totalAmountNoTax);
            vo.setTotalCount(totalCount);
            vo.setContractType("hasContract");
            vo.setInstoreType(MaterialStoreType.STRAIGHT_IN_STORE.getCode());
            CommonResponse<List<ProjectRegisterVO>> response = projectApi.queryProjectList(1);
            if (!response.isSuccess() || ListUtil.isEmpty(response.getData())) {
                return CommonResponse.error("没找到任何项目信息，请联系管理人员添加项目！");
            }
            ProjectRegisterVO projectRegisterVO = response.getData().get(0);
            vo.setOrgId(projectRegisterVO.getProjectDepartmentId());
            vo.setOrgName(projectRegisterVO.getName());
            vo.setProjectId(projectRegisterVO.getId());
            vo.setProjectName(projectRegisterVO.getName());
            vo.setInstoreDate(new Date());
            StoreVO storeVO = storeService.queryNewestStoreByOrgId(projectRegisterVO.getProjectDepartmentId());
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (storeVO != null) {
                vo.setStoreId(storeVO.getId());
                vo.setStoreName(vo.getStoreName());
            }
            if (billCode.isSuccess()) {
                vo.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            vo.setUserName(sessionManager.getUserContext().getUserName());
            vo.setPaymentFlag(0);
        }
        InstoreBillEntity entity = BeanMapper.map(vo, InstoreBillEntity.class);
        instoreBillService.saveOrUpdate(entity, false);
        InstoreBillVO backVo = BeanMapper.map(entity, InstoreBillVO.class);
        return CommonResponse.success("保存或修改单据成功！", backVo);
    }


    /**
     * 用料申请物资导出
     *
     * @param instoreBillVO
     * @param response
     */
    @PostMapping("excelExportMaterialList")
    public void excelExportMaterialList(@RequestBody InstoreBillVO instoreBillVO, HttpServletResponse response) {
        InstoreBillEntity entity = instoreBillService.selectById(instoreBillVO.getId());
        Map<String, Object> beans = new HashMap();
        List<InstoreMaterialVO> list = new ArrayList<>();
        List<InstoreBillMaterialEntity> data = entity.getInstoreMaterialList();
        if (CollectionUtils.isNotEmpty(data)) {
            data.forEach(item -> {
                InstoreMaterialVO vo = BeanMapper.map(item, InstoreMaterialVO.class);
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("straightInoutMaterialExport.xlsx", beans, response);
    }
}
