package com.ejianc.business.plan.service.impl;

import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.SectionPlanEntity;
import com.ejianc.business.plan.mapper.PlanChangeSubMapper;
import com.ejianc.business.plan.mapper.SectionPlanChangeSubMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.ISectionPlanService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.SectionPlanChangeMapper;
import com.ejianc.business.plan.bean.SectionPlanChangeEntity;
import com.ejianc.business.plan.service.ISectionPlanChangeService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 标段计划变更
 * 
 * @author generator
 * 
 */
@Service("sectionPlanChangeService")
public class SectionPlanChangeServiceImpl extends BaseServiceImpl<SectionPlanChangeMapper, SectionPlanChangeEntity> implements ISectionPlanChangeService{

    @Autowired
    private ISectionPlanService sectionPlanService;

    @Autowired
    private SectionPlanChangeSubMapper sectionPlanChangeSubMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SectionPlanChangeEntity saveOrUpdatePlanChange(SectionPlanChangeEntity saveEntity) {
        if(CollectionUtils.isNotEmpty(saveEntity.getMaterialSubList())) {
            //更新子表信息
            if(null != saveEntity.getId()) {
                sectionPlanChangeSubMapper.delByPlanId(saveEntity.getId());
            }
        }
        super.saveOrUpdate(saveEntity, false);

        SectionPlanEntity planEntity = sectionPlanService.selectById(saveEntity.getSourcePlanId());
        if(1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingPlanId(saveEntity.getId());
            sectionPlanService.saveOrUpdate(planEntity, false);
        }
        return saveEntity;
    }
}
