 package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 物资合同
 *
 * @author CJ
 */
@TableName(value = "ejc_material_materialcontract")
public class MaterialContractEntity extends BaseEntity {

    private static final long serialVersionUID = 6154281162738013672L;
    /**
     * 合同编号
     */
    @TableField(value = "code")
    private String code;

    /**
     * 合同名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 是否属于项目: 1-是（默认），0-否
     */
    @TableField(value = "depend_on_project")
    private String dependOnProject;

    /**
     * 所属组织
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 签约日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value = "sign_date")
    private Date signDate;

    /**
     * 总包方企业
     */
    @TableField(value = "contractor_enterprise_id")
    private Long contractorEnterpriseId;
    @TableField(value="section_names")
    private String sectionNames; //标段名称集合
    /**
     * 总包方企业名称
     */
    @TableField(value = "contractor_enterprise_name")
    private String contractorEnterpriseName;

    /**
     * 供应商
     */
    @TableField(value = "supplier_id")
    private Long supplierId;
    @TableField(value = "contract_name_extend")
    private String contractNameExtend;// 合同编码+合同名称+供应商+合同金额(含税)
    /**
     * 供应商名称
     */
    @TableField(value = "supplier_name")
    private String supplierName;

    /**
     * 采购类别
     */
    @TableField(value = "purchase_type")
    private Long purchaseType;

    /**
     * 采购类别名称
     */
    @TableField(value = "purchase_type_name")
    private String purchaseTypeName;

    /**
     * 税率
     */
    @TableField(value = "tax_rate")
    private Double taxRate;

    /**
     * 合同状态：1-未签订，2-履约中，3-已封账
     */
    @TableField(value = "state")
    private String state;

    /**
     * 合同状态名称
     */
    @TableField(value = "state_name")
    private String stateName;

    /**
     * 询比价单
     */
    @TableField(value = "enquiry_price_bill_id")
    private Long enquiryPriceBillId;

    /**
     * 询比价单名称
     */
    @TableField(value = "enquiry_price_bill_name")
    private String enquiryPriceBillName;

    /**
     * 采购方式：
     * 1、当合同的所属组织类型为：集团、公司、分公司、经理部时，采购方式为公司集采合同（及需求中定义的框架合同）
     * 2、当合同的所属组织类型为项目部时，采购方式为项目自采合同
     */
    @TableField(value = "purchase_mode")
    private String purchaseMode;
    /**
     * 采购方式名称
     */
    @TableField(value = "purchase_mode_name")
    private String purchaseModeName;

    /**
     * 约定支付比例
     */
    @TableField(value = "aggreed_payment_ratio")
    private Double aggreedPaymentRatio;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 合同变更状态：0-未变更，1-变更中，2-已变更
     */
    @TableField(value = "change_state")
    private Integer changeState;

    /**
     * 所属项目Id
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 所属项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 所属项目编码
     */
    @TableField(value = "project_code")
    private String projectCode;

    /**
     * 单据审批状态：0、自由态， 1、已提交，2、审批中，3、审批通过，5、审批中
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 合同变更单据审批状态：0、自由态， 1、已提交，2、审批中，3、审批通过，5、审批中
     */
    @TableField(value = "change_bill_state")
    private Integer changeBillState;

    @TableField(exist = false)
    @SubEntity(serviceName = "materialContractDetailSubService", pidName = "materialContractId")
    private List<MaterialContractDetailSubEntity> materialDetailList = new ArrayList<>();

    @TableField(exist = false)
    @SubEntity(serviceName = "materialContractItemService", pidName = "materialContractId")
    private List<MaterialContractItemEntity> contractItemList = new ArrayList<>();

    @TableField(exist = false)
    @SubEntity(serviceName = "materialContractOtherCostSubService", pidName = "materialContractId")
    private List<MaterialContractOtherCostSubEntity> otherCostList = new ArrayList<>();

    /**
     * 合同金额（含税）
     */
    @TableField("amount_with_tax")
    private BigDecimal amountWithTax;

    /**
     * 合同金额（不含税）
     */
    @TableField(value = "amount_without_tax")
    private BigDecimal amountWithoutTax;

    /**
     * 合同优惠前金额
     */
    @TableField(value = "contract_undiscount_mny")
    private BigDecimal contractUndiscountMny;

    /**
     * 优惠金额
     */
    @TableField(value = "discount_mny")
    private BigDecimal discountMny;

    /**
     * 税金
     */
    @TableField(value = "tax_fee")
    private BigDecimal taxFee;

    //其他字段
    /**
     * 变更版本
     */
    @TableField(value = "change_version")
    private Integer changeVersion;
    /**
     * 变更单主键Id
     */
    @TableField(value = "change_id")
    private Long changeId;
    /**
     * 子表物资种类集合
     */
    @TableField(value = "material_type_names")
    private String materialTypeNames;
    /**
     * 变更单编号
     */
    @TableField(value = "change_code")
    private String changeCode;

    /**
     * 初始版本合同金额（不含税）
     */
    @TableField(value = "base_money")
    private BigDecimal baseMoney;
    /**
     * 初始版本合同金额（含税）
     */
    @TableField(value = "base_tax_money")
    private BigDecimal baseTaxMoney;

    /**
     * 变更前合同金额（不含税）
     */
    @TableField(value = "before_change_mny")
    private BigDecimal beforeChangeMny;
    /**
     * 变更前合同金额（含税）
     */
    @TableField(value = "before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny;
    /**
     * 变更后合同金额（不含税）
     */
    @TableField(value = "changing_mny")
    private BigDecimal changingMny;
    /**
     * 变更后合同金额（含税）
     */
    @TableField(value = "changing_tax_mny")
    private BigDecimal changingTaxMny;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "effective_date")
    private Date effectiveDate;

    /**
     * 修改人名称
     */
    @TableField(value = "modify_user_name")
    private String modifyUserName;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "commit_date")
    private Date commitDate;

    /**
     * 提交人名称
     */
    @TableField(value = "commit_user_name")
    private String commitUserName;

    /**
     * 提交人账号
     */
    @TableField(value = "commit_user_code")
    private String commitUserCode;

    @TableField("invoice_type")
    private Long invoiceType; // 发票类型

    @TableField("invoice_type_name")
    private String invoiceTypeName;


    public Long getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }


    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public String getContractNameExtend() {
        return contractNameExtend;
    }

    public void setContractNameExtend(String contractNameExtend) {
        this.contractNameExtend = contractNameExtend;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }

    public Integer getChangeBillState() {
        return changeBillState;
    }

    public void setChangeBillState(Integer changeBillState) {
        this.changeBillState = changeBillState;
    }

    public String getEnquiryPriceBillName() {
        return enquiryPriceBillName;
    }

    public String getSectionNames() {
        return sectionNames;
    }

    public void setSectionNames(String sectionNames) {
        this.sectionNames = sectionNames;
    }

    public void setEnquiryPriceBillName(String enquiryPriceBillName) {
        this.enquiryPriceBillName = enquiryPriceBillName;
    }

    public BigDecimal getTaxFee() {
        return taxFee;
    }

    public void setTaxFee(BigDecimal taxFee) {
        this.taxFee = taxFee;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public BigDecimal getContractUndiscountMny() {
        return contractUndiscountMny;
    }

    public void setContractUndiscountMny(BigDecimal contractUndiscountMny) {
        this.contractUndiscountMny = contractUndiscountMny;
    }

    public BigDecimal getDiscountMny() {
        return discountMny;
    }

    public void setDiscountMny(BigDecimal discountMny) {
        this.discountMny = discountMny;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getContractorEnterpriseName() {
        return contractorEnterpriseName;
    }

    public void setContractorEnterpriseName(String contractorEnterpriseName) {
        this.contractorEnterpriseName = contractorEnterpriseName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Long getContractorEnterpriseId() {
        return contractorEnterpriseId;
    }

    public void setContractorEnterpriseId(Long contractorEnterpriseId) {
        this.contractorEnterpriseId = contractorEnterpriseId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Long getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Long purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Double getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Double taxRate) {
        this.taxRate = taxRate;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStateName() {
        return stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public Long getEnquiryPriceBillId() {
        return enquiryPriceBillId;
    }

    public void setEnquiryPriceBillId(Long enquiryPriceBillId) {
        this.enquiryPriceBillId = enquiryPriceBillId;
    }

    public String getPurchaseMode() {
        return purchaseMode;
    }

    public void setPurchaseMode(String purchaseMode) {
        this.purchaseMode = purchaseMode;
    }

    public String getPurchaseModeName() {
        return purchaseModeName;
    }

    public void setPurchaseModeName(String purchaseModeName) {
        this.purchaseModeName = purchaseModeName;
    }

    public Double getAggreedPaymentRatio() {
        return aggreedPaymentRatio;
    }

    public void setAggreedPaymentRatio(Double aggreedPaymentRatio) {
        this.aggreedPaymentRatio = aggreedPaymentRatio;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public List<MaterialContractDetailSubEntity> getMaterialDetailList() {
        return materialDetailList;
    }

    public void setMaterialDetailList(List<MaterialContractDetailSubEntity> materialDetailList) {
        this.materialDetailList = materialDetailList;
    }

    public List<MaterialContractItemEntity> getContractItemList() {
        return contractItemList;
    }

    public void setContractItemList(List<MaterialContractItemEntity> contractItemList) {
        this.contractItemList = contractItemList;
    }

    public List<MaterialContractOtherCostSubEntity> getOtherCostList() {
        return otherCostList;
    }

    public void setOtherCostList(List<MaterialContractOtherCostSubEntity> otherCostList) {
        this.otherCostList = otherCostList;
    }
}
