package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.*;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;


@Service("instoreMaterialService")
public class InstoreMaterialService extends BaseServiceImpl<InstoreMaterialMapper, InstoreMaterialEntity> implements IInstoreMaterialService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;
    @Autowired
    private IMaterialContractService materialContractService;

    @Autowired
    private StoreService storeService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    //总计划量
    private static String PARAM_PLAN_COUNT = "P-D80E4406";
    //用料申请量
    private static String PARAM_APPLY_COUNT = "P-Zm16p834";

//    【材料合同量】控制【材料入库量]
    private static String PARAM_DETAIL_COUNT = "P-4bxJ4C64";


    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private IUseApplyService useApplyService;
    private static final String PARAM_TOTAL_MNY = "P-5j78wo43"; // 【预算材料费总金额】 控 【材料入库总金额】
    private static final String PARAM_NUM = "P-uFOcn644"; // 预算材料清单量控
    private static final String PARAM_TAX_MNY = "P-14dTg745"; // 预算材料清单金额控
    private static final String PARAM_MATERIAL_PRICE = "P-1N735378"; // 【物资总计划价】管控【材料入库价】
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;

    // 劳务队伍领料限额量控制材料出库量
    private static String PARAM_LABOR_LIMIT_COUNT = "P-29E6rb74";
    //【材料合同价】控制【材料入库价】
    private static String PARAM_DETAIL_PRICE = "P-Yn663f82";

    @Autowired
    private IPickRegisterService pickRegisterService;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public List<InstoreMaterialVO> querylist(QueryWrapper<InstoreMaterialEntity> queryWrapper) {
        List<InstoreMaterialEntity> list = this.list(queryWrapper);
        return BeanMapper.mapList(list, InstoreMaterialVO.class);
    }

    @Override
    public BigDecimal countAmount(QueryParam param) {
        QueryWrapper<InstoreEntity> queryWrapper = super.changeToQueryWrapper(param);
        queryWrapper.eq("dr", 0);
        return instoreMaterialMapper.countAmount(queryWrapper);
    }

    @Override
    public IPage<InstoreMaterialVO> queryStoreCanUseNumPageData(String searchText, String searchObject,String outDate, Long storeId, Integer pageNum, Integer pageSize) {
        IPage<InstoreMaterialVO> page = new Page<>();
        page.setCurrent(pageNum);
        page.setPages(pageSize);
        page.setSize(pageSize);
        String materialTypeName="";
        String materialName="";
        String materialSpec="";
        String materialUnit="";
        if(StringUtils.isNotBlank(searchObject)){
            JSONObject search = JSONObject.parseObject(searchObject);
            if(search.get("materialCategoryName")!=null){
               materialTypeName = search.get("materialCategoryName").toString();
            }
            if(search.get("materialName")!=null){
               materialName = search.get("materialName").toString();
            }
            if(search.get("materialSpec")!=null){
               materialSpec = search.get("materialSpec").toString();
            }
            if(search.get("materialUnit")!=null){
              materialUnit = search.get("materialUnit").toString();
            }
        }

        Long count = instoreMaterialMapper.queryStoreCanUseNumPageDataCount(searchText, outDate, storeId, materialTypeName,materialName,materialSpec,materialUnit);
        page.setTotal(count);
        List<InstoreMaterialVO> records =
                instoreMaterialMapper.queryStoreCanUseNumPageData(searchText, outDate, storeId, (pageNum - 1) * pageSize, pageSize, materialTypeName,materialName,materialSpec,materialUnit);
        page.setRecords(records);
        return page;
    }

    @Override
    public IPage<InstoreMaterialVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize) {
        IPage<InstoreMaterialVO> page = new Page<>();
        Long count = instoreMaterialMapper.countStorematerialList(storeId, searchText);
        if (count > 0) {
            Integer startLine = null;
            if (pageNumber != null) {
                startLine = ((pageNumber > 0 ? pageNumber : 1) - 1) * pageSize;
                page.setCurrent(pageNumber);
                page.setSize(pageSize);
            }
            List<InstoreMaterialVO> list = instoreMaterialMapper.storematerialList(storeId, searchText, startLine, pageSize);
            page.setRecords(list);
        }
        page.setTotal(count);
        return page;
    }

    @Override
    public InstoreMaterialVO censusStorematerial(Long storeIid) {
        return instoreMaterialMapper.censusStorematerial(storeIid);
    }

    @Override
    public IPage<InstoreMaterialVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds, HashMap<String, String> map) {
        IPage<InstoreMaterialVO> page = new Page<>();
        page.setCurrent(pageNumber);
        page.setPages(pageSize);
        page.setSize(pageSize);
        Long count = instoreMaterialMapper.queryUsableSubMaterialCount(searchText, outDate, storeId, materialIds, map);
        page.setTotal(count);
        List<InstoreMaterialVO> records =
                instoreMaterialMapper.queryUsableSubMaterialPageList(searchText, outDate, storeId, (pageNumber - 1) * pageSize, pageSize, materialIds, map);
        page.setRecords(records);
        return page;
    }

    @Override
    public List<InstoreMaterialVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory) {
        return instoreMaterialMapper.querySubMaterialStoreInfo(storeId, checkDate, materialId, inventory);
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }


    /**
     * @param vo
     *
     * @description: 参数校验
     * @return: com.ejianc.business.finance.vo.ParamsCheckVO
     * @author songlx
     * @date: 2021-05-27
     */
    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        List<MaterialPriceVO> detailList = vo.getDetail();

        if (CollectionUtils.isNotEmpty(detailList) && (int) detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());

            Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
            Map<Long, MaterialPriceVO> numMap = new HashMap<>();
            detailList.forEach(detail -> {
                MaterialPriceVO materialPriceVO = numMap.get(detail.getMaterialId());
                if (materialPriceVO != null) {
                    materialPriceVO.setNum(ComputeUtil.safeAdd(materialPriceVO.getNum(), detail.getNum()));
                    materialPriceVO.setAmount(ComputeUtil.safeAdd(materialPriceVO.getAmount(), detail.getAmount()));
                } else {
                    numMap.put(detail.getMaterialId(), detail);
                }
            });
            vo.setDetail(new ArrayList<>(numMap.values()));

            List<MaterialPriceVO> detail = vo.getDetail();
            if (CollectionUtils.isNotEmpty(detail)) {
                List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                // 【预算材料费总金额】 控 【材料入库总金额】
                // 预算材料费总金额
                BudgetProjectProParamControlVO paramControlVO = new BudgetProjectProParamControlVO();
                paramControlVO.setProjectId(vo.getProjectId());
                paramControlVO.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
                paramControlVO.setIds(materialIds);
                CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(paramControlVO);
                if (!res.isSuccess()) {
                    throw new BusinessException("预算材料费总金额，查询项目预算信息失败，失败原因：" + res.getMsg());
                }
                // 没有预算不控制，预算不包含不控制
                if (null != res.getData()) {
                    // 预算总金额
                    BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = res.getData();
                    Map<Long, BudgetProjectDetailProVO> detailProMap = quantityAndMnyVO.getDetailProMap();

                    // 【预算材料费总金额】 控 【材料入库总金额】
                    CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
                    if (!response.isSuccess()) {
                        throw new BusinessException("【预算材料费总金额】 控 【材料入库总金额】，获取控制参数失败，失败原因：" + response.getMsg());
                    }
                    List<BillParamVO> billParamVOS = response.getData();

                    if (CollectionUtils.isNotEmpty(billParamVOS) && (1 == vo.getInstoreType() || 2 == vo.getInstoreType())) {
                        // 历史累计收料入库(直入直出)表体【金额】合计值
                        BigDecimal lastTotalAmount = instoreMaterialMapper.fetchLastTotalAmount(vo.getProjectId(), vo.getId());
                        // 当前收料入库（直入直出）表体【金额】合计值
                        BigDecimal amount = detail.stream().map(MaterialPriceVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        // 【材料入库总金额】：入库表体【金额】合计值 + 收料入库（直入直出）表体【金额】合计值；
                        BigDecimal totalAmount = lastTotalAmount.add(amount);

                        for (BillParamVO billParamVO : billParamVOS) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                                  BigDecimal budgetTaxMnyResult =ComputeUtil.safeMultiply(quantityAndMnyVO.getMaterialTaxMny(),scale);

                                // 材料入库总金额 和 预算材料费总金额比较
                                if (totalAmount.compareTo(budgetTaxMnyResult) > 0) {
                                    // 超出金额 = 材料入库总金额 - 预算材料费总金额 * X%
                                    BigDecimal over = totalAmount.subtract(budgetTaxMnyResult);

                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(vo.getId(), "amount");
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem("材料入库总金额超预算材料费总金额");
                                    paramsCheckDsVO.setWarnName("材料入库总金额大于预算材料费总金额 * " + roleValue + "%");

                                    // 材料入库总金额：XX元，预算材料费总金额 * X%：XX元，超出金额：XX元。
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("该项目材料入库总金额：")
                                            .append(totalAmount.setScale(2, RoundingMode.HALF_UP))
                                            .append("元，预算材料费总金额 * ")
                                            .append(roleValue).append("%：")
                                            .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                            .append("元，超出金额：")
                                            .append(over.setScale(2, RoundingMode.HALF_UP))
                                            .append("元。");
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            }
                        }
                    }

                    // 预算材料清单量控
                    CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_NUM, curOrgId);
                    if (!response1.isSuccess()) {
                        throw new BusinessException("预算材料清单量控，获取控制参数失败，失败原因：" + response1.getMsg());
                    }
                    List<BillParamVO> billParamVOS1 = response1.getData();

                    if (CollectionUtils.isNotEmpty(billParamVOS1) && !detailProMap.isEmpty() && (1 == vo.getInstoreType() || 2 == vo.getInstoreType())) {
                        // 历史累计收料入库(直入直出)材料清单量、金额
                        Map<Long, MaterialPriceVO> lastSubMap = instoreMaterialMapper.sumLastTotalNumAndTotalAmount(vo.getId(), vo.getProjectId(), numMap.keySet());
                        // 合并收料入库(直入直出)材料数据
                        Map<Long, MaterialPriceVO> currentMergeMap = new HashMap<>();
                        if (lastSubMap.isEmpty()) {
                            currentMergeMap.putAll(numMap);
                        } else {
                            for (Map.Entry<Long, MaterialPriceVO> entry : lastSubMap.entrySet()) {
                                Long materialId = entry.getKey();
                                if (numMap.containsKey(materialId)) {
                                    MaterialPriceVO subVO = entry.getValue();
                                    MaterialPriceVO cur = numMap.get(materialId);
                                    BigDecimal num = subVO.getNum();
                                    subVO.setNum(num.add(cur.getNum()));
                                    entry.setValue(subVO);
                                }
                            }
                            currentMergeMap.putAll(lastSubMap);
                        }

                        for (BillParamVO billParamVO : billParamVOS1) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal scale = roleValue.divide(new BigDecimal("100"));

                                // 根据现在的参数重新计算预算清单的清单量和金额
                                Map<Long, BudgetProjectDetailProVO> dProMap = new HashMap<>();
                                for (Map.Entry<Long, BudgetProjectDetailProVO> entry : detailProMap.entrySet()) {
                                    BudgetProjectDetailProVO detailProVO = entry.getValue();
                                    BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                                    BigDecimal num = detailProVO.getNum() == null ? BigDecimal.ZERO : detailProVO.getNum();
                                    budgetProjectDetailProVO.setNum(num.multiply(scale));
                                    dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                                }

                                for (Map.Entry<Long, MaterialPriceVO> entry : currentMergeMap.entrySet()) {
                                    Long materialId = entry.getKey();
                                    MaterialPriceVO materialPriceVO = entry.getValue();
                                    // 预算包含档案才控制，不包含的档案不控制
                                    if (dProMap.containsKey(materialId)) {
                                        BudgetProjectDetailProVO detailProVO = dProMap.get(materialId);

                                        // 收料入库材料清单量+直入直出材料清单量 和 预算材料清单量
                                        BigDecimal cNum = materialPriceVO.getNum();
                                        BigDecimal dNum = detailProVO.getNum();
                                        if (cNum.compareTo(dNum) > 0) {
                                            // 超出量 = 收料入库材料清单量+直入直出材料清单量 - 预算材料清单量 * X%
                                            BigDecimal over = cNum.subtract(dNum);

                                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(materialId, "num");
                                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                            // 预警项：档案名称+单位+规格型号
                                            paramsCheckDsVO.setWarnItem(materialPriceVO.getMaterialName() + "-" + materialPriceVO.getMeasureUnit() + "-" + materialPriceVO.getSpec());
                                            paramsCheckDsVO.setWarnName("收料入库材料清单量+直入直出材料清单量大于预算材料清单量 * " + roleValue + "%");

                                            // 档案累计数量：XX，预算材料清单量 * X%：XX，超出量：XX。
                                            StringBuffer stringBuffer = new StringBuffer();
                                            stringBuffer.append("档案累计数量：")
                                                    .append(cNum.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，预算材料清单量 * ")
                                                    .append(roleValue).append("%：")
                                                    .append(dNum.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，超出量：")
                                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                                    .append("。");
                                            paramsCheckDsVO.setContent(stringBuffer.toString());
                                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                        }
                                    }
                                }
                            }
                        }
                    }


                    // 预算材料清单金额控
                    CommonResponse<List<BillParamVO>> response2 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TAX_MNY, curOrgId);
                    if (!response2.isSuccess()) {
                        throw new BusinessException("预算材料清单金额控，获取控制参数失败，失败原因：" + response2.getMsg());
                    }
                    List<BillParamVO> billParamVOS2 = response2.getData();

                    if (CollectionUtils.isNotEmpty(billParamVOS2) && !detailProMap.isEmpty() && (1 == vo.getInstoreType() || 2 == vo.getInstoreType())) {
                        // 历史累计收料入库(直入直出)材料清单量、金额
                        Map<Long, MaterialPriceVO> lastSubMap = instoreMaterialMapper.sumLastTotalNumAndTotalAmount(vo.getId(), vo.getProjectId(), numMap.keySet());
                        // 合并收料入库(直入直出)材料数据
                        Map<Long, MaterialPriceVO> currentMergeMap = new HashMap<>();
                        if (lastSubMap.isEmpty()) {
                            currentMergeMap.putAll(numMap);
                        } else {
                            for (Map.Entry<Long, MaterialPriceVO> entry : lastSubMap.entrySet()) {
                                Long materialId = entry.getKey();
                                if (numMap.containsKey(materialId)) {
                                    MaterialPriceVO subVO = entry.getValue();
                                    MaterialPriceVO cur = numMap.get(materialId);
                                    BigDecimal amount = subVO.getAmount();
                                    subVO.setAmount(amount.add(cur.getAmount()));
                                    entry.setValue(subVO);
                                }
                            }
                            currentMergeMap.putAll(lastSubMap);
                        }

                        for (BillParamVO billParamVO : billParamVOS2) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal scale = roleValue.divide(new BigDecimal("100"));

                                // 根据现在的参数重新计算预算清单的清单量和金额
                                Map<Long, BudgetProjectDetailProVO> dProMap = new HashMap<>();
                                for (Map.Entry<Long, BudgetProjectDetailProVO> entry : detailProMap.entrySet()) {
                                    BudgetProjectDetailProVO detailProVO = entry.getValue();
                                    BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                                    BigDecimal materialTaxMnyCost = detailProVO.getMaterialTaxMnyCost() == null ? BigDecimal.ZERO : detailProVO.getMaterialTaxMnyCost();
                                    budgetProjectDetailProVO.setMaterialTaxMnyCost(materialTaxMnyCost.multiply(scale));
                                    dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                                }

                                for (Map.Entry<Long, MaterialPriceVO> entry : currentMergeMap.entrySet()) {
                                    Long materialId = entry.getKey();
                                    MaterialPriceVO materialPriceVO = entry.getValue();
                                    // 预算包含档案才控制，不包含的档案不控制
                                    if (dProMap.containsKey(materialId)) {
                                        BudgetProjectDetailProVO detailProVO = dProMap.get(materialId);

                                        // 收料入库材料清单金额+直入直出材料清单金额  和 预算材料清单金额
                                        BigDecimal cAmount = materialPriceVO.getAmount();
                                        BigDecimal dMaterialTaxMnyCost = detailProVO.getMaterialTaxMnyCost();
                                        if (cAmount.compareTo(dMaterialTaxMnyCost) > 0) {
                                            // 超出量 = 收料入库材料清单金额+直入直出材料清单金额 - 预算材料清单量 * X%
                                            BigDecimal over = cAmount.subtract(dMaterialTaxMnyCost);

                                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(materialId, "amount");
                                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                            // 预警项：档案名称+单位+规格型号
                                            paramsCheckDsVO.setWarnItem(materialPriceVO.getMaterialName() + "-" + materialPriceVO.getMeasureUnit() + "-" + materialPriceVO.getSpec());
                                            paramsCheckDsVO.setWarnName("收料入库材料清单金额+直入直出材料清单金额大于预算材料清单量 * " + roleValue + "%");

                                            // 档案累计金额：XX，预算材料清单金额 * X%：XX，超出金额：XX。
                                            StringBuffer stringBuffer = new StringBuffer();
                                            stringBuffer.append("档案累计金额：")
                                                    .append(cAmount.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，预算材料清单金额 * ")
                                                    .append(roleValue).append("%：")
                                                    .append(dMaterialTaxMnyCost.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，超出金额：")
                                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                                    .append("。");
                                            paramsCheckDsVO.setContent(stringBuffer.toString());
                                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                //【总计划量】控制【材料入库量】
                CommonResponse<List<BillParamVO>> response2 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_COUNT, curOrgId);
                if (!response2.isSuccess()) {
                    throw new BusinessException("【总计划量】控制【材料入库量】，获取控制参数失败，失败原因：" + response2.getMsg());
                }
                List<BillParamVO> billParamVOS2 = response2.getData();

                if (CollectionUtils.isNotEmpty(billParamVOS2)) {
                    //获取已生效的量
                    List<MaterialPriceVO> vos = instoreMaterialMapper.queryMaterialInstoreCount(vo.getId(), vo.getProjectId(), materialIds);
                    //获取计划数量
                    List<MaterialPriceVO> materialPriceVOS = materialContractMapper.queryPlanPriceByProjectId(vo.getProjectId(), materialIds);
                    if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                        Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                        for (MaterialPriceVO v : detail) {
                            Long materialId = v.getMaterialId();
                            MaterialPriceVO p = priceVOMap.get(materialId);
                            if (null != p) {
                                v.setPlanNum(p.getPlanNum());
                                v.setPlanPrice(p.getPlanPrice());
                            }
                        }
                    }
                    Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                    for (BillParamVO billParamVO : billParamVOS2) {
                        if (0 != billParamVO.getControlType()) {
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                            for (MaterialPriceVO d : detail) {
                                BigDecimal num = d.getNum();
                                BigDecimal planNum = d.getPlanNum();
                                BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                                BigDecimal allNum = hasNum.add(num);
                                //百分比数量
                                BigDecimal _planNum = planNum.multiply(divide);
                                if (allNum.compareTo(_planNum) > 0) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("材料入库数量大于总计划数量");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("该项目本次入库数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，已入库数量：").append(hasNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，总计划数量*").append(roleValue).append("%: ").append(_planNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("。超出数量：").append(allNum.subtract(_planNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            }
                        }
                    }
                }

                //【用料申请】控制【材料入库量】
                CommonResponse<List<BillParamVO>> response3 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_APPLY_COUNT, curOrgId);
                if (!response3.isSuccess()) {
                    throw new BusinessException("【用料申请】控制【材料入库量】，获取控制参数失败，失败原因：" + response3.getMsg());
                }
                List<BillParamVO> billParamVOS3 = response3.getData();

                if (CollectionUtils.isNotEmpty(billParamVOS3)) {
                    //获取已生效的量
                    List<MaterialPriceVO> vos = instoreMaterialMapper.queryMaterialInstoreCount(vo.getId(), vo.getProjectId(), materialIds);
                    //获取用料申请量
                    List<MaterialApplyCountVO> applyCountVOS = useApplyService.queryMaterialApplyCount(vo.getProjectId(), materialIds);
                    Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                    Map<Long, BigDecimal> applyVOMap = applyCountVOS.stream().collect(Collectors.toMap(MaterialApplyCountVO::getMaterialId, MaterialApplyCountVO::getApplyNum));

                    for (BillParamVO billParamVO : billParamVOS3) {
                        if (0 != billParamVO.getControlType()) {
                           BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                            for (MaterialPriceVO d : detail) {
                                BigDecimal num = d.getNum();
                                BigDecimal applyNum = applyVOMap.get(d.getMaterialId()) != null ? applyVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                                BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                                BigDecimal allNum = ComputeUtil.safeAdd(hasNum, num);
                                //百分比数量
                                BigDecimal _applyNum = applyNum.multiply(divide);
                                if (allNum.compareTo(_applyNum) > 0) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("项目入库数量超项目用料申请量");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("该项目本次入库数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，含本次累计入库数量：").append(allNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，用料申请数量*").append(roleValue).append("%: ").append(_applyNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("。超出数量：").append(ComputeUtil.safeSub(allNum, _applyNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            }
                        }
                    }
                }
                //[材料合同量】控制【材料入库量]

                CommonResponse<List<BillParamVO>> response4 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_DETAIL_COUNT, curOrgId);
                if (!response4.isSuccess()) {
                    throw new BusinessException("【材料合同量】控制【材料入库量】，获取控制参数失败，失败原因：" + response4.getMsg());
                }
                List<BillParamVO> billParamVOS4 = response4.getData();
                if (CollectionUtils.isNotEmpty(billParamVOS4) && "hasContract".equals(vo.getContractType())) {
                    //获取已生效的量
                    List<MaterialPriceVO> vos = instoreMaterialMapper.queryMaterialInstoreCount(vo.getId(), vo.getProjectId(), materialIds);
                    //材料合同数量
                    List<MaterialApplyCountVO> materialDetailCountVOS = materialContractMapper.queryMaterialDetailCount(vo.getProjectId(), materialIds);

                    Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                    Map<Long, BigDecimal> applyVOMap = materialDetailCountVOS.stream().collect(Collectors.toMap(MaterialApplyCountVO::getMaterialId, MaterialApplyCountVO::getApplyNum));

                    for (BillParamVO billParamVO : billParamVOS4) {
                        if (0 != billParamVO.getControlType()) {
                          BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                            for (MaterialPriceVO d : detail) {
                                BigDecimal num = d.getNum();
                                BigDecimal applyNum = applyVOMap.get(d.getMaterialId()) != null ? applyVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                                BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                                BigDecimal allNum = ComputeUtil.safeAdd(hasNum, num);
                                //百分比数量
                                BigDecimal _applyNum = applyNum.multiply(divide);
                                if (allNum.compareTo(_applyNum) > 0) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("材料入库数量大于材料合同量");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("该项目本次入库数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，已入库数量：").append(hasNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，合同数量*").append(roleValue).append("%: ").append(_applyNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("。超出数量：").append(ComputeUtil.safeSub(allNum, _applyNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            }
                        }
                    }
                }
                Integer instoreType = vo.getInstoreType();
                Long labourArmyId = vo.getLabourArmyId();
                Long projectId = vo.getProjectId();
                // 直入直出
                if (instoreType != null && instoreType.intValue() == 2 && labourArmyId != null) {
                    // 劳务队伍领料限额量控制材料出库量
                    CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_LIMIT_COUNT, curOrgId);
                    if (!response.isSuccess()) {
                        throw new BusinessException("劳务队伍领料限额量控制材料出库量，获取控制参数失败，失败原因：" + response.getMsg());
                    }
                    List<BillParamVO> billParamVOS = response.getData();
                    if (CollectionUtils.isNotEmpty(billParamVOS)) {
                        // 根据项目和劳务队获取限量登记
                        Map<Long, BigDecimal> planMap = pickRegisterService.queryLaborLimitMaterialCount(projectId, labourArmyId, materialIds);

                        //获取已生效的量
                        List<MaterialPriceVO> vos = iOutStoreService.queryLaborMaterialCount(vo.getId(), projectId, labourArmyId, materialIds);
                        Map<Long, BigDecimal> numVOMap = CollectionUtils.isEmpty(vos) ? new HashMap<>() : vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                        for (BillParamVO billParamVO : billParamVOS) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                                numMap.forEach((k, d) -> {
                                    BigDecimal num = d.getNum();
                                    BigDecimal applyNum = ComputeUtil.nullToZero(planMap.get(d.getMaterialId()));
                                    BigDecimal hasNum = ComputeUtil.nullToZero(numVOMap.get(d.getMaterialId()));
                                    BigDecimal allNum = ComputeUtil.safeAdd(hasNum, num);
                                    //百分比数量
                                    BigDecimal _applyNum = applyNum.multiply(divide);
                                    if (allNum.compareTo(_applyNum) > 0) {
                                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                        paramsCheckDsVO.setWarnName("劳务队伍领料出库量大于领料限额量");
                                        StringBuffer stringBuffer = new StringBuffer();
                                        stringBuffer.append("该材料本次出库数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                .append("，含本次累计出库数量：").append(allNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                .append("，领料限额数量*").append(roleValue).append("%: ").append(_applyNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                .append("。超出数量：").append(ComputeUtil.safeSub(allNum, _applyNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                        paramsCheckDsVO.setContent(stringBuffer.toString());
                                        updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                    }
                                });
                            }
                        }
                    }
                }

                // 直入直出 收料入库
                if (instoreType != null && (instoreType.intValue() ==2||instoreType.intValue() ==1)
                        &&"hasContract".equals(vo.getContractType()) &&null!=vo.getContractId()) {
                    CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_DETAIL_PRICE, curOrgId);
                    if (!response.isSuccess()) {
                        throw new BusinessException("【材料合同价】控制【材料入库价】，获取控制参数失败，失败原因：" + response.getMsg());
                    }
                    List<BillParamVO> billParamVOS = response.getData();
                    if (CollectionUtils.isNotEmpty(billParamVOS)) {
                        MaterialContractEntity materialContractEntity = materialContractService.selectById(vo.getContractId());
                        MaterialContractVO contractVO = BeanMapper.map(materialContractEntity, MaterialContractVO.class);
                        List<MaterialContractDetailSubVO> materialDetailList = contractVO.getMaterialDetailList();
                        Map<String, BigDecimal> conMap = new HashMap();
                        if (CollectionUtils.isNotEmpty(materialDetailList)){
                            conMap = materialDetailList.stream().collect(Collectors.toMap(MaterialContractDetailSubVO::getMaterialId, MaterialContractDetailSubVO::getUnitPrice, (v1, v2) -> v2));
                        }
                        for (BillParamVO billParamVO : billParamVOS) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                                for (MaterialPriceVO d : detail) {
                                    if (conMap.keySet().contains(String.valueOf(d.getMaterialId()))) {
                                        BigDecimal price = d.getPrice();
                                        BigDecimal conPrice = ComputeUtil.nullToZero(conMap.get(String.valueOf(d.getMaterialId())));
                                        //百分比单价
                                        BigDecimal _conPrice = ComputeUtil.safeMultiply(conPrice,divide);
                                        if (price.compareTo(_conPrice) > 0) {
                                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                            paramsCheckDsVO.setWarnName("材料入库单价大于采购合同价");
                                            StringBuffer stringBuffer = new StringBuffer();
                                            stringBuffer.append("本次入库单价：").append(price.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                    .append("，采购合同单价*").append(roleValue).append("%: ").append(_conPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                    .append("。超出金额：").append(ComputeUtil.safeSub(price, _conPrice).setScale(2, BigDecimal.ROUND_HALF_UP));
                                            paramsCheckDsVO.setContent(stringBuffer.toString());
                                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                //【物资总计划价】管控【材料入库价】
                    CommonResponse<List<BillParamVO>> response5 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_MATERIAL_PRICE, curOrgId);
                    if (!response2.isSuccess()) {
                        throw new BusinessException("【物资总计划价】管控【材料入库价】，获取控制参数失败，失败原因：" + response2.getMsg());
                    }
                    List<BillParamVO> billParamVOS5 = response5.getData();

                    if (CollectionUtils.isNotEmpty(billParamVOS5)) {
                        List<MaterialPriceVO> materialPriceVOS = materialContractMapper.queryPlanPriceByProjectId(projectId, materialIds);
                        Map<Long, BigDecimal> priceVOMap=new HashMap();
                        if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                            priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getPlanPrice));
                        }
                        for (BillParamVO billParamVO : billParamVOS5) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                                for (MaterialPriceVO d : detail) {
                                    BigDecimal price = d.getPrice();
                                    BigDecimal planPrice = ComputeUtil.nullToZero(priceVOMap.get(d.getMaterialId()));
                                    BigDecimal _planPrice = ComputeUtil.safeMultiply(planPrice,divide);
                                    if (null!=price && price.compareTo(_planPrice) > 0) {
                                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                        paramsCheckDsVO.setWarnName("入库单价大于总计划单价");
                                        StringBuffer stringBuffer = new StringBuffer();
                                        stringBuffer.append("本次入库单价：").append(price.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                .append("，总计划单价*").append(roleValue).append("%: ").append(_planPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                .append("。超出单价：").append(price.subtract(_planPrice).setScale(2, BigDecimal.ROUND_HALF_UP));
                                        paramsCheckDsVO.setContent(stringBuffer.toString());
                                        updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                    }
                                }
                            }
                        }
                    }
            }
        }

        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    /**
     * @description: 库存量：该材料在该项目下所有仓库中的现存量合计值 + 该项目本上级所有公司仓的现存量合计值。
     *
     * @return {@link List< InstoreMaterialVO>}
     * @author songlx
     * @date: 2024/2/18
     * @param orgId
     * @param materialIds
     */
    @Override
    public List<InstoreMaterialVO> storeNumCount(Long orgId, List<Long> materialIds) {
        CommonResponse<List<OrgVO>> parentsOrgIds = orgApi.findParentsByOrgId(orgId);
        CommonResponse<List<OrgVO>> childrenOrgIds = orgApi.findChildrenByParentId(orgId);
        LambdaQueryWrapper<StoreEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.and((t)->{
            t.in(StoreEntity::getOrgId, childrenOrgIds.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (parentsOrgIds.isSuccess() && parentsOrgIds.getData() != null) {
                t.or((k) -> k.in(StoreEntity::getOrgId, parentsOrgIds.getData().stream().map(OrgVO::getId).collect(Collectors.toList())).eq(StoreEntity::getProjectType, "2"));
            }
            return t;
        });

        List<StoreEntity> list = storeService.list(wrapper);
        return instoreMaterialMapper.storeNumCount(list.stream().map(StoreEntity::getId).collect(Collectors.toList()), materialIds);
    }
}
