/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.bean.SectionPlanEntity;
import com.ejianc.business.plan.bean.SectionPlanSubEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.mapper.SectionPlanMapper;
import com.ejianc.business.plan.mapper.SectionPlanSubMapper;
import com.ejianc.business.plan.service.ISectionPlanService;
import com.ejianc.business.plan.vo.SectionPlanSubVO;
import com.ejianc.business.plan.vo.SectionPlanVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sectionPlanService")
public class SectionPlanServiceImpl
extends BaseServiceImpl<SectionPlanMapper, SectionPlanEntity>
implements ISectionPlanService {
    @Autowired
    private SectionPlanSubMapper sectionPlanSubMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    private static String PARAM_SECTION_PLAN_NUM = "P-6C8EFs85";
    private static String PARAM_SECTION_PLAN_PRICE = "P-6h53s184";

    @Override
    public ParamsCheckVO checkParams(SectionPlanVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<SectionPlanSubVO> materialSubList = vo.getMaterialSubList();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap paramsCheckVOMap = new HashMap();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)materialSubList) && (int)materialSubList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            CommonResponse response1;
            materialSubList = materialSubList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
            Long projectId = vo.getProjectId();
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"project_id", (Object)projectId);
            wrapper.eq((Object)"dr", (Object)0);
            List materialMasterPlanEntities = this.materialMasterPlanMapper.selectList((Wrapper)wrapper);
            QueryWrapper planSubWrapper = new QueryWrapper();
            ArrayList<Long> ids = new ArrayList<Long>();
            materialMasterPlanEntities.forEach(item -> ids.add(item.getId()));
            ids.add(1L);
            planSubWrapper.in((Object)"material_master_plan_id", ids);
            planSubWrapper.eq((Object)"dr", (Object)0);
            List materialMasterPlanSubEntities = this.materialMasterPlanSubMapper.selectList((Wrapper)planSubWrapper);
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_SECTION_PLAN_NUM, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("\u3010\u7269\u8d44\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u3010\u6807\u6bb5\u8ba1\u5212\u91cf\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            List billParamVOS = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    BigDecimal manageRate = billParamVO.getRoleValue();
                    HashMap planMap = new HashMap();
                    materialMasterPlanSubEntities.forEach(item -> {
                        Double num = item.getNum();
                        if (planMap.containsKey(item.getMaterialId())) {
                            planMap.put(item.getMaterialId(), ComputeUtil.safeAdd((BigDecimal)((BigDecimal)planMap.get(item.getMaterialId())), (BigDecimal)BigDecimal.valueOf(num)));
                        } else {
                            planMap.put(item.getMaterialId(), BigDecimal.valueOf(num));
                        }
                    });
                    QueryWrapper appWrapper = new QueryWrapper();
                    appWrapper.eq((Object)"project_id", (Object)projectId);
                    List batchPlanEntities = this.sectionPlanSubMapper.selectList((Wrapper)appWrapper);
                    ids.clear();
                    batchPlanEntities.forEach(item -> ids.add(item.getId()));
                    ArrayList noIds = new ArrayList();
                    materialSubList.forEach(item -> {
                        if (item.getId() != null) {
                            noIds.add(item.getId());
                        }
                    });
                    ids.add(1L);
                    QueryWrapper appSubWrapper = new QueryWrapper();
                    appSubWrapper.in((Object)"plan_id", ids);
                    appSubWrapper.notIn((Object)"id", noIds);
                    List batchPlanSubEntities1 = this.sectionPlanSubMapper.selectList((Wrapper)appSubWrapper);
                    List batchPlanSubEntities2 = BeanMapper.mapList(materialSubList, SectionPlanSubEntity.class);
                    HashMap<Long, SectionPlanSubEntity> thisMap = new HashMap<Long, SectionPlanSubEntity>();
                    batchPlanSubEntities2.forEach(item -> {
                        if (thisMap.containsKey(item.getMaterialId())) {
                            SectionPlanSubEntity sectionPlanSubEntity = (SectionPlanSubEntity)((Object)((Object)thisMap.get(item.getMaterialId())));
                            sectionPlanSubEntity.setNum(sectionPlanSubEntity.getNum().add(item.getNum()));
                        } else {
                            thisMap.put(item.getMaterialId(), (SectionPlanSubEntity)((Object)item));
                        }
                    });
                    HashMap oldAppMap = new HashMap();
                    batchPlanSubEntities1.forEach(item -> {
                        BigDecimal applyNum = item.getNum();
                        if (oldAppMap.containsKey(item.getMaterialId())) {
                            BigDecimal bigDecimal = (BigDecimal)oldAppMap.get(item.getMaterialId());
                            oldAppMap.put(item.getMaterialId(), applyNum.add(bigDecimal));
                        } else {
                            oldAppMap.put(item.getMaterialId(), applyNum);
                        }
                    });
                    thisMap.forEach((k, item) -> {
                        BigDecimal batNumber;
                        Long materialId = item.getMaterialId();
                        BigDecimal batNum = item.getNum();
                        BigDecimal oldBatNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)oldAppMap.get(materialId);
                        BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)planMap.get(materialId);
                        BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100L));
                        if (ComputeUtil.isLessThan((BigDecimal)planNumber, (BigDecimal)(batNumber = ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)oldBatNum, (BigDecimal)batNum))))) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)item.getSpec()) ? " [" + item.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u6807\u6bb5\u8ba1\u5212\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u91cf");
                            paramsCheckDsVO.setContent("\u672c\u6b21\u8ba1\u5212\u6570\u91cf:" + batNum.setScale(2, 4) + ",\u542b\u672c\u6b21\u7d2f\u8ba1\u8ba1\u5212\u6570\u91cf:" + batNumber.setScale(2, 4) + ",\u603b\u8ba1\u5212\u6570\u91cf*" + manageRate + "%:" + planNumber.setScale(2, 4) + ",\u8d85\u51fa\u6570\u91cf:" + ComputeUtil.safeSub((BigDecimal)batNumber, (BigDecimal)planNumber).setScale(2, 4));
                            SectionPlanServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    });
                }
            }
            if (!(response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_SECTION_PLAN_PRICE, curOrgId)).isSuccess()) {
                throw new BusinessException("\u3010\u7269\u8d44\u603b\u8ba1\u5212\u5355\u4ef7\u3011\u63a7\u5236\u3010\u6807\u6bb5\u8ba1\u5212\u5355\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response1.getMsg());
            }
            List billParamVOS1 = (List)response1.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
                HashMap planMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)materialMasterPlanEntities)) {
                    materialMasterPlanSubEntities.forEach(item -> {
                        BigDecimal price = item.getPrice();
                        Long materialId = item.getMaterialId();
                        if (!planMap.containsKey(materialId) || ComputeUtil.isLessThan((BigDecimal)price, (BigDecimal)((BigDecimal)planMap.get(item.getMaterialId())))) {
                            planMap.put(materialId, price);
                        }
                    });
                }
                for (BillParamVO billParamVO : billParamVOS1) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                    materialSubList.forEach(item -> {
                        BigDecimal price;
                        BigDecimal _planPrice;
                        Long materialId = item.getMaterialId();
                        BigDecimal estimatePrice = item.getPrice();
                        if (ComputeUtil.isGreaterThan((BigDecimal)estimatePrice, (BigDecimal)(_planPrice = (price = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)planMap.get(materialId)))).multiply(divide)))) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)item.getSpec()) ? " [" + item.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u6807\u6bb5\u8ba1\u5212\u5355\u4ef7\u5927\u4e8e\u603b\u8ba1\u5212\u5355\u4ef7");
                            paramsCheckDsVO.setContent("\u672c\u6b21\u6807\u6bb5\u8ba1\u5212\u5355\u4ef7\uff1a" + estimatePrice.setScale(2, 4) + ",\u603b\u8ba1\u5212\u5355\u4ef7*" + roleValue + "%:" + _planPrice.setScale(2, 4) + ",\u8d85\u51fa\u5355\u4ef7" + estimatePrice.subtract(_planPrice).setScale(2, 4));
                            SectionPlanServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    });
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}

