package com.ejianc.business.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 物资总计划-材料实体
 *
 * @author CJ
 * @Description: 物资总计划-材料实体
 * @date 2021/3/2 16:45
 */
@TableName(value = "ejc_material_master_plan_sub")
public class MaterialMasterPlanSubEntity extends BaseEntity {

    private static final long serialVersionUID = -79742252097001808L;

    /**
     * 所属总计划Id
     */
    @TableField(value = "material_master_plan_id")
    private Long materialMasterPlanId;

    /**
     * 物资分类Id
     */
    @TableField(value = "material_category_id")
    private Long materialCategoryId;
    /**
     * 物资分类名称
     */
    @TableField(value = "material_category_name")
    private String materialCategoryName;
    /**
     * 物资Id
     */
    @TableField(value = "material_id")
    private Long materialId;
    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;
    /**
     * 规格型号
     */
    @TableField(value = "spec")
    private String spec;
    /**
     * 计量单位
     */
    @TableField(value = "unit")
    private String unit;

    /**
     * 品牌
     */
    @TableField(value="supplier_name")
    private java.lang.String supplierName;

    /**
     * 数量
     */
    @TableField(value = "num")
    private Double num;
    /**
     * 单价
     */
    @TableField(value = "price")
    private BigDecimal price;
    /**
     * 金额
     */
    @TableField(value = "amount")
    private BigDecimal amount;

    /**
     * 物资来源：1-物料档案，2-导入，3-预算引入，4-项目预算
     */
    @TableField(value = "source_type")
    private String sourceType;

    /**
     * 物资来源出业务Id
     */
    @TableField(value = "source_id")
    private String sourceId;
    @TableField(exist = false)
    private Integer matchStatus; // 匹配状态：0-未匹配，1-已匹配，2-模糊匹配，
    @TableField(exist = false)
    private String matchStatusDescription;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;


    /**
     * 物资编码
     */
    @TableField(value = "material_code")
    private String materialCode;

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Double getNum() {
        return num;
    }

    public void setNum(Double num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Long getMaterialMasterPlanId() {
        return materialMasterPlanId;
    }

    public void setMaterialMasterPlanId(Long materialMasterPlanId) {
        this.materialMasterPlanId = materialMasterPlanId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(Integer matchStatus) {
        this.matchStatus = matchStatus;
    }

    public String getMatchStatusDescription() {
        return matchStatusDescription;
    }

    public void setMatchStatusDescription(String matchStatusDescription) {
        this.matchStatusDescription = matchStatusDescription;
    }
}
