package com.ejianc.business.storeCheck.service;

import com.ejianc.business.storeCheck.bean.StoreCheckEntity;
import com.ejianc.business.storeCheck.vo.StoreCheckVO;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/12 16:12
 */
public interface IStoreCheckService extends IBaseService<StoreCheckEntity> {

    /**
     * 根据编码查询仓库盘点详情
     *
     * @param billCode
     * @return
     */
    StoreCheckVO queryByCode(String billCode);

    /**
     * 根据仓库Id查询未生效的盘点单
     *
     * @param storeId
     * @return
     */
    StoreCheckVO queryInvalidBillByStoreId(Long storeId);

    StoreCheckVO saveCheckStore(StoreCheckEntity saveEntity);

    /**
     * 根据仓库Id查询该仓库最新的生效盘点单
     *
     * @param storeId
     * @return
     */
    StoreCheckVO getLatestStoreCheck(Long storeId);
}
