package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author liyongjia
 * @Date 2020/6/11  收料入库实体
 * @Description InstoreEntity
 */

@TableName("ejc_material_instore_bill")
public class InstoreBillEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 调拨入库时候，记录调拨出库主表id
	 */
	@TableField(value = "out_id")
	private Long outId;

	/**
	 * 调拨入库时候，记录调拨出库主表调出组织
	 */
	@TableField(value = "out_org_id")
	private Long outOrgId;

	/**
	 * 调拨入库时候，记录调拨出库主表调出组织
	 */
	@TableField(value = "out_org_name")
	private String outOrgName;

	/**
	 * 调拨入库时候，记录调拨出库主表调出项目id
	 */
	@TableField(value = "out_project_id")
	private Long outProjectId;

	/**
	 * 调拨入库时候，记录调拨出库主表调出项目名称
	 */
	@TableField(value = "out_project_name")
	private String outProjectName;

	/**
	 * 调拨入库时候，记录调拨出库主表调出仓库id
	 */
	@TableField(value = "out_store_id")
	private Long outStoreId;

	/**
	 * 调拨入库时候，记录调拨出库主表调出仓库名称
	 */
	@TableField(value = "out_store_name")
	private String outStoreName;

	/**
	 * 调拨入库时候，记录收料状态
	 */
	@TableField(value = "receive_state")
	private String receiveState;

	/**
	 * 调拨入库时候，记录收料人
	 */
	@TableField(value = "receive_person")
	private String receivePerson;

	/**
	 * 调拨入库时候，记录收料日期
	 */
	@TableField(value = "receive_date")
	private Date receiveDate;

    /**
     * 入库单号
     */
    @TableField(value = "bill_code")
    private String billCode;
	
    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;
	
    /**
     * 入库日期
     */
    @TableField(value = "instore_date")
    private Date instoreDate;
	
    /**
     * 所属组织
     */
    @TableField(value = "org_id")
    private Long orgId;
	
    /**
     * 所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;
	
    /**
     * 是否属于项目
     */
    @TableField(value = "project_flag")
    private String projectFlag;
	
    /**
     * 所属项目
     */
    @TableField(value = "project_id")
    private Long projectId;
	
    /**
     * 所属项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 所属项目编码
     */
    @TableField(value = "project_code")
    private String projectCode;
	
    /**
     * 仓库
     */
    @TableField(value = "store_id")
    private Long storeId;
	
    /**
     * 仓库名称
     */
    @TableField(value = "store_name")
    private String storeName;
	
    /**
     * 供应商
     */
    @TableField(value = "supplier_id")
    private Long supplierId;
	
    /**
     * 供应商名称
     */
    @TableField(value = "supplier_name")
    private String supplierName;
	
    /**
     * 编制人
     */
    @TableField(value = "user_name")
    private String userName;
	
    /**
     * 合同
     */
    @TableField(value = "contract_id")
    private Long contractId;
	
    /**
     * 合同名称
     */
    @TableField(value = "contract_name")
    private String contractName;
	
    /**
     * 入库类型（hasContractAddBtn:有合同入库;noContractAddBtn:无合同入库）
     */
    @TableField(value = "contract_type")
    private String contractType;
	
    /**
     * 入库类型（1:收料入库,2:直接入库,3:调拨入库,4:物资退库,5:盘盈入库）
     */
    @TableField(value = "instore_type")
    private Integer instoreType;
    
    /**
     * 物资种类
     */
    @TableField(value = "material_name")
    private String materialName;
    
    /**
     * 入库数量
     */
    @TableField(value = "total_count")
    private BigDecimal totalCount;
    
    /**
     * 入库金额 含税
     */
    @TableField(value = "total_amount")
    private BigDecimal totalAmount;

    /**
     * 入库金额 不含税
     */
    @TableField(value = "total_amount_no_tax")
    private BigDecimal totalAmountNoTax;

    /**
     * 备注
     */
    @TableField(value = "note")
    private String note;
	
    /**
     * 用途---直入直出
     */
    @TableField(value = "purpose")
    private String purpose;
    
    /**
     * 是否被付款引用（1引用,0未引用）
     */
    @TableField(value = "payment_flag")
    private Integer paymentFlag;

    /**
     * 是否结算（1已结算,0未结算） 收料入库&直入直出使用
     */
    @TableField(value = "settlement_flag")
    private Integer settlementFlag;

    /**
     * 成本关联科目状态(1:是，0：否)
     */
    @TableField(value = "relation_flag")
    private String relationFlag = "0";

    /**
     * 成本分摊状态(1:是，0：否)
     */
    @TableField(value = "proportion_flag")
    private String proportionFlag = "0";

    /**
     * 税率
     */
    @TableField(value = "tax_rate")
    private BigDecimal taxRate;

	/**
	 * 直入直出管理id
	 */
	@TableField(value = "instore_bill_id")
    private Long instoreBillId;

    /**
     * 子表
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "instoreBillMaterialService", pidName="instoreId")
    private List<InstoreBillMaterialEntity> instoreMaterialList = new ArrayList<>();
	
    /**
     * 退库人---领料退库
     */
    @TableField(value = "pick_return_person")
    private String pickReturnPerson;
	
    /**
     * 退库原因---领料退库  调拨入库---退回原因
     */
    @TableField(value = "pick_return_reason")
    private String pickReturnReason;

	@TableField(value = "labour_army_id")
	private Long labourArmyId;

	@TableField(value = "labour_army")
	private String labourArmy;

	public Long getOutId() {
		return outId;
	}

	public void setOutId(Long outId) {
		this.outId = outId;
	}

	public Long getOutOrgId() {
		return outOrgId;
	}

	public void setOutOrgId(Long outOrgId) {
		this.outOrgId = outOrgId;
	}

	public String getOutOrgName() {
		return outOrgName;
	}

	public void setOutOrgName(String outOrgName) {
		this.outOrgName = outOrgName;
	}

	public Long getOutProjectId() {
		return outProjectId;
	}

	public void setOutProjectId(Long outProjectId) {
		this.outProjectId = outProjectId;
	}

	public String getOutProjectName() {
		return outProjectName;
	}

	public void setOutProjectName(String outProjectName) {
		this.outProjectName = outProjectName;
	}

	public Long getOutStoreId() {
		return outStoreId;
	}

	public void setOutStoreId(Long outStoreId) {
		this.outStoreId = outStoreId;
	}

	public String getOutStoreName() {
		return outStoreName;
	}

	public void setOutStoreName(String outStoreName) {
		this.outStoreName = outStoreName;
	}

	public String getReceiveState() {
		return receiveState;
	}

	public void setReceiveState(String receiveState) {
		this.receiveState = receiveState;
	}

	public String getReceivePerson() {
		return receivePerson;
	}

	public void setReceivePerson(String receivePerson) {
		this.receivePerson = receivePerson;
	}

	public Date getReceiveDate() {
		return receiveDate;
	}

	public void setReceiveDate(Date receiveDate) {
		this.receiveDate = receiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public Date getInstoreDate() {
		return instoreDate;
	}

	public void setInstoreDate(Date instoreDate) {
		this.instoreDate = instoreDate;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getStoreId() {
		return storeId;
	}

	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public String getStoreName() {
		return storeName;
	}

	public void setStoreName(String storeName) {
		this.storeName = storeName;
	}

	public Long getSupplierId() {
		return supplierId;
	}

	public void setSupplierId(Long supplierId) {
		this.supplierId = supplierId;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public Long getContractId() {
		return contractId;
	}

	public void setContractId(Long contractId) {
		this.contractId = contractId;
	}

	public String getContractName() {
		return contractName;
	}

	public void setContractName(String contractName) {
		this.contractName = contractName;
	}

	public String getProjectFlag() {
		return projectFlag;
	}

	public void setProjectFlag(String projectFlag) {
		this.projectFlag = projectFlag;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getContractType() {
		return contractType;
	}

	public void setContractType(String contractType) {
		this.contractType = contractType;
	}

	public List<InstoreBillMaterialEntity> getInstoreMaterialList() {
		return instoreMaterialList;
	}

	public void setInstoreMaterialList(List<InstoreBillMaterialEntity> instoreMaterialList) {
		this.instoreMaterialList = instoreMaterialList;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getInstoreType() {
		return instoreType;
	}

	public void setInstoreType(Integer instoreType) {
		this.instoreType = instoreType;
	}

	public String getPurpose() {
		return purpose;
	}

	public void setPurpose(String purpose) {
		this.purpose = purpose;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public BigDecimal getTotalCount() {
		return totalCount;
	}

	public void setTotalCount(BigDecimal totalCount) {
		this.totalCount = totalCount;
	}

	public BigDecimal getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(BigDecimal totalAmount) {
		this.totalAmount = totalAmount;
	}

	public BigDecimal getTotalAmountNoTax() {
		return totalAmountNoTax;
	}

	public void setTotalAmountNoTax(BigDecimal totalAmountNoTax) {
		this.totalAmountNoTax = totalAmountNoTax;
	}

	public String getPickReturnPerson() {
		return pickReturnPerson;
	}

	public void setPickReturnPerson(String pickReturnPerson) {
		this.pickReturnPerson = pickReturnPerson;
	}

	public String getPickReturnReason() {
		return pickReturnReason;
	}

	public void setPickReturnReason(String pickReturnReason) {
		this.pickReturnReason = pickReturnReason;
	}

	public Integer getPaymentFlag() {
		return paymentFlag;
	}

	public void setPaymentFlag(Integer paymentFlag) {
		this.paymentFlag = paymentFlag;
	}

	public Integer getSettlementFlag() {
		return settlementFlag;
	}

	public void setSettlementFlag(Integer settlementFlag) {
		this.settlementFlag = settlementFlag;
	}

	public String getRelationFlag() {
		return relationFlag;
	}

	public void setRelationFlag(String relationFlag) {
		this.relationFlag = relationFlag;
	}

	public String getProportionFlag() {
		return proportionFlag;
	}

	public void setProportionFlag(String proportionFlag) {
		this.proportionFlag = proportionFlag;
	}

	public BigDecimal getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(BigDecimal taxRate) {
		this.taxRate = taxRate;
	}

	public Long getInstoreBillId() {
		return instoreBillId;
	}

	public void setInstoreBillId(Long instoreBillId) {
		this.instoreBillId = instoreBillId;
	}

	public Long getLabourArmyId() {
		return labourArmyId;
	}

	public void setLabourArmyId(Long labourArmyId) {
		this.labourArmyId = labourArmyId;
	}

	public String getLabourArmy() {
		return labourArmy;
	}

	public void setLabourArmy(String labourArmy) {
		this.labourArmy = labourArmy;
	}
}
