package com.ejianc.business.material.controller.api;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/api/instore/")
public class InstoreApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IInstoreService instoreService;

    /**
     * @Author liyongjia
     * @Date 2020/6/2 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.InstoreVO>
     */
    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InstoreVO> queryDetail(@RequestParam(value = "id") Long id) {
        InstoreEntity entity = instoreService.selectById(id);
        InstoreVO vo = BeanMapper.map(entity, InstoreVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Author liyongjia
     * @Date 2020/6/10  修改是否付款
     * @Description updatePayment
     * @Param [vos]
     * @Return 
     */
    @RequestMapping(value = "updatePayment", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updatePayment(@RequestBody List<InstoreVO> vos) {
    	for(InstoreVO vo : vos){
    		InstoreEntity entity = instoreService.selectById(vo.getId());
    		entity.setPaymentFlag(vo.getPaymentFlag());
            instoreService.saveOrUpdate(entity,false);
    	}
        return CommonResponse.success("保存或修改单据成功！","");
    }


}
