/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.plan.bean.SectionPlanChangeEntity;
import com.ejianc.business.plan.bean.SectionPlanChangeSubEntity;
import com.ejianc.business.plan.bean.SectionPlanEntity;
import com.ejianc.business.plan.service.ISectionPlanChangeService;
import com.ejianc.business.plan.service.ISectionPlanService;
import com.ejianc.business.plan.vo.SectionPlanChangeSubVO;
import com.ejianc.business.plan.vo.SectionPlanChangeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sectionPlanChange"})
public class SectionPlanChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ArchivesUtil archivesUtil;
    @Autowired
    private ISectionPlanChangeService service;
    @Autowired
    private ISectionPlanService planService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SectionPlanChangeVO> saveOrUpdate(@RequestBody SectionPlanChangeVO planVo) {
        List materialSubList;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_plan_id", (Object)planVo.getSourcePlanId());
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.ne(planVo.getId() != null, (Object)"id", (Object)planVo.getId());
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        billStates.add(BillStateEnum.SUSPEND.getBillStateCode());
        query.in((Object)"bill_state", billStates);
        int count = this.service.count((Wrapper)query);
        if (count > 0) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u5b58\u5728\u672a\u5b8c\u6210\u7684\u53d8\u66f4\u8ba1\u5212\uff01");
        }
        SectionPlanEntity masterPlan = (SectionPlanEntity)((Object)this.planService.getById(planVo.getSourcePlanId()));
        UserContext userContext = this.sessionManager.getUserContext();
        SectionPlanChangeEntity saveEntity = null;
        if (null == planVo.getId()) {
            saveEntity = (SectionPlanChangeEntity)((Object)BeanMapper.map((Object)planVo, SectionPlanChangeEntity.class));
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            saveEntity.setChangeUserName(userContext.getUserName());
            saveEntity.setPlanCode(masterPlan.getPlanCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (SectionPlanChangeEntity)((Object)this.service.getById(planVo.getId()));
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
            saveEntity.setPlanCode(planVo.getPlanCode());
            saveEntity.setTotalPlanAmt(planVo.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMaterialSubList(BeanMapper.mapList((Iterable)planVo.getMaterialSubList(), SectionPlanChangeSubEntity.class));
        }
        saveEntity.setChangeReason(planVo.getChangeReason());
        if (null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if (CollectionUtils.isNotEmpty((Collection)(materialSubList = planVo.getMaterialSubList()))) {
            for (SectionPlanChangeSubVO planChangeSubVO : materialSubList) {
                String onlykey = planChangeSubVO.getMaterialCategoryName() + planChangeSubVO.getMaterialName() + planChangeSubVO.getUnit() + planChangeSubVO.getSpec() + planChangeSubVO.getMaterialCode();
                planChangeSubVO.setOnlyKey(onlykey);
            }
            JSONObject jsonObject = this.archivesUtil.batchSaveArchive(materialSubList, "materialCategoryId", "materialId", "materialCategoryName", "materialName", "materialCode", "unit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString((Object)jsonObject.get((Object)"sourceList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
            List list = JSONObject.parseArray((String)sourceList, SectionPlanChangeSubVO.class);
            List materialMasterPlanSubEntities = BeanMapper.mapList((Iterable)list, SectionPlanChangeSubEntity.class);
            saveEntity.setMaterialSubList(materialMasterPlanSubEntities);
        }
        saveEntity = this.service.saveOrUpdatePlanChange(saveEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)saveEntity), SectionPlanChangeVO.class));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SectionPlanChangeVO> queryDetail(Long id) {
        SectionPlanChangeEntity entity = (SectionPlanChangeEntity)((Object)this.service.selectById(id));
        SectionPlanChangeVO vo = (SectionPlanChangeVO)BeanMapper.map((Object)((Object)entity), SectionPlanChangeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SectionPlanChangeVO> vos) {
        this.service.deleteChangePlan(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

